# Transaction Codes (tcode)
TCODE_WRITE_QUAD_REQUEST    = 0
TCODE_WRITE_BLOCK_REQUEST   = 1
TCODE_WRITE_RESPONSE        = 2
TCODE_READ_QUAD_REQUEST     = 4
TCODE_READ_BLOCK_REQUEST    = 5
TCODE_READ_QUAD_RESPONSE    = 6
TCODE_READ_BLOCK_RESPONSE   = 7
# Opto 22 mem-map package sizes
SIZE_WRITE_QUAD_REQUEST     = 16
SIZE_WRITE_BLOCK_REQUEST    = 16
SIZE_WRITE_RESPONSE         = 12
SIZE_READ_QUAD_REQUEST      = 12
SIZE_READ_BLOCK_REQUEST     = 16
SIZE_READ_QUAD_RESPONSE     = 16
SIZE_READ_BLOCK_RESPONSE    = 16

# Digital IO area
BASE_DPOINT_WRITE           = 0xF0220000
BASE_DPOINT_READ            = 0xF01E0000
OFFSET_DPOINT_MOD           = 0x00001000
OFFSET_DPOINT               = 0x00000040
# Analog IO area
BASE_APOINT_WRITE           = 0xF02A0000
BASE_APOINT_READ            = 0xF0260000
OFFSET_APOINT_MOD           = 0x00001000
OFFSET_APOINT               = 0x00000040
OFFSET_APOINT_MIN           = 0x00000008
OFFSET_APOINT_MAX           = 0x0000000C

# System status area
BASE_IP_ADDRESS_ETH0        = 0xF0300034
BASE_MAC_ADDRESS_ETH0       = 0xF030002E
BASE_IP_ADDRESS_ETH1        = 0xFFFFF050
BASE_MAC_ADDRESS_ETH1       = 0xFFFFF060
BASE_FIRMWARE_VERSION       = 0xF030001C
BASE_UNIT_DESCRIPTION       = 0xF0300080
BASE_LAST_ERROR             = 0xF030000C

# ScratchPad area
#   string
BASE_SCRATCHPAD_STRING      = 0xF0D83000
OFFSET_SCRATCHPAD_STRING    = 0x00000082
MAX_BYTES_STRING            = 0x00002080
#   float
BASE_SCRATCHPAD_FLOAT       = 0xF0D82000
BASE_SCRATCHPAD_FLOAT_1     = 0xF0D82000
BASE_SCRATCHPAD_FLOAT_2     = 0xF0DC0000
BASE_SCRATCHPAD_FLOAT_3     = 0xF0DC2000
MAX_ELEMENTS_FLOAT_1        = 0x00000400
MAX_ELEMENTS_FLOAT_2        = 0x00000800
MAX_ELEMENTS_FLOAT_3        = 0x00001C00
MAX_ELEMENTS_FLOAT          = MAX_ELEMENTS_FLOAT_1 + MAX_ELEMENTS_FLOAT_2 + MAX_ELEMENTS_FLOAT_3
MAX_BYTES_FLOAT             = MAX_ELEMENTS_FLOAT * 4
#   integer
BASE_SCRATCHPAD_INTEGER     = 0xF0D81000
BASE_SCRATCHPAD_INTEGER_1   = 0xF0D81000
BASE_SCRATCHPAD_INTEGER_2   = 0xF0DA0000
BASE_SCRATCHPAD_INTEGER_3   = 0xF0DA2000
# integer
MAX_ELEMENTS_INTEGER_1      = 0x00000400
MAX_ELEMENTS_INTEGER_2      = 0x00000800
MAX_ELEMENTS_INTEGER_3      = 0x00001C00
MAX_ELEMENTS_INTEGER        = MAX_ELEMENTS_INTEGER_1 + MAX_ELEMENTS_INTEGER_2 + MAX_ELEMENTS_INTEGER_3
MAX_BYTES_INTEGER           = MAX_ELEMENTS_INTEGER * 4



