"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Project = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const constructs_1 = require("constructs");
const fs = require("fs-extra");
const manifest_1 = require("./manifest");
const model_1 = require("./model");
const yaml_1 = require("./yaml");
class Project extends constructs_1.Construct {
    constructor(props = {}) {
        super(undefined, '');
        this.outdir = props.outdir ?? '.cdktg.out';
    }
    /**
     * Synthesizes the model to the output directory
     */
    synth() {
        fs.mkdirSync(this.outdir, { recursive: true });
        const manifest = new manifest_1.Manifest({
            outdir: this.outdir,
        });
        const models = new Array();
        this.node.findAll().forEach(n => {
            if (n instanceof model_1.Model) {
                models.push(n);
            }
        });
        models.forEach(m => {
            const filename = `${`${m.node.id}`.replace(/[^0-9a-zA-Z-_.]/g, '')}`;
            const filepath = path.join(this.outdir, `${filename}.yml`);
            yaml_1.Yaml.save(filepath, [m._toThreagile()]);
            manifest.addModel(m.node.id, filename);
        });
        manifest.save();
    }
}
exports.Project = Project;
_a = JSII_RTTI_SYMBOL_1;
Project[_a] = { fqn: "cdktg.Project", version: "0.0.7" };
//# sourceMappingURL=data:application/json;base64,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