"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BusinessCriticality = exports.Model = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const data_asset_1 = require("./data-asset");
const technical_asset_1 = require("./technical-asset");
const trust_boundary_1 = require("./trust-boundary");
class Model extends constructs_1.Construct {
    constructor(project, id, props) {
        super(project, id);
        this.version = props.version;
        this.title = props.title ?? id;
        this.date = props.date;
        this.author = props.author;
        this.businessCriticality = props.businessCriticality;
    }
    /**
     * @internal
     */
    _toThreagile() {
        const dataAssets = new Array();
        const technicalAssets = new Array();
        const trustBoundaries = new Array();
        this.node.findAll().map(n => {
            if (n instanceof data_asset_1.DataAsset) {
                dataAssets.push(n);
            }
            else if (n instanceof technical_asset_1.TechnicalAsset) {
                technicalAssets.push(n);
            }
            else if (n instanceof trust_boundary_1.TrustBoundary) {
                trustBoundaries.push(n);
            }
        });
        const threagile = {
            threagile_version: this.version,
            title: this.title,
            data: this.date?.toISOString().split('T')[0],
            author: this.author._toThreagile(),
            business_criticality: this.businessCriticality,
        };
        if (dataAssets.length > 0) {
            threagile.data_assets = {};
            dataAssets.forEach(a => {
                const obj = a._toThreagile();
                const k = Object.keys(obj)[0];
                threagile.data_assets[k] = obj[k];
            });
        }
        if (technicalAssets.length > 0) {
            threagile.technical_assets = {};
            technicalAssets.forEach(a => {
                const obj = a._toThreagile();
                const k = Object.keys(obj)[0];
                threagile.technical_assets[k] = obj[k];
            });
        }
        if (trustBoundaries.length > 0) {
            threagile.trust_boundaries = {};
            trustBoundaries.forEach(t => {
                const obj = t._toThreagile();
                if (obj) {
                    const k = Object.keys(obj)[0];
                    threagile.trust_boundaries[k] = obj[k];
                }
            });
        }
        return threagile;
    }
}
exports.Model = Model;
_a = JSII_RTTI_SYMBOL_1;
Model[_a] = { fqn: "cdktg.Model", version: "0.0.7" };
var BusinessCriticality;
(function (BusinessCriticality) {
    BusinessCriticality["ARCHIVE"] = "archive";
    BusinessCriticality["OPERATIONAL"] = "operational";
    BusinessCriticality["IMPORTANT"] = "important";
    BusinessCriticality["CRITICAL"] = "critical";
    BusinessCriticality["MISSION_CRITICAL"] = "mission-critical";
})(BusinessCriticality = exports.BusinessCriticality || (exports.BusinessCriticality = {}));
//# sourceMappingURL=data:application/json;base64,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