import { Construct } from 'constructs';
import { Author } from './author';
import { Threagile } from './spec/threatgile.generated';
export interface ModelProps {
    /**
     * Version of the Threagile toolkit
     */
    readonly version: string;
    /**
     * Title of the model
     */
    readonly title?: string;
    /**
     * Date of the model
     */
    readonly date?: Date;
    /**
     * Author of the model
     */
    readonly author: Author;
    /**
     * Business criticality of the target
     */
    readonly businessCriticality: BusinessCriticality;
}
export declare class Model extends Construct {
    readonly version: string;
    readonly title: string;
    readonly date?: Date;
    readonly author: Author;
    readonly businessCriticality: BusinessCriticality;
    constructor(project: Construct, id: string, props: ModelProps);
    /**
     * @internal
     */
    _toThreagile(): Threagile;
}
export declare enum BusinessCriticality {
    ARCHIVE = "archive",
    OPERATIONAL = "operational",
    IMPORTANT = "important",
    CRITICAL = "critical",
    MISSION_CRITICAL = "mission-critical"
}
