export interface ManifestProps {
    /**
     * The directory to output the threadgile model.
     *
     * @default - .
     */
    readonly outdir?: string;
}
export declare class Manifest {
    static fromFile(dir: string): Manifest;
    /**
     * The output directory into which models will be synthesized.
     */
    readonly outdir: string;
    readonly data: Record<string, string>;
    constructor(props?: ManifestProps);
    addModel(title: string, filePath: string): void;
    save(): void;
}
