"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SynthCommand = void 0;
const execa = require("execa");
const fs = require("fs-extra");
class SynthCommand {
    constructor() {
        this.command = 'synth <filename>';
        this.describe = 'synthesize the models';
        this.builder = (args) => {
            args.positional('filename', { demandOption: true, type: 'string' });
            args.option('watch', { boolean: true, alias: 'w', describe: 'get watch with it!' });
            return args;
        };
        this.handler = async (args) => {
            const { filename } = args;
            if (!fs.existsSync(filename)) {
                throw new Error(`File ${filename} not exist!`);
            }
            const command = require.resolve('ts-node/dist/bin');
            execa(command, [filename], {
                stdio: ['ignore', 'inherit', 'inherit'],
            });
        };
    }
}
exports.SynthCommand = SynthCommand;
//# sourceMappingURL=data:application/json;base64,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