"use strict";
/* tslint:disable */
/* eslint-disable */
/**
 * Threagile API
 * <b>Threagile API</b> for Agile Threat Modeling: visit <a href=\"https://threagile.io\">https://threagile.io</a> for more information.
 *
 * The version of the OpenAPI document: 1.0.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createRequestFunction = exports.toPathString = exports.serializeDataIfNeeded = exports.setSearchParams = exports.setOAuthToObject = exports.setBearerAuthToObject = exports.setBasicAuthToObject = exports.setApiKeyToObject = exports.assertParamExists = exports.DUMMY_BASE_URL = void 0;
const base_1 = require("./base");
const url_1 = require("url");
/**
 *
 * @export
 */
exports.DUMMY_BASE_URL = 'https://example.com';
/**
 *
 * @throws {RequiredError}
 * @export
 */
exports.assertParamExists = function (functionName, paramName, paramValue) {
    if (paramValue === null || paramValue === undefined) {
        throw new base_1.RequiredError(paramName, `Required parameter ${paramName} was null or undefined when calling ${functionName}.`);
    }
};
/**
 *
 * @export
 */
exports.setApiKeyToObject = async function (object, keyParamName, configuration) {
    if (configuration && configuration.apiKey) {
        const localVarApiKeyValue = typeof configuration.apiKey === 'function'
            ? await configuration.apiKey(keyParamName)
            : await configuration.apiKey;
        object[keyParamName] = localVarApiKeyValue;
    }
};
/**
 *
 * @export
 */
exports.setBasicAuthToObject = function (object, configuration) {
    if (configuration && (configuration.username || configuration.password)) {
        object["auth"] = { username: configuration.username, password: configuration.password };
    }
};
/**
 *
 * @export
 */
exports.setBearerAuthToObject = async function (object, configuration) {
    if (configuration && configuration.accessToken) {
        const accessToken = typeof configuration.accessToken === 'function'
            ? await configuration.accessToken()
            : await configuration.accessToken;
        object["Authorization"] = "Bearer " + accessToken;
    }
};
/**
 *
 * @export
 */
exports.setOAuthToObject = async function (object, name, scopes, configuration) {
    if (configuration && configuration.accessToken) {
        const localVarAccessTokenValue = typeof configuration.accessToken === 'function'
            ? await configuration.accessToken(name, scopes)
            : await configuration.accessToken;
        object["Authorization"] = "Bearer " + localVarAccessTokenValue;
    }
};
/**
 *
 * @export
 */
exports.setSearchParams = function (url, ...objects) {
    const searchParams = new url_1.URLSearchParams(url.search);
    for (const object of objects) {
        for (const key in object) {
            if (Array.isArray(object[key])) {
                searchParams.delete(key);
                for (const item of object[key]) {
                    searchParams.append(key, item);
                }
            }
            else {
                searchParams.set(key, object[key]);
            }
        }
    }
    url.search = searchParams.toString();
};
/**
 *
 * @export
 */
exports.serializeDataIfNeeded = function (value, requestOptions, configuration) {
    const nonString = typeof value !== 'string';
    const needsSerialization = nonString && configuration && configuration.isJsonMime
        ? configuration.isJsonMime(requestOptions.headers['Content-Type'])
        : nonString;
    return needsSerialization
        ? JSON.stringify(value !== undefined ? value : {})
        : (value || "");
};
/**
 *
 * @export
 */
exports.toPathString = function (url) {
    return url.pathname + url.search + url.hash;
};
/**
 *
 * @export
 */
exports.createRequestFunction = function (axiosArgs, globalAxios, BASE_PATH, configuration) {
    return (axios = globalAxios, basePath = BASE_PATH) => {
        const axiosRequestArgs = { ...axiosArgs.options, url: (configuration?.basePath || basePath) + axiosArgs.url };
        return axios.request(axiosRequestArgs);
    };
};
//# sourceMappingURL=data:application/json;base64,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