# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING

from msrest import Deserializer, Serializer

from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient

from .. import models
from ._configuration import ContainerAppsAPIClientConfiguration
from .operations import CertificatesOperations, ContainerAppsAuthConfigsOperations, ContainerAppsOperations, ContainerAppsRevisionReplicasOperations, ContainerAppsRevisionsOperations, ContainerAppsSourceControlsOperations, DaprComponentsOperations, ManagedEnvironmentsOperations, ManagedEnvironmentsStoragesOperations, NamespacesOperations, Operations

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

class ContainerAppsAPIClient:    # pylint: disable=too-many-instance-attributes
    """ContainerAppsAPIClient.

    :ivar container_apps_auth_configs: ContainerAppsAuthConfigsOperations operations
    :vartype container_apps_auth_configs:
     azure.mgmt.appcontainers.aio.operations.ContainerAppsAuthConfigsOperations
    :ivar container_apps: ContainerAppsOperations operations
    :vartype container_apps: azure.mgmt.appcontainers.aio.operations.ContainerAppsOperations
    :ivar container_apps_revisions: ContainerAppsRevisionsOperations operations
    :vartype container_apps_revisions:
     azure.mgmt.appcontainers.aio.operations.ContainerAppsRevisionsOperations
    :ivar container_apps_revision_replicas: ContainerAppsRevisionReplicasOperations operations
    :vartype container_apps_revision_replicas:
     azure.mgmt.appcontainers.aio.operations.ContainerAppsRevisionReplicasOperations
    :ivar dapr_components: DaprComponentsOperations operations
    :vartype dapr_components: azure.mgmt.appcontainers.aio.operations.DaprComponentsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.appcontainers.aio.operations.Operations
    :ivar managed_environments: ManagedEnvironmentsOperations operations
    :vartype managed_environments:
     azure.mgmt.appcontainers.aio.operations.ManagedEnvironmentsOperations
    :ivar certificates: CertificatesOperations operations
    :vartype certificates: azure.mgmt.appcontainers.aio.operations.CertificatesOperations
    :ivar namespaces: NamespacesOperations operations
    :vartype namespaces: azure.mgmt.appcontainers.aio.operations.NamespacesOperations
    :ivar managed_environments_storages: ManagedEnvironmentsStoragesOperations operations
    :vartype managed_environments_storages:
     azure.mgmt.appcontainers.aio.operations.ManagedEnvironmentsStoragesOperations
    :ivar container_apps_source_controls: ContainerAppsSourceControlsOperations operations
    :vartype container_apps_source_controls:
     azure.mgmt.appcontainers.aio.operations.ContainerAppsSourceControlsOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The ID of the target subscription.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2022-03-01". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = ContainerAppsAPIClientConfiguration(credential=credential, subscription_id=subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.container_apps_auth_configs = ContainerAppsAuthConfigsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.container_apps = ContainerAppsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.container_apps_revisions = ContainerAppsRevisionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.container_apps_revision_replicas = ContainerAppsRevisionReplicasOperations(self._client, self._config, self._serialize, self._deserialize)
        self.dapr_components = DaprComponentsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.managed_environments = ManagedEnvironmentsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.certificates = CertificatesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.namespaces = NamespacesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.managed_environments_storages = ManagedEnvironmentsStoragesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.container_apps_source_controls = ContainerAppsSourceControlsOperations(self._client, self._config, self._serialize, self._deserialize)


    def _send_request(
        self,
        request: HttpRequest,
        **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/python/protocol/quickstart

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "ContainerAppsAPIClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
