# Copyright 2019 Francesco Ceccon
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


class MonotonicityRule(object):
    """Base class for rules that compute monotonicity properties of an expression."""
    def apply(self, expr, monotonicity, bounds):
        """Apply rule to `expr`.

        Parameters
        ----------
        expr : Expression
            the expression
        monotonicity : dict-like
            contains monotonicity of children
        bounds : dict-like
            contains bounds of children
        """
        raise NotImplementedError('apply')
