// Copyright (c) Mito
import React from 'react';
import { getSortedActions } from '../../utils/actions';
import Dropdown from '../elements/Dropdown';
import { makeToolbarDropdownItem } from './utils';
/**
 * Dropdown that displays the help dropdown, which contains a searchable
 * list of all the functionality that Mito supports
 */
const ToolbarHelpDropdown = (props) => {
    const allActions = getSortedActions(props.actions);
    return (React.createElement(React.Fragment, null,
        React.createElement(Dropdown, { display: props.uiState.currOpenToolbarDropdown === 'Help', searchable: true, closeDropdown: () => props.setUIState((prevUIState) => {
                // Only close this dropdown if it's actually the one that is open, to avoid race conditions
                if (prevUIState.currOpenToolbarDropdown === 'Help') {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenToolbarDropdown: undefined });
                }
                return prevUIState;
            }), width: 'large' }, allActions.map((action) => {
            return makeToolbarDropdownItem(action);
        }))));
};
export default ToolbarHelpDropdown;
//# sourceMappingURL=ToolbarHelpDropdown.js.map