// Copyright (c) Mito
import React from 'react';
import { ActionEnum } from '../../types';
import Dropdown from '../elements/Dropdown';
import DropdownSectionSeperator from '../elements/DropdownSectionSeperator';
import { makeToolbarDropdownItem } from './utils';
/**
 * Dropdown that displays all the actions that are available for editing dataframes.
 */
const ToolbarDataframesDropdown = (props) => {
    return (React.createElement(React.Fragment, null,
        React.createElement(Dropdown, { display: props.uiState.currOpenToolbarDropdown === 'Dataframes', closeDropdown: () => props.setUIState((prevUIState) => {
                // Only close this dropdown if it's actually the one that is open, to avoid race conditions
                if (prevUIState.currOpenToolbarDropdown === 'Dataframes') {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenToolbarDropdown: undefined });
                }
                return prevUIState;
            }), width: 'large' },
            makeToolbarDropdownItem(props.actions[ActionEnum.Import]),
            makeToolbarDropdownItem(props.actions[ActionEnum.Export]),
            React.createElement(DropdownSectionSeperator, { isDropdownSectionSeperator: true }),
            makeToolbarDropdownItem(props.actions[ActionEnum.Duplicate_Dataframe]),
            makeToolbarDropdownItem(props.actions[ActionEnum.Rename_Dataframe]),
            makeToolbarDropdownItem(props.actions[ActionEnum.Delete_Dataframe]),
            React.createElement(DropdownSectionSeperator, { isDropdownSectionSeperator: true }),
            makeToolbarDropdownItem(props.actions[ActionEnum.Pivot]),
            makeToolbarDropdownItem(props.actions[ActionEnum.Drop_Duplicates]),
            makeToolbarDropdownItem(props.actions[ActionEnum.Merge]),
            makeToolbarDropdownItem(props.actions[ActionEnum.Concat_Dataframes]))));
};
export default ToolbarDataframesDropdown;
//# sourceMappingURL=ToolbarDataframesDropdown.js.map