// Copyright (c) Mito
import React from 'react';
import SheetTab from './SheetTab';
// import css
import "../../../css/footer.css";
import { TaskpaneType } from '../taskpanes/taskpanes';
import PlusIcon from '../icons/PlusIcon';
/*
    Wrapper component that displays the entire footer of the sheet, including
    the sheet tabs, as well as the shape of the currently selected dataframe.
*/
function Footer(props) {
    const selectedSheetIndex = props.uiState.selectedSheetIndex;
    const selectedGraphID = props.uiState.selectedGraphID;
    const selectedTabType = props.uiState.selectedTabType;
    // Get the sheet index to display the rows and columns of. 
    // If the sheet tab is a graph, then display the info from the data being graphed 
    const sheetIndex = selectedTabType === 'graph' && selectedGraphID !== undefined && props.graphDataDict[selectedGraphID] !== undefined ?
        props.graphDataDict[selectedGraphID].graphParams.graphCreation.sheet_index : selectedSheetIndex;
    const sheetData = props.sheetDataArray[sheetIndex];
    return (React.createElement("div", { className: 'footer' },
        React.createElement("div", { className: 'footer-add-button', onClick: () => {
                props.setUIState(prevUIState => {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: { type: TaskpaneType.IMPORT } });
                });
            } },
            React.createElement(PlusIcon, null)),
        React.createElement("div", { className: "footer-tab-bar scrollbar-gutter" },
            props.sheetDataArray.map(df => df.dfName).map((dfName, idx) => {
                return (React.createElement(SheetTab, { key: idx, tabName: dfName, tabIDObj: { tabType: 'data', sheetIndex: idx }, isSelectedTab: selectedTabType === 'data' && idx === selectedSheetIndex, setUIState: props.setUIState, closeOpenEditingPopups: props.closeOpenEditingPopups, mitoAPI: props.mitoAPI, mitoContainerRef: props.mitoContainerRef, graphDataDict: props.graphDataDict, sheetDataArray: props.sheetDataArray, setEditorState: props.setEditorState }));
            }),
            Object.entries(props.graphDataDict || {}).map(([graphID, graphData]) => {
                return (React.createElement(SheetTab, { key: graphID, tabName: graphData.graphTabName, tabIDObj: { tabType: 'graph', graphID: graphID }, isSelectedTab: selectedTabType === 'graph' && graphID === selectedGraphID, setUIState: props.setUIState, closeOpenEditingPopups: props.closeOpenEditingPopups, mitoAPI: props.mitoAPI, mitoContainerRef: props.mitoContainerRef, graphDataDict: props.graphDataDict, sheetDataArray: props.sheetDataArray, setEditorState: props.setEditorState }));
            })),
        sheetData !== undefined &&
            React.createElement("div", { className: 'footer-right-side' },
                React.createElement("div", { className: 'footer-sheet-shape' },
                    "(",
                    sheetData.numRows,
                    " rows, ",
                    sheetData.numColumns,
                    " cols)"))));
}
export default Footer;
//# sourceMappingURL=Footer.js.map