import React, { useState } from 'react';
import '../../../css/endo/IndexHeaders.css';
import { getBorderStyle, getIsCellSelected } from './selectionUtils';
import { calculateCurrentSheetView, calculateTranslate } from './sheetViewUtils';
import { classNames } from '../../utils/classNames';
import IndexHeaderDropdown from './IndexHeaderDropdown';
/*
    The headers on the side of the sheet that display
    the indexes of the dataframe.
*/
const IndexHeaders = (props) => {
    const [openIndexHeaderDropdown, setOpenIndexHeaderDropdown] = useState(undefined);
    const currentSheetView = calculateCurrentSheetView(props.gridState);
    const translate = calculateTranslate(props.gridState);
    const indexHeadersStyle = {
        transform: `translateY(${-translate.y}px)`,
    };
    return (React.createElement(React.Fragment, null,
        React.createElement("div", { className: "index-headers-container" }, props.sheetData.numRows > 0 &&
            React.createElement("div", { style: indexHeadersStyle }, Array(currentSheetView.numRowsRendered).fill(0).map((_, _rowIndex) => {
                const rowIndex = currentSheetView.startingRowIndex + _rowIndex;
                const selected = getIsCellSelected(props.gridState.selections, rowIndex, -1);
                const className = classNames('index-header-container', 'text-overflow-hide', 'text-unselectable', { 'index-header-selected': selected });
                const indexHeader = rowIndex >= props.sheetData.numRows ? '' : props.sheetData.index[rowIndex];
                return (React.createElement("div", { className: className, key: rowIndex, title: indexHeader + '', tabIndex: -1, "mito-row-index": rowIndex, "mito-col-index": -1, style: Object.assign({}, getBorderStyle(props.gridState.selections, props.gridState.copiedSelections, rowIndex, -1, props.sheetData.numRows)), onContextMenu: (e) => {
                        e.preventDefault();
                        e.stopPropagation();
                        setOpenIndexHeaderDropdown(indexHeader);
                    } },
                    indexHeader,
                    React.createElement(IndexHeaderDropdown, { sheetData: props.sheetData, setOpenIndexHeaderDropdown: setOpenIndexHeaderDropdown, display: indexHeader === openIndexHeaderDropdown, index: indexHeader, mitoAPI: props.mitoAPI, sheetIndex: props.sheetIndex, selections: props.gridState.selections, closeOpenEditingPopups: props.closeOpenEditingPopups })));
            })))));
};
export default React.memo(IndexHeaders);
//# sourceMappingURL=IndexHeaders.js.map