# A python tool box

Our python tool-box is supposed to help professional in their day-to-day work.

Everything started when reaching blocking limitations with Excel, which forced us to start learning Python. We then 
started to implement reusable snippets.

As of 2021, we have a very first workable snippet (yet perfectible), and we target to progressively (even-though 
slowly) enrich this tool-box, focusing as a start on "IT project management" related stuff.

In case you have feedbacks, ideas or suggestions, please let us know!

# Table of contents

[TOC]

# Functions

## `markdown.markdown(text [, **kwargs])` { #markdown data-toc-label='markdown.markdown' }

# Versions

* 0.0.5: date predictability - workable version

# Command line

From the "source" directory, you can run the below command:

* To compute and persist:
```
python3 ./enov.py --verbose \
  load-csv -c id -c timestamp -c ps_kick_off_date ~/Documents/07.PRO/04.ENOVATION/2021-06-29.MX.TestFiles/00.pipeline_history.csv df_raw \
  rename-columns -o df_renamed df_raw '{"id":"key","timestamp":"date","ps_kick_off_date":"measure"}' \
  cleanse-null-values -o df_cleansed df_renamed measure \
  compute_date_predictability -o df_predictability df_cleansed \
  write_predictability df_predictability ~/Documents/07.PRO/04.ENOVATION/2021-06-29.MX.TestFiles/jsg.bean.xlsx

```

* To load persisted predictability, and graph
```
python3 ./enov.py --verbose \
  load_predictability_bean ~/Documents/07.PRO/04.ENOVATION/2021-06-29.MX.TestFiles/jsg.bean.xlsx df_predictability \
  graph_predictability_into_dash df_predictability
```
---

# Steps to produce and publish distribution

* Commands to execute from the root directory `com.enovation`

## Check we have latest versions

* pip: `python3 -m pip install --upgrade pip`
* build to generate the distribution: `python3 -m pip install --upgrade build`
* twine to publish to pypi: `python3 -m pip install --upgrade twine`

## Generate and publish the distribution

* build the distribution files and directories: `python3 -m build`
  * Directories `build` and `dist` should be generated
* publish to `pypi`: `python3 -m twine upload --repository pypi dist/*`
  * Package viewable at [pypi](https://pypi.org/project/com-enovation)

## Install

* load the package on another machine: `python3 -m pip install com-enovation`
  * You can test by launching a python interpreter: `python3`
  * And load the package: `>>> import com.enovation`

---

# Dependencies

* pandas: to handle dataframes, series, etc
* click: to handle command line
* enlighten: to display a progress bar for lengthy steps
* openpyxl: to handle `xlsx` files
* xlwt: that is a dependency for pandas.io.excel
* To be decommissioned:
  * scipy: used in old version of data preditability, that used `special.psi` function

---

# Pycharm configuration

## Unit test configuration

* From menu `Run > Edit Configurations...`
  * `Configuration > Target > Script path: /Users/jsg/PycharmProjects/com.enovation.toolbox/tests`
  * `Configuration > Working directory: /Users/jsg/PycharmProjects/com.enovation/`
  * `Configuration > Add content roots to PYTHONPATH: checked`
  * `Configuration > Add source roots to PYTHONPATH: checked`

---

# Python stuff

## To update all packages

* Check all packages are fine: `pip check`
* List all packages outdated: `pip list --outdated`
* Update all packages outdated: `pip list --outdated --format=freeze | grep -v '^\-e' | cut -d = -f 1  | xargs -n1 pip install -U`

---

This is a simple example package. You can use
[Github-flavored Markdown](https://guides.github.com/features/mastering-markdown/)
to write your content.

---