# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['unsplashx']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'unsplashx',
    'version': '0.1.2',
    'description': 'Unsplash eXplorer for Humans',
    'long_description': "# UnsplashX\n\n[![GitHub][github_badge]][github_link] [![PyPI][pypi_badge]][pypi_link]\n\n**UnsplashX** is \n\n* an extremely simple **Unsplash** e**X**ploerer for Python.\n* written in Python Standard Library\n\n**UnsplashX** supports to\n\n* get Unsplash Source's URL of a photo without the Official Unsplash API.\n\n\n\n\n## Installation\n\n```bash\npip install unsplashx\n```\n\n\n\n## Quickstart\n\n```python\nimport unsplashx\n\nunsplashx.source()\n```\n\n\n\n## License\n\n**UnsplashX** has a BSD-3-Clause license, as found in the [LICENSE](https://github.com/imyizhang/unsplashx/blob/main/LICENSE) file.\n\n\n\n## Documentation\n\n### unsplashx.status\n\n#### `unsplashx.status`\n\nUnsplash API Status URL.\n\n\n\n### unsplashx.changelog\n\n#### `unsplashx.changelog`\n\nUnsplash API Changelog URL.\n\n\n\n### unsplashx.id\n\n#### `unsplashx.id(link, verbose=False)`\n\nGet the identifier given Unsplash share link URL.\n\n> **Get the ID of a photo**\n> ```\n> https://unsplash.com/photos/{id}\n> ```\n\n> **Get the username of a user**\n> ```\n> https://unsplash.com/@{id}\n> ```\n\n> **Get the ID of a collection**\n> ```\n> https://unsplash.com/collections/{id}/{name}\n> ```\n\n**Parameters:**\n\n* **link** (str): Unsplash share link URL of a photo, a user, or a collection. \n* **verbose** (bool, optional): Whether to enable verbose output. Defaults to `False`.\n\n**Returns:**\n\n(str): The identifier, that can be the ID of a photo, the username of a user, or the ID of a collection.\n\n\n\n### unsplashx.source\n\n#### `unsplashx.source(photo=None, user=None, collection=None, liked=None, featured=None, resolution=None, update=None, query=None, verbose=False)`\n\nGet Unsplash Source download link URL of a photo given the parameters.\n\n> **Get a random photo**\n> ```\n> https://source.unsplash.com/random\n> ```\n> Optionally, limit to a featured selection\n> ```\n> https://source.unsplash.com/featured\n> ```\n> Optionally, specify a size\n> ```\n> https://source.unsplash.com/{resolution}\n> ```\n> Optionally, limit to only updaing daily or weekly\n> ```\n> https://source.unsplash.com/{update}\n> ```\n> Optionally, limit to matching search terms\n> ```\n> https://source.unsplash.com/random?{query}\n> ```\n> Optionally, narrow the selection further\n> ```\n> https://source.unsplash.com/featured/{resolution}/{update}?{query}\n> ```\n\n> **Get a photo**\n> ```\n> https://source.unsplash.com/{id}\n> ```\n> Optionally, specify a size\n> ```\n> https://source.unsplash.com/{id}/{resolution}\n> ```\n\n> **Get a random photo from a user's photos**\n> ```\n> https://source.unsplash.com/user/{id}\n> ```\n> Optionally, narrow the selection further\n> ```\n> https://source.unsplash.com/user/{id}/featured/{resolution}/{update}\n> ```\n\n> **Get a random photo from a user's liked photos**\n> ```\n> https://source.unsplash.com/user/{id}/likes\n> ```\n> Optionally, specify a size\n> ```\n> https://source.unsplash.com/user/{id}/likes/{resolution}\n> ```\n\n> **Get a random photo from a collection's photos**\n> ```\n> https://source.unsplash.com/collection/{id}\n> ```\n> Optionally, narrow the selection further\n> ```\n> https://source.unsplash.com/collection/{id}/{resolution}/{update}\n> ```\n\n**Note:**\n\nUnsplash Source is being deprecated. Existing uses will continue to work, however for new projects use the full Unsplash API.\n\n**Parameters:**\n\n* **photo** (str, optional): Unsplash share link URL or the ID of a photo.\n* **user** (str, optional): Unsplash share link URL or the username of a user.\n* **liked** (bool, optional): Whether to limit to a user's liked photos. Defaults to `False`.\n* **collection** (str, optional): Unsplash share link URL or the ID of a collection.\n* **featured** (bool, optional): Whether to limit to a featured selection. Defaults to `False`.\n* **resolution** (str, optional): The size of a photo to be set. Formats to `{width}x{height}`. Defaults to `None`. \n* **update** (str, optional): Whether to limit to only updating daily or weekly. Defaults to `False`.\n* **query** (str, optional): Comma-separated search terms. Defaults to `None`.\n* **verbose** (bool, optional): Whether to enable verbose output. Defaults to `False`.\n\n**Returns:**\n\n(str): Unsplash Source download link URL of a photo.\n\n**Reference:**\n\n[1] https://changelog.unsplash.com/deprecations/2021/11/25/source-deprecation.html\n\n\n\n## Contributing\n\nThanks for your interest in contributing to **UnsplashX**! Please feel free to create a pull request.\n\n\n\n## Changelog\n\n**UnsplashX 0.1.0**\n\n* Made Unsplash Source's URL constructor functional.\n\n\n\n\n\n[github_badge]: https://badgen.net/badge/icon/GitHub?icon=github&color=black&label\n[github_link]: https://github.com/imyizhang/unsplashx\n\n[pypi_badge]: https://badgen.net/pypi/v/unsplashx?icon=pypi&color=black&label\n[pypi_link]: https://www.pypi.org/project/unsplashx",
    'author': 'Yi Zhang',
    'author_email': 'yizhang.dev@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://pypi.org/project/unsplashx',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
