from typing import List, Tuple, Union

from frenetic.core.mutation.mutators.mutations import AbstractMutator


class Exploiter(AbstractMutator):
    def get_all(self):
        # mutations that we may want to avoid in tests that passed because they are easily reversible
        return [("reverse test", Exploiter.reverse_test), ("split and swap test", Exploiter.split_and_swap)]

    @staticmethod
    def reverse_test(parent_info: Union[dict, List[float]]) -> List[Union[float, Tuple[float, float]]]:
        test = Exploiter.get_test(parent_info)
        return test[int(len(test) / 2) :] + test[: int(len(test) / 2)]

    @staticmethod
    def split_and_swap(parent_info: Union[dict, List[float]]) -> List[Union[float, Tuple[float, float]]]:
        test = Exploiter.get_test(parent_info)
        return test[::-1]


class SingleVariableExploiter(Exploiter):
    def get_all(self):
        return super().get_all() + [("flip sign", SingleVariableExploiter.flip_sign)]

    @staticmethod
    def flip_sign(parent_info: Union[dict, List[float]]) -> List[Union[float, Tuple[float, float]]]:
        test = Exploiter.get_test(parent_info)
        return list(map(lambda x: x * -1.0, test))


class FirstVariableExploiter(Exploiter):
    def get_all(self):
        return super().get_all() + [("flip sign", FirstVariableExploiter.flip_sign)]

    @staticmethod
    def flip_sign(parent_info: Union[dict, List[float]]) -> List[Tuple[float, float]]:
        test = Exploiter.get_test(parent_info)
        return list(map(lambda x: (x[0] * -1.0, x[1]), test))
