"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualNodeListener = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const utils_1 = require("./private/utils");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 *  Defines listener for a VirtualNode
 */
class VirtualNodeListener {
    /**
     * Returns an HTTP Listener for a VirtualNode
     */
    static http(props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_HttpVirtualNodeListenerOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.http);
            }
            throw error;
        }
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.HTTP, props.healthCheck, props.timeout, props.port, props.tls, props.outlierDetection, props.connectionPool);
    }
    /**
     * Returns an HTTP2 Listener for a VirtualNode
     */
    static http2(props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_Http2VirtualNodeListenerOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.http2);
            }
            throw error;
        }
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.HTTP2, props.healthCheck, props.timeout, props.port, props.tls, props.outlierDetection, props.connectionPool);
    }
    /**
     * Returns an GRPC Listener for a VirtualNode
     */
    static grpc(props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_GrpcVirtualNodeListenerOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.grpc);
            }
            throw error;
        }
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.GRPC, props.healthCheck, props.timeout, props.port, props.tls, props.outlierDetection, props.connectionPool);
    }
    /**
     * Returns an TCP Listener for a VirtualNode
     */
    static tcp(props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_TcpVirtualNodeListenerOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.tcp);
            }
            throw error;
        }
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.TCP, props.healthCheck, props.timeout, props.port, props.tls, props.outlierDetection, props.connectionPool);
    }
}
exports.VirtualNodeListener = VirtualNodeListener;
_a = JSII_RTTI_SYMBOL_1;
VirtualNodeListener[_a] = { fqn: "@aws-cdk/aws-appmesh.VirtualNodeListener", version: "1.154.0" };
class VirtualNodeListenerImpl extends VirtualNodeListener {
    constructor(protocol, healthCheck, timeout, port = 8080, tls, outlierDetection, connectionPool) {
        super();
        this.protocol = protocol;
        this.healthCheck = healthCheck;
        this.timeout = timeout;
        this.port = port;
        this.tls = tls;
        this.outlierDetection = outlierDetection;
        this.connectionPool = connectionPool;
    }
    bind(scope) {
        var _b;
        return {
            listener: {
                portMapping: {
                    port: this.port,
                    protocol: this.protocol,
                },
                healthCheck: (_b = this.healthCheck) === null || _b === void 0 ? void 0 : _b.bind(scope, { defaultPort: this.port }).virtualNodeHealthCheck,
                timeout: this.timeout ? this.renderTimeout(this.timeout) : undefined,
                tls: utils_1.renderListenerTlsOptions(scope, this.tls),
                outlierDetection: this.outlierDetection ? this.renderOutlierDetection(this.outlierDetection) : undefined,
                connectionPool: this.connectionPool ? this.renderConnectionPool(this.connectionPool) : undefined,
            },
        };
    }
    renderTimeout(timeout) {
        return ({
            [this.protocol]: {
                idle: (timeout === null || timeout === void 0 ? void 0 : timeout.idle) !== undefined ? {
                    unit: 'ms',
                    value: timeout === null || timeout === void 0 ? void 0 : timeout.idle.toMilliseconds(),
                } : undefined,
                perRequest: (timeout === null || timeout === void 0 ? void 0 : timeout.perRequest) !== undefined ? {
                    unit: 'ms',
                    value: timeout === null || timeout === void 0 ? void 0 : timeout.perRequest.toMilliseconds(),
                } : undefined,
            },
        });
    }
    renderOutlierDetection(outlierDetection) {
        return {
            baseEjectionDuration: {
                unit: 'ms',
                value: outlierDetection.baseEjectionDuration.toMilliseconds(),
            },
            interval: {
                unit: 'ms',
                value: outlierDetection.interval.toMilliseconds(),
            },
            maxEjectionPercent: outlierDetection.maxEjectionPercent,
            maxServerErrors: outlierDetection.maxServerErrors,
        };
    }
    renderConnectionPool(connectionPool) {
        return ({
            [this.protocol]: {
                maxRequests: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxRequests) !== undefined ? connectionPool.maxRequests : undefined,
                maxConnections: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxConnections) !== undefined ? connectionPool.maxConnections : undefined,
                maxPendingRequests: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxPendingRequests) !== undefined ? connectionPool.maxPendingRequests : undefined,
            },
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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