from __future__ import annotations

from textual import events
from textual.app import ComposeResult
from textual.containers import VerticalScroll
from textual.widget import Widget
from textual.widgets import Static

from meilisearch_tui.utils import get_current_indexes_string


class CurrentIndexes(Widget):
    DEFAULT_CSS = """
    CurrentIndexes {
        border: $primary;
        height: 25;
    }
    """

    def compose(self) -> ComposeResult:
        with VerticalScroll(id="current_indexes_view"):
            yield Static(id="current_indexes", expand=True)

    async def on_screen_resume(self, event: events.ScreenResume) -> None:
        current_indexes = self.query_one("#current_indexes", Static)
        try:
            indexes = await get_current_indexes_string()
            current_indexes.update(indexes)
        except Exception as e:
            current_indexes.update(f"Error: {e}")
