# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['skimpy']

package_data = \
{'': ['*']}

install_requires = \
['Pygments>=2.10.0,<3.0.0',
 'click>=8.1.3,<9.0.0',
 'ipykernel>=6.7.0,<7.0.0',
 'jupyter>=1.0.0,<2.0.0',
 'numpy>=1.22.2,<2.0.0',
 'pandas>=1.3.2,<2.0.0',
 'rich>=10.9,<13.0',
 'typeguard>=2.12.1,<3.0.0']

entry_points = \
{'console_scripts': ['skimpy = skimpy.__main__:main']}

setup_kwargs = {
    'name': 'skimpy',
    'version': '0.0.8',
    'description': 'skimpy',
    'long_description': '# Skimpy\n\nA light weight tool for creating summary statistics from dataframes.\n![png](docs/logo.png)\n\n[![PyPI](https://img.shields.io/pypi/v/skimpy.svg)](https://pypi.org/project/skimpy/)\n[![Status](https://img.shields.io/pypi/status/skimpy.svg)](https://pypi.org/project/skimpy/)\n[![Python Version](https://img.shields.io/pypi/pyversions/skimpy)](https://pypi.org/project/skimpy)\n[![License](https://img.shields.io/pypi/l/skimpy)](https://opensource.org/licenses/MIT)\n[![Read the documentation at https://aeturrell.github.io/skimpy/](https://img.shields.io/badge/docs-passing-brightgreen)](https://aeturrell.github.io/skimpy/)\n[![Tests](https://github.com/aeturrell/skimpy/workflows/Tests/badge.svg)](https://github.com/aeturrell/skimpy/actions?workflow=Tests)\n[![Codecov](https://codecov.io/gh/aeturrell/skimpy/branch/main/graph/badge.svg)](https://codecov.io/gh/aeturrell/skimpy)\n[![Downloads](https://static.pepy.tech/badge/skimpy)](https://pepy.tech/project/skimpy)\n[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)\n[![Black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![Google Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/gist/aeturrell/7bf183c559dc1d15ab7e7aaac39ea0ed/skimpy_demo.ipynb)\n\n[![Linux](https://svgshare.com/i/Zhy.svg)](https://svgshare.com/i/Zhy.svg)\n[![macOS](https://svgshare.com/i/ZjP.svg)](https://svgshare.com/i/ZjP.svg)\n[![Windows](https://svgshare.com/i/ZhY.svg)](https://svgshare.com/i/ZhY.svg)\n\n[![Soure](https://img.shields.io/badge/source%20code-github-lightgrey?style=for-the-badge)](https://github.com/aeturrell/skimpy)\n\n**skimpy** is a light weight tool that provides\nsummary statistics about variables in data frames within the console or your interactive Python window.\nThink of it as a super-charged version of `df.describe()`.\n[You can find the documentation here](https://aeturrell.github.io/skimpy/).\n\n## Quickstart\n\n_skim_ a dataframe and produce summary statistics within the console\nusing:\n\n```python\nfrom skimpy import skim\n\nskim(df)\n```\n\nwhere `df` is a dataframe.\n\nIf you need to a dataset to try _skimpy_ out on, you can use the\nbuilt-in test dataframe:\n\n```python\nfrom skimpy import skim, generate_test_data\n\ndf = generate_test_data()\nskim(df)\n```\n\n<pre style="white-space:pre;overflow-x:auto;line-height:normal;font-family:Menlo,\'DejaVu Sans Mono\',consolas,\'Courier New\',monospace">╭──────────────────────────────────────────────── skimpy summary ─────────────────────────────────────────────────╮\n│ <span style="font-style: italic">         Data Summary         </span> <span style="font-style: italic">      Data Types       </span> <span style="font-style: italic">       Categories        </span>                                │\n│ ┏━━━━━━━━━━━━━━━━━━━┳━━━━━━━━┓ ┏━━━━━━━━━━━━━┳━━━━━━━┓ ┏━━━━━━━━━━━━━━━━━━━━━━━┓                                │\n│ ┃<span style="color: #008080; text-decoration-color: #008080; font-weight: bold"> dataframe         </span>┃<span style="color: #008080; text-decoration-color: #008080; font-weight: bold"> Values </span>┃ ┃<span style="color: #008080; text-decoration-color: #008080; font-weight: bold"> Column Type </span>┃<span style="color: #008080; text-decoration-color: #008080; font-weight: bold"> Count </span>┃ ┃<span style="color: #008080; text-decoration-color: #008080; font-weight: bold"> Categorical Variables </span>┃                                │\n│ ┡━━━━━━━━━━━━━━━━━━━╇━━━━━━━━┩ ┡━━━━━━━━━━━━━╇━━━━━━━┩ ┡━━━━━━━━━━━━━━━━━━━━━━━┩                                │\n│ │ Number of rows    │ 1000   │ │ float64     │ 3     │ │ class                 │                                │\n│ │ Number of columns │ 10     │ │ category    │ 2     │ │ location              │                                │\n│ └───────────────────┴────────┘ │ datetime64  │ 2     │ └───────────────────────┘                                │\n│                                │ int64       │ 1     │                                                          │\n│                                │ bool        │ 1     │                                                          │\n│                                │ string      │ 1     │                                                          │\n│                                └─────────────┴───────┘                                                          │\n│ <span style="font-style: italic">                                                    number                                                    </span>  │\n│ ┏━━━━━━━━━━━━━━━━━━┳━━━━━━━┳━━━━━━━━━┳━━━━━━━━━━┳━━━━━━━━┳━━━━━━━━━━━━┳━━━━━━━━━━┳━━━━━━━━┳━━━━━━━━┳━━━━━━━━━┓  │\n│ ┃<span style="font-weight: bold"> column_name      </span>┃<span style="font-weight: bold"> NA    </span>┃<span style="font-weight: bold"> NA %    </span>┃<span style="font-weight: bold"> mean     </span>┃<span style="font-weight: bold"> sd     </span>┃<span style="font-weight: bold"> p0         </span>┃<span style="font-weight: bold"> p25      </span>┃<span style="font-weight: bold"> p75    </span>┃<span style="font-weight: bold"> p100   </span>┃<span style="font-weight: bold"> hist    </span>┃  │\n│ ┡━━━━━━━━━━━━━━━━━━╇━━━━━━━╇━━━━━━━━━╇━━━━━━━━━━╇━━━━━━━━╇━━━━━━━━━━━━╇━━━━━━━━━━╇━━━━━━━━╇━━━━━━━━╇━━━━━━━━━┩  │\n│ │ <span style="color: #af87ff; text-decoration-color: #af87ff">length          </span> │ <span style="color: #008080; text-decoration-color: #008080">    0</span> │ <span style="color: #008080; text-decoration-color: #008080">      0</span> │ <span style="color: #008080; text-decoration-color: #008080">     0.5</span> │ <span style="color: #008080; text-decoration-color: #008080">  0.36</span> │ <span style="color: #008080; text-decoration-color: #008080">   1.6e-06</span> │ <span style="color: #008080; text-decoration-color: #008080">    0.13</span> │ <span style="color: #008080; text-decoration-color: #008080">  0.86</span> │ <span style="color: #008080; text-decoration-color: #008080">     1</span> │ <span style="color: #008000; text-decoration-color: #008000">█▃▃▃▄█ </span> │  │\n│ │ <span style="color: #af87ff; text-decoration-color: #af87ff">width           </span> │ <span style="color: #008080; text-decoration-color: #008080">    0</span> │ <span style="color: #008080; text-decoration-color: #008080">      0</span> │ <span style="color: #008080; text-decoration-color: #008080">       2</span> │ <span style="color: #008080; text-decoration-color: #008080">   1.9</span> │ <span style="color: #008080; text-decoration-color: #008080">    0.0021</span> │ <span style="color: #008080; text-decoration-color: #008080">     0.6</span> │ <span style="color: #008080; text-decoration-color: #008080">     3</span> │ <span style="color: #008080; text-decoration-color: #008080">    14</span> │ <span style="color: #008000; text-decoration-color: #008000">  █▃▁  </span> │  │\n│ │ <span style="color: #af87ff; text-decoration-color: #af87ff">depth           </span> │ <span style="color: #008080; text-decoration-color: #008080">    0</span> │ <span style="color: #008080; text-decoration-color: #008080">      0</span> │ <span style="color: #008080; text-decoration-color: #008080">      10</span> │ <span style="color: #008080; text-decoration-color: #008080">   3.2</span> │ <span style="color: #008080; text-decoration-color: #008080">         2</span> │ <span style="color: #008080; text-decoration-color: #008080">       8</span> │ <span style="color: #008080; text-decoration-color: #008080">    12</span> │ <span style="color: #008080; text-decoration-color: #008080">    20</span> │ <span style="color: #008000; text-decoration-color: #008000">▁▄█▆▃▁ </span> │  │\n│ │ <span style="color: #af87ff; text-decoration-color: #af87ff">rnd             </span> │ <span style="color: #008080; text-decoration-color: #008080">  120</span> │ <span style="color: #008080; text-decoration-color: #008080">     12</span> │ <span style="color: #008080; text-decoration-color: #008080">   -0.02</span> │ <span style="color: #008080; text-decoration-color: #008080">     1</span> │ <span style="color: #008080; text-decoration-color: #008080">      -2.8</span> │ <span style="color: #008080; text-decoration-color: #008080">   -0.74</span> │ <span style="color: #008080; text-decoration-color: #008080">  0.66</span> │ <span style="color: #008080; text-decoration-color: #008080">   3.7</span> │ <span style="color: #008000; text-decoration-color: #008000"> ▁▄█▅▁ </span> │  │\n│ └──────────────────┴───────┴─────────┴──────────┴────────┴────────────┴──────────┴────────┴────────┴─────────┘  │\n│ <span style="font-style: italic">                                                   category                                                   </span>  │\n│ ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━┳━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━┓  │\n│ ┃<span style="font-weight: bold"> column_name                      </span>┃<span style="font-weight: bold"> NA        </span>┃<span style="font-weight: bold"> NA %           </span>┃<span style="font-weight: bold"> ordered               </span>┃<span style="font-weight: bold"> unique             </span>┃  │\n│ ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━╇━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━┩  │\n│ │ <span style="color: #af87ff; text-decoration-color: #af87ff">class                           </span> │ <span style="color: #008080; text-decoration-color: #008080">        0</span> │ <span style="color: #008080; text-decoration-color: #008080">             0</span> │ <span style="color: #00d7ff; text-decoration-color: #00d7ff">False                </span> │ <span style="color: #008080; text-decoration-color: #008080">                 2</span> │  │\n│ │ <span style="color: #af87ff; text-decoration-color: #af87ff">location                        </span> │ <span style="color: #008080; text-decoration-color: #008080">        1</span> │ <span style="color: #008080; text-decoration-color: #008080">           0.1</span> │ <span style="color: #00d7ff; text-decoration-color: #00d7ff">False                </span> │ <span style="color: #008080; text-decoration-color: #008080">                 5</span> │  │\n│ └──────────────────────────────────┴───────────┴────────────────┴───────────────────────┴────────────────────┘  │\n│ <span style="font-style: italic">                                                   datetime                                                   </span>  │\n│ ┏━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━┳━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━┓  │\n│ ┃<span style="font-weight: bold"> column_name             </span>┃<span style="font-weight: bold"> NA    </span>┃<span style="font-weight: bold"> NA %      </span>┃<span style="font-weight: bold"> first               </span>┃<span style="font-weight: bold"> last                </span>┃<span style="font-weight: bold"> frequency        </span>┃  │\n│ ┡━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━╇━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━┩  │\n│ │ <span style="color: #af87ff; text-decoration-color: #af87ff">date                   </span> │ <span style="color: #008080; text-decoration-color: #008080">    0</span> │ <span style="color: #008080; text-decoration-color: #008080">        0</span> │ <span style="color: #800000; text-decoration-color: #800000">    2018-01-31     </span> │ <span style="color: #800000; text-decoration-color: #800000">    2101-04-30     </span> │ <span style="color: #af87ff; text-decoration-color: #af87ff">M               </span> │  │\n│ │ <span style="color: #af87ff; text-decoration-color: #af87ff">date_no_freq           </span> │ <span style="color: #008080; text-decoration-color: #008080">    3</span> │ <span style="color: #008080; text-decoration-color: #008080">      0.3</span> │ <span style="color: #800000; text-decoration-color: #800000">    1992-01-05     </span> │ <span style="color: #800000; text-decoration-color: #800000">    2023-03-04     </span> │ <span style="color: #af87ff; text-decoration-color: #af87ff">None            </span> │  │\n│ └─────────────────────────┴───────┴───────────┴─────────────────────┴─────────────────────┴──────────────────┘  │\n│ <span style="font-style: italic">                                                    string                                                    </span>  │\n│ ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━┳━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━┓  │\n│ ┃<span style="font-weight: bold"> column_name               </span>┃<span style="font-weight: bold"> NA      </span>┃<span style="font-weight: bold"> NA %       </span>┃<span style="font-weight: bold"> words per row                </span>┃<span style="font-weight: bold"> total words              </span>┃  │\n│ ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━╇━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━┩  │\n│ │ <span style="color: #af87ff; text-decoration-color: #af87ff">text                     </span> │ <span style="color: #008080; text-decoration-color: #008080">      6</span> │ <span style="color: #008080; text-decoration-color: #008080">       0.6</span> │ <span style="color: #008080; text-decoration-color: #008080">                         5.8</span> │ <span style="color: #008080; text-decoration-color: #008080">                    5800</span> │  │\n│ └───────────────────────────┴─────────┴────────────┴──────────────────────────────┴──────────────────────────┘  │\n│ <span style="font-style: italic">                                                     bool                                                     </span>  │\n│ ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━┓  │\n│ ┃<span style="font-weight: bold"> column_name                        </span>┃<span style="font-weight: bold"> true            </span>┃<span style="font-weight: bold"> true rate                     </span>┃<span style="font-weight: bold"> hist                </span>┃  │\n│ ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━┩  │\n│ │ <span style="color: #af87ff; text-decoration-color: #af87ff">booly_col                         </span> │ <span style="color: #008080; text-decoration-color: #008080">            520</span> │ <span style="color: #008080; text-decoration-color: #008080">                         0.52</span> │ <span style="color: #008000; text-decoration-color: #008000">      █    █       </span> │  │\n│ └────────────────────────────────────┴─────────────────┴───────────────────────────────┴─────────────────────┘  │\n╰────────────────────────────────────────────────────── End ──────────────────────────────────────────────────────╯\n</pre>\n\nIt is recommended that you set your datatypes before using _skimpy_ (for example converting any text columns to pandas string datatype), as this will produce richer statistical summaries. However, the _skim_ function will try and guess what the datatypes of your columns are.\n\n**skimpy** also comes with a `clean_columns` function as a convenience. This slugifies column names. For example,\n\n```python\nimport pandas as pd\nfrom rich import print\nfrom skimpy import clean_columns\n\ncolumns = [\n    "bs lncs;n edbn ",\n    "Nín hǎo. Wǒ shì zhōng guó rén",\n    "___This is a test___",\n    "ÜBER Über German Umlaut",\n]\nmessy_df = pd.DataFrame(columns=columns, index=[0], data=[range(len(columns))])\nprint("Column names:")\nprint(list(messy_df.columns))\n```\n\n<pre style="white-space:pre;overflow-x:auto;line-height:normal;font-family:Menlo,\'DejaVu Sans Mono\',consolas,\'Courier New\',monospace">Column names:\n</pre>\n\n<pre style="white-space:pre;overflow-x:auto;line-height:normal;font-family:Menlo,\'DejaVu Sans Mono\',consolas,\'Courier New\',monospace"><span style="font-weight: bold">[</span><span style="color: #008000; text-decoration-color: #008000">\'bs lncs;n edbn \'</span>, <span style="color: #008000; text-decoration-color: #008000">\'Nín hǎo. Wǒ shì zhōng guó rén\'</span>, <span style="color: #008000; text-decoration-color: #008000">\'___This is a test___\'</span>, <span style="color: #008000; text-decoration-color: #008000">\'ÜBER Über German Umlaut\'</span><span style="font-weight: bold">]</span>\n</pre>\n\nNow let\'s clean these—by default what we get back is in _snake case_:\n\n```python\nclean_df = clean_columns(messy_df)\nprint(list(clean_df.columns))\n```\n\n<pre style="white-space:pre;overflow-x:auto;line-height:normal;font-family:Menlo,\'DejaVu Sans Mono\',consolas,\'Courier New\',monospace"><span style="color: #008080; text-decoration-color: #008080; font-weight: bold">4</span> column names have been cleaned\n</pre>\n\n<pre style="white-space:pre;overflow-x:auto;line-height:normal;font-family:Menlo,\'DejaVu Sans Mono\',consolas,\'Courier New\',monospace"><span style="font-weight: bold">[</span><span style="color: #008000; text-decoration-color: #008000">\'bs_lncs_n_edbn\'</span>, <span style="color: #008000; text-decoration-color: #008000">\'nin_hao_wo_shi_zhong_guo_ren\'</span>, <span style="color: #008000; text-decoration-color: #008000">\'this_is_a_test\'</span>, <span style="color: #008000; text-decoration-color: #008000">\'uber_uber_german_umlaut\'</span><span style="font-weight: bold">]</span>\n</pre>\n\nOther naming conventions are available, for example _camel case_:\n\n```python\nclean_df = clean_columns(messy_df, case="camel")\nprint(list(clean_df.columns))\n```\n\n<pre style="white-space:pre;overflow-x:auto;line-height:normal;font-family:Menlo,\'DejaVu Sans Mono\',consolas,\'Courier New\',monospace"><span style="color: #008080; text-decoration-color: #008080; font-weight: bold">4</span> column names have been cleaned\n</pre>\n\n<pre style="white-space:pre;overflow-x:auto;line-height:normal;font-family:Menlo,\'DejaVu Sans Mono\',consolas,\'Courier New\',monospace"><span style="font-weight: bold">[</span><span style="color: #008000; text-decoration-color: #008000">\'bsLncsNEdbn\'</span>, <span style="color: #008000; text-decoration-color: #008000">\'ninHaoWoShiZhongGuoRen\'</span>, <span style="color: #008000; text-decoration-color: #008000">\'thisIsATest\'</span>, <span style="color: #008000; text-decoration-color: #008000">\'uberUberGermanUmlaut\'</span><span style="font-weight: bold">]</span>\n</pre>\n\n## Requirements\n\nYou can find a full list of requirements in the [pyproject.toml](https://github.com/aeturrell/skimpy/blob/main/pyproject.toml) file. The\nmain requirements are:\n\n```python\nimport toml\nfrom pathlib import Path\n\nconfig = toml.load(Path("../pyproject.toml"))\ndict_main_deps = config["tool"]["poetry"]["dependencies"]\nfor key, value in dict_main_deps.items():\n    print(f"{key} {value}")\n```\n\n<pre style="white-space:pre;overflow-x:auto;line-height:normal;font-family:Menlo,\'DejaVu Sans Mono\',consolas,\'Courier New\',monospace">python &gt;=<span style="color: #008080; text-decoration-color: #008080; font-weight: bold">3.8</span>,&lt;<span style="color: #008080; text-decoration-color: #008080; font-weight: bold">4.0</span>.<span style="color: #008080; text-decoration-color: #008080; font-weight: bold">0</span>\n</pre>\n\n<pre style="white-space:pre;overflow-x:auto;line-height:normal;font-family:Menlo,\'DejaVu Sans Mono\',consolas,\'Courier New\',monospace">click ^<span style="color: #008080; text-decoration-color: #008080; font-weight: bold">8.1</span>.<span style="color: #008080; text-decoration-color: #008080; font-weight: bold">3</span>\n</pre>\n\n<pre style="white-space:pre;overflow-x:auto;line-height:normal;font-family:Menlo,\'DejaVu Sans Mono\',consolas,\'Courier New\',monospace">rich &gt;=<span style="color: #008080; text-decoration-color: #008080; font-weight: bold">10.9</span>,&lt;<span style="color: #008080; text-decoration-color: #008080; font-weight: bold">13.0</span>\n</pre>\n\n<pre style="white-space:pre;overflow-x:auto;line-height:normal;font-family:Menlo,\'DejaVu Sans Mono\',consolas,\'Courier New\',monospace">pandas ^<span style="color: #008080; text-decoration-color: #008080; font-weight: bold">1.3</span>.<span style="color: #008080; text-decoration-color: #008080; font-weight: bold">2</span>\n</pre>\n\n<pre style="white-space:pre;overflow-x:auto;line-height:normal;font-family:Menlo,\'DejaVu Sans Mono\',consolas,\'Courier New\',monospace">Pygments ^<span style="color: #008080; text-decoration-color: #008080; font-weight: bold">2.10</span>.<span style="color: #008080; text-decoration-color: #008080; font-weight: bold">0</span>\n</pre>\n\n<pre style="white-space:pre;overflow-x:auto;line-height:normal;font-family:Menlo,\'DejaVu Sans Mono\',consolas,\'Courier New\',monospace">typeguard ^<span style="color: #008080; text-decoration-color: #008080; font-weight: bold">2.12</span>.<span style="color: #008080; text-decoration-color: #008080; font-weight: bold">1</span>\n</pre>\n\n<pre style="white-space:pre;overflow-x:auto;line-height:normal;font-family:Menlo,\'DejaVu Sans Mono\',consolas,\'Courier New\',monospace">jupyter ^<span style="color: #008080; text-decoration-color: #008080; font-weight: bold">1.0</span>.<span style="color: #008080; text-decoration-color: #008080; font-weight: bold">0</span>\n</pre>\n\n<pre style="white-space:pre;overflow-x:auto;line-height:normal;font-family:Menlo,\'DejaVu Sans Mono\',consolas,\'Courier New\',monospace">ipykernel ^<span style="color: #008080; text-decoration-color: #008080; font-weight: bold">6.7</span>.<span style="color: #008080; text-decoration-color: #008080; font-weight: bold">0</span>\n</pre>\n\n<pre style="white-space:pre;overflow-x:auto;line-height:normal;font-family:Menlo,\'DejaVu Sans Mono\',consolas,\'Courier New\',monospace">numpy ^<span style="color: #008080; text-decoration-color: #008080; font-weight: bold">1.22</span>.<span style="color: #008080; text-decoration-color: #008080; font-weight: bold">2</span>\n</pre>\n\nYou can try this package out right now in your browser using this\n[Google Colab notebook](https://colab.research.google.com/gist/aeturrell/7bf183c559dc1d15ab7e7aaac39ea0ed/skimpy_demo.ipynb)\n(requires a Google account). Note that the Google Colab notebook uses the latest package released on PyPI (rather than the development release).\n\n## Installation\n\nYou can install the latest release of _skimpy_ via\n[pip](https://pip.pypa.io/) from [PyPI](https://pypi.org/):\n\n```bash\n$ pip install skimpy\n```\n\nTo install the development version from git, use:\n\n```bash\n$ pip install git+https://github.com/aeturrell/skimpy.git\n```\n\nFor development, see {ref}`contributing`.\n\n## Usage\n\nThis package is mostly designed to be used within an interactive console\nsession or Jupyter notebook\n\n```python\nfrom skimpy import skim\n\nskim(df)\n```\n\nHowever, you can also use it on the command line:\n\n```bash\n$ skimpy file.csv\n```\n\n## Features\n\n- Support for boolean, numeric, datetime, string, and category\n  datatypes\n- Command line interface in addition to interactive console\n  functionality\n- Light weight, with results printed to terminal using the\n  [rich](https://github.com/willmcgugan/rich) package.\n- Rounds numerical output to 2 significant figures\n\n## Citing Skimpy\n\n```text\n@misc{aeturrell_2022_skimpy,\n  author       = {Arthur Turrell},\n  title        = {Skimpy: v0.0.7},\n  month        = oct,\n  year         = 2022,\n  version      = {0.0.7},\n  url          = {https://github.com/aeturrell/skimpy}\n}\n```\n\nUsing **Skimpy** in your paper? Let us know by raising an issue beginning with "citation" and we\'ll add it to this page.\n\n## Contributing\n\nContributions are very welcome. To learn more, see the page on {ref}`contributing`.\n\nNote that you will need [Make](https://www.gnu.org/software/make/) installed to build the docs automatically\n\n## License\n\nDistributed under the terms of the [MIT license](https://opensource.org/licenses/MIT), _skimpy_ is free and open source software.\n\n## Issues\n\nIf you encounter any problems, please [file an issue](https://github.com/aeturrell/skimpy/issues) along with a detailed description.\n\n## Credits\n\nThis project was generated from [\\@cjolowicz](https://github.com/cjolowicz)\\\'s [Hypermodern Python Cookiecutter](https://github.com/cjolowicz/cookiecutter-hypermodern-python) template.\n\nskimpy was inspired by the R package [skimr](https://docs.ropensci.org/skimr/articles/skimr.html) and by exploratory Python packages including [pandas_profiling](https://pandas-profiling.github.io/pandas-profiling) and [dataprep](https://dataprep.ai/), from which the `clean_columns` function comes.\n\nThe package is built with [poetry](https://python-poetry.org/), while the documentation is built with [Jupyter Book](https://jupyterbook.org). Tests are run with [nox](https://nox.thea.codes/en/stable/).\n',
    'author': 'Arthur Turrell',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://aeturrell.github.io/skimpy/',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0.0',
}


setup(**setup_kwargs)
