# -*- coding: utf-8 -*-
# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from .vmwareengine import (
    CreateClusterRequest,
    CreateExternalAccessRuleRequest,
    CreateExternalAddressRequest,
    CreateHcxActivationKeyRequest,
    CreateLoggingServerRequest,
    CreateManagementDnsZoneBindingRequest,
    CreateNetworkPeeringRequest,
    CreateNetworkPolicyRequest,
    CreatePrivateCloudRequest,
    CreatePrivateConnectionRequest,
    CreateVmwareEngineNetworkRequest,
    DeleteClusterRequest,
    DeleteExternalAccessRuleRequest,
    DeleteExternalAddressRequest,
    DeleteLoggingServerRequest,
    DeleteManagementDnsZoneBindingRequest,
    DeleteNetworkPeeringRequest,
    DeleteNetworkPolicyRequest,
    DeletePrivateCloudRequest,
    DeletePrivateConnectionRequest,
    DeleteVmwareEngineNetworkRequest,
    FetchNetworkPolicyExternalAddressesRequest,
    FetchNetworkPolicyExternalAddressesResponse,
    GetClusterRequest,
    GetDnsBindPermissionRequest,
    GetDnsForwardingRequest,
    GetExternalAccessRuleRequest,
    GetExternalAddressRequest,
    GetHcxActivationKeyRequest,
    GetLoggingServerRequest,
    GetManagementDnsZoneBindingRequest,
    GetNetworkPeeringRequest,
    GetNetworkPolicyRequest,
    GetNodeRequest,
    GetNodeTypeRequest,
    GetPrivateCloudRequest,
    GetPrivateConnectionRequest,
    GetSubnetRequest,
    GetVmwareEngineNetworkRequest,
    GrantDnsBindPermissionRequest,
    ListClustersRequest,
    ListClustersResponse,
    ListExternalAccessRulesRequest,
    ListExternalAccessRulesResponse,
    ListExternalAddressesRequest,
    ListExternalAddressesResponse,
    ListHcxActivationKeysRequest,
    ListHcxActivationKeysResponse,
    ListLoggingServersRequest,
    ListLoggingServersResponse,
    ListManagementDnsZoneBindingsRequest,
    ListManagementDnsZoneBindingsResponse,
    ListNetworkPeeringsRequest,
    ListNetworkPeeringsResponse,
    ListNetworkPoliciesRequest,
    ListNetworkPoliciesResponse,
    ListNodesRequest,
    ListNodesResponse,
    ListNodeTypesRequest,
    ListNodeTypesResponse,
    ListPeeringRoutesRequest,
    ListPeeringRoutesResponse,
    ListPrivateCloudsRequest,
    ListPrivateCloudsResponse,
    ListPrivateConnectionPeeringRoutesRequest,
    ListPrivateConnectionPeeringRoutesResponse,
    ListPrivateConnectionsRequest,
    ListPrivateConnectionsResponse,
    ListSubnetsRequest,
    ListSubnetsResponse,
    ListVmwareEngineNetworksRequest,
    ListVmwareEngineNetworksResponse,
    OperationMetadata,
    RepairManagementDnsZoneBindingRequest,
    ResetNsxCredentialsRequest,
    ResetVcenterCredentialsRequest,
    RevokeDnsBindPermissionRequest,
    ShowNsxCredentialsRequest,
    ShowVcenterCredentialsRequest,
    UndeletePrivateCloudRequest,
    UpdateClusterRequest,
    UpdateDnsForwardingRequest,
    UpdateExternalAccessRuleRequest,
    UpdateExternalAddressRequest,
    UpdateLoggingServerRequest,
    UpdateManagementDnsZoneBindingRequest,
    UpdateNetworkPeeringRequest,
    UpdateNetworkPolicyRequest,
    UpdatePrivateCloudRequest,
    UpdatePrivateConnectionRequest,
    UpdateSubnetRequest,
    UpdateVmwareEngineNetworkRequest,
)
from .vmwareengine_resources import (
    AutoscalingSettings,
    Cluster,
    Credentials,
    DnsBindPermission,
    DnsForwarding,
    ExternalAccessRule,
    ExternalAddress,
    Hcx,
    HcxActivationKey,
    LocationMetadata,
    LoggingServer,
    ManagementDnsZoneBinding,
    NetworkConfig,
    NetworkPeering,
    NetworkPolicy,
    Node,
    NodeType,
    NodeTypeConfig,
    Nsx,
    PeeringRoute,
    Principal,
    PrivateCloud,
    PrivateConnection,
    StretchedClusterConfig,
    Subnet,
    Vcenter,
    VmwareEngineNetwork,
)

__all__ = (
    "CreateClusterRequest",
    "CreateExternalAccessRuleRequest",
    "CreateExternalAddressRequest",
    "CreateHcxActivationKeyRequest",
    "CreateLoggingServerRequest",
    "CreateManagementDnsZoneBindingRequest",
    "CreateNetworkPeeringRequest",
    "CreateNetworkPolicyRequest",
    "CreatePrivateCloudRequest",
    "CreatePrivateConnectionRequest",
    "CreateVmwareEngineNetworkRequest",
    "DeleteClusterRequest",
    "DeleteExternalAccessRuleRequest",
    "DeleteExternalAddressRequest",
    "DeleteLoggingServerRequest",
    "DeleteManagementDnsZoneBindingRequest",
    "DeleteNetworkPeeringRequest",
    "DeleteNetworkPolicyRequest",
    "DeletePrivateCloudRequest",
    "DeletePrivateConnectionRequest",
    "DeleteVmwareEngineNetworkRequest",
    "FetchNetworkPolicyExternalAddressesRequest",
    "FetchNetworkPolicyExternalAddressesResponse",
    "GetClusterRequest",
    "GetDnsBindPermissionRequest",
    "GetDnsForwardingRequest",
    "GetExternalAccessRuleRequest",
    "GetExternalAddressRequest",
    "GetHcxActivationKeyRequest",
    "GetLoggingServerRequest",
    "GetManagementDnsZoneBindingRequest",
    "GetNetworkPeeringRequest",
    "GetNetworkPolicyRequest",
    "GetNodeRequest",
    "GetNodeTypeRequest",
    "GetPrivateCloudRequest",
    "GetPrivateConnectionRequest",
    "GetSubnetRequest",
    "GetVmwareEngineNetworkRequest",
    "GrantDnsBindPermissionRequest",
    "ListClustersRequest",
    "ListClustersResponse",
    "ListExternalAccessRulesRequest",
    "ListExternalAccessRulesResponse",
    "ListExternalAddressesRequest",
    "ListExternalAddressesResponse",
    "ListHcxActivationKeysRequest",
    "ListHcxActivationKeysResponse",
    "ListLoggingServersRequest",
    "ListLoggingServersResponse",
    "ListManagementDnsZoneBindingsRequest",
    "ListManagementDnsZoneBindingsResponse",
    "ListNetworkPeeringsRequest",
    "ListNetworkPeeringsResponse",
    "ListNetworkPoliciesRequest",
    "ListNetworkPoliciesResponse",
    "ListNodesRequest",
    "ListNodesResponse",
    "ListNodeTypesRequest",
    "ListNodeTypesResponse",
    "ListPeeringRoutesRequest",
    "ListPeeringRoutesResponse",
    "ListPrivateCloudsRequest",
    "ListPrivateCloudsResponse",
    "ListPrivateConnectionPeeringRoutesRequest",
    "ListPrivateConnectionPeeringRoutesResponse",
    "ListPrivateConnectionsRequest",
    "ListPrivateConnectionsResponse",
    "ListSubnetsRequest",
    "ListSubnetsResponse",
    "ListVmwareEngineNetworksRequest",
    "ListVmwareEngineNetworksResponse",
    "OperationMetadata",
    "RepairManagementDnsZoneBindingRequest",
    "ResetNsxCredentialsRequest",
    "ResetVcenterCredentialsRequest",
    "RevokeDnsBindPermissionRequest",
    "ShowNsxCredentialsRequest",
    "ShowVcenterCredentialsRequest",
    "UndeletePrivateCloudRequest",
    "UpdateClusterRequest",
    "UpdateDnsForwardingRequest",
    "UpdateExternalAccessRuleRequest",
    "UpdateExternalAddressRequest",
    "UpdateLoggingServerRequest",
    "UpdateManagementDnsZoneBindingRequest",
    "UpdateNetworkPeeringRequest",
    "UpdateNetworkPolicyRequest",
    "UpdatePrivateCloudRequest",
    "UpdatePrivateConnectionRequest",
    "UpdateSubnetRequest",
    "UpdateVmwareEngineNetworkRequest",
    "AutoscalingSettings",
    "Cluster",
    "Credentials",
    "DnsBindPermission",
    "DnsForwarding",
    "ExternalAccessRule",
    "ExternalAddress",
    "Hcx",
    "HcxActivationKey",
    "LocationMetadata",
    "LoggingServer",
    "ManagementDnsZoneBinding",
    "NetworkConfig",
    "NetworkPeering",
    "NetworkPolicy",
    "Node",
    "NodeType",
    "NodeTypeConfig",
    "Nsx",
    "PeeringRoute",
    "Principal",
    "PrivateCloud",
    "PrivateConnection",
    "StretchedClusterConfig",
    "Subnet",
    "Vcenter",
    "VmwareEngineNetwork",
)
