# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cloudsaga', 'cloudsaga.scenarios']

package_data = \
{'': ['*']}

install_requires = \
['boto3>=1.21.7,<2.0.0']

entry_points = \
{'console_scripts': ['cloudsaga = cloudsaga.cloudsaga:main']}

setup_kwargs = {
    'name': 'cloudsaga',
    'version': '1.0.1',
    'description': 'AWS CloudSaga is a tool to test security controls and alerts within their Amazon Web Services (AWS) environment',
    'long_description': '# AWS CloudSaga - Simulate security events in AWS\nAWS CloudSaga is for customers to test security controls and alerts within their Amazon Web Services (AWS) environment, using generated alerts based on security events seen by the AWS Customer Incident Response Team (CIRT).\n\n## Use Case\nSecurity controls and best practices are published for securing AWS accounts, however, customers look for mechanisms to test security and incident response within their AWS environments, in order to protect themselves against known security events. \n\nAWS CloudSaga is for customers who want to test their environment against documented security events from the AWS CIRT. Using AWS CloudSaga, simple scenarios that mimic actual security events can be run against a customer\'s environment, testing the customer\'s response plans and defenses when these events occur, and improve defenses of their AWS environment from the results.\n\n## Usage\n```\ncloudsaga\n\n\n\n     ___   ____    __    ____   _______.          \n    /   \\  \\   \\  /  \\  /   /  /       |         \n   /  ^  \\  \\   \\/    \\/   /  |   (----`       \n  /  /_\\  \\  \\            /    \\   \\         \n /  _____  \\  \\    /\\    / .----)   |      \n/__/     \\__\\  \\__/  \\__/  |_______/       \n\n  ______  __        ______    __    __   _______       _______.     ___       _______      ___\n /      ||  |      /  __  \\  |  |  |  | |       \\     /       |    /   \\     /  _____|    /   \\ \n|  ,----\'|  |     |  |  |  | |  |  |  | |  .--.  |   |   (----`   /  ^  \\   |  |  __     /  ^  \\ \n|  |     |  |     |  |  |  | |  |  |  | |  |  |  |    \\   \\      /  /_\\  \\  |  | |_ |   /  /_\\  \\ \n|  `----.|  `----.|  `--\'  | |  `--\'  | |  \'--\'  |.----)   |    /  _____  \\ |  |__| |  /  _____  \\  \n \\______||_______| \\______/   \\______/  |_______/ |_______/    /__/     \\__\\ \\______| /__/     \\__\\ \n                                                                                                                                               \n\n\n            Joshua "DozerCat" McKiddy - Team DragonCat - AWS\n            Type -h for help.\n\n    usage: cloudsaga.py [-h] [--scenario SCENARIO] [--chapters] [--about ABOUT]\n\n    CloudSaga - Simulate security events based on previous Ziplines\n\n    optional arguments:\n    -h, --help           show this help message and exit\n    --scenario SCENARIO  Perform the scenario you want to run against your AWS\n                        environment.\n    --chapters           List the available scenarios within CloudSaga. Use the\n                        --about flag to read details about a specific scenario.\n    --about ABOUT        Read about a specific scenario (e.g. --about\n                        <scenario>. For a list of available scenarios, use the\n                        --chapters flag.\n```\n\n\n## Prerequesites\n### Permissions\nThe following permissions are needed within AWS IAM for CloudSaga to run:\n* For imds-reveal:\n```\n"ec2:DescribeInstances"\n```\n* For network-changes:\n```\n"ec2:DescribeInstances",\n"ec2:RunInstances",\n"ec2:CreateVpc",\n"ec2:DescribeVpcs",\n"ec2:CreateSecurityGroup"\n```\n* For mining-bitcoin:\n```\n"ec2:DescribeInstances",\n"ec2:RunInstances"\n```\n* For iam-credentials:\n```\n"iam:GenerateCredentialReport",\n"iam:GetCredentialReport"\n```\n* For public-resources:\n```\n"rds:DescribeDBInstances",\n"rds:CreateDBInstance",\n"rds:DeleteDBInstance",\n"s3:ListBuckets",\n"s3:CreateBucket",\n"s3:PutPublicAccessBlock",\n"s3:DeletePublicAccessBlock"\n```\n\n## Specific Scenario Details\n```\nIMDS Reveal Scenario:\nThis scenario is based on a server-side request forgery attack. \nEC2 instances using IMDS version 1 are more likely to be subject to this \nkind of software flaw, and if EC2 Role credentials are present, those \ncredentials can be used in AWS.\n```\n```\nBitcoin Mining Scenario:\nThis scenario simulates the creation of Bitcoin mining instances.\nAttackers attempt to create Bitcoin mining instances using Amazon EC2,\nin order to leverage legitimate AWS customer\'s resources for their own purposes.\n```\n```\nNetwork Changes Scenario:\nThis scenario simulates the creation and modification of network resources within\nAWS. This includes creating Amazon VPCs, as well as modifications to Security Groups,\nfor the purposes of compromising resources within the AWS account.\n```\n```\nIAM Credentials Scenario:\nThis scenario attempts to grab the IAM credential report within the AWS account.\n```\n```\nPublicly Accessible Resources Scenario:\nThis scenario is for creating then checking for publicly accessible resources within an AWS account.\n```\n\n## Running the Code\nThe code in it\'s current form can be ran inside the following:\n* AWS CloudShell (preferred)\n* Locally (with IAM credentials, not preferred)\n\n## Prerequisites\nThe following prerequisites are required to use AWS CloudSaga\n* Python 3.7 or later\n* pip3 (for installation of AWS CloudSaga)\n\n## Installing the code\nAfter cloning the repository, you can install AWS CloudSaga locally via pip3.\n```\n# Clone AWS CloudSaga:\ngit clone https://github.com/awslabs/aws-cloudsaga\n# Go into the directory aws-cloudsaga:\ncd aws-cloudsaga\n# Run pip3 to install the local packages\npip3 install .\n```\n\n## Step-by-Step Instructions (for running in AWS CloudShell)\n1. Log into the AWS Console of the account you want to run AWS CloudSaga.\n2. Click on the icon for AWS Cloudshell next to the search bar.\n   * Ensure that you\'re in a region where AWS CloudShell is currently available.\n3. Once the session begins, download AWS CloudSaga within the AWS CloudShell session.\n```\ngit clone https://github.com/awslabs/aws-cloudsaga.git\n```\n4. Change the directory to the folder cloned from the link in Step 3:\n```\ncd aws-cloudsaga\n```\n5. Run the following command to review the help page for AWS CloudSaga.\n```\npython3 cloudsaga.py -h\n```\n6. Review the scenarios, select the one that you want to run for generating your security event for testing.\n\n### Logging\nA log file containing the detailed output of actions will be placed in the root directory of AWS CloudSaga. The format of the file will be cloudsaga_timestamp_here.log\n\nSample output within the log file:\n```\n2022-02-22 01:20:47,826 - INFO - --Checking instances in AWS region me-south-1--\n2022-02-22 01:20:47,826 - INFO - DescribeInstances API Call in AWS region me-south-1--\n2022-02-22 01:20:48,712 - INFO - You cannot perform lookup of IMDS versions in this region. Error message below:\n2022-02-22 01:20:48,712 - ERROR - An error occurred (AuthFailure) when calling the DescribeInstances operation: AWS was not able to validate the provided access credentials\n2022-02-22 01:20:48,713 - INFO - --Checking instances in AWS region sa-east-1--\n2022-02-22 01:20:48,713 - INFO - DescribeInstances API Call in AWS region sa-east-1--\n2022-02-22 01:20:49,525 - INFO - --Checking instances in AWS region us-east-1--\n2022-02-22 01:20:49,525 - INFO - DescribeInstances API Call in AWS region us-east-1--\n2022-02-22 01:20:49,876 - INFO - --Checking instances in AWS region us-east-2--\n2022-02-22 01:20:49,876 - INFO - DescribeInstances API Call in AWS region us-east-2--\n2022-02-22 01:20:50,192 - INFO - --Checking instances in AWS region us-west-1--\n2022-02-22 01:20:50,192 - INFO - DescribeInstances API Call in AWS region us-west-1--\n2022-02-22 01:20:50,444 - INFO - --Checking instances in AWS region us-west-2--\n2022-02-22 01:20:50,445 - INFO - DescribeInstances API Call in AWS region us-west-2--\n2022-02-22 01:20:50,610 - INFO - Instance ID i-99999999999999999 is using IMDSv1, where no authentication header is required to access the IMDS service.\n```\n\n## Cleaning Up\nOnce the logs have been enabled, you can safely remove any of the downloaded files from AWS CloudShell.\n* Note: The log file containing the detailed output of actions will be in the root directory of AWS CloudSaga. If you want to retain this, please download this to a safe place, either locally or to an Amazon S3 bucket, for your records. For information on how to download files from AWS CloudShell sessions, refer to the following [link](https://docs.aws.amazon.com/cloudshell/latest/userguide/working-with-cloudshell.html#files-storage).\n\n## Feedback\nPlease use the Issues section to submit any feedback, such as features or recommendations, as well as any bugs that are encountered.\n\n## Security\n\nSee [CONTRIBUTING](CONTRIBUTING.md#security-issue-notifications) for more information.\n\n## License\n\nThis project is licensed under the Apache-2.0 License.\n',
    'author': 'Joshua McKiddy',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/awslabs/aws-cloudsaga',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
