"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RollbackEvent = exports.EcsDeploymentGroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_codedeploy_1 = require("@aws-cdk/aws-codedeploy");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const ecs_deployment_config_1 = require("./ecs-deployment-config");
class EcsDeploymentGroup extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const { applicationName, deploymentGroupName, deploymentConfig, ecsServices, targetGroupNames, prodTrafficListener, testTrafficListener, terminationWaitTimeInMinutes = 60, autoRollbackOnEvents, } = props;
        if (terminationWaitTimeInMinutes > 2880) {
            throw new Error('Invalid TerminationWaitTimeInMinutes: The maximum setting is 2880 minutes (2 days).');
        }
        const codeDeployEcsRole = new aws_iam_1.Role(this, 'EcsCodeDeployRole', {
            assumedBy: new aws_iam_1.ServicePrincipal('codedeploy.amazonaws.com'),
            managedPolicies: [aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AWSCodeDeployRoleForECS')],
        });
        this.application = new aws_codedeploy_1.EcsApplication(this, 'EcsApplication', {
            applicationName,
        });
        const serviceToken = core_1.CustomResourceProvider.getOrCreate(this, 'Custom::EcsDeploymentGroup', {
            codeDirectory: path.join(__dirname, 'lambdas', 'ecs-deployment-group'),
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_12_X,
            policyStatements: [
                {
                    Effect: aws_iam_1.Effect.ALLOW,
                    Action: ['codeDeploy:CreateDeploymentGroup', 'codeDeploy:UpdateDeploymentGroup', 'codeDeploy:DeleteDeploymentGroup'],
                    Resource: '*',
                },
                {
                    Effect: aws_iam_1.Effect.ALLOW,
                    Action: ['iam:PassRole'],
                    Resource: codeDeployEcsRole.roleArn,
                },
            ],
        });
        this.deploymentConfig = deploymentConfig || ecs_deployment_config_1.EcsDeploymentConfig.ALL_AT_ONCE;
        if (core_1.Construct.isConstruct(props.deploymentConfig)) {
            this.node.addDependency(props.deploymentConfig);
        }
        const ecsDeploymentGroup = new core_1.CustomResource(this, 'CustomResource', {
            serviceToken,
            resourceType: 'Custom::EcsDeploymentGroup',
            properties: {
                ApplicationName: this.application.applicationName,
                DeploymentGroupName: deploymentGroupName,
                ServiceRoleArn: codeDeployEcsRole.roleArn,
                TargetGroupNames: targetGroupNames,
                EcsServices: ecsServices.map((service) => ({
                    ClusterName: service.clusterName,
                    ServiceName: service.serviceName,
                })),
                ProdTrafficListenerArn: prodTrafficListener.listenerArn,
                TestTrafficListenerArn: testTrafficListener.listenerArn,
                TerminationWaitTimeInMinutes: terminationWaitTimeInMinutes,
                AutoRollbackOnEvents: autoRollbackOnEvents,
                DeploymentConfigName: this.deploymentConfig.deploymentConfigName,
            },
        });
        this.deploymentGroupName = ecsDeploymentGroup.ref;
        this.deploymentGroupArn = this.arnForDeploymentGroup(this.application.applicationName, this.deploymentGroupName);
    }
    arnForDeploymentGroup(applicationName, deploymentGroupName) {
        return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:deploymentgroup:${applicationName}/${deploymentGroupName}`;
    }
}
exports.EcsDeploymentGroup = EcsDeploymentGroup;
_a = JSII_RTTI_SYMBOL_1;
EcsDeploymentGroup[_a] = { fqn: "@cloudcomponents/cdk-blue-green-container-deployment.EcsDeploymentGroup", version: "1.41.0" };
var RollbackEvent;
(function (RollbackEvent) {
    RollbackEvent["DEPLOYMENT_FAILURE"] = "DEPLOYMENT_FAILURE";
    RollbackEvent["DEPLOYMENT_STOP_ON_ALARM"] = "DEPLOYMENT_STOP_ON_ALARM";
    RollbackEvent["DEPLOYMENT_STOP_ON_REQUEST"] = "DEPLOYMENT_STOP_ON_REQUEST";
})(RollbackEvent = exports.RollbackEvent || (exports.RollbackEvent = {}));
//# sourceMappingURL=data:application/json;base64,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