# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import Callable

from ....config import Config
from ....context import Context
from ....event.event import set_event_callback

from .model import *


class RoomCreatedEventHandler(object):
    def __init__(self, callback):
        # type: (Callable[[Context, Config, RoomCreatedEvent], Any]) -> None
        self.handler = callback

    def handle(self, ctx, conf, event):  # type: (Context, Config, RoomCreatedEvent) -> Any
        return self.handler(ctx, conf, event)

    @staticmethod
    def set_callback(conf, callback):
        # type: (Config, Callable[[Context, Config, RoomCreatedEvent], Any]) -> None
        handler = RoomCreatedEventHandler(callback)
        set_event_callback(conf, "meeting_room.room.created_v1",
                          handler.handle, clazz=RoomCreatedEvent)


class RoomDeletedEventHandler(object):
    def __init__(self, callback):
        # type: (Callable[[Context, Config, RoomDeletedEvent], Any]) -> None
        self.handler = callback

    def handle(self, ctx, conf, event):  # type: (Context, Config, RoomDeletedEvent) -> Any
        return self.handler(ctx, conf, event)

    @staticmethod
    def set_callback(conf, callback):
        # type: (Config, Callable[[Context, Config, RoomDeletedEvent], Any]) -> None
        handler = RoomDeletedEventHandler(callback)
        set_event_callback(conf, "meeting_room.room.deleted_v1",
                          handler.handle, clazz=RoomDeletedEvent)


class RoomStatusChangedEventHandler(object):
    def __init__(self, callback):
        # type: (Callable[[Context, Config, RoomStatusChangedEvent], Any]) -> None
        self.handler = callback

    def handle(self, ctx, conf, event):  # type: (Context, Config, RoomStatusChangedEvent) -> Any
        return self.handler(ctx, conf, event)

    @staticmethod
    def set_callback(conf, callback):
        # type: (Config, Callable[[Context, Config, RoomStatusChangedEvent], Any]) -> None
        handler = RoomStatusChangedEventHandler(callback)
        set_event_callback(conf, "meeting_room.room.status_changed_v1",
                          handler.handle, clazz=RoomStatusChangedEvent)


class RoomUpdatedEventHandler(object):
    def __init__(self, callback):
        # type: (Callable[[Context, Config, RoomUpdatedEvent], Any]) -> None
        self.handler = callback

    def handle(self, ctx, conf, event):  # type: (Context, Config, RoomUpdatedEvent) -> Any
        return self.handler(ctx, conf, event)

    @staticmethod
    def set_callback(conf, callback):
        # type: (Config, Callable[[Context, Config, RoomUpdatedEvent], Any]) -> None
        handler = RoomUpdatedEventHandler(callback)
        set_event_callback(conf, "meeting_room.room.updated_v1",
                          handler.handle, clazz=RoomUpdatedEvent)


class MeetingRoomStatusChangedEventHandler(object):
    def __init__(self, callback):
        # type: (Callable[[Context, Config, MeetingRoomStatusChangedEvent], Any]) -> None
        self.handler = callback

    def handle(self, ctx, conf, event):  # type: (Context, Config, MeetingRoomStatusChangedEvent) -> Any
        return self.handler(ctx, conf, event)

    @staticmethod
    def set_callback(conf, callback):
        # type: (Config, Callable[[Context, Config, MeetingRoomStatusChangedEvent], Any]) -> None
        handler = MeetingRoomStatusChangedEventHandler(callback)
        set_event_callback(conf, "meeting_room.meeting_room.status_changed_v1",
                          handler.handle, clazz=MeetingRoomStatusChangedEvent)


class MeetingRoomCreatedEventHandler(object):
    def __init__(self, callback):
        # type: (Callable[[Context, Config, MeetingRoomCreatedEvent], Any]) -> None
        self.handler = callback

    def handle(self, ctx, conf, event):  # type: (Context, Config, MeetingRoomCreatedEvent) -> Any
        return self.handler(ctx, conf, event)

    @staticmethod
    def set_callback(conf, callback):
        # type: (Config, Callable[[Context, Config, MeetingRoomCreatedEvent], Any]) -> None
        handler = MeetingRoomCreatedEventHandler(callback)
        set_event_callback(conf, "meeting_room.meeting_room.created_v1",
                          handler.handle, clazz=MeetingRoomCreatedEvent)


class MeetingRoomDeletedEventHandler(object):
    def __init__(self, callback):
        # type: (Callable[[Context, Config, MeetingRoomDeletedEvent], Any]) -> None
        self.handler = callback

    def handle(self, ctx, conf, event):  # type: (Context, Config, MeetingRoomDeletedEvent) -> Any
        return self.handler(ctx, conf, event)

    @staticmethod
    def set_callback(conf, callback):
        # type: (Config, Callable[[Context, Config, MeetingRoomDeletedEvent], Any]) -> None
        handler = MeetingRoomDeletedEventHandler(callback)
        set_event_callback(conf, "meeting_room.meeting_room.deleted_v1",
                          handler.handle, clazz=MeetingRoomDeletedEvent)


class MeetingRoomUpdatedEventHandler(object):
    def __init__(self, callback):
        # type: (Callable[[Context, Config, MeetingRoomUpdatedEvent], Any]) -> None
        self.handler = callback

    def handle(self, ctx, conf, event):  # type: (Context, Config, MeetingRoomUpdatedEvent) -> Any
        return self.handler(ctx, conf, event)

    @staticmethod
    def set_callback(conf, callback):
        # type: (Config, Callable[[Context, Config, MeetingRoomUpdatedEvent], Any]) -> None
        handler = MeetingRoomUpdatedEventHandler(callback)
        set_event_callback(conf, "meeting_room.meeting_room.updated_v1",
                          handler.handle, clazz=MeetingRoomUpdatedEvent)
