# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request, Response, set_timeout, set_tenant_key, set_user_access_token, set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.messages = MessageService(self)
        self.chats = ChatService(self)
        self.chat_member_users = ChatMemberUserService(self)
        self.chat_member_bots = ChatMemberBotService(self)
        self.message_reactions = MessageReactionService(self)
        self.chat_announcements = ChatAnnouncementService(self)
        self.chat_memberss = ChatMembersService(self)
        self.files = FileService(self)
        self.images = ImageService(self)
        self.message_resources = MessageResourceService(self)
        self.chat_custom_bots = ChatCustomBotService(self)
        



class MessageService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def list(self, tenant_key=None, timeout=None):
        # type: (str, int) -> MessageListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return MessageListReqCall(self, request_opts=request_opts)

    def patch(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (MessagePatchReqBody, str, str, int) -> MessagePatchReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MessagePatchReqCall(self, body, request_opts=request_opts)

    def reply(self, body, tenant_key=None, timeout=None):
        # type: (MessageReplyReqBody, str, int) -> MessageReplyReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return MessageReplyReqCall(self, body, request_opts=request_opts)

    def create(self, body, tenant_key=None, timeout=None):
        # type: (MessageCreateReqBody, str, int) -> MessageCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return MessageCreateReqCall(self, body, request_opts=request_opts)

    def delete(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> MessageDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MessageDeleteReqCall(self, request_opts=request_opts)

    def read_users(self, tenant_key=None, timeout=None):
        # type: (str, int) -> MessageReadUsersReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return MessageReadUsersReqCall(self, request_opts=request_opts)

    def get(self, tenant_key=None, timeout=None):
        # type: (str, int) -> MessageGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return MessageGetReqCall(self, request_opts=request_opts)


class ChatService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def update(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (ChatUpdateReqBody, str, str, int) -> ChatUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return ChatUpdateReqCall(self, body, request_opts=request_opts)

    def list(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> ChatListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return ChatListReqCall(self, request_opts=request_opts)

    def delete(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> ChatDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return ChatDeleteReqCall(self, request_opts=request_opts)

    def get(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> ChatGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return ChatGetReqCall(self, request_opts=request_opts)

    def create(self, body, tenant_key=None, timeout=None):
        # type: (ChatCreateReqBody, str, int) -> ChatCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return ChatCreateReqCall(self, body, request_opts=request_opts)

    def search(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> ChatSearchReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return ChatSearchReqCall(self, request_opts=request_opts)


class ChatMemberUserService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service


class ChatMemberBotService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service


class MessageReactionService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def create(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (MessageReactionCreateReqBody, str, str, int) -> MessageReactionCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MessageReactionCreateReqCall(self, body, request_opts=request_opts)

    def delete(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> MessageReactionDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MessageReactionDeleteReqCall(self, request_opts=request_opts)

    def list(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> MessageReactionListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MessageReactionListReqCall(self, request_opts=request_opts)


class ChatAnnouncementService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def get(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> ChatAnnouncementGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return ChatAnnouncementGetReqCall(self, request_opts=request_opts)

    def patch(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (ChatAnnouncementPatchReqBody, str, str, int) -> ChatAnnouncementPatchReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return ChatAnnouncementPatchReqCall(self, body, request_opts=request_opts)


class ChatMembersService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def create(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (ChatMembersCreateReqBody, str, str, int) -> ChatMembersCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return ChatMembersCreateReqCall(self, body, request_opts=request_opts)

    def delete(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (ChatMembersDeleteReqBody, str, str, int) -> ChatMembersDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return ChatMembersDeleteReqCall(self, body, request_opts=request_opts)

    def get(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> ChatMembersGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return ChatMembersGetReqCall(self, request_opts=request_opts)

    def is_in_chat(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> ChatMembersIsInChatReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return ChatMembersIsInChatReqCall(self, request_opts=request_opts)

    def me_join(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> ChatMembersMeJoinReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return ChatMembersMeJoinReqCall(self, request_opts=request_opts)


class FileService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def create(self, tenant_key=None, timeout=None):
        # type: (str, int) -> FileCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return FileCreateReqCall(self, request_opts=request_opts)

    def get(self, tenant_key=None, response_stream=None, timeout=None):
        # type: (str, Union[None, IO], int) -> FileGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if response_stream is not None:
            request_opts += [set_response_stream(response_stream)]

        return FileGetReqCall(self, request_opts=request_opts)


class ImageService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def create(self, tenant_key=None, timeout=None):
        # type: (str, int) -> ImageCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return ImageCreateReqCall(self, request_opts=request_opts)

    def get(self, tenant_key=None, response_stream=None, timeout=None):
        # type: (str, Union[None, IO], int) -> ImageGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if response_stream is not None:
            request_opts += [set_response_stream(response_stream)]

        return ImageGetReqCall(self, request_opts=request_opts)


class MessageResourceService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def get(self, tenant_key=None, response_stream=None, timeout=None):
        # type: (str, Union[None, IO], int) -> MessageResourceGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if response_stream is not None:
            request_opts += [set_response_stream(response_stream)]

        return MessageResourceGetReqCall(self, request_opts=request_opts)


class ChatCustomBotService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def create(self, body, tenant_key=None, timeout=None):
        # type: (ChatCustomBotCreateReqBody, str, int) -> ChatCustomBotCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return ChatCustomBotCreateReqCall(self, body, request_opts=request_opts)

    def delete(self, tenant_key=None, timeout=None):
        # type: (str, int) -> ChatCustomBotDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return ChatCustomBotDeleteReqCall(self, request_opts=request_opts)

    def get(self, tenant_key=None, timeout=None):
        # type: (str, int) -> ChatCustomBotGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return ChatCustomBotGetReqCall(self, request_opts=request_opts)

    def patch(self, body, tenant_key=None, timeout=None):
        # type: (ChatCustomBotPatchReqBody, str, int) -> ChatCustomBotPatchReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return ChatCustomBotPatchReqCall(self, body, request_opts=request_opts)



class MessageListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MessageService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_container_id_type(self, container_id_type):
        # type: (str) -> MessageListReqCall
        self.query_params['container_id_type'] = container_id_type
        return self

    def set_container_id(self, container_id):
        # type: (str) -> MessageListReqCall
        self.query_params['container_id'] = container_id
        return self

    def set_start_time(self, start_time):
        # type: (str) -> MessageListReqCall
        self.query_params['start_time'] = start_time
        return self

    def set_end_time(self, end_time):
        # type: (str) -> MessageListReqCall
        self.query_params['end_time'] = end_time
        return self

    def set_page_token(self, page_token):
        # type: (str) -> MessageListReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> MessageListReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> Response[MessageListResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('im/v1/messages', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=MessageListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MessagePatchReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MessageService, MessagePatchReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_message_id(self, message_id):
        # type: (str) -> MessagePatchReqCall
        self.path_params['message_id'] = message_id
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('im/v1/messages/:message_id', 'PATCH', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MessageReplyReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MessageService, MessageReplyReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_message_id(self, message_id):
        # type: (str) -> MessageReplyReqCall
        self.path_params['message_id'] = message_id
        return self

    def do(self):
        # type: () -> Response[Message]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('im/v1/messages/:message_id/reply', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=Message, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MessageCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MessageService, MessageCreateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_receive_id_type(self, receive_id_type):
        # type: (str) -> MessageCreateReqCall
        self.query_params['receive_id_type'] = receive_id_type
        return self

    def do(self):
        # type: () -> Response[Message]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('im/v1/messages', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=Message, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MessageDeleteReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MessageService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_message_id(self, message_id):
        # type: (str) -> MessageDeleteReqCall
        self.path_params['message_id'] = message_id
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('im/v1/messages/:message_id', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MessageReadUsersReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MessageService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_message_id(self, message_id):
        # type: (str) -> MessageReadUsersReqCall
        self.path_params['message_id'] = message_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> MessageReadUsersReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_page_size(self, page_size):
        # type: (int) -> MessageReadUsersReqCall
        self.query_params['page_size'] = page_size
        return self

    def set_page_token(self, page_token):
        # type: (str) -> MessageReadUsersReqCall
        self.query_params['page_token'] = page_token
        return self

    def do(self):
        # type: () -> Response[MessageReadUsersResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('im/v1/messages/:message_id/read_users', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=MessageReadUsersResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ChatUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (ChatService, ChatUpdateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_chat_id(self, chat_id):
        # type: (str) -> ChatUpdateReqCall
        self.path_params['chat_id'] = chat_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> ChatUpdateReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('im/v1/chats/:chat_id', 'PUT', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FileCreateReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (FileService, List[Any]) -> None

        self.service = service
        self.body = FormData()

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_file_type(self, file_type):
        # type: (str) -> FileCreateReqCall
        self.body.add_param('file_type', file_type)
        return self

    def set_file_name(self, file_name):
        # type: (str) -> FileCreateReqCall
        self.body.add_param('file_name', file_name)
        return self

    def set_duration(self, duration):
        # type: (int) -> FileCreateReqCall
        self.body.add_param('duration', duration)
        return self

    def set_file(self, file):
        # type: (IO[Any]) -> FileCreateReqCall
        self.body.add_file('file', FormDataFile(file))
        return self

    def do(self):
        # type: () -> Response[FileCreateResult]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('im/v1/files', 'POST', [ACCESS_TOKEN_TYPE_TENANT], self.body, output_class=FileCreateResult , request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FileGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (FileService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_file_key(self, file_key):
        # type: (str) -> FileGetReqCall
        self.path_params['file_key'] = file_key
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_is_response_stream()]
        req = Request('im/v1/files/:file_key', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ChatListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (ChatService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id_type(self, user_id_type):
        # type: (str) -> ChatListReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_page_token(self, page_token):
        # type: (str) -> ChatListReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> ChatListReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> Response[ChatListResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('im/v1/chats', 'GET', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=ChatListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ImageCreateReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (ImageService, List[Any]) -> None

        self.service = service
        self.body = FormData()

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_image_type(self, image_type):
        # type: (str) -> ImageCreateReqCall
        self.body.add_param('image_type', image_type)
        return self

    def set_image(self, image):
        # type: (IO[Any]) -> ImageCreateReqCall
        self.body.add_file('image', FormDataFile(image))
        return self

    def do(self):
        # type: () -> Response[ImageCreateResult]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('im/v1/images', 'POST', [ACCESS_TOKEN_TYPE_TENANT], self.body, output_class=ImageCreateResult , request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ChatDeleteReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (ChatService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_chat_id(self, chat_id):
        # type: (str) -> ChatDeleteReqCall
        self.path_params['chat_id'] = chat_id
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('im/v1/chats/:chat_id', 'DELETE', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ImageGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (ImageService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_image_key(self, image_key):
        # type: (str) -> ImageGetReqCall
        self.path_params['image_key'] = image_key
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_is_response_stream()]
        req = Request('im/v1/images/:image_key', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ChatGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (ChatService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_chat_id(self, chat_id):
        # type: (str) -> ChatGetReqCall
        self.path_params['chat_id'] = chat_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> ChatGetReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def do(self):
        # type: () -> Response[ChatGetResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('im/v1/chats/:chat_id', 'GET', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=ChatGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ChatCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (ChatService, ChatCreateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id_type(self, user_id_type):
        # type: (str) -> ChatCreateReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def do(self):
        # type: () -> Response[ChatCreateResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('im/v1/chats', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=ChatCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ChatSearchReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (ChatService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id_type(self, user_id_type):
        # type: (str) -> ChatSearchReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_query(self, query):
        # type: (str) -> ChatSearchReqCall
        self.query_params['query'] = query
        return self

    def set_page_token(self, page_token):
        # type: (str) -> ChatSearchReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> ChatSearchReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> Response[ChatSearchResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('im/v1/chats/search', 'GET', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=ChatSearchResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MessageGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MessageService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_message_id(self, message_id):
        # type: (str) -> MessageGetReqCall
        self.path_params['message_id'] = message_id
        return self

    def do(self):
        # type: () -> Response[MessageGetResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('im/v1/messages/:message_id', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=MessageGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ChatMembersCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (ChatMembersService, ChatMembersCreateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_chat_id(self, chat_id):
        # type: (str) -> ChatMembersCreateReqCall
        self.path_params['chat_id'] = chat_id
        return self

    def set_member_id_type(self, member_id_type):
        # type: (str) -> ChatMembersCreateReqCall
        self.query_params['member_id_type'] = member_id_type
        return self

    def do(self):
        # type: () -> Response[ChatMembersCreateResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('im/v1/chats/:chat_id/members', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=ChatMembersCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ChatMembersDeleteReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (ChatMembersService, ChatMembersDeleteReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_chat_id(self, chat_id):
        # type: (str) -> ChatMembersDeleteReqCall
        self.path_params['chat_id'] = chat_id
        return self

    def set_member_id_type(self, member_id_type):
        # type: (str) -> ChatMembersDeleteReqCall
        self.query_params['member_id_type'] = member_id_type
        return self

    def do(self):
        # type: () -> Response[ChatMembersDeleteResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('im/v1/chats/:chat_id/members', 'DELETE', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=ChatMembersDeleteResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ChatMembersGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (ChatMembersService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_chat_id(self, chat_id):
        # type: (str) -> ChatMembersGetReqCall
        self.path_params['chat_id'] = chat_id
        return self

    def set_member_id_type(self, member_id_type):
        # type: (str) -> ChatMembersGetReqCall
        self.query_params['member_id_type'] = member_id_type
        return self

    def set_page_token(self, page_token):
        # type: (str) -> ChatMembersGetReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> ChatMembersGetReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> Response[ChatMembersGetResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('im/v1/chats/:chat_id/members', 'GET', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=ChatMembersGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MessageResourceGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MessageResourceService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_message_id(self, message_id):
        # type: (str) -> MessageResourceGetReqCall
        self.path_params['message_id'] = message_id
        return self

    def set_file_key(self, file_key):
        # type: (str) -> MessageResourceGetReqCall
        self.path_params['file_key'] = file_key
        return self

    def set_type(self, type):
        # type: (str) -> MessageResourceGetReqCall
        self.query_params['type'] = type
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        self.request_opts += [set_is_response_stream()]
        req = Request('im/v1/messages/:message_id/resources/:file_key', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ChatAnnouncementGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (ChatAnnouncementService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_chat_id(self, chat_id):
        # type: (str) -> ChatAnnouncementGetReqCall
        self.path_params['chat_id'] = chat_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> ChatAnnouncementGetReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def do(self):
        # type: () -> Response[ChatAnnouncementGetResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('im/v1/chats/:chat_id/announcement', 'GET', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=ChatAnnouncementGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ChatMembersIsInChatReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (ChatMembersService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_chat_id(self, chat_id):
        # type: (str) -> ChatMembersIsInChatReqCall
        self.path_params['chat_id'] = chat_id
        return self

    def do(self):
        # type: () -> Response[ChatMembersIsInChatResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('im/v1/chats/:chat_id/members/is_in_chat', 'GET', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=ChatMembersIsInChatResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ChatMembersMeJoinReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (ChatMembersService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_chat_id(self, chat_id):
        # type: (str) -> ChatMembersMeJoinReqCall
        self.path_params['chat_id'] = chat_id
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('im/v1/chats/:chat_id/members/me_join', 'PATCH', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ChatAnnouncementPatchReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (ChatAnnouncementService, ChatAnnouncementPatchReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_chat_id(self, chat_id):
        # type: (str) -> ChatAnnouncementPatchReqCall
        self.path_params['chat_id'] = chat_id
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('im/v1/chats/:chat_id/announcement', 'PATCH', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ChatCustomBotCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (ChatCustomBotService, ChatCustomBotCreateReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> Response[ChatCustomBotCreateResult]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('im/v1/chat_custom_bots', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=ChatCustomBotCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ChatCustomBotDeleteReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (ChatCustomBotService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_bot_id(self, bot_id):
        # type: (int) -> ChatCustomBotDeleteReqCall
        self.path_params['bot_id'] = bot_id
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('im/v1/chat_custom_bots/:bot_id', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ChatCustomBotGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (ChatCustomBotService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_bot_id(self, bot_id):
        # type: (int) -> ChatCustomBotGetReqCall
        self.path_params['bot_id'] = bot_id
        return self

    def do(self):
        # type: () -> Response[ChatCustomBotGetResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('im/v1/chat_custom_bots/:bot_id', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=ChatCustomBotGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ChatCustomBotPatchReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (ChatCustomBotService, ChatCustomBotPatchReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_bot_id(self, bot_id):
        # type: (int) -> ChatCustomBotPatchReqCall
        self.path_params['bot_id'] = bot_id
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('im/v1/chat_custom_bots/:bot_id', 'PATCH', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MessageReactionCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MessageReactionService, MessageReactionCreateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_message_id(self, message_id):
        # type: (str) -> MessageReactionCreateReqCall
        self.path_params['message_id'] = message_id
        return self

    def do(self):
        # type: () -> Response[MessageReaction]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('im/v1/messages/:message_id/reactions', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=MessageReaction, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MessageReactionDeleteReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MessageReactionService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_message_id(self, message_id):
        # type: (str) -> MessageReactionDeleteReqCall
        self.path_params['message_id'] = message_id
        return self

    def set_reaction_id(self, reaction_id):
        # type: (str) -> MessageReactionDeleteReqCall
        self.path_params['reaction_id'] = reaction_id
        return self

    def do(self):
        # type: () -> Response[MessageReaction]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('im/v1/messages/:message_id/reactions/:reaction_id', 'DELETE', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=MessageReaction, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MessageReactionListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MessageReactionService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_message_id(self, message_id):
        # type: (str) -> MessageReactionListReqCall
        self.path_params['message_id'] = message_id
        return self

    def set_reaction_type(self, reaction_type):
        # type: (str) -> MessageReactionListReqCall
        self.query_params['reaction_type'] = reaction_type
        return self

    def set_page_token(self, page_token):
        # type: (str) -> MessageReactionListReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> MessageReactionListReqCall
        self.query_params['page_size'] = page_size
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> MessageReactionListReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def do(self):
        # type: () -> Response[MessageReactionListResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('im/v1/messages/:message_id/reactions', 'GET', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=MessageReactionListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp

