# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request, Response, set_timeout, set_tenant_key, set_user_access_token, set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.identitys = IdentityService(self)
        



class IdentityService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def create(self, body, tenant_key=None, timeout=None):
        # type: (IdentityCreateReqBody, str, int) -> IdentityCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return IdentityCreateReqCall(self, body, request_opts=request_opts)



class IdentityCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (IdentityService, IdentityCreateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id(self, user_id):
        # type: (str) -> IdentityCreateReqCall
        self.query_params['user_id'] = user_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> IdentityCreateReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def do(self):
        # type: () -> Response[IdentityCreateResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('human_authentication/v1/identities', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=IdentityCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp

