# DeviceServer
DeviceServer API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

```bash
pip install Icotest-DeviceServer
```

Then import the package:
```python
import DeviceServer
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import DeviceServer
from DeviceServer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/DeviceServer
# See configuration.py for a list of all supported configuration parameters.
configuration = DeviceServer.Configuration(
    host = "http://localhost/DeviceServer"
)



# Enter a context with an instance of the API client
with DeviceServer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = DeviceServer.DevicesApi(api_client)
    
    try:
        # GET list of devices
        api_response = api_instance.get_devices()
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DevicesApi->get_devices: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/DeviceServer*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DevicesApi* | [**get_devices**](docs/DevicesApi.md#get_devices) | **GET** /Devices | GET list of devices
*DevicesApi* | [**get_devices_button**](docs/DevicesApi.md#get_devices_button) | **GET** /Devices/Button/{device_id} | GET state of button
*DevicesApi* | [**get_devices_device_id_ports**](docs/DevicesApi.md#get_devices_device_id_ports) | **GET** /Devices/{device_id}/Ports | GET all ports for device
*DevicesApi* | [**get_devices_index**](docs/DevicesApi.md#get_devices_index) | **GET** /Devices/{device_id} | GET single device
*DevicesApi* | [**get_devices_leds**](docs/DevicesApi.md#get_devices_leds) | **GET** /Devices/{device_id}/Leds/{led_index} | GET state of LED
*DevicesApi* | [**get_devices_port**](docs/DevicesApi.md#get_devices_port) | **GET** /Devices/{device_id}/Ports/{port_index} | GET status of port
*DevicesApi* | [**get_port**](docs/DevicesApi.md#get_port) | **GET** /Ports/{port_index} | GET status of port
*DevicesApi* | [**put_devices_leds_index**](docs/DevicesApi.md#put_devices_leds_index) | **PUT** /Devices/{device_id}/Leds/{led_index} | PUT state of LED
*DevicesApi* | [**put_devices_ports**](docs/DevicesApi.md#put_devices_ports) | **PUT** /Devices/{device_id}/Ports/{port_index} | PUT state of port
*DevicesApi* | [**put_devices_ports_pulse**](docs/DevicesApi.md#put_devices_ports_pulse) | **PUT** /Devices/{device_id}/Ports/{port_index}/Pulse | PUT port into state for period of time
*DevicesApi* | [**put_ports**](docs/DevicesApi.md#put_ports) | **PUT** /Ports/{port_index} | PUT state of port
*DevicesApi* | [**put_ports_pulse**](docs/DevicesApi.md#put_ports_pulse) | **PUT** /Ports/{port_index}/Pulse | PUT port into state for period of time


## Documentation For Models

 - [Device](docs/Device.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [Port](docs/Port.md)
 - [PortState](docs/PortState.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

david@3adesign.co.uk


