# coding: utf-8

"""
    DeviceServer

    DeviceServer API  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: david@3adesign.co.uk
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from DeviceServer.api_client import ApiClient
from DeviceServer.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DevicesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_devices(self, **kwargs):  # noqa: E501
        """GET list of devices  # noqa: E501

        Returns list of devices  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_devices(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Device]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_devices_with_http_info(**kwargs)  # noqa: E501

    def get_devices_with_http_info(self, **kwargs):  # noqa: E501
        """GET list of devices  # noqa: E501

        Returns list of devices  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_devices_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Device], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_devices" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/Devices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Device]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_devices_button(self, device_id, button_index, **kwargs):  # noqa: E501
        """GET state of button  # noqa: E501

        Returns state of the selected devices button  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_devices_button(device_id, button_index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: UUID of device (required)
        :param int button_index: index of the button on tha device (1-100) (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_devices_button_with_http_info(device_id, button_index, **kwargs)  # noqa: E501

    def get_devices_button_with_http_info(self, device_id, button_index, **kwargs):  # noqa: E501
        """GET state of button  # noqa: E501

        Returns state of the selected devices button  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_devices_button_with_http_info(device_id, button_index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: UUID of device (required)
        :param int button_index: index of the button on tha device (1-100) (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse200, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'button_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_devices_button" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and ('device_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['device_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_devices_button`")  # noqa: E501
        # verify the required parameter 'button_index' is set
        if self.api_client.client_side_validation and ('button_index' not in local_var_params or  # noqa: E501
                                                        local_var_params['button_index'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `button_index` when calling `get_devices_button`")  # noqa: E501

        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices_button`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'button_index' in local_var_params and local_var_params['button_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `button_index` when calling `get_devices_button`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'button_index' in local_var_params and local_var_params['button_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `button_index` when calling `get_devices_button`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []
        if 'button_index' in local_var_params and local_var_params['button_index'] is not None:  # noqa: E501
            query_params.append(('button_index', local_var_params['button_index']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/Devices/Button/{device_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_devices_device_id_ports(self, device_id, **kwargs):  # noqa: E501
        """GET all ports for device  # noqa: E501

        returns a list of all ports attached to a device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_devices_device_id_ports(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: UUID of device (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Port]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_devices_device_id_ports_with_http_info(device_id, **kwargs)  # noqa: E501

    def get_devices_device_id_ports_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """GET all ports for device  # noqa: E501

        returns a list of all ports attached to a device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_devices_device_id_ports_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: UUID of device (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Port], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'device_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_devices_device_id_ports" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and ('device_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['device_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_devices_device_id_ports`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices_device_id_ports`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices_device_id_ports`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices_device_id_ports`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/Devices/{device_id}/Ports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Port]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_devices_index(self, device_id, **kwargs):  # noqa: E501
        """GET single device  # noqa: E501

        Gets information for a single device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_devices_index(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: UUID of device (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Device
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_devices_index_with_http_info(device_id, **kwargs)  # noqa: E501

    def get_devices_index_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """GET single device  # noqa: E501

        Gets information for a single device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_devices_index_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: UUID of device (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Device, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'device_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_devices_index" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and ('device_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['device_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_devices_index`")  # noqa: E501

        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices_index`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/Devices/{device_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Device',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_devices_leds(self, device_id, led_index, **kwargs):  # noqa: E501
        """GET state of LED  # noqa: E501

        Returns state of selected led on selected device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_devices_leds(device_id, led_index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: UUID of device (required)
        :param int led_index: Index of LED (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_devices_leds_with_http_info(device_id, led_index, **kwargs)  # noqa: E501

    def get_devices_leds_with_http_info(self, device_id, led_index, **kwargs):  # noqa: E501
        """GET state of LED  # noqa: E501

        Returns state of selected led on selected device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_devices_leds_with_http_info(device_id, led_index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: UUID of device (required)
        :param int led_index: Index of LED (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse200, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'led_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_devices_leds" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and ('device_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['device_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_devices_leds`")  # noqa: E501
        # verify the required parameter 'led_index' is set
        if self.api_client.client_side_validation and ('led_index' not in local_var_params or  # noqa: E501
                                                        local_var_params['led_index'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `led_index` when calling `get_devices_leds`")  # noqa: E501

        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices_leds`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'led_index' in local_var_params and local_var_params['led_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `led_index` when calling `get_devices_leds`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'led_index' in local_var_params and local_var_params['led_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `led_index` when calling `get_devices_leds`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'led_index' in local_var_params:
            path_params['led_index'] = local_var_params['led_index']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/Devices/{device_id}/Leds/{led_index}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_devices_port(self, device_id, port_index, **kwargs):  # noqa: E501
        """GET status of port  # noqa: E501

        returns status of ports  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_devices_port(device_id, port_index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: UUID of device (required)
        :param int port_index: Index of port (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Port
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_devices_port_with_http_info(device_id, port_index, **kwargs)  # noqa: E501

    def get_devices_port_with_http_info(self, device_id, port_index, **kwargs):  # noqa: E501
        """GET status of port  # noqa: E501

        returns status of ports  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_devices_port_with_http_info(device_id, port_index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: UUID of device (required)
        :param int port_index: Index of port (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Port, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'port_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_devices_port" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and ('device_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['device_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_devices_port`")  # noqa: E501
        # verify the required parameter 'port_index' is set
        if self.api_client.client_side_validation and ('port_index' not in local_var_params or  # noqa: E501
                                                        local_var_params['port_index'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_index` when calling `get_devices_port`")  # noqa: E501

        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices_port`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `get_devices_port`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `get_devices_port`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'port_index' in local_var_params:
            path_params['port_index'] = local_var_params['port_index']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/Devices/{device_id}/Ports/{port_index}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Port',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_port(self, port_index, **kwargs):  # noqa: E501
        """GET status of port  # noqa: E501

        status of port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_port(port_index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int port_index: Index of port (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Port
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_port_with_http_info(port_index, **kwargs)  # noqa: E501

    def get_port_with_http_info(self, port_index, **kwargs):  # noqa: E501
        """GET status of port  # noqa: E501

        status of port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_port_with_http_info(port_index, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int port_index: Index of port (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Port, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'port_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_port" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'port_index' is set
        if self.api_client.client_side_validation and ('port_index' not in local_var_params or  # noqa: E501
                                                        local_var_params['port_index'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_index` when calling `get_port`")  # noqa: E501

        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] > 10000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `get_port`, must be a value less than or equal to `10000`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `get_port`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'port_index' in local_var_params:
            path_params['port_index'] = local_var_params['port_index']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/Ports/{port_index}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Port',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_devices_leds_index(self, device_id, led_index, state, **kwargs):  # noqa: E501
        """PUT state of LED  # noqa: E501

        Set led at index on selected device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_devices_leds_index(device_id, led_index, state, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: UUID of device (required)
        :param int led_index: Index of LED (required)
        :param bool state: True = LED on, False = LED off (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_devices_leds_index_with_http_info(device_id, led_index, state, **kwargs)  # noqa: E501

    def put_devices_leds_index_with_http_info(self, device_id, led_index, state, **kwargs):  # noqa: E501
        """PUT state of LED  # noqa: E501

        Set led at index on selected device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_devices_leds_index_with_http_info(device_id, led_index, state, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: UUID of device (required)
        :param int led_index: Index of LED (required)
        :param bool state: True = LED on, False = LED off (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'led_index',
            'state'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_devices_leds_index" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and ('device_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['device_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `put_devices_leds_index`")  # noqa: E501
        # verify the required parameter 'led_index' is set
        if self.api_client.client_side_validation and ('led_index' not in local_var_params or  # noqa: E501
                                                        local_var_params['led_index'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `led_index` when calling `put_devices_leds_index`")  # noqa: E501
        # verify the required parameter 'state' is set
        if self.api_client.client_side_validation and ('state' not in local_var_params or  # noqa: E501
                                                        local_var_params['state'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `state` when calling `put_devices_leds_index`")  # noqa: E501

        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_devices_leds_index`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'led_index' in local_var_params and local_var_params['led_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `led_index` when calling `put_devices_leds_index`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'led_index' in local_var_params and local_var_params['led_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `led_index` when calling `put_devices_leds_index`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'led_index' in local_var_params:
            path_params['led_index'] = local_var_params['led_index']  # noqa: E501

        query_params = []
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/Devices/{device_id}/Leds/{led_index}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_devices_ports(self, device_id, port_index, state, **kwargs):  # noqa: E501
        """PUT state of port  # noqa: E501

        Set State of Port   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_devices_ports(device_id, port_index, state, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: UUID of device (required)
        :param int port_index: Index of port (required)
        :param int state: state id to switch to, 1 or more (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_devices_ports_with_http_info(device_id, port_index, state, **kwargs)  # noqa: E501

    def put_devices_ports_with_http_info(self, device_id, port_index, state, **kwargs):  # noqa: E501
        """PUT state of port  # noqa: E501

        Set State of Port   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_devices_ports_with_http_info(device_id, port_index, state, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: UUID of device (required)
        :param int port_index: Index of port (required)
        :param int state: state id to switch to, 1 or more (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'port_index',
            'state'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_devices_ports" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and ('device_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['device_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `put_devices_ports`")  # noqa: E501
        # verify the required parameter 'port_index' is set
        if self.api_client.client_side_validation and ('port_index' not in local_var_params or  # noqa: E501
                                                        local_var_params['port_index'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_index` when calling `put_devices_ports`")  # noqa: E501
        # verify the required parameter 'state' is set
        if self.api_client.client_side_validation and ('state' not in local_var_params or  # noqa: E501
                                                        local_var_params['state'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `state` when calling `put_devices_ports`")  # noqa: E501

        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_devices_ports`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_devices_ports`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_devices_ports`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'state' in local_var_params and local_var_params['state'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `state` when calling `put_devices_ports`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'state' in local_var_params and local_var_params['state'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `state` when calling `put_devices_ports`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'port_index' in local_var_params:
            path_params['port_index'] = local_var_params['port_index']  # noqa: E501

        query_params = []
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/Devices/{device_id}/Ports/{port_index}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_devices_ports_pulse(self, device_id, port_index, time, state, **kwargs):  # noqa: E501
        """PUT port into state for period of time  # noqa: E501

        Pulse port from one state to another for a period of time in seconds  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_devices_ports_pulse(device_id, port_index, time, state, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: UUID of device (required)
        :param int port_index: Index of port (required)
        :param float time: time in seconds to press for 0.1 = 100ms (required)
        :param int state: state to switch to (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_devices_ports_pulse_with_http_info(device_id, port_index, time, state, **kwargs)  # noqa: E501

    def put_devices_ports_pulse_with_http_info(self, device_id, port_index, time, state, **kwargs):  # noqa: E501
        """PUT port into state for period of time  # noqa: E501

        Pulse port from one state to another for a period of time in seconds  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_devices_ports_pulse_with_http_info(device_id, port_index, time, state, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str device_id: UUID of device (required)
        :param int port_index: Index of port (required)
        :param float time: time in seconds to press for 0.1 = 100ms (required)
        :param int state: state to switch to (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'port_index',
            'time',
            'state'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_devices_ports_pulse" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and ('device_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['device_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `put_devices_ports_pulse`")  # noqa: E501
        # verify the required parameter 'port_index' is set
        if self.api_client.client_side_validation and ('port_index' not in local_var_params or  # noqa: E501
                                                        local_var_params['port_index'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_index` when calling `put_devices_ports_pulse`")  # noqa: E501
        # verify the required parameter 'time' is set
        if self.api_client.client_side_validation and ('time' not in local_var_params or  # noqa: E501
                                                        local_var_params['time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `time` when calling `put_devices_ports_pulse`")  # noqa: E501
        # verify the required parameter 'state' is set
        if self.api_client.client_side_validation and ('state' not in local_var_params or  # noqa: E501
                                                        local_var_params['state'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `state` when calling `put_devices_ports_pulse`")  # noqa: E501

        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_devices_ports_pulse`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_devices_ports_pulse`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_devices_ports_pulse`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'state' in local_var_params and local_var_params['state'] > 1000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `state` when calling `put_devices_ports_pulse`, must be a value less than or equal to `1000`")  # noqa: E501
        if self.api_client.client_side_validation and 'state' in local_var_params and local_var_params['state'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `state` when calling `put_devices_ports_pulse`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'port_index' in local_var_params:
            path_params['port_index'] = local_var_params['port_index']  # noqa: E501

        query_params = []
        if 'time' in local_var_params and local_var_params['time'] is not None:  # noqa: E501
            query_params.append(('time', local_var_params['time']))  # noqa: E501
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/Devices/{device_id}/Ports/{port_index}/Pulse', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_ports(self, port_index, state, **kwargs):  # noqa: E501
        """PUT state of port  # noqa: E501

        Set State of Port   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_ports(port_index, state, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int port_index: Index of port (required)
        :param int state: state id to switch to, 1 or more (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_ports_with_http_info(port_index, state, **kwargs)  # noqa: E501

    def put_ports_with_http_info(self, port_index, state, **kwargs):  # noqa: E501
        """PUT state of port  # noqa: E501

        Set State of Port   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_ports_with_http_info(port_index, state, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int port_index: Index of port (required)
        :param int state: state id to switch to, 1 or more (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'port_index',
            'state'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_ports" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'port_index' is set
        if self.api_client.client_side_validation and ('port_index' not in local_var_params or  # noqa: E501
                                                        local_var_params['port_index'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_index` when calling `put_ports`")  # noqa: E501
        # verify the required parameter 'state' is set
        if self.api_client.client_side_validation and ('state' not in local_var_params or  # noqa: E501
                                                        local_var_params['state'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `state` when calling `put_ports`")  # noqa: E501

        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] > 10000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_ports`, must be a value less than or equal to `10000`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_ports`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'port_index' in local_var_params:
            path_params['port_index'] = local_var_params['port_index']  # noqa: E501

        query_params = []
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/Ports/{port_index}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_ports_pulse(self, port_index, time, state, **kwargs):  # noqa: E501
        """PUT port into state for period of time  # noqa: E501

        Pulse port from one state to another for a period of time in seconds  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_ports_pulse(port_index, time, state, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int port_index: Index of port (required)
        :param float time: time in seconds to press for 0.1 = 100ms (required)
        :param int state: state to switch to (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_ports_pulse_with_http_info(port_index, time, state, **kwargs)  # noqa: E501

    def put_ports_pulse_with_http_info(self, port_index, time, state, **kwargs):  # noqa: E501
        """PUT port into state for period of time  # noqa: E501

        Pulse port from one state to another for a period of time in seconds  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_ports_pulse_with_http_info(port_index, time, state, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int port_index: Index of port (required)
        :param float time: time in seconds to press for 0.1 = 100ms (required)
        :param int state: state to switch to (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'port_index',
            'time',
            'state'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_ports_pulse" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'port_index' is set
        if self.api_client.client_side_validation and ('port_index' not in local_var_params or  # noqa: E501
                                                        local_var_params['port_index'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_index` when calling `put_ports_pulse`")  # noqa: E501
        # verify the required parameter 'time' is set
        if self.api_client.client_side_validation and ('time' not in local_var_params or  # noqa: E501
                                                        local_var_params['time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `time` when calling `put_ports_pulse`")  # noqa: E501
        # verify the required parameter 'state' is set
        if self.api_client.client_side_validation and ('state' not in local_var_params or  # noqa: E501
                                                        local_var_params['state'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `state` when calling `put_ports_pulse`")  # noqa: E501

        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] > 10000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_ports_pulse`, must be a value less than or equal to `10000`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_ports_pulse`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'state' in local_var_params and local_var_params['state'] > 1000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `state` when calling `put_ports_pulse`, must be a value less than or equal to `1000`")  # noqa: E501
        if self.api_client.client_side_validation and 'state' in local_var_params and local_var_params['state'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `state` when calling `put_ports_pulse`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'port_index' in local_var_params:
            path_params['port_index'] = local_var_params['port_index']  # noqa: E501

        query_params = []
        if 'time' in local_var_params and local_var_params['time'] is not None:  # noqa: E501
            query_params.append(('time', local_var_params['time']))  # noqa: E501
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/Ports/{port_index}/Pulse', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
