# ----------------------------------------------------------------------------------------------------------------------
# - Package Imports -
# ----------------------------------------------------------------------------------------------------------------------
# General Packages
from __future__ import annotations
import dearpygui.dearpygui as dpg

# Custom Library

# Custom Packages

# ----------------------------------------------------------------------------------------------------------------------
# - Code -
# ----------------------------------------------------------------------------------------------------------------------
RUNTIMEPARSER_MAPPING_CONTEXTMANGERS = {
    # A full dictionary of all DPG items that can be used in context managers
    #   Ergo, the ones that can be used in with ... statements
    "child": dpg.child,
    "clipper": dpg.clipper,
    "collapsing_header": dpg.collapsing_header,
    "colormap_registry": dpg.colormap_registry,
    "drag_payload": dpg.drag_payload,
    "draw_layer": dpg.draw_layer,
    "drawlist": dpg.drawlist,
    "file_dialog": dpg.file_dialog,
    "filter_set": dpg.filter_set,
    "font": dpg.font,
    "font_registry": dpg.font_registry,
    "group": dpg.group,
    "handler_registry": dpg.handler_registry,
    "menu": dpg.menu,
    "menu_bar": dpg.menu_bar,
    "node": dpg.node,
    "node_attribute": dpg.node_attribute,
    "node_editor": dpg.node_editor,
    "plot": dpg.plot,
    "popup": dpg.popup,
    "staging_container": dpg.staging_container,
    "subplots": dpg.subplots,
    "tab": dpg.tab,
    "tab_bar": dpg.tab_bar,
    "table": dpg.table,
    "table_row": dpg.table_row,
    "template_registry": dpg.template_registry,
    "texture_registry": dpg.texture_registry,
    "theme": dpg.theme,
    "tooltip": dpg.tooltip,
    "tree_node": dpg.tree_node,
    "value_registry": dpg.value_registry,
    "viewport_drawlist": dpg.viewport_drawlist,
    "viewport_menu_bar": dpg.viewport_menu_bar,
    "window": dpg.window,
}

RUNTIMEPARSER_MAPPING_ITEMS_FULL = {
    # A full dictionary of all DPG items
    #   Most often than not, these will be used within context managed items
    "2d_histogram_series": dpg.add_2d_histogram_series,
    "3d_slider": dpg.add_3d_slider,
    "alias": dpg.add_alias,
    "area_series": dpg.add_area_series,
    "bar_series": dpg.add_bar_series,
    "bool_value": dpg.add_bool_value,
    "button": dpg.add_button,
    "candle_series": dpg.add_candle_series,
    "char_remap": dpg.add_char_remap,
    "checkbox": dpg.add_checkbox,
    "child_window": dpg.add_child_window,
    "clipper": dpg.add_clipper,
    "collapsing_header": dpg.add_collapsing_header,
    "color_button": dpg.add_color_button,
    "color_edit": dpg.add_color_edit,
    "color_picker": dpg.add_color_picker,
    "color_value": dpg.add_color_value,
    "colormap": dpg.add_colormap,
    "colormap_button": dpg.add_colormap_button,
    "colormap_registry": dpg.add_colormap_registry,
    "colormap_scale": dpg.add_colormap_scale,
    "colormap_slider": dpg.add_colormap_slider,
    "combo": dpg.add_combo,
    "custom_series": dpg.add_custom_series,
    "date_picker": dpg.add_date_picker,
    "double4_value": dpg.add_double4_value,
    "double_value": dpg.add_double_value,
    "drag_double": dpg.add_drag_double,
    "drag_doublex": dpg.add_drag_doublex,
    "drag_float": dpg.add_drag_float,
    "drag_floatx": dpg.add_drag_floatx,
    "drag_int": dpg.add_drag_int,
    "drag_intx": dpg.add_drag_intx,
    "drag_line": dpg.add_drag_line,
    "drag_payload": dpg.add_drag_payload,
    "drag_point": dpg.add_drag_point,
    "draw_layer": dpg.add_draw_layer,
    "draw_node": dpg.add_draw_node,
    "draw_arrow": dpg.draw_arrow,
    "draw_bezier_cubic": dpg.draw_bezier_cubic,
    "draw_bezier_quadratic": dpg.draw_bezier_quadratic,
    "draw_circle": dpg.draw_circle,
    "draw_ellipse": dpg.draw_ellipse,
    "draw_image": dpg.draw_image,
    "draw_image_quad": dpg.draw_image_quad,
    "draw_line": dpg.draw_line,
    "draw_polygon": dpg.draw_polygon,
    "draw_polyline": dpg.draw_polyline,
    "draw_quad": dpg.draw_quad,
    "draw_rectangle": dpg.draw_rectangle,
    "draw_text": dpg.draw_text,
    "draw_triangle": dpg.draw_triangle,
    "drawlist": dpg.add_drawlist,
    "dynamic_texture": dpg.add_dynamic_texture,
    "error_series": dpg.add_error_series,
    "file_dialog": dpg.add_file_dialog,
    "file_extension": dpg.add_file_extension,
    "filter_set": dpg.add_filter_set,
    "float4_value": dpg.add_float4_value,
    "float_value": dpg.add_float_value,
    "float_vect_value": dpg.add_float_vect_value,
    "font": dpg.add_font,
    "font_chars": dpg.add_font_chars,
    "font_range": dpg.add_font_range,
    "font_range_hint": dpg.add_font_range_hint,
    "font_registry": dpg.add_font_registry,
    "group": dpg.add_group,
    "handler_registry": dpg.add_handler_registry,
    "heat_series": dpg.add_heat_series,
    "histogram_series": dpg.add_histogram_series,
    "hline_series": dpg.add_hline_series,
    "image": dpg.add_image,
    "image_button": dpg.add_image_button,
    "image_series": dpg.add_image_series,
    "input_double": dpg.add_input_double,
    "input_doublex": dpg.add_input_doublex,
    "input_float": dpg.add_input_float,
    "input_floatx": dpg.add_input_floatx,
    "input_int": dpg.add_input_int,
    "input_intx": dpg.add_input_intx,
    "input_text": dpg.add_input_text,
    "int4_value": dpg.add_int4_value,
    "int_value": dpg.add_int_value,
    "item_activated_handler": dpg.add_item_activated_handler,
    "item_active_handler": dpg.add_item_active_handler,
    "item_clicked_handler": dpg.add_item_clicked_handler,
    "item_deactivated_after_edit_han": dpg.add_item_deactivated_after_edit_handler,
    "item_deactivated_handler": dpg.add_item_deactivated_handler,
    "item_edited_handler": dpg.add_item_edited_handler,
    "item_focus_handler": dpg.add_item_focus_handler,
    "item_handler_registry": dpg.add_item_handler_registry,
    "item_hover_handler": dpg.add_item_hover_handler,
    "item_resize_handler": dpg.add_item_resize_handler,
    "item_toggled_open_handler": dpg.add_item_toggled_open_handler,
    "item_visible_handler": dpg.add_item_visible_handler,
    "key_down_handler": dpg.add_key_down_handler,
    "key_press_handler": dpg.add_key_press_handler,
    "key_release_handler": dpg.add_key_release_handler,
    "knob_float": dpg.add_knob_float,
    "line_series": dpg.add_line_series,
    "listbox": dpg.add_listbox,
    "loading_indicator": dpg.add_loading_indicator,
    "menu": dpg.add_menu,
    "menu_bar": dpg.add_menu_bar,
    "menu_item": dpg.add_menu_item,
    "mouse_click_handler": dpg.add_mouse_click_handler,
    "mouse_double_click_handler": dpg.add_mouse_double_click_handler,
    "mouse_down_handler": dpg.add_mouse_down_handler,
    "mouse_drag_handler": dpg.add_mouse_drag_handler,
    "mouse_move_handler": dpg.add_mouse_move_handler,
    "mouse_release_handler": dpg.add_mouse_release_handler,
    "mouse_wheel_handler": dpg.add_mouse_wheel_handler,
    "node": dpg.add_node,
    "node_attribute": dpg.add_node_attribute,
    "node_editor": dpg.add_node_editor,
    "node_link": dpg.add_node_link,
    "pie_series": dpg.add_pie_series,
    "plot": dpg.add_plot,
    "plot_annotation": dpg.add_plot_annotation,
    "plot_axis": dpg.add_plot_axis,
    "plot_legend": dpg.add_plot_legend,
    "progress_bar": dpg.add_progress_bar,
    "radio_button": dpg.add_radio_button,
    "raw_texture": dpg.add_raw_texture,
    "scatter_series": dpg.add_scatter_series,
    "selectable": dpg.add_selectable,
    "separator": dpg.add_separator,
    "series_value": dpg.add_series_value,
    "shade_series": dpg.add_shade_series,
    "simple_plot": dpg.add_simple_plot,
    "slider_double": dpg.add_slider_double,
    "slider_doublex": dpg.add_slider_doublex,
    "slider_float": dpg.add_slider_float,
    "slider_floatx": dpg.add_slider_floatx,
    "slider_int": dpg.add_slider_int,
    "slider_intx": dpg.add_slider_intx,
    "spacer": dpg.add_spacer,
    "stage": dpg.add_stage,
    "stair_series": dpg.add_stair_series,
    "static_texture": dpg.add_static_texture,
    "stem_series": dpg.add_stem_series,
    "string_value": dpg.add_string_value,
    "subplots": dpg.add_subplots,
    "tab": dpg.add_tab,
    "tab_bar": dpg.add_tab_bar,
    "tab_button": dpg.add_tab_button,
    "table": dpg.add_table,
    "table_cell": dpg.add_table_cell,
    "table_column": dpg.add_table_column,
    "table_row": dpg.add_table_row,
    "template_registry": dpg.add_template_registry,
    "text": dpg.add_text,
    "text_point": dpg.add_text_point,
    "texture_registry": dpg.add_texture_registry,
    "theme": dpg.add_theme,
    "theme_color": dpg.add_theme_color,
    "theme_component": dpg.add_theme_component,
    "theme_style": dpg.add_theme_style,
    "time_picker": dpg.add_time_picker,
    "tooltip": dpg.add_tooltip,
    "tree_node": dpg.add_tree_node,
    "value_registry": dpg.add_value_registry,
    "viewport_drawlist": dpg.add_viewport_drawlist,
    "viewport_menu_bar": dpg.add_viewport_menu_bar,
    "vline_series": dpg.add_vline_series,
    "window": dpg.add_window,
}