/*! Leaflet.Geodesic 2.5.2 - (c) Henry Thasler - https://github.com/henrythasler/Leaflet.Geodesic */
!function(t,n){"object"==typeof exports&&"undefined"!=typeof module?n(exports,require("leaflet")):"function"==typeof define&&define.amd?define(["exports","leaflet"],n):n(((t=t||self).L=t.L||{},t.L.geodesic={}),t.L)}(this,(function(t,n){"use strict";n=n&&n.hasOwnProperty("default")?n.default:n;
/*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0

    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.

    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
var e=function(t,n){return(e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,n){t.__proto__=n}||function(t,n){for(var e in n)n.hasOwnProperty(e)&&(t[e]=n[e])})(t,n)};function i(t,n){function i(){this.constructor=t}e(t,n),t.prototype=null===n?Object.create(n):(i.prototype=n.prototype,new i)}var a=function(){return(a=Object.assign||function(t){for(var n,e=1,i=arguments.length;e<i;e++)for(var a in n=arguments[e])Object.prototype.hasOwnProperty.call(n,a)&&(t[a]=n[a]);return t}).apply(this,arguments)};function s(){for(var t=0,n=0,e=arguments.length;n<e;n++)t+=arguments[n].length;var i=Array(t),a=0;for(n=0;n<e;n++)for(var s=arguments[n],o=0,r=s.length;o<r;o++,a++)i[a]=s[o];return i}var o=function(){function t(t){this.options={wrap:!0,steps:3},this.ellipsoid={a:6378137,b:6356752.3142,f:1/298.257223563},this.options=a(a({},this.options),t)}return t.prototype.toRadians=function(t){return t*Math.PI/180},t.prototype.toDegrees=function(t){return 180*t/Math.PI},t.prototype.mod=function(t,n){var e=t%n;return e<0?e+n:e},t.prototype.wrap360=function(t){return 0<=t&&t<360?t:this.mod(t,360)},t.prototype.wrap=function(t,n){return void 0===n&&(n=360),-n<=t&&t<=n?t:this.mod(t+n,2*n)-n},t.prototype.direct=function(t,n,e,i){void 0===i&&(i=100);var a=this.toRadians(t.lat),s=this.toRadians(t.lng),o=this.toRadians(n),r=e,h=1e3*Number.EPSILON,l=this.ellipsoid,c=l.a,p=l.b,u=l.f,g=Math.sin(o),f=Math.cos(o),d=(1-u)*Math.tan(a),M=1/Math.sqrt(1+d*d),L=d*M,y=Math.atan2(d,f),v=M*g,w=1-v*v,m=w*(c*c-p*p)/(p*p),b=1+m/16384*(4096+m*(m*(320-175*m)-768)),E=m/1024*(256+m*(m*(74-47*m)-128)),O=r/(p*b),P=null,S=null,R=null,x=null,D=0;do{R=Math.cos(2*y+O),x=O,O=r/(p*b)+E*(P=Math.sin(O))*(R+E/4*((S=Math.cos(O))*(2*R*R-1)-E/6*R*(4*P*P-3)*(4*R*R-3)))}while(Math.abs(O-x)>h&&++D<i);if(D>=i)throw new EvalError("Direct vincenty formula failed to converge after "+i+" iterations \n                (start="+t.lat+"/"+t.lng+"; bearing="+n+"; distance="+e+")");var G=L*P-M*S*f,N=Math.atan2(L*S+M*P*f,(1-u)*Math.sqrt(v*v+G*G)),j=u/16*w*(4+u*(4-3*w)),k=s+(Math.atan2(P*g,M*S-L*P*f)-(1-j)*u*v*(O+j*P*(R+j*S*(2*R*R-1)))),_=Math.atan2(v,-G);return{lat:this.toDegrees(N),lng:this.toDegrees(k),bearing:this.wrap360(this.toDegrees(_))}},t.prototype.inverse=function(t,e,i,a){void 0===i&&(i=100),void 0===a&&(a=!0);var s=t,o=e,r=this.toRadians(s.lat),h=this.toRadians(s.lng),l=this.toRadians(o.lat),c=this.toRadians(o.lng),p=Math.PI,u=Number.EPSILON,g=this.ellipsoid,f=g.a,d=g.b,M=g.f,L=c-h,y=(1-M)*Math.tan(r),v=1/Math.sqrt(1+y*y),w=y*v,m=(1-M)*Math.tan(l),b=1/Math.sqrt(1+m*m),E=m*b,O=Math.abs(L)>p/2||Math.abs(l-r)>p/2,P=L,S=null,R=null,x=O?p:0,D=0,G=O?-1:1,N=null,j=1,k=null,_=1,q=null,I=null,C=0;do{if(N=b*(S=Math.sin(P))*(b*S)+(v*E-w*b*(R=Math.cos(P)))*(v*E-w*b*R),Math.abs(N)<u)break;if(G=w*E+v*b*R,I=P,P=L+(1-(q=M/16*(_=1-(k=v*b*S/(D=Math.sqrt(N)))*k)*(4+M*(4-3*_))))*M*k*((x=Math.atan2(D,G))+q*D*((j=0!==_?G-2*w*E/_:0)+q*G*(2*j*j-1))),(O?Math.abs(P)-p:Math.abs(P))>p)throw new EvalError("λ > π")}while(Math.abs(P-I)>1e-12&&++C<i);if(C>=i){if(a)return this.inverse(t,new n.LatLng(e.lat,e.lng-.01),i,a);throw new EvalError("Inverse vincenty formula failed to converge after "+i+" iterations \n                    (start="+t.lat+"/"+t.lng+"; dest="+e.lat+"/"+e.lng+")")}var A=_*(f*f-d*d)/(d*d),B=A/1024*(256+A*(A*(74-47*A)-128)),J=d*(1+A/16384*(4096+A*(A*(320-175*A)-768)))*(x-B*D*(j+B/4*(G*(2*j*j-1)-B/6*j*(4*D*D-3)*(4*j*j-3)))),T=Math.abs(N)<u?0:Math.atan2(b*S,v*E-w*b*R),U=Math.abs(N)<u?p:Math.atan2(v*S,-w*b+v*E*R);return{distance:J,initialBearing:Math.abs(J)<u?NaN:this.wrap360(this.toDegrees(T)),finalBearing:Math.abs(J)<u?NaN:this.wrap360(this.toDegrees(U))}},t.prototype.intersection=function(t,e,i,a){var s=this.toRadians(t.lat),o=this.toRadians(t.lng),r=this.toRadians(i.lat),h=this.toRadians(i.lng),l=this.toRadians(e),c=this.toRadians(a),p=r-s,u=h-o,g=Math.PI,f=Number.EPSILON,d=2*Math.asin(Math.sqrt(Math.sin(p/2)*Math.sin(p/2)+Math.cos(s)*Math.cos(r)*Math.sin(u/2)*Math.sin(u/2)));if(Math.abs(d)<f)return t;var M=(Math.sin(r)-Math.sin(s)*Math.cos(d))/(Math.sin(d)*Math.cos(s)),L=(Math.sin(s)-Math.sin(r)*Math.cos(d))/(Math.sin(d)*Math.cos(r)),y=Math.acos(Math.min(Math.max(M,-1),1)),v=Math.acos(Math.min(Math.max(L,-1),1)),w=l-(Math.sin(h-o)>0?y:2*g-y),m=(Math.sin(h-o)>0?2*g-v:v)-c;if(0===Math.sin(w)&&0===Math.sin(m))return null;if(Math.sin(w)*Math.sin(m)<0)return null;var b=-Math.cos(w)*Math.cos(m)+Math.sin(w)*Math.sin(m)*Math.cos(d),E=Math.atan2(Math.sin(d)*Math.sin(w)*Math.sin(m),Math.cos(m)+Math.cos(w)*b),O=Math.asin(Math.min(Math.max(Math.sin(s)*Math.cos(E)+Math.cos(s)*Math.sin(E)*Math.cos(l),-1),1)),P=o+Math.atan2(Math.sin(l)*Math.sin(E)*Math.cos(s),Math.cos(E)-Math.sin(s)*Math.sin(O));return new n.LatLng(this.toDegrees(O),this.toDegrees(P))},t.prototype.midpoint=function(t,e){var i=this.toRadians(t.lat),a=this.toRadians(t.lng),s=this.toRadians(e.lat),o=this.toRadians(e.lng-t.lng),r=Math.cos(i),h=0,l=Math.sin(i),c={x:r+Math.cos(s)*Math.cos(o),y:h+Math.cos(s)*Math.sin(o),z:l+Math.sin(s)},p=Math.atan2(c.z,Math.sqrt(c.x*c.x+c.y*c.y)),u=a+Math.atan2(c.y,c.x);return new n.LatLng(this.toDegrees(p),this.toDegrees(u))},t}(),r=function(){function t(t){this.geodesic=new o,this.steps=t&&void 0!==t.steps?t.steps:3}return t.prototype.recursiveMidpoint=function(t,n,e){var i=[t,n],a=this.geodesic.midpoint(t,n);return e>0?(i.splice.apply(i,s([0,1],this.recursiveMidpoint(t,a,e-1))),i.splice.apply(i,s([i.length-2,2],this.recursiveMidpoint(a,n,e-1)))):i.splice(1,0,a),i},t.prototype.line=function(t,n){return this.recursiveMidpoint(t,n,Math.min(8,this.steps))},t.prototype.multiLineString=function(t){var n=this,e=[];return t.forEach((function(t){for(var i=[],a=1;a<t.length;a++)i.splice.apply(i,s([i.length-1,1],n.line(t[a-1],t[a])));e.push(i)})),e},t.prototype.lineString=function(t){return this.multiLineString([t])[0]},t.prototype.splitLine=function(t,e){var i={point:new n.LatLng(89.9,-180.0000001),bearing:180},a={point:new n.LatLng(89.9,180.0000001),bearing:180},s=new n.LatLng(t.lat,t.lng),o=new n.LatLng(e.lat,e.lng);s.lng=this.geodesic.wrap(s.lng,360),o.lng=this.geodesic.wrap(o.lng,360),o.lng-s.lng>180?o.lng=o.lng-360:o.lng-s.lng<-180&&(o.lng=o.lng+360);var r=[[new n.LatLng(s.lat,this.geodesic.wrap(s.lng,180)),new n.LatLng(o.lat,this.geodesic.wrap(o.lng,180))]];if(s.lng>=-180&&s.lng<=180){if(o.lng<-180){var h=this.geodesic.inverse(s,o).initialBearing;(l=this.geodesic.intersection(s,h,i.point,i.bearing))&&(r=[[s,l],[new n.LatLng(l.lat,l.lng+360),new n.LatLng(o.lat,o.lng+360)]])}else if(o.lng>180){h=this.geodesic.inverse(s,o).initialBearing;(l=this.geodesic.intersection(s,h,a.point,a.bearing))&&(r=[[s,l],[new n.LatLng(l.lat,l.lng-360),new n.LatLng(o.lat,o.lng-360)]])}}else if(o.lng>=-180&&o.lng<=180)if(s.lng<-180){h=this.geodesic.inverse(s,o).initialBearing;(l=this.geodesic.intersection(s,h,i.point,i.bearing))&&(r=[[new n.LatLng(s.lat,s.lng+360),new n.LatLng(l.lat,l.lng+360)],[l,o]])}else if(s.lng>180){var l;h=this.geodesic.inverse(s,o).initialBearing;(l=this.geodesic.intersection(s,h,i.point,i.bearing))&&(r=[[new n.LatLng(s.lat,s.lng-360),new n.LatLng(l.lat,l.lng-360)],[l,o]])}return r},t.prototype.splitMultiLineString=function(t){var n=this,e=[];return t.forEach((function(t){if(1===t.length)e.push(t);else{for(var i=[],a=1;a<t.length;a++){var s=n.splitLine(t[a-1],t[a]);i.pop(),i=i.concat(s[0]),s.length>1&&(e.push(i),i=s[1])}e.push(i)}})),e},t.prototype.circle=function(t,e){for(var i=[],a=0;a<this.steps;a++){var s=this.geodesic.direct(t,360/this.steps*a,e);i.push(new n.LatLng(s.lat,s.lng))}return i.push(new n.LatLng(i[0].lat,i[0].lng)),i},t.prototype.splitCircle=function(t){var n=[];return 3===(n=this.splitMultiLineString([t])).length&&(n[2]=s(n[2],n[0]),n.shift()),n},t.prototype.distance=function(t,e){return this.geodesic.inverse(new n.LatLng(t.lat,this.geodesic.wrap(t.lng,180)),new n.LatLng(e.lat,this.geodesic.wrap(e.lng,180))).distance},t.prototype.multilineDistance=function(t){var n=this,e=[];return t.forEach((function(t){for(var i=0,a=1;a<t.length;a++)i+=n.distance(t[a-1],t[a]);e.push(i)})),e},t.prototype.updateStatistics=function(t,n){var e={};return e.distanceArray=this.multilineDistance(t),e.totalDistance=e.distanceArray.reduce((function(t,n){return t+n}),0),e.points=0,t.forEach((function(t){e.points+=t.reduce((function(t){return t+1}),0)})),e.vertices=0,n.forEach((function(t){e.vertices+=t.reduce((function(t){return t+1}),0)})),e},t}();function h(t){return"object"==typeof t&&null!==t&&"lat"in t&&"lng"in t&&"number"==typeof t.lat&&"number"==typeof t.lng}function l(t){return t instanceof Array&&"number"==typeof t[0]&&"number"==typeof t[1]}function c(t){return t instanceof n.LatLng||(!!l(t)||!!h(t))}function p(t){if(t instanceof n.LatLng)return t;if(l(t))return new n.LatLng(t[0],t[1]);if(h(t))return new n.LatLng(t.lat,t.lng);throw new Error("L.LatLngExpression expected. Unknown object found.")}var u=function(t){function e(e,i){var s=t.call(this,[],i)||this;return s.defaultOptions={wrap:!0,steps:3},s.statistics={},s.points=[],n.Util.setOptions(s,a(a({},s.defaultOptions),i)),s.geom=new r(s.options),void 0!==e&&s.setLatLngs(e),s}return i(e,t),e.prototype.updateGeometry=function(){var n;if(n=this.geom.multiLineString(this.points),this.statistics=this.geom.updateStatistics(this.points,n),this.options.wrap){var e=this.geom.splitMultiLineString(n);t.prototype.setLatLngs.call(this,e)}else t.prototype.setLatLngs.call(this,n)},e.prototype.setLatLngs=function(t){return this.points=function(t){for(var n=[],e=function(e){if(c(e)){var i=[];return t.forEach((function(t){i.push(p(t))})),n.push(i),"break"}if(!(e instanceof Array))throw new Error("L.LatLngExpression[] | L.LatLngExpression[][] expected. Unknown object found.");if(!c(e[0]))throw new Error("L.LatLngExpression[] | L.LatLngExpression[][] expected. Unknown object found.");var a=[];e.forEach((function(t){a.push(p(t))})),n.push(a)},i=0,a=t;i<a.length;i++){if("break"===e(a[i]))break}return n}(t),this.updateGeometry(),this},e.prototype.addLatLng=function(t,n){var e=p(t);return 0===this.points.length?this.points.push([e]):void 0===n?this.points[this.points.length-1].push(e):n.push(e),this.updateGeometry(),this},e.prototype.fromGeoJson=function(t){var e=[],i=[];return"FeatureCollection"===t.type?i=t.features:"Feature"===t.type?i=[t]:["MultiPoint","LineString","MultiLineString","Polygon","MultiPolygon"].includes(t.type)?i=[{type:"Feature",geometry:t,properties:{}}]:console.log('[Leaflet.Geodesic] fromGeoJson() - Type "'+t.type+'" not supported.'),i.forEach((function(t){switch(t.geometry.type){case"MultiPoint":case"LineString":e=s(e,[n.GeoJSON.coordsToLatLngs(t.geometry.coordinates,0)]);break;case"MultiLineString":case"Polygon":e=s(e,n.GeoJSON.coordsToLatLngs(t.geometry.coordinates,1));break;case"MultiPolygon":t.geometry.coordinates.forEach((function(t){e=s(e,n.GeoJSON.coordsToLatLngs(t,1))}));break;default:console.log('[Leaflet.Geodesic] fromGeoJson() - Type "'+t.geometry.type+'" not supported.')}})),e.length&&this.setLatLngs(e),this},e.prototype.distance=function(t,n){return this.geom.distance(p(t),p(n))},e}(n.Polyline),g=function(t){function e(e,i){var s=t.call(this,[],i)||this;s.defaultOptions={wrap:!0,steps:24,fill:!0,noClip:!0},s.statistics={},n.Util.setOptions(s,a(a({},s.defaultOptions),i));var o=s.options;return s.radius=void 0===o.radius?1e6:o.radius,s.center=void 0===e?new n.LatLng(0,0):p(e),s.geom=new r(s.options),s.update(),s}return i(e,t),e.prototype.update=function(){var n=this.geom.circle(this.center,this.radius);if(this.statistics=this.geom.updateStatistics([[this.center]],[n]),this.statistics.totalDistance=this.geom.multilineDistance([n]).reduce((function(t,n){return t+n}),0),this.options.wrap){var e=this.geom.splitCircle(n);t.prototype.setLatLngs.call(this,e)}else t.prototype.setLatLngs.call(this,n)},e.prototype.distanceTo=function(t){var n=p(t);return this.geom.distance(this.center,n)},e.prototype.setLatLng=function(t,n){this.center=p(t),this.radius=n||this.radius,this.update()},e.prototype.setRadius=function(t,n){this.radius=t,this.center=n?p(n):this.center,this.update()},e}(n.Polyline);n.Geodesic=u,n.geodesic=function(){for(var t=[],n=0;n<arguments.length;n++)t[n]=arguments[n];return new(u.bind.apply(u,s([void 0],t)))},n.GeodesicCircle=g,n.geodesiccircle=function(){for(var t=[],n=0;n<arguments.length;n++)t[n]=arguments[n];return new(g.bind.apply(g,s([void 0],t)))},t.GeodesicCircleClass=g,t.GeodesicLine=u,Object.defineProperty(t,"__esModule",{value:!0})}));
