import L from "leaflet";
import { GeodesicOptions } from "./geodesic-core";
import { GeodesicGeometry, Statistics } from "./geodesic-geom";
/**
 * Draw geodesic lines based on L.Polyline
 */
export declare class GeodesicLine extends L.Polyline {
    /** these should be good for most use-cases */
    defaultOptions: GeodesicOptions;
    /** does the actual geometry calculations */
    readonly geom: GeodesicGeometry;
    /** use this if you need some detailled info about the current geometry */
    statistics: Statistics;
    /** stores all positions that are used to create the geodesic line */
    points: L.LatLng[][];
    constructor(latlngs?: L.LatLngExpression[] | L.LatLngExpression[][], options?: GeodesicOptions);
    /** calculates the geodesics and update the polyline-object accordingly */
    private updateGeometry;
    /**
     * overwrites the original function with additional functionality to create a geodesic line
     * @param latlngs an array (or 2d-array) of positions
     */
    setLatLngs(latlngs: L.LatLngExpression[] | L.LatLngExpression[][]): this;
    /**
     * add a given point to the geodesic line object
     * @param latlng point to add. The point will always be added to the last linestring of a multiline
     * @param latlngs define a linestring to add the new point to. Read from points-property before (e.g. `line.addLatLng(Beijing, line.points[0]);`)
     */
    addLatLng(latlng: L.LatLngExpression, latlngs?: L.LatLng[]): this;
    /**
     * Creates geodesic lines from a given GeoJSON-Object.
     * @param input GeoJSON-Object
     */
    fromGeoJson(input: GeoJSON.GeoJSON): this;
    /**
     * Calculates the distance between two geo-positions
     * @param start 1st position
     * @param dest 2nd position
     * @return the distance in meters
     */
    distance(start: L.LatLngExpression, dest: L.LatLngExpression): number;
}
