# Contributing

Contributions are welcome, and they are greatly appreciated! Every
little bit helps, and [credit](thanks.md) will always be given.
You can contribute in many ways:

## Types of Contributions

### Report Bugs and Propose Features

```{note}
First, go to [issue tracker][] and see if any of the existing issues sounds familiar
```

If you are **reporting a bug**, please include:

  - Your operating system name and version.
  - Any details about your local setup that might be helpful in
    troubleshooting.
  - Detailed steps to reproduce the bug.

If you are **proposing a feature**:

  - Explain in detail how it would work.
  - Keep the scope as narrow as possible, to make it easier to
    implement.
  - Remember that this is a volunteer-driven project, and that
    contributions are welcome :)

### Fix Bugs

Look through the [issue tracker][] for bugs. Anything tagged with "bug" and
"help wanted" is open to whoever wants to implement it.

### Implement Features

Look through the [issue tracker][] for feature requests. Anything tagged with
"enhancement" and "help wanted" is open to whoever wants to implement it.

### Write Documentation

Pymech could always use more documentation, whether as part of the official
Pymech docs, in docstrings, as tutorials, or even on the web in blog posts,
articles, and such.

```{hint}
The latest documentation built directly from unreleased version is visible at
<https://pymech.readthedocs.io/en/latest/>
```

```{note}
If any of the above seems interesting, take a look how to {ref}`get-started`
```

## Seek support

Need help? You are welcome to contact us and post your questions at the instant
messaging Matrix chat room,
[#ex-mech-help:matrix.org](https://matrix.to/#/#ex-mech-help:matrix.org)

[issue tracker]: https://github.com/eX-Mech/pymech/issues
