# Generated by Django 2.2.7 on 2019-11-24 23:05

from django.conf import settings
import django.contrib.auth.models
import django.contrib.auth.validators
import django.contrib.gis.db.models.fields
import django.contrib.postgres.fields.jsonb
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import irekua_database.models.items.items
import irekua_database.models.items.secondary_items
import irekua_database.utils
import sorl.thumbnail.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0011_update_proxy_permissions'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='username')),
                ('first_name', models.CharField(blank=True, max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=150, verbose_name='last name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('is_developer', models.BooleanField(db_column='is_developer', default=False, help_text='Flag to indicate if user is a model developer', verbose_name='is developer')),
                ('is_curator', models.BooleanField(db_column='is_curator', default=False, help_text='Flag to indicate if user is a curator', verbose_name='is curator')),
                ('is_model', models.BooleanField(db_column='is_model', default=False, help_text='Flag to indicate if user is an AI model', verbose_name='is model')),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
            ],
            options={
                'verbose_name': 'User',
                'verbose_name_plural': 'Users',
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Annotation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('annotation', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='annotation', default=irekua_database.utils.empty_JSON, help_text='Information of annotation location within item', verbose_name='annotation')),
                ('visualizer_configuration', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='visualizer_configuration', default=irekua_database.utils.empty_JSON, help_text='Configuration of visualizer at annotation creation', verbose_name='visualizer configuration')),
                ('certainty', models.CharField(blank=True, choices=[('L', 'uncertain'), ('M', 'somewhat certain'), ('H', 'certain')], db_column='certainty', help_text='Level of certainty of location or labelling of annotation', max_length=16, null=True, verbose_name='certainty')),
                ('quality', models.CharField(blank=True, choices=[('L', 'low'), ('M', 'medium'), ('H', 'high')], db_column='quality', help_text='Quality of item content inside annotation', max_length=16, verbose_name='quality')),
                ('commentaries', models.TextField(blank=True, db_column='commentaries', help_text='Commentaries of annotator', verbose_name='commentaries')),
            ],
            options={
                'verbose_name': 'Annotation',
                'verbose_name_plural': 'Annotations',
                'ordering': ['-modified_on'],
                'permissions': (('vote', 'Can vote annotation'),),
            },
        ),
        migrations.CreateModel(
            name='AnnotationType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('name', models.CharField(db_column='name', help_text='Name for type of annotation', max_length=64, unique=True, verbose_name='name')),
                ('description', models.TextField(db_column='description', help_text='Description of annotation type', verbose_name='description')),
                ('annotation_schema', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='annotation_schema', default=irekua_database.utils.simple_JSON_schema, help_text='JSON Schema for annotation info', validators=[irekua_database.utils.validate_JSON_schema], verbose_name='annotation schema')),
                ('icon', models.ImageField(blank=True, db_column='icon', help_text='Annotation type icon', null=True, upload_to='images/annotation_types/', verbose_name='icon')),
            ],
            options={
                'verbose_name': 'Annotation Type',
                'verbose_name_plural': 'Annotation Types',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Collection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('name', models.CharField(db_column='name', help_text='Name of collection', max_length=128, unique=True, verbose_name='name')),
                ('description', models.TextField(db_column='description', help_text='Description of collection', verbose_name='description')),
                ('metadata', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata', default=irekua_database.utils.empty_JSON, help_text='Metadata associated to collection', verbose_name='metadata')),
                ('logo', models.ImageField(blank=True, db_column='logo', help_text='Logo of data collection', null=True, upload_to='images/collections/', verbose_name='logo')),
                ('is_open', models.BooleanField(blank=True, db_column='is_open', default=False, help_text='Boolean flag indicating whether contents of the collection are public.', verbose_name='is open')),
                ('administrators', models.ManyToManyField(blank=True, help_text='Administrators of collection', related_name='collection_administrators', to=settings.AUTH_USER_MODEL, verbose_name='administrators')),
            ],
            options={
                'verbose_name': 'Collection',
                'verbose_name_plural': 'Collections',
                'ordering': ['-created_on'],
                'permissions': (('add_collection_site', 'Can add site to collection'), ('add_collection_item', 'Can add item to collection'), ('add_collection_device', 'Can add device to collection'), ('add_collection_sampling_event', 'Can add a sampling event to collection'), ('add_collection_user', 'Can add user to collection'), ('add_collection_licence', 'Can add licence to collection'), ('add_collection_annotation', 'Can annotate items in collection'), ('add_collection_annotation_vote', 'Can vote on annotations of items in collection'), ('view_collection_sites', 'Can view sites in collection'), ('view_collection_items', 'Can view items in collection'), ('view_collection_devices', 'Can view devices in collection'), ('view_collection_sampling_events', 'Can view sampling event in collection'), ('view_collection_annotations', 'Can view annotations of items in collection'), ('change_collection_sites', 'Can change sites in collection'), ('change_collection_users', 'Can change user info in collection'), ('change_collection_items', 'Can change items in collection'), ('change_collection_devices', 'Can change devices in collection'), ('change_collection_annotations', 'Can change annotations of items in collection'), ('change_collection_sampling_events', 'Can change sampling events in collection'), ('download_collection_items', 'Can download annotation items')),
            },
        ),
        migrations.CreateModel(
            name='CollectionDevice',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('internal_id', models.CharField(blank=True, db_column='internal_id', help_text='ID of device within the collection (visible to all collection users)', max_length=64, verbose_name='ID within collection')),
                ('metadata', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata', default=irekua_database.utils.empty_JSON, help_text='Metadata associated with device within collection', null=True, verbose_name='metadata')),
                ('collection', models.ForeignKey(db_column='collection_id', help_text='Collection to which the device belongs', on_delete=django.db.models.deletion.CASCADE, to='irekua_database.Collection', verbose_name='collection')),
                ('created_by', models.ForeignKey(blank=True, db_column='creator_id', help_text='Creator of object', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='collectiondevice_created_by', to=settings.AUTH_USER_MODEL, verbose_name='creator')),
                ('modified_by', models.ForeignKey(blank=True, db_column='modified_by', editable=False, help_text='User who made modifications last', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='collectiondevice_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='modified by')),
            ],
            options={
                'verbose_name': 'Collection Device',
                'verbose_name_plural': 'Collection Devices',
                'ordering': ['-modified_on'],
            },
        ),
        migrations.CreateModel(
            name='CollectionDeviceType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('metadata_schema', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata_schema', default=irekua_database.utils.simple_JSON_schema, help_text='JSON Schema for metadata of collection device info', validators=[irekua_database.utils.validate_JSON_schema], verbose_name='metadata schema')),
            ],
            options={
                'verbose_name': 'Collection Device Type',
                'verbose_name_plural': 'Collection Device Types',
            },
        ),
        migrations.CreateModel(
            name='CollectionItemType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('metadata_schema', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata_schema', default=irekua_database.utils.simple_JSON_schema, help_text='JSON Schema for metadata of collection item info', validators=[irekua_database.utils.validate_JSON_schema], verbose_name='metadata schema')),
            ],
            options={
                'verbose_name': 'Collection Item Type',
                'verbose_name_plural': 'Collection Item Types',
            },
        ),
        migrations.CreateModel(
            name='CollectionRole',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('metadata_schema', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata_schema', default=irekua_database.utils.simple_JSON_schema, help_text='JSON Schema for metadata of collection role info', validators=[irekua_database.utils.validate_JSON_schema], verbose_name='metadata schema')),
            ],
            options={
                'verbose_name': 'Collection Role',
                'verbose_name_plural': 'Collection Roles',
            },
        ),
        migrations.CreateModel(
            name='CollectionSite',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('metadata', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata', default=irekua_database.utils.empty_JSON, help_text='Metadata associated to site in collection', null=True, verbose_name='metadata')),
                ('internal_id', models.CharField(blank=True, db_column='internal_id', help_text='ID of site within the collection (visible to all collection users)', max_length=64, verbose_name='ID within collection')),
                ('collection', models.ForeignKey(db_column='collection_id', help_text='Collection to which the site belongs', on_delete=django.db.models.deletion.CASCADE, to='irekua_database.Collection', verbose_name='collection')),
                ('created_by', models.ForeignKey(blank=True, db_column='creator_id', help_text='Creator of object', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='collectionsite_created_by', to=settings.AUTH_USER_MODEL, verbose_name='creator')),
                ('modified_by', models.ForeignKey(blank=True, db_column='modified_by', editable=False, help_text='User who made modifications last', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='collectionsite_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='modified by')),
            ],
            options={
                'verbose_name': 'Collection Site',
                'verbose_name_plural': 'Collection Sites',
            },
        ),
        migrations.CreateModel(
            name='Device',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('model', models.CharField(db_column='model', help_text='Model of device', max_length=64, verbose_name='model')),
                ('metadata_schema', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata_schema', default=irekua_database.utils.simple_JSON_schema, help_text='JSON Schema for metadata of device info', validators=[irekua_database.utils.validate_JSON_schema], verbose_name='metadata schema')),
                ('configuration_schema', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='configuration_schema', default=irekua_database.utils.simple_JSON_schema, help_text='JSON Schema for configuration info of device', validators=[irekua_database.utils.validate_JSON_schema], verbose_name='configuration schema')),
            ],
            options={
                'verbose_name': 'Device',
                'verbose_name_plural': 'Devices',
                'ordering': ['brand', 'model'],
            },
        ),
        migrations.CreateModel(
            name='DeviceBrand',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('name', models.CharField(db_column='name', help_text='Name of device brand', max_length=128, unique=True, verbose_name='name')),
                ('website', models.URLField(blank=True, db_column='website', help_text="Brand's website", null=True, verbose_name='website')),
                ('logo', models.ImageField(blank=True, db_column='logo', help_text='Logo of device brand', null=True, upload_to='images/device_brands/', verbose_name='logo')),
            ],
            options={
                'verbose_name': 'Device Brand',
                'verbose_name_plural': 'Device Brands',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='DeviceType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('name', models.CharField(db_column='name', help_text='Name for device type', max_length=64, unique=True, verbose_name='name')),
                ('description', models.TextField(db_column='description', help_text='Description of device type', verbose_name='description')),
                ('icon', models.ImageField(blank=True, db_column='icon', help_text='Icon for device type', null=True, upload_to='images/device_types/', verbose_name='icon')),
            ],
            options={
                'verbose_name': 'Device Type',
                'verbose_name_plural': 'Device Types',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='EventType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('name', models.CharField(db_column='name', help_text='Name of event type', max_length=64, unique=True, verbose_name='name')),
                ('description', models.TextField(db_column='description', help_text='Description of event type', verbose_name='description')),
                ('icon', models.ImageField(blank=True, db_column='icon', help_text='Event type icon', null=True, upload_to='images/event_types/', verbose_name='icon')),
            ],
            options={
                'verbose_name': 'Event Type',
                'verbose_name_plural': 'Event Types',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Item',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('filesize', models.IntegerField(blank=True, db_column='filesize', help_text='Size of resource in Bytes', null=True, verbose_name='file size')),
                ('hash', models.CharField(blank=True, db_column='hash', help_text='Hash of resource file', max_length=64, unique=True, verbose_name='hash')),
                ('item_file', models.FileField(blank=True, db_column='item_file', help_text='Upload file associated to file', null=True, upload_to=irekua_database.models.items.items.get_item_path, verbose_name='item file')),
                ('item_thumbnail', sorl.thumbnail.fields.ImageField(blank=True, db_column='item_thumbnail', help_text='Thumbnail associated to file', null=True, upload_to=irekua_database.models.items.items.get_thumbnail_path, verbose_name='item thumbnail')),
                ('media_info', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='media_info', default=irekua_database.utils.empty_JSON, help_text='Information of resource file', verbose_name='media info')),
                ('source_foreign_key', models.CharField(blank=True, db_column='source_foreign_key', help_text='Foreign key of file in source database', max_length=64, verbose_name='source foreign key')),
                ('metadata', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata', default=irekua_database.utils.empty_JSON, help_text='Metadata associated to item', null=True, verbose_name='metadata')),
                ('captured_on', models.DateTimeField(blank=True, db_column='captured_on', help_text='Date on which item was produced', null=True, verbose_name='captured on')),
                ('captured_on_year', models.IntegerField(blank=True, db_column='captured_on_year', help_text='Year in which the item was captured (YYYY)', null=True, validators=[django.core.validators.MinValueValidator(1800), django.core.validators.MaxValueValidator(3000)], verbose_name='year')),
                ('captured_on_month', models.IntegerField(blank=True, db_column='captured_on_month', help_text='Month in which the item was captured (1-12)', null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(12)], verbose_name='month')),
                ('captured_on_day', models.IntegerField(blank=True, db_column='captured_on_day', help_text='Day in which the item was captured', null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(32)], verbose_name='day')),
                ('captured_on_hour', models.IntegerField(blank=True, db_column='captured_on_hour', help_text='Hour of the day in which the item was captured (0 - 23)', null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(23)], verbose_name='hour')),
                ('captured_on_minute', models.IntegerField(blank=True, db_column='captured_on_minute', help_text='Minute in which the item was captured (0-59)', null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(59)], verbose_name='minute')),
                ('captured_on_second', models.IntegerField(blank=True, db_column='captured_on_second', help_text='Second in which the item was captured (0-59)', null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(59)], verbose_name='second')),
                ('captured_on_timezone', models.CharField(blank=True, db_column='captured_on_timezone', help_text='Timezone corresponding to date fields', max_length=256, null=True, verbose_name='timezone')),
                ('created_by', models.ForeignKey(blank=True, db_column='creator_id', help_text='Creator of object', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='item_created_by', to=settings.AUTH_USER_MODEL, verbose_name='creator')),
            ],
            options={
                'verbose_name': 'Item',
                'verbose_name_plural': 'Items',
                'ordering': ['created_on'],
                'permissions': (('download_item', 'Can download item'), ('annotate_item', 'Can annotate item')),
            },
        ),
        migrations.CreateModel(
            name='ItemType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('name', models.CharField(db_column='name', help_text='Name of item type', max_length=64, unique=True, verbose_name='name')),
                ('description', models.TextField(db_column='description', help_text='Description of item type', verbose_name='description')),
                ('icon', models.ImageField(blank=True, db_column='icon', help_text='Item type icon', null=True, upload_to='images/item_types/', verbose_name='icon')),
                ('event_types', models.ManyToManyField(blank=True, db_column='event_types', help_text='Types of event for this item type', to='irekua_database.EventType', verbose_name='event types')),
            ],
            options={
                'verbose_name': 'Item Type',
                'verbose_name_plural': 'Item Types',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Licence',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('document', models.FileField(blank=True, db_column='document', help_text='Legal document of licence agreement', upload_to='documents/licences/', verbose_name='document')),
                ('metadata', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata', default=irekua_database.utils.empty_JSON, help_text='Metadata associated with licence', null=True, verbose_name='metadata')),
                ('is_active', models.BooleanField(blank=True, db_column='is_active', default=False, editable=False, help_text='Licence is still active', verbose_name='is active')),
                ('collection', models.ForeignKey(db_column='collection_id', help_text='Collection to which this licence belongs', on_delete=django.db.models.deletion.CASCADE, to='irekua_database.Collection', verbose_name='collection')),
                ('created_by', models.ForeignKey(blank=True, db_column='creator_id', help_text='Creator of object', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='licence_created_by', to=settings.AUTH_USER_MODEL, verbose_name='creator')),
            ],
            options={
                'verbose_name': 'Licence',
                'verbose_name_plural': 'Licences',
                'ordering': ['-created_on'],
            },
        ),
        migrations.CreateModel(
            name='LicenceType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('name', models.CharField(db_column='name', help_text='Licence type name', max_length=128, unique=True, verbose_name='name')),
                ('description', models.TextField(db_column='description', help_text='Description of licence', verbose_name='description')),
                ('metadata_schema', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata_schema', default=irekua_database.utils.simple_JSON_schema, help_text='JSON Schema for metadata of licence info', validators=[irekua_database.utils.validate_JSON_schema], verbose_name='metadata schema')),
                ('document_template', models.FileField(blank=True, db_column='document_template', help_text='Template for licence document', null=True, upload_to='documents/licence_types/', verbose_name='document template')),
                ('years_valid_for', models.IntegerField(db_column='years_valid_for', help_text='Number of years for which licences of this type are valid', verbose_name='years valid for')),
                ('icon', models.ImageField(blank=True, db_column='icon', help_text='Licence type icon', null=True, upload_to='images/licence_types/', verbose_name='icon')),
                ('can_view', models.BooleanField(db_column='can_view', help_text='Any user can view item info', verbose_name='can view')),
                ('can_download', models.BooleanField(db_column='can_download', help_text='Any user can download item', verbose_name='can download')),
                ('can_view_annotations', models.BooleanField(db_column='can_view_annotations', help_text='Any user can view item annotations', verbose_name='can view annotations')),
                ('can_annotate', models.BooleanField(db_column='can_annotate', help_text='Any user can annotate item', verbose_name='can annotate')),
                ('can_vote_annotations', models.BooleanField(db_column='can_vote_annotations', help_text='Any user can vote on item annotations', verbose_name='can vote annotations')),
            ],
            options={
                'verbose_name': 'Licence Type',
                'verbose_name_plural': 'Licence Types',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Locality',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(db_column='name', help_text='Name of locality', max_length=128)),
                ('description', models.TextField(blank=True, db_column='description', help_text='Description of the locality', verbose_name='description')),
                ('geometry', django.contrib.gis.db.models.fields.MultiPolygonField(blank=True, db_column='geometry', help_text='Geometry of locality', srid=4326, verbose_name='geometry')),
                ('metadata', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata', default=irekua_database.utils.empty_JSON, help_text='Metadata associated to locality', null=True, verbose_name='metadata')),
                ('is_part_of', models.ManyToManyField(blank=True, to='irekua_database.Locality')),
            ],
            options={
                'verbose_name': 'Locality',
                'verbose_name_plural': 'Localities',
                'ordering': ['-name'],
            },
        ),
        migrations.CreateModel(
            name='LocalityType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(db_column='name', help_text='Name of locality', max_length=128, unique=True)),
                ('description', models.TextField(blank=True, db_column='description', help_text='Description of type of locality', verbose_name='description')),
                ('source', models.URLField(blank=True, db_column='source', help_text='Source of information for localities of this type', max_length=128, verbose_name='source')),
                ('original_datum', models.TextField(blank=True, db_column='original_datum', help_text='Datum used for the original coordinates for localities of this type in WTK format', verbose_name='original datum')),
                ('publication_date', models.DateField(blank=True, db_column='publication_date', help_text='Date of publication of localities defined in this type', verbose_name='publication date')),
                ('metadata_schema', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata_schema', default=irekua_database.utils.simple_JSON_schema, help_text='JSON Schema for metadata of localities of this type', null=True, validators=[irekua_database.utils.validate_JSON_schema], verbose_name='metadata_schema')),
            ],
            options={
                'verbose_name': 'Locality Type',
                'verbose_name_plural': 'Locality Types',
                'ordering': ['-name'],
            },
        ),
        migrations.CreateModel(
            name='MimeType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('mime_type', models.CharField(choices=[('application/andrew-inset', 'application/andrew-inset'), ('application/applixware', 'application/applixware'), ('application/atom+xml', 'application/atom+xml'), ('application/atomcat+xml', 'application/atomcat+xml'), ('application/atomsvc+xml', 'application/atomsvc+xml'), ('application/ccxml+xml', 'application/ccxml+xml'), ('application/cdmi-capability', 'application/cdmi-capability'), ('application/cdmi-container', 'application/cdmi-container'), ('application/cdmi-domain', 'application/cdmi-domain'), ('application/cdmi-object', 'application/cdmi-object'), ('application/cdmi-queue', 'application/cdmi-queue'), ('application/cu-seeme', 'application/cu-seeme'), ('application/davmount+xml', 'application/davmount+xml'), ('application/docbook+xml', 'application/docbook+xml'), ('application/dssc+der', 'application/dssc+der'), ('application/dssc+xml', 'application/dssc+xml'), ('application/ecmascript', 'application/ecmascript'), ('application/emma+xml', 'application/emma+xml'), ('application/epub+zip', 'application/epub+zip'), ('application/exi', 'application/exi'), ('application/font-tdpfr', 'application/font-tdpfr'), ('application/gml+xml', 'application/gml+xml'), ('application/gpx+xml', 'application/gpx+xml'), ('application/gxf', 'application/gxf'), ('application/hyperstudio', 'application/hyperstudio'), ('application/inkml+xml', 'application/inkml+xml'), ('application/ipfix', 'application/ipfix'), ('application/java-archive', 'application/java-archive'), ('application/java-serialized-object', 'application/java-serialized-object'), ('application/java-vm', 'application/java-vm'), ('application/javascript', 'application/javascript'), ('application/json', 'application/json'), ('application/jsonml+json', 'application/jsonml+json'), ('application/lost+xml', 'application/lost+xml'), ('application/mac-binhex40', 'application/mac-binhex40'), ('application/mac-compactpro', 'application/mac-compactpro'), ('application/mads+xml', 'application/mads+xml'), ('application/marc', 'application/marc'), ('application/marcxml+xml', 'application/marcxml+xml'), ('application/mathematica', 'application/mathematica'), ('application/mathml+xml', 'application/mathml+xml'), ('application/mbox', 'application/mbox'), ('application/mediaservercontrol+xml', 'application/mediaservercontrol+xml'), ('application/metalink+xml', 'application/metalink+xml'), ('application/metalink4+xml', 'application/metalink4+xml'), ('application/mets+xml', 'application/mets+xml'), ('application/mods+xml', 'application/mods+xml'), ('application/mp21', 'application/mp21'), ('application/mp4', 'application/mp4'), ('application/msword', 'application/msword'), ('application/mxf', 'application/mxf'), ('application/octet-stream', 'application/octet-stream'), ('application/oda', 'application/oda'), ('application/oebps-package+xml', 'application/oebps-package+xml'), ('application/ogg', 'application/ogg'), ('application/omdoc+xml', 'application/omdoc+xml'), ('application/onenote', 'application/onenote'), ('application/oxps', 'application/oxps'), ('application/patch-ops-error+xml', 'application/patch-ops-error+xml'), ('application/pdf', 'application/pdf'), ('application/pgp-encrypted', 'application/pgp-encrypted'), ('application/pgp-signature', 'application/pgp-signature'), ('application/pics-rules', 'application/pics-rules'), ('application/pkcs10', 'application/pkcs10'), ('application/pkcs7-mime', 'application/pkcs7-mime'), ('application/pkcs7-signature', 'application/pkcs7-signature'), ('application/pkcs8', 'application/pkcs8'), ('application/pkix-attr-cert', 'application/pkix-attr-cert'), ('application/pkix-cert', 'application/pkix-cert'), ('application/pkix-crl', 'application/pkix-crl'), ('application/pkix-pkipath', 'application/pkix-pkipath'), ('application/pkixcmp', 'application/pkixcmp'), ('application/pls+xml', 'application/pls+xml'), ('application/postscript', 'application/postscript'), ('application/prs.cww', 'application/prs.cww'), ('application/pskc+xml', 'application/pskc+xml'), ('application/rdf+xml', 'application/rdf+xml'), ('application/reginfo+xml', 'application/reginfo+xml'), ('application/relax-ng-compact-syntax', 'application/relax-ng-compact-syntax'), ('application/resource-lists+xml', 'application/resource-lists+xml'), ('application/resource-lists-diff+xml', 'application/resource-lists-diff+xml'), ('application/rls-services+xml', 'application/rls-services+xml'), ('application/rpki-ghostbusters', 'application/rpki-ghostbusters'), ('application/rpki-manifest', 'application/rpki-manifest'), ('application/rpki-roa', 'application/rpki-roa'), ('application/rsd+xml', 'application/rsd+xml'), ('application/rss+xml', 'application/rss+xml'), ('application/rtf', 'application/rtf'), ('application/sbml+xml', 'application/sbml+xml'), ('application/scvp-cv-request', 'application/scvp-cv-request'), ('application/scvp-cv-response', 'application/scvp-cv-response'), ('application/scvp-vp-request', 'application/scvp-vp-request'), ('application/scvp-vp-response', 'application/scvp-vp-response'), ('application/sdp', 'application/sdp'), ('application/set-payment-initiation', 'application/set-payment-initiation'), ('application/set-registration-initiation', 'application/set-registration-initiation'), ('application/shf+xml', 'application/shf+xml'), ('application/smil+xml', 'application/smil+xml'), ('application/sparql-query', 'application/sparql-query'), ('application/sparql-results+xml', 'application/sparql-results+xml'), ('application/srgs', 'application/srgs'), ('application/srgs+xml', 'application/srgs+xml'), ('application/sru+xml', 'application/sru+xml'), ('application/ssdl+xml', 'application/ssdl+xml'), ('application/ssml+xml', 'application/ssml+xml'), ('application/tei+xml', 'application/tei+xml'), ('application/thraud+xml', 'application/thraud+xml'), ('application/timestamped-data', 'application/timestamped-data'), ('application/vnd.3gpp.pic-bw-large', 'application/vnd.3gpp.pic-bw-large'), ('application/vnd.3gpp.pic-bw-small', 'application/vnd.3gpp.pic-bw-small'), ('application/vnd.3gpp.pic-bw-var', 'application/vnd.3gpp.pic-bw-var'), ('application/vnd.3gpp2.tcap', 'application/vnd.3gpp2.tcap'), ('application/vnd.3m.post-it-notes', 'application/vnd.3m.post-it-notes'), ('application/vnd.accpac.simply.aso', 'application/vnd.accpac.simply.aso'), ('application/vnd.accpac.simply.imp', 'application/vnd.accpac.simply.imp'), ('application/vnd.acucobol', 'application/vnd.acucobol'), ('application/vnd.acucorp', 'application/vnd.acucorp'), ('application/vnd.adobe.air-application-installer-package+zip', 'application/vnd.adobe.air-application-installer-package+zip'), ('application/vnd.adobe.formscentral.fcdt', 'application/vnd.adobe.formscentral.fcdt'), ('application/vnd.adobe.fxp', 'application/vnd.adobe.fxp'), ('application/vnd.adobe.xdp+xml', 'application/vnd.adobe.xdp+xml'), ('application/vnd.adobe.xfdf', 'application/vnd.adobe.xfdf'), ('application/vnd.ahead.space', 'application/vnd.ahead.space'), ('application/vnd.airzip.filesecure.azf', 'application/vnd.airzip.filesecure.azf'), ('application/vnd.airzip.filesecure.azs', 'application/vnd.airzip.filesecure.azs'), ('application/vnd.amazon.ebook', 'application/vnd.amazon.ebook'), ('application/vnd.americandynamics.acc', 'application/vnd.americandynamics.acc'), ('application/vnd.amiga.ami', 'application/vnd.amiga.ami'), ('application/vnd.android.package-archive', 'application/vnd.android.package-archive'), ('application/vnd.anser-web-certificate-issue-initiation', 'application/vnd.anser-web-certificate-issue-initiation'), ('application/vnd.anser-web-funds-transfer-initiation', 'application/vnd.anser-web-funds-transfer-initiation'), ('application/vnd.antix.game-component', 'application/vnd.antix.game-component'), ('application/vnd.apple.installer+xml', 'application/vnd.apple.installer+xml'), ('application/vnd.aristanetworks.swi', 'application/vnd.aristanetworks.swi'), ('application/vnd.astraea-software.iota', 'application/vnd.astraea-software.iota'), ('application/vnd.audiograph', 'application/vnd.audiograph'), ('application/vnd.blueice.multipass', 'application/vnd.blueice.multipass'), ('application/vnd.bmi', 'application/vnd.bmi'), ('application/vnd.businessobjects', 'application/vnd.businessobjects'), ('application/vnd.chemdraw+xml', 'application/vnd.chemdraw+xml'), ('application/vnd.chipnuts.karaoke-mmd', 'application/vnd.chipnuts.karaoke-mmd'), ('application/vnd.cinderella', 'application/vnd.cinderella'), ('application/vnd.claymore', 'application/vnd.claymore'), ('application/vnd.cloanto.rp9', 'application/vnd.cloanto.rp9'), ('application/vnd.clonk.c4group', 'application/vnd.clonk.c4group'), ('application/vnd.cluetrust.cartomobile-config', 'application/vnd.cluetrust.cartomobile-config'), ('application/vnd.cluetrust.cartomobile-config-pkg', 'application/vnd.cluetrust.cartomobile-config-pkg'), ('application/vnd.commonspace', 'application/vnd.commonspace'), ('application/vnd.contact.cmsg', 'application/vnd.contact.cmsg'), ('application/vnd.cosmocaller', 'application/vnd.cosmocaller'), ('application/vnd.crick.clicker', 'application/vnd.crick.clicker'), ('application/vnd.crick.clicker.keyboard', 'application/vnd.crick.clicker.keyboard'), ('application/vnd.crick.clicker.palette', 'application/vnd.crick.clicker.palette'), ('application/vnd.crick.clicker.template', 'application/vnd.crick.clicker.template'), ('application/vnd.crick.clicker.wordbank', 'application/vnd.crick.clicker.wordbank'), ('application/vnd.criticaltools.wbs+xml', 'application/vnd.criticaltools.wbs+xml'), ('application/vnd.ctc-posml', 'application/vnd.ctc-posml'), ('application/vnd.cups-ppd', 'application/vnd.cups-ppd'), ('application/vnd.curl.car', 'application/vnd.curl.car'), ('application/vnd.curl.pcurl', 'application/vnd.curl.pcurl'), ('application/vnd.dart', 'application/vnd.dart'), ('application/vnd.data-vision.rdz', 'application/vnd.data-vision.rdz'), ('application/vnd.dece.data', 'application/vnd.dece.data'), ('application/vnd.dece.ttml+xml', 'application/vnd.dece.ttml+xml'), ('application/vnd.dece.unspecified', 'application/vnd.dece.unspecified'), ('application/vnd.dece.zip', 'application/vnd.dece.zip'), ('application/vnd.denovo.fcselayout-link', 'application/vnd.denovo.fcselayout-link'), ('application/vnd.dna', 'application/vnd.dna'), ('application/vnd.dolby.mlp', 'application/vnd.dolby.mlp'), ('application/vnd.dpgraph', 'application/vnd.dpgraph'), ('application/vnd.dreamfactory', 'application/vnd.dreamfactory'), ('application/vnd.ds-keypoint', 'application/vnd.ds-keypoint'), ('application/vnd.dvb.ait', 'application/vnd.dvb.ait'), ('application/vnd.dvb.service', 'application/vnd.dvb.service'), ('application/vnd.dynageo', 'application/vnd.dynageo'), ('application/vnd.ecowin.chart', 'application/vnd.ecowin.chart'), ('application/vnd.enliven', 'application/vnd.enliven'), ('application/vnd.epson.esf', 'application/vnd.epson.esf'), ('application/vnd.epson.msf', 'application/vnd.epson.msf'), ('application/vnd.epson.quickanime', 'application/vnd.epson.quickanime'), ('application/vnd.epson.salt', 'application/vnd.epson.salt'), ('application/vnd.epson.ssf', 'application/vnd.epson.ssf'), ('application/vnd.eszigno3+xml', 'application/vnd.eszigno3+xml'), ('application/vnd.ezpix-album', 'application/vnd.ezpix-album'), ('application/vnd.ezpix-package', 'application/vnd.ezpix-package'), ('application/vnd.fdf', 'application/vnd.fdf'), ('application/vnd.fdsn.mseed', 'application/vnd.fdsn.mseed'), ('application/vnd.fdsn.seed', 'application/vnd.fdsn.seed'), ('application/vnd.flographit', 'application/vnd.flographit'), ('application/vnd.fluxtime.clip', 'application/vnd.fluxtime.clip'), ('application/vnd.framemaker', 'application/vnd.framemaker'), ('application/vnd.frogans.fnc', 'application/vnd.frogans.fnc'), ('application/vnd.frogans.ltf', 'application/vnd.frogans.ltf'), ('application/vnd.fsc.weblaunch', 'application/vnd.fsc.weblaunch'), ('application/vnd.fujitsu.oasys', 'application/vnd.fujitsu.oasys'), ('application/vnd.fujitsu.oasys2', 'application/vnd.fujitsu.oasys2'), ('application/vnd.fujitsu.oasys3', 'application/vnd.fujitsu.oasys3'), ('application/vnd.fujitsu.oasysgp', 'application/vnd.fujitsu.oasysgp'), ('application/vnd.fujitsu.oasysprs', 'application/vnd.fujitsu.oasysprs'), ('application/vnd.fujixerox.ddd', 'application/vnd.fujixerox.ddd'), ('application/vnd.fujixerox.docuworks', 'application/vnd.fujixerox.docuworks'), ('application/vnd.fujixerox.docuworks.binder', 'application/vnd.fujixerox.docuworks.binder'), ('application/vnd.fuzzysheet', 'application/vnd.fuzzysheet'), ('application/vnd.genomatix.tuxedo', 'application/vnd.genomatix.tuxedo'), ('application/vnd.geogebra.file', 'application/vnd.geogebra.file'), ('application/vnd.geogebra.tool', 'application/vnd.geogebra.tool'), ('application/vnd.geometry-explorer', 'application/vnd.geometry-explorer'), ('application/vnd.geonext', 'application/vnd.geonext'), ('application/vnd.geoplan', 'application/vnd.geoplan'), ('application/vnd.geospace', 'application/vnd.geospace'), ('application/vnd.gmx', 'application/vnd.gmx'), ('application/vnd.google-earth.kml+xml', 'application/vnd.google-earth.kml+xml'), ('application/vnd.google-earth.kmz', 'application/vnd.google-earth.kmz'), ('application/vnd.grafeq', 'application/vnd.grafeq'), ('application/vnd.groove-account', 'application/vnd.groove-account'), ('application/vnd.groove-help', 'application/vnd.groove-help'), ('application/vnd.groove-identity-message', 'application/vnd.groove-identity-message'), ('application/vnd.groove-injector', 'application/vnd.groove-injector'), ('application/vnd.groove-tool-message', 'application/vnd.groove-tool-message'), ('application/vnd.groove-tool-template', 'application/vnd.groove-tool-template'), ('application/vnd.groove-vcard', 'application/vnd.groove-vcard'), ('application/vnd.hal+xml', 'application/vnd.hal+xml'), ('application/vnd.handheld-entertainment+xml', 'application/vnd.handheld-entertainment+xml'), ('application/vnd.hbci', 'application/vnd.hbci'), ('application/vnd.hhe.lesson-player', 'application/vnd.hhe.lesson-player'), ('application/vnd.hp-hpgl', 'application/vnd.hp-hpgl'), ('application/vnd.hp-hpid', 'application/vnd.hp-hpid'), ('application/vnd.hp-hps', 'application/vnd.hp-hps'), ('application/vnd.hp-jlyt', 'application/vnd.hp-jlyt'), ('application/vnd.hp-pcl', 'application/vnd.hp-pcl'), ('application/vnd.hp-pclxl', 'application/vnd.hp-pclxl'), ('application/vnd.hydrostatix.sof-data', 'application/vnd.hydrostatix.sof-data'), ('application/vnd.ibm.minipay', 'application/vnd.ibm.minipay'), ('application/vnd.ibm.modcap', 'application/vnd.ibm.modcap'), ('application/vnd.ibm.rights-management', 'application/vnd.ibm.rights-management'), ('application/vnd.ibm.secure-container', 'application/vnd.ibm.secure-container'), ('application/vnd.iccprofile', 'application/vnd.iccprofile'), ('application/vnd.igloader', 'application/vnd.igloader'), ('application/vnd.immervision-ivp', 'application/vnd.immervision-ivp'), ('application/vnd.immervision-ivu', 'application/vnd.immervision-ivu'), ('application/vnd.insors.igm', 'application/vnd.insors.igm'), ('application/vnd.intercon.formnet', 'application/vnd.intercon.formnet'), ('application/vnd.intergeo', 'application/vnd.intergeo'), ('application/vnd.intu.qbo', 'application/vnd.intu.qbo'), ('application/vnd.intu.qfx', 'application/vnd.intu.qfx'), ('application/vnd.ipunplugged.rcprofile', 'application/vnd.ipunplugged.rcprofile'), ('application/vnd.irepository.package+xml', 'application/vnd.irepository.package+xml'), ('application/vnd.is-xpr', 'application/vnd.is-xpr'), ('application/vnd.isac.fcs', 'application/vnd.isac.fcs'), ('application/vnd.jam', 'application/vnd.jam'), ('application/vnd.jcp.javame.midlet-rms', 'application/vnd.jcp.javame.midlet-rms'), ('application/vnd.jisp', 'application/vnd.jisp'), ('application/vnd.joost.joda-archive', 'application/vnd.joost.joda-archive'), ('application/vnd.kahootz', 'application/vnd.kahootz'), ('application/vnd.kde.karbon', 'application/vnd.kde.karbon'), ('application/vnd.kde.kchart', 'application/vnd.kde.kchart'), ('application/vnd.kde.kformula', 'application/vnd.kde.kformula'), ('application/vnd.kde.kivio', 'application/vnd.kde.kivio'), ('application/vnd.kde.kontour', 'application/vnd.kde.kontour'), ('application/vnd.kde.kpresenter', 'application/vnd.kde.kpresenter'), ('application/vnd.kde.kspread', 'application/vnd.kde.kspread'), ('application/vnd.kde.kword', 'application/vnd.kde.kword'), ('application/vnd.kenameaapp', 'application/vnd.kenameaapp'), ('application/vnd.kidspiration', 'application/vnd.kidspiration'), ('application/vnd.kinar', 'application/vnd.kinar'), ('application/vnd.koan', 'application/vnd.koan'), ('application/vnd.kodak-descriptor', 'application/vnd.kodak-descriptor'), ('application/vnd.las.las+xml', 'application/vnd.las.las+xml'), ('application/vnd.llamagraphics.life-balance.desktop', 'application/vnd.llamagraphics.life-balance.desktop'), ('application/vnd.llamagraphics.life-balance.exchange+xml', 'application/vnd.llamagraphics.life-balance.exchange+xml'), ('application/vnd.lotus-1-2-3', 'application/vnd.lotus-1-2-3'), ('application/vnd.lotus-approach', 'application/vnd.lotus-approach'), ('application/vnd.lotus-freelance', 'application/vnd.lotus-freelance'), ('application/vnd.lotus-notes', 'application/vnd.lotus-notes'), ('application/vnd.lotus-organizer', 'application/vnd.lotus-organizer'), ('application/vnd.lotus-screencam', 'application/vnd.lotus-screencam'), ('application/vnd.lotus-wordpro', 'application/vnd.lotus-wordpro'), ('application/vnd.macports.portpkg', 'application/vnd.macports.portpkg'), ('application/vnd.mcd', 'application/vnd.mcd'), ('application/vnd.medcalcdata', 'application/vnd.medcalcdata'), ('application/vnd.mediastation.cdkey', 'application/vnd.mediastation.cdkey'), ('application/vnd.mfer', 'application/vnd.mfer'), ('application/vnd.mfmp', 'application/vnd.mfmp'), ('application/vnd.micrografx.flo', 'application/vnd.micrografx.flo'), ('application/vnd.micrografx.igx', 'application/vnd.micrografx.igx'), ('application/vnd.mif', 'application/vnd.mif'), ('application/vnd.mobius.daf', 'application/vnd.mobius.daf'), ('application/vnd.mobius.dis', 'application/vnd.mobius.dis'), ('application/vnd.mobius.mbk', 'application/vnd.mobius.mbk'), ('application/vnd.mobius.mqy', 'application/vnd.mobius.mqy'), ('application/vnd.mobius.msl', 'application/vnd.mobius.msl'), ('application/vnd.mobius.plc', 'application/vnd.mobius.plc'), ('application/vnd.mobius.txf', 'application/vnd.mobius.txf'), ('application/vnd.mophun.application', 'application/vnd.mophun.application'), ('application/vnd.mophun.certificate', 'application/vnd.mophun.certificate'), ('application/vnd.mozilla.xul+xml', 'application/vnd.mozilla.xul+xml'), ('application/vnd.ms-artgalry', 'application/vnd.ms-artgalry'), ('application/vnd.ms-cab-compressed', 'application/vnd.ms-cab-compressed'), ('application/vnd.ms-excel', 'application/vnd.ms-excel'), ('application/vnd.ms-excel.addin.macroenabled.12', 'application/vnd.ms-excel.addin.macroenabled.12'), ('application/vnd.ms-excel.sheet.binary.macroenabled.12', 'application/vnd.ms-excel.sheet.binary.macroenabled.12'), ('application/vnd.ms-excel.sheet.macroenabled.12', 'application/vnd.ms-excel.sheet.macroenabled.12'), ('application/vnd.ms-excel.template.macroenabled.12', 'application/vnd.ms-excel.template.macroenabled.12'), ('application/vnd.ms-fontobject', 'application/vnd.ms-fontobject'), ('application/vnd.ms-htmlhelp', 'application/vnd.ms-htmlhelp'), ('application/vnd.ms-ims', 'application/vnd.ms-ims'), ('application/vnd.ms-lrm', 'application/vnd.ms-lrm'), ('application/vnd.ms-officetheme', 'application/vnd.ms-officetheme'), ('application/vnd.ms-pki.seccat', 'application/vnd.ms-pki.seccat'), ('application/vnd.ms-pki.stl', 'application/vnd.ms-pki.stl'), ('application/vnd.ms-powerpoint', 'application/vnd.ms-powerpoint'), ('application/vnd.ms-powerpoint.addin.macroenabled.12', 'application/vnd.ms-powerpoint.addin.macroenabled.12'), ('application/vnd.ms-powerpoint.presentation.macroenabled.12', 'application/vnd.ms-powerpoint.presentation.macroenabled.12'), ('application/vnd.ms-powerpoint.slide.macroenabled.12', 'application/vnd.ms-powerpoint.slide.macroenabled.12'), ('application/vnd.ms-powerpoint.slideshow.macroenabled.12', 'application/vnd.ms-powerpoint.slideshow.macroenabled.12'), ('application/vnd.ms-powerpoint.template.macroenabled.12', 'application/vnd.ms-powerpoint.template.macroenabled.12'), ('application/vnd.ms-project', 'application/vnd.ms-project'), ('application/vnd.ms-word.document.macroenabled.12', 'application/vnd.ms-word.document.macroenabled.12'), ('application/vnd.ms-word.template.macroenabled.12', 'application/vnd.ms-word.template.macroenabled.12'), ('application/vnd.ms-works', 'application/vnd.ms-works'), ('application/vnd.ms-wpl', 'application/vnd.ms-wpl'), ('application/vnd.ms-xpsdocument', 'application/vnd.ms-xpsdocument'), ('application/vnd.mseq', 'application/vnd.mseq'), ('application/vnd.musician', 'application/vnd.musician'), ('application/vnd.muvee.style', 'application/vnd.muvee.style'), ('application/vnd.mynfc', 'application/vnd.mynfc'), ('application/vnd.neurolanguage.nlu', 'application/vnd.neurolanguage.nlu'), ('application/vnd.nitf', 'application/vnd.nitf'), ('application/vnd.noblenet-directory', 'application/vnd.noblenet-directory'), ('application/vnd.noblenet-sealer', 'application/vnd.noblenet-sealer'), ('application/vnd.noblenet-web', 'application/vnd.noblenet-web'), ('application/vnd.nokia.n-gage.data', 'application/vnd.nokia.n-gage.data'), ('application/vnd.nokia.n-gage.symbian.install', 'application/vnd.nokia.n-gage.symbian.install'), ('application/vnd.nokia.radio-preset', 'application/vnd.nokia.radio-preset'), ('application/vnd.nokia.radio-presets', 'application/vnd.nokia.radio-presets'), ('application/vnd.novadigm.edm', 'application/vnd.novadigm.edm'), ('application/vnd.novadigm.edx', 'application/vnd.novadigm.edx'), ('application/vnd.novadigm.ext', 'application/vnd.novadigm.ext'), ('application/vnd.oasis.opendocument.chart', 'application/vnd.oasis.opendocument.chart'), ('application/vnd.oasis.opendocument.chart-template', 'application/vnd.oasis.opendocument.chart-template'), ('application/vnd.oasis.opendocument.database', 'application/vnd.oasis.opendocument.database'), ('application/vnd.oasis.opendocument.formula', 'application/vnd.oasis.opendocument.formula'), ('application/vnd.oasis.opendocument.formula-template', 'application/vnd.oasis.opendocument.formula-template'), ('application/vnd.oasis.opendocument.graphics', 'application/vnd.oasis.opendocument.graphics'), ('application/vnd.oasis.opendocument.graphics-template', 'application/vnd.oasis.opendocument.graphics-template'), ('application/vnd.oasis.opendocument.image', 'application/vnd.oasis.opendocument.image'), ('application/vnd.oasis.opendocument.image-template', 'application/vnd.oasis.opendocument.image-template'), ('application/vnd.oasis.opendocument.presentation', 'application/vnd.oasis.opendocument.presentation'), ('application/vnd.oasis.opendocument.presentation-template', 'application/vnd.oasis.opendocument.presentation-template'), ('application/vnd.oasis.opendocument.spreadsheet', 'application/vnd.oasis.opendocument.spreadsheet'), ('application/vnd.oasis.opendocument.spreadsheet-template', 'application/vnd.oasis.opendocument.spreadsheet-template'), ('application/vnd.oasis.opendocument.text', 'application/vnd.oasis.opendocument.text'), ('application/vnd.oasis.opendocument.text-master', 'application/vnd.oasis.opendocument.text-master'), ('application/vnd.oasis.opendocument.text-template', 'application/vnd.oasis.opendocument.text-template'), ('application/vnd.oasis.opendocument.text-web', 'application/vnd.oasis.opendocument.text-web'), ('application/vnd.olpc-sugar', 'application/vnd.olpc-sugar'), ('application/vnd.oma.dd2+xml', 'application/vnd.oma.dd2+xml'), ('application/vnd.openofficeorg.extension', 'application/vnd.openofficeorg.extension'), ('application/vnd.openxmlformats-officedocument.presentationml.presentation', 'application/vnd.openxmlformats-officedocument.presentationml.presentation'), ('application/vnd.openxmlformats-officedocument.presentationml.slide', 'application/vnd.openxmlformats-officedocument.presentationml.slide'), ('application/vnd.openxmlformats-officedocument.presentationml.slideshow', 'application/vnd.openxmlformats-officedocument.presentationml.slideshow'), ('application/vnd.openxmlformats-officedocument.presentationml.template', 'application/vnd.openxmlformats-officedocument.presentationml.template'), ('application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'), ('application/vnd.openxmlformats-officedocument.spreadsheetml.template', 'application/vnd.openxmlformats-officedocument.spreadsheetml.template'), ('application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'), ('application/vnd.openxmlformats-officedocument.wordprocessingml.template', 'application/vnd.openxmlformats-officedocument.wordprocessingml.template'), ('application/vnd.osgeo.mapguide.package', 'application/vnd.osgeo.mapguide.package'), ('application/vnd.osgi.dp', 'application/vnd.osgi.dp'), ('application/vnd.osgi.subsystem', 'application/vnd.osgi.subsystem'), ('application/vnd.palm', 'application/vnd.palm'), ('application/vnd.pawaafile', 'application/vnd.pawaafile'), ('application/vnd.pg.format', 'application/vnd.pg.format'), ('application/vnd.pg.osasli', 'application/vnd.pg.osasli'), ('application/vnd.picsel', 'application/vnd.picsel'), ('application/vnd.pmi.widget', 'application/vnd.pmi.widget'), ('application/vnd.pocketlearn', 'application/vnd.pocketlearn'), ('application/vnd.powerbuilder6', 'application/vnd.powerbuilder6'), ('application/vnd.previewsystems.box', 'application/vnd.previewsystems.box'), ('application/vnd.proteus.magazine', 'application/vnd.proteus.magazine'), ('application/vnd.publishare-delta-tree', 'application/vnd.publishare-delta-tree'), ('application/vnd.pvi.ptid1', 'application/vnd.pvi.ptid1'), ('application/vnd.quark.quarkxpress', 'application/vnd.quark.quarkxpress'), ('application/vnd.realvnc.bed', 'application/vnd.realvnc.bed'), ('application/vnd.recordare.musicxml', 'application/vnd.recordare.musicxml'), ('application/vnd.recordare.musicxml+xml', 'application/vnd.recordare.musicxml+xml'), ('application/vnd.rig.cryptonote', 'application/vnd.rig.cryptonote'), ('application/vnd.rim.cod', 'application/vnd.rim.cod'), ('application/vnd.rn-realmedia', 'application/vnd.rn-realmedia'), ('application/vnd.rn-realmedia-vbr', 'application/vnd.rn-realmedia-vbr'), ('application/vnd.route66.link66+xml', 'application/vnd.route66.link66+xml'), ('application/vnd.sailingtracker.track', 'application/vnd.sailingtracker.track'), ('application/vnd.seemail', 'application/vnd.seemail'), ('application/vnd.sema', 'application/vnd.sema'), ('application/vnd.semd', 'application/vnd.semd'), ('application/vnd.semf', 'application/vnd.semf'), ('application/vnd.shana.informed.formdata', 'application/vnd.shana.informed.formdata'), ('application/vnd.shana.informed.formtemplate', 'application/vnd.shana.informed.formtemplate'), ('application/vnd.shana.informed.interchange', 'application/vnd.shana.informed.interchange'), ('application/vnd.shana.informed.package', 'application/vnd.shana.informed.package'), ('application/vnd.simtech-mindmapper', 'application/vnd.simtech-mindmapper'), ('application/vnd.smaf', 'application/vnd.smaf'), ('application/vnd.smart.teacher', 'application/vnd.smart.teacher'), ('application/vnd.solent.sdkm+xml', 'application/vnd.solent.sdkm+xml'), ('application/vnd.spotfire.dxp', 'application/vnd.spotfire.dxp'), ('application/vnd.spotfire.sfs', 'application/vnd.spotfire.sfs'), ('application/vnd.stardivision.calc', 'application/vnd.stardivision.calc'), ('application/vnd.stardivision.draw', 'application/vnd.stardivision.draw'), ('application/vnd.stardivision.impress', 'application/vnd.stardivision.impress'), ('application/vnd.stardivision.math', 'application/vnd.stardivision.math'), ('application/vnd.stardivision.writer', 'application/vnd.stardivision.writer'), ('application/vnd.stardivision.writer-global', 'application/vnd.stardivision.writer-global'), ('application/vnd.stepmania.package', 'application/vnd.stepmania.package'), ('application/vnd.stepmania.stepchart', 'application/vnd.stepmania.stepchart'), ('application/vnd.sun.xml.calc', 'application/vnd.sun.xml.calc'), ('application/vnd.sun.xml.calc.template', 'application/vnd.sun.xml.calc.template'), ('application/vnd.sun.xml.draw', 'application/vnd.sun.xml.draw'), ('application/vnd.sun.xml.draw.template', 'application/vnd.sun.xml.draw.template'), ('application/vnd.sun.xml.impress', 'application/vnd.sun.xml.impress'), ('application/vnd.sun.xml.impress.template', 'application/vnd.sun.xml.impress.template'), ('application/vnd.sun.xml.math', 'application/vnd.sun.xml.math'), ('application/vnd.sun.xml.writer', 'application/vnd.sun.xml.writer'), ('application/vnd.sun.xml.writer.global', 'application/vnd.sun.xml.writer.global'), ('application/vnd.sun.xml.writer.template', 'application/vnd.sun.xml.writer.template'), ('application/vnd.sus-calendar', 'application/vnd.sus-calendar'), ('application/vnd.svd', 'application/vnd.svd'), ('application/vnd.symbian.install', 'application/vnd.symbian.install'), ('application/vnd.syncml+xml', 'application/vnd.syncml+xml'), ('application/vnd.syncml.dm+wbxml', 'application/vnd.syncml.dm+wbxml'), ('application/vnd.syncml.dm+xml', 'application/vnd.syncml.dm+xml'), ('application/vnd.tao.intent-module-archive', 'application/vnd.tao.intent-module-archive'), ('application/vnd.tcpdump.pcap', 'application/vnd.tcpdump.pcap'), ('application/vnd.tmobile-livetv', 'application/vnd.tmobile-livetv'), ('application/vnd.trid.tpt', 'application/vnd.trid.tpt'), ('application/vnd.triscape.mxs', 'application/vnd.triscape.mxs'), ('application/vnd.trueapp', 'application/vnd.trueapp'), ('application/vnd.ufdl', 'application/vnd.ufdl'), ('application/vnd.uiq.theme', 'application/vnd.uiq.theme'), ('application/vnd.umajin', 'application/vnd.umajin'), ('application/vnd.unity', 'application/vnd.unity'), ('application/vnd.uoml+xml', 'application/vnd.uoml+xml'), ('application/vnd.vcx', 'application/vnd.vcx'), ('application/vnd.visio', 'application/vnd.visio'), ('application/vnd.visionary', 'application/vnd.visionary'), ('application/vnd.vsf', 'application/vnd.vsf'), ('application/vnd.wap.wbxml', 'application/vnd.wap.wbxml'), ('application/vnd.wap.wmlc', 'application/vnd.wap.wmlc'), ('application/vnd.wap.wmlscriptc', 'application/vnd.wap.wmlscriptc'), ('application/vnd.webturbo', 'application/vnd.webturbo'), ('application/vnd.wolfram.player', 'application/vnd.wolfram.player'), ('application/vnd.wordperfect', 'application/vnd.wordperfect'), ('application/vnd.wqd', 'application/vnd.wqd'), ('application/vnd.wt.stf', 'application/vnd.wt.stf'), ('application/vnd.xara', 'application/vnd.xara'), ('application/vnd.xfdl', 'application/vnd.xfdl'), ('application/vnd.yamaha.hv-dic', 'application/vnd.yamaha.hv-dic'), ('application/vnd.yamaha.hv-script', 'application/vnd.yamaha.hv-script'), ('application/vnd.yamaha.hv-voice', 'application/vnd.yamaha.hv-voice'), ('application/vnd.yamaha.openscoreformat', 'application/vnd.yamaha.openscoreformat'), ('application/vnd.yamaha.openscoreformat.osfpvg+xml', 'application/vnd.yamaha.openscoreformat.osfpvg+xml'), ('application/vnd.yamaha.smaf-audio', 'application/vnd.yamaha.smaf-audio'), ('application/vnd.yamaha.smaf-phrase', 'application/vnd.yamaha.smaf-phrase'), ('application/vnd.yellowriver-custom-menu', 'application/vnd.yellowriver-custom-menu'), ('application/vnd.zul', 'application/vnd.zul'), ('application/vnd.zzazz.deck+xml', 'application/vnd.zzazz.deck+xml'), ('application/voicexml+xml', 'application/voicexml+xml'), ('application/widget', 'application/widget'), ('application/winhlp', 'application/winhlp'), ('application/wsdl+xml', 'application/wsdl+xml'), ('application/wspolicy+xml', 'application/wspolicy+xml'), ('application/x-7z-compressed', 'application/x-7z-compressed'), ('application/x-abiword', 'application/x-abiword'), ('application/x-ace-compressed', 'application/x-ace-compressed'), ('application/x-apple-diskimage', 'application/x-apple-diskimage'), ('application/x-authorware-bin', 'application/x-authorware-bin'), ('application/x-authorware-map', 'application/x-authorware-map'), ('application/x-authorware-seg', 'application/x-authorware-seg'), ('application/x-bcpio', 'application/x-bcpio'), ('application/x-bittorrent', 'application/x-bittorrent'), ('application/x-blorb', 'application/x-blorb'), ('application/x-bzip', 'application/x-bzip'), ('application/x-bzip2', 'application/x-bzip2'), ('application/x-cbr', 'application/x-cbr'), ('application/x-cdlink', 'application/x-cdlink'), ('application/x-cfs-compressed', 'application/x-cfs-compressed'), ('application/x-chat', 'application/x-chat'), ('application/x-chess-pgn', 'application/x-chess-pgn'), ('application/x-conference', 'application/x-conference'), ('application/x-cpio', 'application/x-cpio'), ('application/x-csh', 'application/x-csh'), ('application/x-debian-package', 'application/x-debian-package'), ('application/x-dgc-compressed', 'application/x-dgc-compressed'), ('application/x-director', 'application/x-director'), ('application/x-doom', 'application/x-doom'), ('application/x-dtbncx+xml', 'application/x-dtbncx+xml'), ('application/x-dtbook+xml', 'application/x-dtbook+xml'), ('application/x-dtbresource+xml', 'application/x-dtbresource+xml'), ('application/x-dvi', 'application/x-dvi'), ('application/x-envoy', 'application/x-envoy'), ('application/x-eva', 'application/x-eva'), ('application/x-font-bdf', 'application/x-font-bdf'), ('application/x-font-ghostscript', 'application/x-font-ghostscript'), ('application/x-font-linux-psf', 'application/x-font-linux-psf'), ('application/x-font-pcf', 'application/x-font-pcf'), ('application/x-font-snf', 'application/x-font-snf'), ('application/x-font-type1', 'application/x-font-type1'), ('application/x-freearc', 'application/x-freearc'), ('application/x-futuresplash', 'application/x-futuresplash'), ('application/x-gca-compressed', 'application/x-gca-compressed'), ('application/x-glulx', 'application/x-glulx'), ('application/x-gnumeric', 'application/x-gnumeric'), ('application/x-gramps-xml', 'application/x-gramps-xml'), ('application/x-gtar', 'application/x-gtar'), ('application/x-hdf', 'application/x-hdf'), ('application/x-install-instructions', 'application/x-install-instructions'), ('application/x-iso9660-image', 'application/x-iso9660-image'), ('application/x-java-jnlp-file', 'application/x-java-jnlp-file'), ('application/x-latex', 'application/x-latex'), ('application/x-lzh-compressed', 'application/x-lzh-compressed'), ('application/x-mie', 'application/x-mie'), ('application/x-mobipocket-ebook', 'application/x-mobipocket-ebook'), ('application/x-mpegurl', 'application/x-mpegurl'), ('application/x-ms-application', 'application/x-ms-application'), ('application/x-ms-shortcut', 'application/x-ms-shortcut'), ('application/x-ms-wmd', 'application/x-ms-wmd'), ('application/x-ms-xbap', 'application/x-ms-xbap'), ('application/x-msaccess', 'application/x-msaccess'), ('application/x-msbinder', 'application/x-msbinder'), ('application/x-mscardfile', 'application/x-mscardfile'), ('application/x-msclip', 'application/x-msclip'), ('application/x-msdownload', 'application/x-msdownload'), ('application/x-msmediaview', 'application/x-msmediaview'), ('application/x-msmetafile', 'application/x-msmetafile'), ('application/x-msmoney', 'application/x-msmoney'), ('application/x-mspublisher', 'application/x-mspublisher'), ('application/x-msschedule', 'application/x-msschedule'), ('application/x-msterminal', 'application/x-msterminal'), ('application/x-mswrite', 'application/x-mswrite'), ('application/x-netcdf', 'application/x-netcdf'), ('application/x-nzb', 'application/x-nzb'), ('application/x-pkcs12', 'application/x-pkcs12'), ('application/x-pkcs7-certificates', 'application/x-pkcs7-certificates'), ('application/x-pkcs7-certreqresp', 'application/x-pkcs7-certreqresp'), ('application/x-python-code', 'application/x-python-code'), ('application/x-rar-compressed', 'application/x-rar-compressed'), ('application/x-research-info-systems', 'application/x-research-info-systems'), ('application/x-sh', 'application/x-sh'), ('application/x-shar', 'application/x-shar'), ('application/x-shockwave-flash', 'application/x-shockwave-flash'), ('application/x-silverlight-app', 'application/x-silverlight-app'), ('application/x-sql', 'application/x-sql'), ('application/x-stuffit', 'application/x-stuffit'), ('application/x-stuffitx', 'application/x-stuffitx'), ('application/x-subrip', 'application/x-subrip'), ('application/x-sv4cpio', 'application/x-sv4cpio'), ('application/x-sv4crc', 'application/x-sv4crc'), ('application/x-t3vm-image', 'application/x-t3vm-image'), ('application/x-tads', 'application/x-tads'), ('application/x-tar', 'application/x-tar'), ('application/x-tcl', 'application/x-tcl'), ('application/x-tex', 'application/x-tex'), ('application/x-tex-tfm', 'application/x-tex-tfm'), ('application/x-texinfo', 'application/x-texinfo'), ('application/x-tgif', 'application/x-tgif'), ('application/x-ustar', 'application/x-ustar'), ('application/x-wais-source', 'application/x-wais-source'), ('application/x-x509-ca-cert', 'application/x-x509-ca-cert'), ('application/x-xfig', 'application/x-xfig'), ('application/x-xliff+xml', 'application/x-xliff+xml'), ('application/x-xpinstall', 'application/x-xpinstall'), ('application/x-xz', 'application/x-xz'), ('application/x-zmachine', 'application/x-zmachine'), ('application/xaml+xml', 'application/xaml+xml'), ('application/xcap-diff+xml', 'application/xcap-diff+xml'), ('application/xenc+xml', 'application/xenc+xml'), ('application/xhtml+xml', 'application/xhtml+xml'), ('application/xml', 'application/xml'), ('application/xml-dtd', 'application/xml-dtd'), ('application/xop+xml', 'application/xop+xml'), ('application/xproc+xml', 'application/xproc+xml'), ('application/xslt+xml', 'application/xslt+xml'), ('application/xspf+xml', 'application/xspf+xml'), ('application/xv+xml', 'application/xv+xml'), ('application/yang', 'application/yang'), ('application/yin+xml', 'application/yin+xml'), ('application/zip', 'application/zip'), ('audio/adpcm', 'audio/adpcm'), ('audio/basic', 'audio/basic'), ('audio/midi', 'audio/midi'), ('audio/mp4', 'audio/mp4'), ('audio/mp4a-latm', 'audio/mp4a-latm'), ('audio/mpeg', 'audio/mpeg'), ('audio/ogg', 'audio/ogg'), ('audio/s3m', 'audio/s3m'), ('audio/silk', 'audio/silk'), ('audio/vnd.dece.audio', 'audio/vnd.dece.audio'), ('audio/vnd.digital-winds', 'audio/vnd.digital-winds'), ('audio/vnd.dra', 'audio/vnd.dra'), ('audio/vnd.dts', 'audio/vnd.dts'), ('audio/vnd.dts.hd', 'audio/vnd.dts.hd'), ('audio/vnd.lucent.voice', 'audio/vnd.lucent.voice'), ('audio/vnd.ms-playready.media.pya', 'audio/vnd.ms-playready.media.pya'), ('audio/vnd.nuera.ecelp4800', 'audio/vnd.nuera.ecelp4800'), ('audio/vnd.nuera.ecelp7470', 'audio/vnd.nuera.ecelp7470'), ('audio/vnd.nuera.ecelp9600', 'audio/vnd.nuera.ecelp9600'), ('audio/vnd.rip', 'audio/vnd.rip'), ('audio/webm', 'audio/webm'), ('audio/x-aac', 'audio/x-aac'), ('audio/x-aiff', 'audio/x-aiff'), ('audio/x-caf', 'audio/x-caf'), ('audio/x-flac', 'audio/x-flac'), ('audio/x-matroska', 'audio/x-matroska'), ('audio/x-mpegurl', 'audio/x-mpegurl'), ('audio/x-ms-wax', 'audio/x-ms-wax'), ('audio/x-ms-wma', 'audio/x-ms-wma'), ('audio/x-pn-realaudio', 'audio/x-pn-realaudio'), ('audio/x-pn-realaudio-plugin', 'audio/x-pn-realaudio-plugin'), ('audio/x-wav', 'audio/x-wav'), ('audio/xm', 'audio/xm'), ('chemical/x-cdx', 'chemical/x-cdx'), ('chemical/x-cif', 'chemical/x-cif'), ('chemical/x-cmdf', 'chemical/x-cmdf'), ('chemical/x-cml', 'chemical/x-cml'), ('chemical/x-csml', 'chemical/x-csml'), ('chemical/x-xyz', 'chemical/x-xyz'), ('font/collection', 'font/collection'), ('font/otf', 'font/otf'), ('font/ttf', 'font/ttf'), ('font/woff', 'font/woff'), ('font/woff2', 'font/woff2'), ('image/bmp', 'image/bmp'), ('image/cgm', 'image/cgm'), ('image/g3fax', 'image/g3fax'), ('image/gif', 'image/gif'), ('image/ief', 'image/ief'), ('image/jp2', 'image/jp2'), ('image/jpeg', 'image/jpeg'), ('image/ktx', 'image/ktx'), ('image/pict', 'image/pict'), ('image/png', 'image/png'), ('image/prs.btif', 'image/prs.btif'), ('image/sgi', 'image/sgi'), ('image/svg+xml', 'image/svg+xml'), ('image/tiff', 'image/tiff'), ('image/vnd.adobe.photoshop', 'image/vnd.adobe.photoshop'), ('image/vnd.dece.graphic', 'image/vnd.dece.graphic'), ('image/vnd.djvu', 'image/vnd.djvu'), ('image/vnd.dwg', 'image/vnd.dwg'), ('image/vnd.dxf', 'image/vnd.dxf'), ('image/vnd.fastbidsheet', 'image/vnd.fastbidsheet'), ('image/vnd.fpx', 'image/vnd.fpx'), ('image/vnd.fst', 'image/vnd.fst'), ('image/vnd.fujixerox.edmics-mmr', 'image/vnd.fujixerox.edmics-mmr'), ('image/vnd.fujixerox.edmics-rlc', 'image/vnd.fujixerox.edmics-rlc'), ('image/vnd.ms-modi', 'image/vnd.ms-modi'), ('image/vnd.ms-photo', 'image/vnd.ms-photo'), ('image/vnd.net-fpx', 'image/vnd.net-fpx'), ('image/vnd.wap.wbmp', 'image/vnd.wap.wbmp'), ('image/vnd.xiff', 'image/vnd.xiff'), ('image/webp', 'image/webp'), ('image/x-3ds', 'image/x-3ds'), ('image/x-cmu-raster', 'image/x-cmu-raster'), ('image/x-cmx', 'image/x-cmx'), ('image/x-freehand', 'image/x-freehand'), ('image/x-icon', 'image/x-icon'), ('image/x-macpaint', 'image/x-macpaint'), ('image/x-mrsid-image', 'image/x-mrsid-image'), ('image/x-pcx', 'image/x-pcx'), ('image/x-pict', 'image/x-pict'), ('image/x-portable-anymap', 'image/x-portable-anymap'), ('image/x-portable-bitmap', 'image/x-portable-bitmap'), ('image/x-portable-graymap', 'image/x-portable-graymap'), ('image/x-portable-pixmap', 'image/x-portable-pixmap'), ('image/x-quicktime', 'image/x-quicktime'), ('image/x-rgb', 'image/x-rgb'), ('image/x-tga', 'image/x-tga'), ('image/x-xbitmap', 'image/x-xbitmap'), ('image/x-xpixmap', 'image/x-xpixmap'), ('image/x-xwindowdump', 'image/x-xwindowdump'), ('message/rfc822', 'message/rfc822'), ('model/iges', 'model/iges'), ('model/mesh', 'model/mesh'), ('model/vnd.collada+xml', 'model/vnd.collada+xml'), ('model/vnd.dwf', 'model/vnd.dwf'), ('model/vnd.gdl', 'model/vnd.gdl'), ('model/vnd.gtw', 'model/vnd.gtw'), ('model/vnd.mts', 'model/vnd.mts'), ('model/vnd.vtu', 'model/vnd.vtu'), ('model/vrml', 'model/vrml'), ('model/x3d+binary', 'model/x3d+binary'), ('model/x3d+vrml', 'model/x3d+vrml'), ('model/x3d+xml', 'model/x3d+xml'), ('text/cache-manifest', 'text/cache-manifest'), ('text/calendar', 'text/calendar'), ('text/css', 'text/css'), ('text/csv', 'text/csv'), ('text/html', 'text/html'), ('text/n3', 'text/n3'), ('text/plain', 'text/plain'), ('text/prs.lines.tag', 'text/prs.lines.tag'), ('text/richtext', 'text/richtext'), ('text/sgml', 'text/sgml'), ('text/tab-separated-values', 'text/tab-separated-values'), ('text/troff', 'text/troff'), ('text/turtle', 'text/turtle'), ('text/uri-list', 'text/uri-list'), ('text/vcard', 'text/vcard'), ('text/vnd.curl', 'text/vnd.curl'), ('text/vnd.curl.dcurl', 'text/vnd.curl.dcurl'), ('text/vnd.curl.mcurl', 'text/vnd.curl.mcurl'), ('text/vnd.curl.scurl', 'text/vnd.curl.scurl'), ('text/vnd.dvb.subtitle', 'text/vnd.dvb.subtitle'), ('text/vnd.fly', 'text/vnd.fly'), ('text/vnd.fmi.flexstor', 'text/vnd.fmi.flexstor'), ('text/vnd.graphviz', 'text/vnd.graphviz'), ('text/vnd.in3d.3dml', 'text/vnd.in3d.3dml'), ('text/vnd.in3d.spot', 'text/vnd.in3d.spot'), ('text/vnd.sun.j2me.app-descriptor', 'text/vnd.sun.j2me.app-descriptor'), ('text/vnd.wap.wml', 'text/vnd.wap.wml'), ('text/vnd.wap.wmlscript', 'text/vnd.wap.wmlscript'), ('text/x-asm', 'text/x-asm'), ('text/x-c', 'text/x-c'), ('text/x-fortran', 'text/x-fortran'), ('text/x-java-source', 'text/x-java-source'), ('text/x-nfo', 'text/x-nfo'), ('text/x-opml', 'text/x-opml'), ('text/x-pascal', 'text/x-pascal'), ('text/x-python', 'text/x-python'), ('text/x-setext', 'text/x-setext'), ('text/x-sfv', 'text/x-sfv'), ('text/x-uuencode', 'text/x-uuencode'), ('text/x-vcalendar', 'text/x-vcalendar'), ('text/x-vcard', 'text/x-vcard'), ('video/3gpp', 'video/3gpp'), ('video/3gpp2', 'video/3gpp2'), ('video/h261', 'video/h261'), ('video/h263', 'video/h263'), ('video/h264', 'video/h264'), ('video/jpeg', 'video/jpeg'), ('video/jpm', 'video/jpm'), ('video/mj2', 'video/mj2'), ('video/mp2t', 'video/mp2t'), ('video/mp4', 'video/mp4'), ('video/mpeg', 'video/mpeg'), ('video/ogg', 'video/ogg'), ('video/quicktime', 'video/quicktime'), ('video/vnd.dece.hd', 'video/vnd.dece.hd'), ('video/vnd.dece.mobile', 'video/vnd.dece.mobile'), ('video/vnd.dece.pd', 'video/vnd.dece.pd'), ('video/vnd.dece.sd', 'video/vnd.dece.sd'), ('video/vnd.dece.video', 'video/vnd.dece.video'), ('video/vnd.dvb.file', 'video/vnd.dvb.file'), ('video/vnd.fvt', 'video/vnd.fvt'), ('video/vnd.mpegurl', 'video/vnd.mpegurl'), ('video/vnd.ms-playready.media.pyv', 'video/vnd.ms-playready.media.pyv'), ('video/vnd.uvvu.mp4', 'video/vnd.uvvu.mp4'), ('video/vnd.vivo', 'video/vnd.vivo'), ('video/webm', 'video/webm'), ('video/x-dv', 'video/x-dv'), ('video/x-f4v', 'video/x-f4v'), ('video/x-fli', 'video/x-fli'), ('video/x-flv', 'video/x-flv'), ('video/x-m4v', 'video/x-m4v'), ('video/x-matroska', 'video/x-matroska'), ('video/x-mng', 'video/x-mng'), ('video/x-ms-asf', 'video/x-ms-asf'), ('video/x-ms-vob', 'video/x-ms-vob'), ('video/x-ms-wm', 'video/x-ms-wm'), ('video/x-ms-wmv', 'video/x-ms-wmv'), ('video/x-ms-wmx', 'video/x-ms-wmx'), ('video/x-ms-wvx', 'video/x-ms-wvx'), ('video/x-msvideo', 'video/x-msvideo'), ('video/x-sgi-movie', 'video/x-sgi-movie'), ('video/x-smv', 'video/x-smv'), ('x-conference/x-cooltalk', 'x-conference/x-cooltalk')], db_column='media_type', help_text='MIME types associated with item type', max_length=128, unique=True, verbose_name='media type')),
                ('media_info_schema', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='media_info_schema', default=irekua_database.utils.simple_JSON_schema, help_text='JSON Schema for item type media info', validators=[irekua_database.utils.validate_JSON_schema], verbose_name='media info schema')),
            ],
            options={
                'verbose_name': 'Mime Type',
                'verbose_name_plural': 'Mime Types',
                'ordering': ['mime_type'],
            },
        ),
        migrations.CreateModel(
            name='SamplingEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('commentaries', models.TextField(blank=True, db_column='commentaries', help_text='Sampling event commentaries', verbose_name='commentaries')),
                ('metadata', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata', default=irekua_database.utils.empty_JSON, help_text='Metadata associated to sampling event', null=True, verbose_name='metadata')),
                ('started_on', models.DateTimeField(blank=True, db_column='started_on', help_text='Date at which sampling begun', null=True, verbose_name='started on')),
                ('ended_on', models.DateTimeField(blank=True, db_column='ended_on', help_text='Date at which sampling stoped', null=True, verbose_name='ended on')),
                ('collection', models.ForeignKey(db_column='collection_id', help_text='Collection to which sampling event belongs', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.Collection', verbose_name='collection')),
                ('collection_site', models.ForeignKey(blank=True, db_column='collection_site_id', help_text='Reference to site at which sampling took place', null=True, on_delete=django.db.models.deletion.PROTECT, to='irekua_database.CollectionSite', verbose_name='collection site')),
                ('created_by', models.ForeignKey(blank=True, db_column='creator_id', help_text='Creator of object', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='samplingevent_created_by', to=settings.AUTH_USER_MODEL, verbose_name='creator')),
                ('licence', models.ForeignKey(blank=True, db_column='licence_id', help_text='Licence for all items in sampling event', null=True, on_delete=django.db.models.deletion.PROTECT, to='irekua_database.Licence', verbose_name='licence')),
                ('modified_by', models.ForeignKey(blank=True, db_column='modified_by', editable=False, help_text='User who made modifications last', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='samplingevent_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='modified by')),
            ],
            options={
                'verbose_name': 'Sampling Event',
                'verbose_name_plural': 'Sampling Events',
                'ordering': ['-created_on'],
            },
        ),
        migrations.CreateModel(
            name='SamplingEventType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('name', models.CharField(db_column='name', help_text='Name fo sampling event type', max_length=128, unique=True, verbose_name='name')),
                ('description', models.TextField(blank=True, db_column='description', help_text='Description of sampling event type', verbose_name='description')),
                ('icon', models.ImageField(blank=True, db_column='icon', help_text='Icon for sampling event type', null=True, upload_to='images/sampling_event_types/', verbose_name='icon')),
                ('metadata_schema', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata_schema', default=irekua_database.utils.simple_JSON_schema, help_text='JSON Schema for metadata of sampling event info', validators=[irekua_database.utils.validate_JSON_schema], verbose_name='metadata schema')),
                ('restrict_device_types', models.BooleanField(db_column='restrict_device_types', default=False, help_text='Flag indicating whether to restrict device types associated with this sampling event type', verbose_name='restrict device types')),
                ('restrict_site_types', models.BooleanField(db_column='restrict_site_types', default=False, help_text='Flag indicating whether to restrict site types associated with this sampling event type', verbose_name='restrict site types')),
            ],
            options={
                'verbose_name': 'Sampling Event Type',
                'verbose_name_plural': 'Sampling Event Types',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='SiteDescriptorType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('name', models.CharField(db_column='name', help_text='Name for site descriptor type', max_length=128, unique=True, verbose_name='name')),
                ('description', models.TextField(db_column='description', help_text='Description of site descriptor type', verbose_name='description')),
                ('icon', models.ImageField(blank=True, db_column='icon', help_text='Site descriptor type icon', null=True, upload_to='images/site_descriptor_types/', verbose_name='icon')),
                ('metadata', models.TextField(blank=True, db_column='metadata', help_text='Metadata of site descriptor type', verbose_name='metadata')),
                ('source', models.URLField(blank=True, db_column='url', help_text='Source of information for site descriptor type', verbose_name='source')),
                ('metadata_schema', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata_schema', default=irekua_database.utils.simple_JSON_schema, help_text='JSON Schema for metadata of descriptors of this type', null=True, validators=[irekua_database.utils.validate_JSON_schema], verbose_name='metadata_schema')),
            ],
            options={
                'verbose_name': 'Site Descriptor Type',
                'verbose_name_plural': 'Site Descriptor Types',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('name', models.CharField(db_column='name', help_text='Name of tag', max_length=128, unique=True, verbose_name='name')),
                ('description', models.TextField(blank=True, db_column='description', help_text='Tag description', verbose_name='description')),
                ('icon', models.ImageField(blank=True, db_column='icon', help_text='Icon for tag', null=True, upload_to='images/tags/', verbose_name='icon')),
            ],
            options={
                'verbose_name': 'Tag',
                'verbose_name_plural': 'Tags',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='TermType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('name', models.CharField(db_column='name', help_text='Name for term type', max_length=128, unique=True, verbose_name='name')),
                ('description', models.TextField(db_column='description', help_text='Description of term type', verbose_name='description')),
                ('icon', models.ImageField(blank=True, db_column='icon', help_text='Term type icon', null=True, upload_to='images/term_types/', verbose_name='icon')),
                ('is_categorical', models.BooleanField(db_column='is_categorical', help_text='Flag indicating whether the term type represents a categorical variable', verbose_name='is categorical')),
                ('metadata_schema', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata_schema', default=irekua_database.utils.simple_JSON_schema, help_text='JSON Schema for metadata of term info', validators=[irekua_database.utils.validate_JSON_schema], verbose_name='metadata schema')),
                ('synonym_metadata_schema', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='synonym_metadata_schema', default=irekua_database.utils.simple_JSON_schema, help_text='JSON Schema for metadata of synonym info', validators=[irekua_database.utils.validate_JSON_schema], verbose_name='synonym metadata schema')),
            ],
            options={
                'verbose_name': 'Term Type',
                'verbose_name_plural': 'Term Types',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Visualizer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('name', models.CharField(db_column='name', help_text='Name of visualizer app', max_length=64, verbose_name='name')),
                ('version', models.CharField(db_column='version', help_text='Version of visualizer app', max_length=16, verbose_name='version')),
                ('website', models.URLField(blank=True, db_column='website', help_text='Link to visualizer website', verbose_name='website')),
                ('configuration_schema', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='configuration_schema', default=irekua_database.utils.simple_JSON_schema, help_text='JSON schema for annotation tool configuration info', validators=[irekua_database.utils.validate_JSON_schema], verbose_name='configuration schema')),
            ],
            options={
                'verbose_name': 'Visualizer',
                'verbose_name_plural': 'Visualizers',
                'ordering': ['-created_on'],
                'unique_together': {('name', 'version')},
            },
        ),
        migrations.CreateModel(
            name='TermSuggestion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('value', models.CharField(db_column='value', help_text='Value of term', max_length=128, verbose_name='value')),
                ('description', models.TextField(blank=True, db_column='description', help_text='Description of term', verbose_name='description')),
                ('metadata', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata', default=irekua_database.utils.empty_JSON, help_text='Metadata associated to term', null=True, verbose_name='metadata')),
                ('created_by', models.ForeignKey(blank=True, db_column='creator_id', help_text='Creator of object', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='termsuggestion_created_by', to=settings.AUTH_USER_MODEL, verbose_name='creator')),
                ('modified_by', models.ForeignKey(blank=True, db_column='modified_by', editable=False, help_text='User who made modifications last', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='termsuggestion_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='modified by')),
                ('term_type', models.ForeignKey(db_column='term_type', help_text='Type of term', on_delete=django.db.models.deletion.CASCADE, to='irekua_database.TermType', verbose_name='term type')),
            ],
            options={
                'verbose_name': 'Term Suggestions',
                'ordering': ['-created_on'],
            },
        ),
        migrations.CreateModel(
            name='Term',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('value', models.CharField(db_column='value', help_text='Value of term', max_length=128, verbose_name='value')),
                ('scope', models.CharField(blank=True, db_column='scope', help_text='Scope of term. Use for disambiguation.', max_length=128, verbose_name='scope')),
                ('description', models.TextField(blank=True, db_column='description', help_text='Description of term', verbose_name='description')),
                ('url', models.URLField(blank=True, db_column='url', help_text='URL for term description', verbose_name='term url')),
                ('metadata', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata', default=irekua_database.utils.empty_JSON, help_text='Metadata associated to term', null=True, verbose_name='metadata')),
                ('term_type', models.ForeignKey(db_column='term_type', help_text='Type of term', limit_choices_to={'is_categorical': True}, on_delete=django.db.models.deletion.CASCADE, to='irekua_database.TermType', verbose_name='term type')),
            ],
            options={
                'verbose_name': 'Term',
                'verbose_name_plural': 'Terms',
                'ordering': ['term_type', 'value'],
                'unique_together': {('term_type', 'value', 'scope')},
            },
        ),
        migrations.CreateModel(
            name='SynonymSuggestion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('synonym', models.CharField(db_column='synonym', help_text='Suggestion of synonym', max_length=128, verbose_name='synonym')),
                ('description', models.TextField(blank=True, db_column='description', help_text='Description of synonym', verbose_name='description')),
                ('metadata', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata', default=irekua_database.utils.empty_JSON, help_text='Metadata associated to synonym', null=True, verbose_name='metadata')),
                ('created_by', models.ForeignKey(blank=True, db_column='creator_id', help_text='Creator of object', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='synonymsuggestion_created_by', to=settings.AUTH_USER_MODEL, verbose_name='creator')),
                ('modified_by', models.ForeignKey(blank=True, db_column='modified_by', editable=False, help_text='User who made modifications last', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='synonymsuggestion_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='modified by')),
                ('source', models.ForeignKey(db_column='source_id', on_delete=django.db.models.deletion.CASCADE, to='irekua_database.Term', verbose_name='')),
            ],
            options={
                'verbose_name': 'Synonym Suggestions',
                'ordering': ['-created_on'],
            },
        ),
        migrations.CreateModel(
            name='Synonym',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('metadata', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata', default=irekua_database.utils.empty_JSON, help_text='Metadata associated to the synonym', null=True, verbose_name='metadata')),
                ('source', models.ForeignKey(db_column='source_id', help_text='Reference to the source of synonym', on_delete=django.db.models.deletion.CASCADE, related_name='synonym_source', to='irekua_database.Term', verbose_name='source')),
                ('target', models.ForeignKey(db_column='target_id', help_text='Reference to the target of the synonym', on_delete=django.db.models.deletion.CASCADE, related_name='synonym_target', to='irekua_database.Term', verbose_name='target')),
            ],
            options={
                'verbose_name': 'Synonym',
                'verbose_name_plural': 'Synonyms',
                'ordering': ['source'],
            },
        ),
        migrations.CreateModel(
            name='Source',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('directory', models.CharField(db_column='directory', help_text='Directory containing all files in source', max_length=64, unique=True, verbose_name='directory')),
                ('source_file', models.CharField(db_column='source_file', help_text='File containing metadata for files in source directory', max_length=64, verbose_name='source file')),
                ('parse_function', models.CharField(db_column='parse_function', help_text='Parse function used to insert files and metadata to database', max_length=64, verbose_name='parse function')),
                ('uploader', models.ForeignKey(db_column='uploader_id', help_text='Reference to user who uploaded files in source', on_delete=django.db.models.deletion.PROTECT, related_name='source_uploader', to=settings.AUTH_USER_MODEL, verbose_name='uploader id')),
            ],
            options={
                'verbose_name': 'Source',
                'verbose_name_plural': 'Sources',
            },
        ),
        migrations.CreateModel(
            name='SiteType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('name', models.CharField(db_column='name', help_text='Name of site type', max_length=128, unique=True, verbose_name='name')),
                ('description', models.TextField(db_column='description', help_text='Description of site type', verbose_name='description')),
                ('metadata_schema', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata_schema', default=irekua_database.utils.simple_JSON_schema, help_text='JSON Schema for metadata of site info', validators=[irekua_database.utils.validate_JSON_schema], verbose_name='metadata schema')),
                ('site_descriptor_types', models.ManyToManyField(blank=True, to='irekua_database.SiteDescriptorType')),
            ],
            options={
                'verbose_name': 'Site Type',
                'verbose_name_plural': 'Site Types',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='SiteDescriptor',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('value', models.CharField(db_column='value', help_text='Value of descriptor', max_length=128, verbose_name='value')),
                ('description', models.TextField(blank=True, db_column='description', help_text='Description of term', verbose_name='description')),
                ('metadata', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata', default=irekua_database.utils.empty_JSON, help_text='Metadata associated to term', null=True, verbose_name='metadata')),
                ('descriptor_type', models.ForeignKey(db_column='descriptor_type', help_text='Type of site descriptor', on_delete=django.db.models.deletion.CASCADE, to='irekua_database.SiteDescriptorType', verbose_name='descriptor type')),
            ],
            options={
                'verbose_name': 'Site Descriptor',
                'verbose_name_plural': 'Site Descriptors',
                'ordering': ['descriptor_type', 'value'],
                'unique_together': {('descriptor_type', 'value')},
            },
        ),
        migrations.CreateModel(
            name='Site',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('name', models.CharField(blank=True, db_column='name', help_text='Name of site (visible only to owner)', max_length=128, null=True, verbose_name='name')),
                ('geo_ref', django.contrib.gis.db.models.fields.PointField(blank=True, db_column='geo_ref', help_text='Georeference of site as Geometry', srid=4326, verbose_name='geo ref')),
                ('latitude', models.FloatField(blank=True, db_column='latitude', help_text='Latitude of site (in decimal degrees)', validators=[django.core.validators.MinValueValidator(-90), django.core.validators.MaxValueValidator(90)], verbose_name='latitude')),
                ('longitude', models.FloatField(blank=True, db_column='longitude', help_text='Longitude of site (in decimal degrees)', validators=[django.core.validators.MinValueValidator(-180), django.core.validators.MaxValueValidator(180)], verbose_name='longitude')),
                ('altitude', models.FloatField(blank=True, db_column='altitude', help_text='Altitude of site (in meters)', null=True, verbose_name='altitude')),
                ('created_by', models.ForeignKey(blank=True, db_column='creator_id', help_text='Creator of object', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='site_created_by', to=settings.AUTH_USER_MODEL, verbose_name='creator')),
                ('locality', models.ForeignKey(blank=True, db_column='locality_id', help_text='Name of locality in which the site is located', null=True, on_delete=django.db.models.deletion.PROTECT, to='irekua_database.Locality', verbose_name='locality')),
                ('modified_by', models.ForeignKey(blank=True, db_column='modified_by', editable=False, help_text='User who made modifications last', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='site_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='modified by')),
            ],
            options={
                'verbose_name': 'Site',
                'verbose_name_plural': 'Sites',
                'ordering': ['-created_on'],
            },
        ),
        migrations.CreateModel(
            name='SecondaryItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('hash', models.CharField(db_column='hash', help_text='Hash of secondary resource file', max_length=64, unique=True, verbose_name='hash')),
                ('item_file', models.FileField(blank=True, db_column='item_file', help_text='Upload file associated to file', null=True, upload_to=irekua_database.models.items.secondary_items.get_item_path, verbose_name='item file')),
                ('media_info', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='media_info', default=irekua_database.utils.empty_JSON, help_text='Media information of secondary item file', null=True, verbose_name='media info')),
                ('item', models.ForeignKey(db_column='item_id', help_text='Reference to primary item associated to secondary item', on_delete=django.db.models.deletion.CASCADE, to='irekua_database.Item', verbose_name='item id')),
                ('item_type', models.ForeignKey(db_column='item_type', help_text='Type of file of secondary item', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.ItemType', verbose_name='item type')),
            ],
            options={
                'verbose_name': 'Secondary Item',
                'verbose_name_plural': 'Secondary Items',
                'ordering': ['created_on'],
            },
        ),
        migrations.CreateModel(
            name='SamplingEventTypeDeviceType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('metadata_schema', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata_schema', default=irekua_database.utils.simple_JSON_schema, help_text='JSON schema for metadata associated to device in sampling event', validators=[irekua_database.utils.validate_JSON_schema], verbose_name='metadata schema')),
                ('device_type', models.ForeignKey(db_column='device_type_id', help_text='Type of device that can be used in sampling event of the given type', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.DeviceType', verbose_name='device type')),
                ('sampling_event_type', models.ForeignKey(db_column='sampling_event_type_id', help_text='Sampling event type in which this device types can be placed', on_delete=django.db.models.deletion.CASCADE, to='irekua_database.SamplingEventType', verbose_name='sampling event type')),
            ],
            options={
                'verbose_name': 'Sampling Event Type Device Type',
                'verbose_name_plural': 'Sampling Event Type Device Types',
                'ordering': ['sampling_event_type'],
                'unique_together': {('sampling_event_type', 'device_type')},
            },
        ),
        migrations.AddField(
            model_name='samplingeventtype',
            name='device_types',
            field=models.ManyToManyField(blank=True, help_text='Valid device types for this sampling event type', through='irekua_database.SamplingEventTypeDeviceType', to='irekua_database.DeviceType', verbose_name='device types'),
        ),
        migrations.AddField(
            model_name='samplingeventtype',
            name='site_types',
            field=models.ManyToManyField(blank=True, help_text='Valid site types for this sampling event type', to='irekua_database.SiteType', verbose_name='site types'),
        ),
        migrations.CreateModel(
            name='SamplingEventDevice',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('deployed_on', models.DateTimeField(blank=True, db_column='deployed_on', help_text='Date at which the device started capturing information.', null=True, verbose_name='deployed on')),
                ('recovered_on', models.DateTimeField(blank=True, db_column='recovered_on', help_text='Date at which the device stoped capturing information.', null=True, verbose_name='recovered on')),
                ('commentaries', models.TextField(blank=True, db_column='commentaries', help_text='Sampling event commentaries', verbose_name='commentaries')),
                ('metadata', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata', default=irekua_database.utils.empty_JSON, help_text='Metadata associated to sampling event device', null=True, verbose_name='metadata')),
                ('configuration', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='configuration', default=irekua_database.utils.empty_JSON, help_text='Configuration on device through the sampling event', null=True, verbose_name='configuration')),
                ('collection_device', models.ForeignKey(blank=True, db_column='collection_device_id', help_text='Reference to collection device used on sampling event', null=True, on_delete=django.db.models.deletion.PROTECT, to='irekua_database.CollectionDevice', verbose_name='collection device')),
                ('created_by', models.ForeignKey(blank=True, db_column='creator_id', help_text='Creator of object', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='samplingeventdevice_created_by', to=settings.AUTH_USER_MODEL, verbose_name='creator')),
                ('licence', models.ForeignKey(blank=True, db_column='licence_id', help_text='Licence for all items in sampling event', null=True, on_delete=django.db.models.deletion.PROTECT, to='irekua_database.Licence', verbose_name='licence')),
                ('modified_by', models.ForeignKey(blank=True, db_column='modified_by', editable=False, help_text='User who made modifications last', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='samplingeventdevice_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='modified by')),
                ('sampling_event', models.ForeignKey(db_column='sampling_event_id', help_text='Sampling event in which this device was deployed', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.SamplingEvent', verbose_name='sampling event')),
            ],
            options={
                'verbose_name': 'Sampling Event Device',
                'verbose_name_plural': 'Sampling Event Devices',
                'ordering': ['-created_on'],
                'unique_together': {('sampling_event', 'collection_device')},
            },
        ),
        migrations.AddField(
            model_name='samplingevent',
            name='sampling_event_type',
            field=models.ForeignKey(db_column='sampling_event_type', help_text='Type of sampling event', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.SamplingEventType', verbose_name='sampling event type'),
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('name', models.CharField(db_column='name', help_text='Name of role', max_length=64, unique=True, verbose_name='name')),
                ('description', models.TextField(blank=True, db_column='description', help_text='Description of role', verbose_name='description')),
                ('icon', models.ImageField(blank=True, db_column='icon', help_text='Role type icon', null=True, upload_to='images/role_types/', verbose_name='icon')),
                ('permissions', models.ManyToManyField(blank=True, help_text='Permissions associated to role', limit_choices_to=models.Q(content_type__model='collection'), to='auth.Permission', verbose_name='permissions')),
            ],
            options={
                'verbose_name': 'Role',
                'verbose_name_plural': 'Roles',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='PhysicalDevice',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('identifier', models.CharField(blank=True, db_column='identifier', help_text='Simple device identifier (visible only to owner)', max_length=128, verbose_name='name')),
                ('serial_number', models.CharField(blank=True, db_column='serial_number', help_text='Serial number of device', max_length=128, null=True, verbose_name='serial number')),
                ('metadata', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata', default=irekua_database.utils.empty_JSON, help_text='Metadata associated to device', null=True, verbose_name='metadata')),
                ('bundle', models.BooleanField(db_column='bundle', help_text='Does this device possibly represents many physical devices?', verbose_name='bundle')),
                ('created_by', models.ForeignKey(blank=True, db_column='creator_id', help_text='Creator of object', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='physicaldevice_created_by', to=settings.AUTH_USER_MODEL, verbose_name='creator')),
                ('device', models.ForeignKey(db_column='device_id', help_text='Brand and model of device', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.Device', verbose_name='device')),
                ('modified_by', models.ForeignKey(blank=True, db_column='modified_by', editable=False, help_text='User who made modifications last', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='physicaldevice_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='modified by')),
            ],
            options={
                'verbose_name': 'Physical Device',
                'verbose_name_plural': 'Physical Devices',
                'ordering': ['-created_on'],
                'unique_together': {('serial_number', 'device')},
            },
        ),
        migrations.CreateModel(
            name='MetaCollection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('name', models.CharField(db_column='name', help_text='Name of meta collection', max_length=64, unique=True, verbose_name='name')),
                ('description', models.TextField(db_column='description', help_text='Description of Meta Collection', verbose_name='description')),
                ('created_by', models.ForeignKey(blank=True, db_column='creator_id', help_text='Creator of object', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='metacollection_created_by', to=settings.AUTH_USER_MODEL, verbose_name='creator')),
                ('curators', models.ManyToManyField(blank=True, help_text='Curators of metacollection', related_name='metacollection_curators', to=settings.AUTH_USER_MODEL, verbose_name='curators')),
                ('items', models.ManyToManyField(blank=True, help_text='Items belonging to MetaCollection', to='irekua_database.Item', verbose_name='items')),
                ('modified_by', models.ForeignKey(blank=True, db_column='modified_by', editable=False, help_text='User who made modifications last', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='metacollection_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='modified by')),
            ],
            options={
                'verbose_name': 'Meta Collection',
                'verbose_name_plural': 'Meta Collections',
                'ordering': ['name'],
            },
        ),
        migrations.AddField(
            model_name='locality',
            name='locality_type',
            field=models.ForeignKey(db_column='locality_type_id', help_text='Type of locality', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.LocalityType', verbose_name='locality type'),
        ),
        migrations.AddField(
            model_name='licence',
            name='licence_type',
            field=models.ForeignKey(db_column='licence_type_id', help_text='Type of licence used', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.LicenceType', verbose_name='licence type'),
        ),
        migrations.AddField(
            model_name='licence',
            name='modified_by',
            field=models.ForeignKey(blank=True, db_column='modified_by', editable=False, help_text='User who made modifications last', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='licence_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='modified by'),
        ),
        migrations.AddField(
            model_name='itemtype',
            name='mime_types',
            field=models.ManyToManyField(blank=True, db_column='mime_types', help_text='Mime types of files for this item type', to='irekua_database.MimeType', verbose_name='mime types'),
        ),
        migrations.AddField(
            model_name='item',
            name='item_type',
            field=models.ForeignKey(db_column='item_type_id', help_text='Type of resource', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.ItemType', verbose_name='item type'),
        ),
        migrations.AddField(
            model_name='item',
            name='licence',
            field=models.ForeignKey(blank=True, db_column='licence_id', help_text='Licence of item', null=True, on_delete=django.db.models.deletion.PROTECT, to='irekua_database.Licence', verbose_name='licence'),
        ),
        migrations.AddField(
            model_name='item',
            name='modified_by',
            field=models.ForeignKey(blank=True, db_column='modified_by', editable=False, help_text='User who made modifications last', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='item_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='modified by'),
        ),
        migrations.AddField(
            model_name='item',
            name='ready_event_types',
            field=models.ManyToManyField(blank=True, help_text='Types of event for which item has been fully annotated', to='irekua_database.EventType', verbose_name='ready event types'),
        ),
        migrations.AddField(
            model_name='item',
            name='sampling_event_device',
            field=models.ForeignKey(db_column='sampling_event_device_id', help_text='Sampling event device used to create item', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.SamplingEventDevice', verbose_name='sampling event device'),
        ),
        migrations.AddField(
            model_name='item',
            name='source',
            field=models.ForeignKey(blank=True, db_column='source_id', help_text='Source of item (parsing function and parent directory)', null=True, on_delete=django.db.models.deletion.PROTECT, to='irekua_database.Source', verbose_name='source'),
        ),
        migrations.AddField(
            model_name='item',
            name='tags',
            field=models.ManyToManyField(blank=True, help_text='Tags for item', to='irekua_database.Tag', verbose_name='tags'),
        ),
        migrations.CreateModel(
            name='Institution',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('institution_name', models.CharField(db_column='institution_name', help_text='Name of institution', max_length=256, verbose_name='institution name')),
                ('institution_code', models.CharField(blank=True, db_column='institution_code', help_text='Code of institution', max_length=64, verbose_name='institution code')),
                ('subdependency', models.CharField(blank=True, db_column='subdependency', help_text='Subdependency at institution', max_length=256, null=True, verbose_name='subdependency')),
                ('country', models.CharField(blank=True, choices=[('AW', 'Aruba'), ('AF', 'Afghanistan'), ('AO', 'Angola'), ('AI', 'Anguilla'), ('AX', 'Åland Islands'), ('AL', 'Albania'), ('AD', 'Andorra'), ('AE', 'United Arab Emirates'), ('AR', 'Argentina'), ('AM', 'Armenia'), ('AS', 'American Samoa'), ('AQ', 'Antarctica'), ('TF', 'French Southern Territories'), ('AG', 'Antigua and Barbuda'), ('AU', 'Australia'), ('AT', 'Austria'), ('AZ', 'Azerbaijan'), ('BI', 'Burundi'), ('BE', 'Belgium'), ('BJ', 'Benin'), ('BQ', 'Bonaire, Sint Eustatius and Saba'), ('BF', 'Burkina Faso'), ('BD', 'Bangladesh'), ('BG', 'Bulgaria'), ('BH', 'Bahrain'), ('BS', 'Bahamas'), ('BA', 'Bosnia and Herzegovina'), ('BL', 'Saint Barthélemy'), ('BY', 'Belarus'), ('BZ', 'Belize'), ('BM', 'Bermuda'), ('BO', 'Bolivia, Plurinational State of'), ('BR', 'Brazil'), ('BB', 'Barbados'), ('BN', 'Brunei Darussalam'), ('BT', 'Bhutan'), ('BV', 'Bouvet Island'), ('BW', 'Botswana'), ('CF', 'Central African Republic'), ('CA', 'Canada'), ('CC', 'Cocos (Keeling) Islands'), ('CH', 'Switzerland'), ('CL', 'Chile'), ('CN', 'China'), ('CI', "Côte d'Ivoire"), ('CM', 'Cameroon'), ('CD', 'Congo, The Democratic Republic of the'), ('CG', 'Congo'), ('CK', 'Cook Islands'), ('CO', 'Colombia'), ('KM', 'Comoros'), ('CV', 'Cabo Verde'), ('CR', 'Costa Rica'), ('CU', 'Cuba'), ('CW', 'Curaçao'), ('CX', 'Christmas Island'), ('KY', 'Cayman Islands'), ('CY', 'Cyprus'), ('CZ', 'Czechia'), ('DE', 'Germany'), ('DJ', 'Djibouti'), ('DM', 'Dominica'), ('DK', 'Denmark'), ('DO', 'Dominican Republic'), ('DZ', 'Algeria'), ('EC', 'Ecuador'), ('EG', 'Egypt'), ('ER', 'Eritrea'), ('EH', 'Western Sahara'), ('ES', 'Spain'), ('EE', 'Estonia'), ('ET', 'Ethiopia'), ('FI', 'Finland'), ('FJ', 'Fiji'), ('FK', 'Falkland Islands (Malvinas)'), ('FR', 'France'), ('FO', 'Faroe Islands'), ('FM', 'Micronesia, Federated States of'), ('GA', 'Gabon'), ('GB', 'United Kingdom'), ('GE', 'Georgia'), ('GG', 'Guernsey'), ('GH', 'Ghana'), ('GI', 'Gibraltar'), ('GN', 'Guinea'), ('GP', 'Guadeloupe'), ('GM', 'Gambia'), ('GW', 'Guinea-Bissau'), ('GQ', 'Equatorial Guinea'), ('GR', 'Greece'), ('GD', 'Grenada'), ('GL', 'Greenland'), ('GT', 'Guatemala'), ('GF', 'French Guiana'), ('GU', 'Guam'), ('GY', 'Guyana'), ('HK', 'Hong Kong'), ('HM', 'Heard Island and McDonald Islands'), ('HN', 'Honduras'), ('HR', 'Croatia'), ('HT', 'Haiti'), ('HU', 'Hungary'), ('ID', 'Indonesia'), ('IM', 'Isle of Man'), ('IN', 'India'), ('IO', 'British Indian Ocean Territory'), ('IE', 'Ireland'), ('IR', 'Iran, Islamic Republic of'), ('IQ', 'Iraq'), ('IS', 'Iceland'), ('IL', 'Israel'), ('IT', 'Italy'), ('JM', 'Jamaica'), ('JE', 'Jersey'), ('JO', 'Jordan'), ('JP', 'Japan'), ('KZ', 'Kazakhstan'), ('KE', 'Kenya'), ('KG', 'Kyrgyzstan'), ('KH', 'Cambodia'), ('KI', 'Kiribati'), ('KN', 'Saint Kitts and Nevis'), ('KR', 'Korea, Republic of'), ('KW', 'Kuwait'), ('LA', "Lao People's Democratic Republic"), ('LB', 'Lebanon'), ('LR', 'Liberia'), ('LY', 'Libya'), ('LC', 'Saint Lucia'), ('LI', 'Liechtenstein'), ('LK', 'Sri Lanka'), ('LS', 'Lesotho'), ('LT', 'Lithuania'), ('LU', 'Luxembourg'), ('LV', 'Latvia'), ('MO', 'Macao'), ('MF', 'Saint Martin (French part)'), ('MA', 'Morocco'), ('MC', 'Monaco'), ('MD', 'Moldova, Republic of'), ('MG', 'Madagascar'), ('MV', 'Maldives'), ('MX', 'Mexico'), ('MH', 'Marshall Islands'), ('MK', 'North Macedonia'), ('ML', 'Mali'), ('MT', 'Malta'), ('MM', 'Myanmar'), ('ME', 'Montenegro'), ('MN', 'Mongolia'), ('MP', 'Northern Mariana Islands'), ('MZ', 'Mozambique'), ('MR', 'Mauritania'), ('MS', 'Montserrat'), ('MQ', 'Martinique'), ('MU', 'Mauritius'), ('MW', 'Malawi'), ('MY', 'Malaysia'), ('YT', 'Mayotte'), ('NA', 'Namibia'), ('NC', 'New Caledonia'), ('NE', 'Niger'), ('NF', 'Norfolk Island'), ('NG', 'Nigeria'), ('NI', 'Nicaragua'), ('NU', 'Niue'), ('NL', 'Netherlands'), ('NO', 'Norway'), ('NP', 'Nepal'), ('NR', 'Nauru'), ('NZ', 'New Zealand'), ('OM', 'Oman'), ('PK', 'Pakistan'), ('PA', 'Panama'), ('PN', 'Pitcairn'), ('PE', 'Peru'), ('PH', 'Philippines'), ('PW', 'Palau'), ('PG', 'Papua New Guinea'), ('PL', 'Poland'), ('PR', 'Puerto Rico'), ('KP', "Korea, Democratic People's Republic of"), ('PT', 'Portugal'), ('PY', 'Paraguay'), ('PS', 'Palestine, State of'), ('PF', 'French Polynesia'), ('QA', 'Qatar'), ('RE', 'Réunion'), ('RO', 'Romania'), ('RU', 'Russian Federation'), ('RW', 'Rwanda'), ('SA', 'Saudi Arabia'), ('SD', 'Sudan'), ('SN', 'Senegal'), ('SG', 'Singapore'), ('GS', 'South Georgia and the South Sandwich Islands'), ('SH', 'Saint Helena, Ascension and Tristan da Cunha'), ('SJ', 'Svalbard and Jan Mayen'), ('SB', 'Solomon Islands'), ('SL', 'Sierra Leone'), ('SV', 'El Salvador'), ('SM', 'San Marino'), ('SO', 'Somalia'), ('PM', 'Saint Pierre and Miquelon'), ('RS', 'Serbia'), ('SS', 'South Sudan'), ('ST', 'Sao Tome and Principe'), ('SR', 'Suriname'), ('SK', 'Slovakia'), ('SI', 'Slovenia'), ('SE', 'Sweden'), ('SZ', 'Eswatini'), ('SX', 'Sint Maarten (Dutch part)'), ('SC', 'Seychelles'), ('SY', 'Syrian Arab Republic'), ('TC', 'Turks and Caicos Islands'), ('TD', 'Chad'), ('TG', 'Togo'), ('TH', 'Thailand'), ('TJ', 'Tajikistan'), ('TK', 'Tokelau'), ('TM', 'Turkmenistan'), ('TL', 'Timor-Leste'), ('TO', 'Tonga'), ('TT', 'Trinidad and Tobago'), ('TN', 'Tunisia'), ('TR', 'Turkey'), ('TV', 'Tuvalu'), ('TW', 'Taiwan, Province of China'), ('TZ', 'Tanzania, United Republic of'), ('UG', 'Uganda'), ('UA', 'Ukraine'), ('UM', 'United States Minor Outlying Islands'), ('UY', 'Uruguay'), ('US', 'United States'), ('UZ', 'Uzbekistan'), ('VA', 'Holy See (Vatican City State)'), ('VC', 'Saint Vincent and the Grenadines'), ('VE', 'Venezuela, Bolivarian Republic of'), ('VG', 'Virgin Islands, British'), ('VI', 'Virgin Islands, U.S.'), ('VN', 'Viet Nam'), ('VU', 'Vanuatu'), ('WF', 'Wallis and Futuna'), ('WS', 'Samoa'), ('YE', 'Yemen'), ('ZA', 'South Africa'), ('ZM', 'Zambia'), ('ZW', 'Zimbabwe')], db_column='country', help_text='Country home of institution', max_length=2, verbose_name='country')),
                ('postal_code', models.CharField(blank=True, db_column='postal_code', help_text='Postal code', max_length=8, verbose_name='postal code')),
                ('address', models.TextField(blank=True, db_column='address', help_text='Address of institution', verbose_name='address')),
                ('website', models.URLField(blank=True, db_column='website', help_text='Website of institution', verbose_name='website')),
                ('logo', models.ImageField(blank=True, db_column='logo', help_text='Institution logo', null=True, upload_to='images/institutions/', verbose_name='logo')),
                ('created_by', models.ForeignKey(blank=True, db_column='creator_id', help_text='Creator of object', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='institution_created_by', to=settings.AUTH_USER_MODEL, verbose_name='creator')),
                ('modified_by', models.ForeignKey(blank=True, db_column='modified_by', editable=False, help_text='User who made modifications last', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='institution_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='modified by')),
            ],
            options={
                'verbose_name': 'Institution',
                'verbose_name_plural': 'Institutions',
                'ordering': ['institution_name'],
                'unique_together': {('institution_name', 'subdependency')},
            },
        ),
        migrations.AddField(
            model_name='eventtype',
            name='should_imply',
            field=models.ManyToManyField(blank=True, db_column='should_imply', help_text='Terms that should be implied (if meaningful) by any terms used to describe this event type.', to='irekua_database.Term', verbose_name='should imply'),
        ),
        migrations.AddField(
            model_name='eventtype',
            name='term_types',
            field=models.ManyToManyField(blank=True, db_column='term_types', help_text='Valid term types with which to label this type of events', to='irekua_database.TermType', verbose_name='term types'),
        ),
        migrations.CreateModel(
            name='Entailment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('metadata', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata', help_text='Metadata associated to entailment', null=True, verbose_name='metadata')),
                ('source', models.ForeignKey(db_column='source_id', help_text='Source of entailment', on_delete=django.db.models.deletion.CASCADE, related_name='entailment_source', to='irekua_database.Term', verbose_name='source')),
                ('target', models.ForeignKey(db_column='target_id', help_text='Target of entailment', on_delete=django.db.models.deletion.CASCADE, related_name='entailment_target', to='irekua_database.Term', verbose_name='target')),
            ],
            options={
                'verbose_name': 'Entailment',
                'verbose_name_plural': 'Entailments',
                'ordering': ['source'],
            },
        ),
        migrations.AddField(
            model_name='devicetype',
            name='mime_types',
            field=models.ManyToManyField(blank=True, db_column='mime_types', help_text='Possible mime types for files generated by devicesof this type', to='irekua_database.MimeType', verbose_name='mime types'),
        ),
        migrations.AddField(
            model_name='device',
            name='brand',
            field=models.ForeignKey(db_column='device_brand_id', help_text='Brand of device', on_delete=django.db.models.deletion.PROTECT, related_name='device_brand', to='irekua_database.DeviceBrand', verbose_name='brand'),
        ),
        migrations.AddField(
            model_name='device',
            name='device_type',
            field=models.ForeignKey(db_column='device_type_id', help_text='Type of device', on_delete=django.db.models.deletion.PROTECT, related_name='device_type', to='irekua_database.DeviceType', verbose_name='device type'),
        ),
        migrations.CreateModel(
            name='CollectionUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('metadata', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata', default=irekua_database.utils.empty_JSON, help_text='Metadata associated to user in collection', null=True, verbose_name='metadata')),
                ('collection', models.ForeignKey(db_column='collection_id', help_text='Collection to which user belongs', on_delete=django.db.models.deletion.CASCADE, to='irekua_database.Collection', verbose_name='collection')),
                ('created_by', models.ForeignKey(blank=True, db_column='creator_id', help_text='Creator of object', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='collectionuser_created_by', to=settings.AUTH_USER_MODEL, verbose_name='creator')),
                ('modified_by', models.ForeignKey(blank=True, db_column='modified_by', editable=False, help_text='User who made modifications last', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='collectionuser_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='modified by')),
                ('role', models.ForeignKey(db_column='role_id', help_text='Role of user in collection', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.Role', verbose_name='role')),
                ('user', models.ForeignKey(db_column='user_id', help_text='User of collection', on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'verbose_name': 'Collection User',
                'verbose_name_plural': 'Collection Users',
                'unique_together': {('collection', 'user')},
            },
        ),
        migrations.CreateModel(
            name='CollectionType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('name', models.CharField(db_column='name', help_text='Name of collection type', max_length=128, unique=True, verbose_name='name')),
                ('description', models.TextField(db_column='description', help_text='Description of collection type', verbose_name='description')),
                ('logo', models.ImageField(blank=True, db_column='logo', help_text='Logo of collection type', null=True, upload_to='images/collection_types/', verbose_name='logo')),
                ('metadata_schema', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata_schema', default=irekua_database.utils.simple_JSON_schema, help_text='JSON Schema for metadata of collection info', validators=[irekua_database.utils.validate_JSON_schema], verbose_name='metadata schema')),
                ('anyone_can_create', models.BooleanField(blank=True, db_column='anyone_can_create', default=False, help_text='Boolean flag indicating wheter any user can create collections of this type', verbose_name='anyone can create')),
                ('restrict_site_types', models.BooleanField(blank=True, db_column='restrict_site_types', default=True, help_text='Flag indicating whether types of sites are restricted to registered ones', verbose_name='restrict site types')),
                ('restrict_annotation_types', models.BooleanField(blank=True, db_column='restrict_annotation_types', default=True, help_text='Flag indicating whether types of annotations are restricted to registered ones', verbose_name='restrict annotation types')),
                ('restrict_item_types', models.BooleanField(blank=True, db_column='restrict_item_types', default=True, help_text='Flag indicating whether types of items are restricted to registered ones', verbose_name='restrict item types')),
                ('restrict_licence_types', models.BooleanField(blank=True, db_column='restrict_licence_types', default=True, help_text='Flag indicating whether types of licences are restricted to registered ones', verbose_name='restrict licence types')),
                ('restrict_device_types', models.BooleanField(blank=True, db_column='restrict_device_types', default=True, help_text='Flag indicating whether types of devices are restricted to registered ones', verbose_name='restrict device types')),
                ('restrict_event_types', models.BooleanField(blank=True, db_column='restrict_event_types', default=True, help_text='Flag indicating whether types of events are restricted to registered ones', verbose_name='restrict event types')),
                ('restrict_sampling_event_types', models.BooleanField(blank=True, db_column='restrict_sampling_event_types', default=True, help_text='Flag indicating whether types of sampling events are restricted to registered ones', verbose_name='restrict sampling event types')),
                ('administrators', models.ManyToManyField(blank=True, help_text='Administrators of this collection type. Administrators can create collections of this type', to=settings.AUTH_USER_MODEL, verbose_name='administrators')),
                ('annotation_types', models.ManyToManyField(blank=True, help_text='Types of annotations valid for collections of type', to='irekua_database.AnnotationType', verbose_name='annotation types')),
                ('device_types', models.ManyToManyField(blank=True, help_text='Types of devices valid for collections of type', through='irekua_database.CollectionDeviceType', to='irekua_database.DeviceType', verbose_name='device types')),
                ('event_types', models.ManyToManyField(blank=True, help_text='Types of events valid for collections of type', to='irekua_database.EventType', verbose_name='event types')),
                ('item_types', models.ManyToManyField(blank=True, help_text='Types of items valid for collections of type', through='irekua_database.CollectionItemType', to='irekua_database.ItemType', verbose_name='item types')),
                ('licence_types', models.ManyToManyField(blank=True, help_text='Types of licences valid for collections of type', to='irekua_database.LicenceType', verbose_name='licence types')),
                ('roles', models.ManyToManyField(blank=True, help_text='Roles valid for collections of type', through='irekua_database.CollectionRole', to='irekua_database.Role', verbose_name='roles')),
                ('sampling_event_types', models.ManyToManyField(blank=True, help_text='Types of sampling events valid for collections of type', to='irekua_database.SamplingEventType', verbose_name='sampling event types')),
                ('site_types', models.ManyToManyField(blank=True, help_text='Types of sites valid for collections of type', to='irekua_database.SiteType', verbose_name='site types')),
            ],
            options={
                'verbose_name': 'Collection Type',
                'verbose_name_plural': 'Collection Types',
                'ordering': ['name'],
            },
        ),
        migrations.AddField(
            model_name='collectionsite',
            name='site',
            field=models.ForeignKey(db_column='site_id', help_text='Reference to Site', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.Site', verbose_name='site'),
        ),
        migrations.AddField(
            model_name='collectionsite',
            name='site_descriptors',
            field=models.ManyToManyField(blank=True, to='irekua_database.SiteDescriptor'),
        ),
        migrations.AddField(
            model_name='collectionsite',
            name='site_type',
            field=models.ForeignKey(db_column='site_type', help_text='Type of site', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.SiteType', verbose_name='site type'),
        ),
        migrations.AddField(
            model_name='collectionrole',
            name='collection_type',
            field=models.ForeignKey(db_column='collection_type_id', help_text='Collection type in which role applies', on_delete=django.db.models.deletion.CASCADE, to='irekua_database.CollectionType', verbose_name='collection type'),
        ),
        migrations.AddField(
            model_name='collectionrole',
            name='role',
            field=models.ForeignKey(db_column='role_id', help_text='Role to be part of collection', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.Role', verbose_name='role'),
        ),
        migrations.AddField(
            model_name='collectionitemtype',
            name='collection_type',
            field=models.ForeignKey(db_column='collection_type_id', help_text='Collection type in which role applies', on_delete=django.db.models.deletion.CASCADE, to='irekua_database.CollectionType', verbose_name='collection type'),
        ),
        migrations.AddField(
            model_name='collectionitemtype',
            name='item_type',
            field=models.ForeignKey(db_column='item_type_id', help_text='Item to be part of collection', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.ItemType', verbose_name='item type'),
        ),
        migrations.AddField(
            model_name='collectiondevicetype',
            name='collection_type',
            field=models.ForeignKey(db_column='collection_type_id', help_text='Collection type in which role applies', on_delete=django.db.models.deletion.CASCADE, to='irekua_database.CollectionType', verbose_name='collection type'),
        ),
        migrations.AddField(
            model_name='collectiondevicetype',
            name='device_type',
            field=models.ForeignKey(db_column='device_type_id', help_text='Device to be part of collection', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.DeviceType', verbose_name='device type'),
        ),
        migrations.AddField(
            model_name='collectiondevice',
            name='physical_device',
            field=models.ForeignKey(db_column='physical_device_id', help_text='Reference to physical device', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.PhysicalDevice', verbose_name='physical device'),
        ),
        migrations.AddField(
            model_name='collection',
            name='collection_type',
            field=models.ForeignKey(db_column='collection_type_id', help_text='Type of collection', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.CollectionType', verbose_name='collection type'),
        ),
        migrations.AddField(
            model_name='collection',
            name='created_by',
            field=models.ForeignKey(blank=True, db_column='creator_id', help_text='Creator of object', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='collection_created_by', to=settings.AUTH_USER_MODEL, verbose_name='creator'),
        ),
        migrations.AddField(
            model_name='collection',
            name='institution',
            field=models.ForeignKey(blank=True, db_column='institution_id', help_text='Institution to which the collection belogs', null=True, on_delete=django.db.models.deletion.PROTECT, to='irekua_database.Institution', verbose_name='institution'),
        ),
        migrations.AddField(
            model_name='collection',
            name='modified_by',
            field=models.ForeignKey(blank=True, db_column='modified_by', editable=False, help_text='User who made modifications last', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='collection_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='modified by'),
        ),
        migrations.AddField(
            model_name='collection',
            name='physical_devices',
            field=models.ManyToManyField(blank=True, through='irekua_database.CollectionDevice', to='irekua_database.PhysicalDevice'),
        ),
        migrations.AddField(
            model_name='collection',
            name='sites',
            field=models.ManyToManyField(blank=True, through='irekua_database.CollectionSite', to='irekua_database.Site'),
        ),
        migrations.AddField(
            model_name='collection',
            name='users',
            field=models.ManyToManyField(blank=True, related_name='collection_users', through='irekua_database.CollectionUser', to=settings.AUTH_USER_MODEL),
        ),
        migrations.CreateModel(
            name='AnnotationVote',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('annotation', models.ForeignKey(db_column='annotation_id', help_text='Reference to annotation being voted', on_delete=django.db.models.deletion.CASCADE, to='irekua_database.Annotation', verbose_name='annotation')),
                ('created_by', models.ForeignKey(blank=True, db_column='creator_id', help_text='Creator of object', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='annotationvote_created_by', to=settings.AUTH_USER_MODEL, verbose_name='creator')),
                ('labels', models.ManyToManyField(blank=True, db_column='labels', help_text='Labels associated with annotation', to='irekua_database.Term', verbose_name='labels')),
                ('modified_by', models.ForeignKey(blank=True, db_column='modified_by', editable=False, help_text='User who made modifications last', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='annotationvote_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='modified by')),
            ],
            options={
                'verbose_name': 'Annotation Vote',
                'verbose_name_plural': 'Annotation Votes',
                'ordering': ['-modified_on'],
            },
        ),
        migrations.CreateModel(
            name='AnnotationTool',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('name', models.CharField(db_column='name', help_text='Name of annotation tool', max_length=64, verbose_name='name')),
                ('version', models.CharField(db_column='version', help_text='Version of annotation tool', max_length=16, verbose_name='version')),
                ('logo', models.ImageField(blank=True, db_column='logo', help_text='Annotation tool logo', null=True, upload_to='images/annotation_tools/', verbose_name='logo')),
                ('website', models.URLField(blank=True, db_column='website', help_text='Annotation tool website', null=True, verbose_name='website')),
                ('annotation_type', models.ForeignKey(db_column='annotation_type_id', help_text='Type of annotation this tool produces', on_delete=django.db.models.deletion.CASCADE, to='irekua_database.AnnotationType', verbose_name='annotation type')),
            ],
            options={
                'verbose_name': 'Annotation Tool',
                'verbose_name_plural': 'Annotation Tools',
                'ordering': ['name'],
                'unique_together': {('name', 'version')},
            },
        ),
        migrations.AddField(
            model_name='annotation',
            name='annotation_tool',
            field=models.ForeignKey(db_column='annotation_tool_id', help_text='Annotation tool used when annotating', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.AnnotationTool', verbose_name='annotation tool'),
        ),
        migrations.AddField(
            model_name='annotation',
            name='annotation_type',
            field=models.ForeignKey(db_column='annotation_type_id', help_text='Type of annotation', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.AnnotationType', verbose_name='annotation type'),
        ),
        migrations.AddField(
            model_name='annotation',
            name='created_by',
            field=models.ForeignKey(blank=True, db_column='creator_id', help_text='Creator of object', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='annotation_created_by', to=settings.AUTH_USER_MODEL, verbose_name='creator'),
        ),
        migrations.AddField(
            model_name='annotation',
            name='event_type',
            field=models.ForeignKey(db_column='event_type_id', help_text='Type of event being annotated', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.EventType', verbose_name='event type'),
        ),
        migrations.AddField(
            model_name='annotation',
            name='item',
            field=models.ForeignKey(db_column='item_id', help_text='Annotated item', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.Item', verbose_name='item'),
        ),
        migrations.AddField(
            model_name='annotation',
            name='labels',
            field=models.ManyToManyField(blank=True, db_column='labels', help_text='Labels associated with annotation', to='irekua_database.Term', verbose_name='labels'),
        ),
        migrations.AddField(
            model_name='annotation',
            name='modified_by',
            field=models.ForeignKey(blank=True, db_column='modified_by', editable=False, help_text='User who made modifications last', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='annotation_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='modified by'),
        ),
        migrations.AddField(
            model_name='annotation',
            name='visualizer',
            field=models.ForeignKey(db_column='visualizers_id', help_text='Visualizer used when annotating', on_delete=django.db.models.deletion.PROTECT, to='irekua_database.Visualizer', verbose_name='visualizer'),
        ),
        migrations.AddField(
            model_name='user',
            name='institution',
            field=models.ForeignKey(blank=True, db_column='institution_id', help_text='Institution to which user belongs', null=True, on_delete=django.db.models.deletion.PROTECT, to='irekua_database.Institution', verbose_name='institution'),
        ),
        migrations.AddField(
            model_name='user',
            name='user_permissions',
            field=models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions'),
        ),
        migrations.CreateModel(
            name='EntailmentType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(auto_now_add=True, db_column='created_on', help_text='Date of creation', verbose_name='created on')),
                ('modified_on', models.DateTimeField(auto_now=True, db_column='modified_on', help_text='Date of last modification', verbose_name='modified on')),
                ('metadata_schema', django.contrib.postgres.fields.jsonb.JSONField(blank=True, db_column='metadata_schema', default=irekua_database.utils.simple_JSON_schema, help_text='JSON Schema for metadata of entailment info', validators=[irekua_database.utils.validate_JSON_schema], verbose_name='metadata schema')),
                ('source_type', models.ForeignKey(db_column='source_type_id', help_text='Term type of source of entailment', on_delete=django.db.models.deletion.CASCADE, related_name='entailment_source_type', to='irekua_database.TermType', verbose_name='source type')),
                ('target_type', models.ForeignKey(db_column='target_type_id', help_text='Term type of target of entailment', on_delete=django.db.models.deletion.CASCADE, related_name='entailment_target_type', to='irekua_database.TermType', verbose_name='target type')),
            ],
            options={
                'verbose_name': 'Entailment Type',
                'verbose_name_plural': 'Entailment Types',
                'ordering': ['source_type'],
                'unique_together': {('source_type', 'target_type')},
            },
        ),
        migrations.AlterUniqueTogether(
            name='device',
            unique_together={('brand', 'model')},
        ),
        migrations.AlterUniqueTogether(
            name='collectionsite',
            unique_together={('collection', 'site'), ('collection', 'internal_id')},
        ),
        migrations.AlterUniqueTogether(
            name='collectionrole',
            unique_together={('collection_type', 'role')},
        ),
        migrations.AlterUniqueTogether(
            name='collectionitemtype',
            unique_together={('collection_type', 'item_type')},
        ),
        migrations.AlterUniqueTogether(
            name='collectiondevicetype',
            unique_together={('collection_type', 'device_type')},
        ),
        migrations.AlterUniqueTogether(
            name='collectiondevice',
            unique_together={('physical_device', 'collection')},
        ),
        migrations.AlterUniqueTogether(
            name='user',
            unique_together={('email',)},
        ),
    ]
