//During the test the env variable is set to test
process.env.NODE_ENV = 'test';
//Require the dev-dependencies
let chai = require('chai');
let main = require('../lib/index.js');
let expect = chai.expect;
const uuidv4 = require('uuid/v4');
/*
* Test the /GET route
*/
describe('API Tests', function() {
    
    
    describe('/POST verify Good', () => {
        it('it should be pass',  function () {
            let ccw = new main.CommonCheckWidget(uuidv4())
            return new Promise(function (resolve) {
                ccw.verifyByPathAsync('./test/success.enc')
                  .then(function(result) {
                    const str = JSON.stringify(result)
                    console.log(str)
                     expect(str).to.equal('{"validToEnter":true,"code":"2000","errors":[],"metadata":{"info":[{"type":"Verified"}]}}')
                     resolve()
                  });
             });
            
        });
    });

    describe('/POST verify Bad', () => {
        it('it should be fail', function () {
            let ccw = new main.CommonCheckWidget(uuidv4())
            return new Promise(function (resolve) {
                ccw.verifyByPathAsync('./test/fail.enc')
                  .then(function(result) {
                    const str = JSON.stringify(result)
                    console.log(str)
                     expect(str).to.equal('{"validToEnter":false,"code":"4000","errors":[{"type":"Test Collection Date","value":"2021-07-29T13:15:42.443Z","description":"Covid Test must be obtained 3 days before departure"}],"metadata":{}}')   
                     resolve()
                  });
             });
            
        });
    });

    describe('/POST verify Unsupported', () => {
        it('it should be unsupported',  function () {
            let ccw = new main.CommonCheckWidget(uuidv4())
            return new Promise(function (resolve) {
                ccw.verifyByPathAsync('./test/unsupported.enc')
                  .then(function(result) {
                    const str = JSON.stringify(result)
                    console.log(str)
                     expect(str).to.equal('{"validToEnter":false,"code":"6000","errors":[{"type":"Unsupported document(s)","description":"Currently we only support documents with digital certificate QR codes to be verified online."}],"metadata":{}}')  
                     resolve()
                  });
             });
            
        });
    });
});

