"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommonCheckVerify = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const FormData = require("form-data");
const jwt = require("jsonwebtoken");
const crypto = require("crypto");
const fs = require("fs");
const dotenv_1 = require("dotenv");
const base_1 = require("./base");
exports.endpointServiceBase = require("./base");
dotenv_1.config();
class CommonCheckVerify extends base_1.EndpointServiceBase {
    constructor(requestID) {
        const { API_KEY = require('API_KEY'), COMMON_CHECK_ENDPOINT = require('COMMON_CHECK_ENDPOINT'), COMMON_CHECK_API = require('COMMON_CHECK_API'), ERROR_CODE = require('ERROR_CODE'), SECRET_PASSPHRASE = require('SECRET_PASSPHRASE'), PRIVATE_KEY_FILE_NAME = require('PRIVATE_KEY_FILE_NAME') } = process.env;
        super(COMMON_CHECK_ENDPOINT + COMMON_CHECK_API, API_KEY, ERROR_CODE, requestID);
        this.secretPassphrase = SECRET_PASSPHRASE;
        this.privateKeyFileName = PRIVATE_KEY_FILE_NAME;
        this.requestID = requestID;
        console.log("Requst ID", { requestID });
    }
    async generateToken() {
        const data = await fs.promises.readFile(this.encryptionFile.path, "binary");
        const fileBinary = Buffer.from(data, 'binary');
        const hashSum = crypto.createHash('sha256');
        hashSum.update(fileBinary);
        const privateKey = fs.readFileSync(this.privateKeyFileName);
        const objectToSign = hashSum.digest('hex');
        const token = jwt.sign(objectToSign, { key: privateKey, passphrase: this.secretPassphrase }, { algorithm: 'RS512' });
        console.log("Token", token);
        return token;
    }
    async generateOptions() {
        let formData = new FormData();
        formData.append('file', this.encryptionFile);
        this.options = {
            method: 'POST',
            body: formData,
            headers: {
                'Api-Key': this.retrieveApiKey(),
                'Authorization': await this.generateToken(),
                'Request-ID': this.requestID
            },
            timeout: 30000,
        };
        return this.options;
    }
    fillEncryptionFile(encryptionFile) {
        this.encryptionFile = encryptionFile;
    }
    async generateResponse() {
        if (this.encryptionFile === undefined || this.encryptionFile === null) {
            return this.getErrorMessage({
                type: 'Invalid File',
                value: 'Undefined',
                description: 'File is required'
            });
        }
        try {
            this.fillOptions(await this.generateOptions());
            return this.callAPIEndpoint();
        }
        catch (error) {
            return this.getErrorMessage({
                type: 'Generate Response',
                value: 'Trying to Get Response',
                description: error
            });
        }
    }
}
exports.CommonCheckVerify = CommonCheckVerify;
_a = JSII_RTTI_SYMBOL_1;
CommonCheckVerify[_a] = { fqn: "@affinidi/common-check-widget-backend-lib.commonCheckVerify.CommonCheckVerify", version: "1.3.1" };
//# sourceMappingURL=data:application/json;base64,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