"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommonCheckWidget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const uuid_1 = require("uuid");
const service_1 = require("./service");
exports.commonCheckVerify = require("./service");
class CommonCheckWidget {
    constructor(requestID) {
        let requestIDValue = uuid_1.v4();
        if (requestID != null) {
            requestIDValue = requestID;
        }
        this.commonCheckVerify = new service_1.CommonCheckVerify(requestIDValue);
    }
    verifyWithCallback(encryptionFile, callback) {
        (async () => {
            this.commonCheckVerify.fillEncryptionFile(encryptionFile);
            const result = await this.commonCheckVerify.generateResponse();
            callback(result);
        })();
    }
    async verifyAsync(encryptionFile) {
        this.commonCheckVerify.fillEncryptionFile(encryptionFile);
        const result = await this.commonCheckVerify.generateResponse();
        return result;
    }
    verifyByPathWithCallback(encryptionFilePath, callback) {
        (async () => {
            let encryptionFileReadStream = fs.createReadStream(encryptionFilePath);
            this.commonCheckVerify.fillEncryptionFile(encryptionFileReadStream);
            const result = await this.commonCheckVerify.generateResponse();
            callback(result);
        })();
    }
    async verifyByPathAsync(encryptionFilePath) {
        let encryptionFileReadStream = fs.createReadStream(encryptionFilePath);
        this.commonCheckVerify.fillEncryptionFile(encryptionFileReadStream);
        const result = await this.commonCheckVerify.generateResponse();
        return result;
    }
    getErrorMessage(errorObj) {
        return this.commonCheckVerify.getErrorMessage(errorObj);
    }
}
exports.CommonCheckWidget = CommonCheckWidget;
_a = JSII_RTTI_SYMBOL_1;
CommonCheckWidget[_a] = { fqn: "@affinidi/common-check-widget-backend-lib.CommonCheckWidget", version: "1.3.1" };
//# sourceMappingURL=data:application/json;base64,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