"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EndpointServiceBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const node_fetch_1 = require("node-fetch");
class EndpointServiceBase {
    constructor(apiEndpoint, apiKey, errorCode, requestID) {
        this.apiEndpoint = apiEndpoint;
        this.apiKey = apiKey;
        this.errorCode = errorCode;
        this.requestID = requestID;
    }
    retrieveApiKey() {
        return this.apiKey;
    }
    getErrorMessage(errorObj) {
        let error = [];
        if (errorObj) {
            error.push(errorObj);
        }
        this.errors = ({
            validToEnter: false,
            code: this.errorCode,
            errors: error,
            entryWindow: {},
            metadata: {
                requestID: this.requestID,
                service: 'EndpointService'
            }
        });
        return this.errors;
    }
    fillOptions(options) {
        this.options = options;
    }
    async callAPIEndpoint() {
        console.log(new Date(), "Calling Endpoint", this.apiEndpoint);
        let response;
        try {
            response = await node_fetch_1.default(this.apiEndpoint, this.options);
            console.log(new Date(), "Completed Endpoint");
            if (response === null || response === void 0 ? void 0 : response.code) {
                return this.getErrorMessage({
                    type: 'Error Code',
                    value: response.code,
                    description: 'Error From Endpoint'
                });
            }
            return response.json();
        }
        catch (error) {
            console.log(new Date(), "Fail Endpoint with error", { error });
            throw new Error(response.status);
        }
    }
}
exports.EndpointServiceBase = EndpointServiceBase;
_a = JSII_RTTI_SYMBOL_1;
EndpointServiceBase[_a] = { fqn: "@affinidi/common-check-widget-backend-lib.commonCheckVerify.endpointServiceBase.EndpointServiceBase", version: "1.3.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmFzZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImJhc2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSwyQ0FBOEI7QUFFOUIsTUFBc0IsbUJBQW1CO0lBU3JDLFlBQWEsV0FBbUIsRUFBRSxNQUFjLEVBQUUsU0FBZ0IsRUFBRSxTQUFpQjtRQUNqRixJQUFJLENBQUMsV0FBVyxHQUFHLFdBQVcsQ0FBQTtRQUM5QixJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQTtRQUNwQixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQTtRQUMxQixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQTtJQUM5QixDQUFDO0lBRU0sY0FBYztRQUVqQixPQUFPLElBQUksQ0FBQyxNQUFNLENBQUE7SUFDdEIsQ0FBQztJQUVNLGVBQWUsQ0FBQyxRQUFjO1FBRWpDLElBQUksS0FBSyxHQUFHLEVBQUUsQ0FBQTtRQUNkLElBQUksUUFBUSxFQUNaO1lBQ0ksS0FBSyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQTtTQUN2QjtRQUNELElBQUksQ0FBQyxNQUFNLEdBQUcsQ0FDVjtZQUNFLFlBQVksRUFBRSxLQUFLO1lBQ25CLElBQUksRUFBRSxJQUFJLENBQUMsU0FBUztZQUNwQixNQUFNLEVBQUUsS0FBSztZQUNiLFdBQVcsRUFBRSxFQUFFO1lBQ2YsUUFBUSxFQUFFO2dCQUNOLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztnQkFDekIsT0FBTyxFQUFFLGlCQUFpQjthQUU3QjtTQUNGLENBQ0YsQ0FBQTtRQUNILE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQTtJQUN0QixDQUFDO0lBRU0sV0FBVyxDQUFDLE9BQVk7UUFFM0IsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPLENBQUE7SUFDMUIsQ0FBQztJQUVNLEtBQUssQ0FBQyxlQUFlO1FBRXhCLE9BQU8sQ0FBQyxHQUFHLENBQUMsSUFBSSxJQUFJLEVBQUUsRUFBRSxrQkFBa0IsRUFBRSxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUE7UUFDN0QsSUFBSSxRQUFZLENBQUE7UUFDaEIsSUFBRztZQUNDLFFBQVEsR0FBRyxNQUFNLG9CQUFLLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUE7WUFDdEQsT0FBTyxDQUFDLEdBQUcsQ0FBQyxJQUFJLElBQUksRUFBRSxFQUFFLG9CQUFvQixDQUFDLENBQUE7WUFDN0MsSUFBSSxRQUFRLGFBQVIsUUFBUSx1QkFBUixRQUFRLENBQUUsSUFBSSxFQUNsQjtnQkFDSSxPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7b0JBQ3hCLElBQUksRUFBRSxZQUFZO29CQUNsQixLQUFLLEVBQUcsUUFBUSxDQUFDLElBQUk7b0JBQ3JCLFdBQVcsRUFBRyxxQkFBcUI7aUJBQ3RDLENBQUMsQ0FBQTthQUNMO1lBQ0QsT0FBTyxRQUFRLENBQUMsSUFBSSxFQUFFLENBQUE7U0FDekI7UUFBQyxPQUFPLEtBQUssRUFBRTtZQUNaLE9BQU8sQ0FBQyxHQUFHLENBQUMsSUFBSSxJQUFJLEVBQUUsRUFBRSwwQkFBMEIsRUFBRSxFQUFDLEtBQUssRUFBQyxDQUFDLENBQUE7WUFDNUQsTUFBTSxJQUFJLEtBQUssQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLENBQUE7U0FDbkM7SUFDTCxDQUFDOztBQXJFTCxrREFzRUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgZmV0Y2ggZnJvbSAnbm9kZS1mZXRjaCdcblxuZXhwb3J0IGFic3RyYWN0IGNsYXNzIEVuZHBvaW50U2VydmljZUJhc2Uge1xuICAgIGFwaUVuZHBvaW50OiBzdHJpbmdcbiAgICBhcGlLZXk6IHN0cmluZztcbiAgICBlcnJvckNvZGU6IHN0cmluZztcbiAgICByZXF1ZXN0SUQ6IHN0cmluZ1xuICAgIG9wdGlvbnM6IGFueVxuICAgIGVycm9yczogYW55XG4gICAgXG5cbiAgICBjb25zdHJ1Y3RvciAoYXBpRW5kcG9pbnQ6IHN0cmluZywgYXBpS2V5OiBzdHJpbmcsIGVycm9yQ29kZTpzdHJpbmcsIHJlcXVlc3RJRDogc3RyaW5nKSB7XG4gICAgICAgIHRoaXMuYXBpRW5kcG9pbnQgPSBhcGlFbmRwb2ludFxuICAgICAgICB0aGlzLmFwaUtleSA9IGFwaUtleVxuICAgICAgICB0aGlzLmVycm9yQ29kZSA9IGVycm9yQ29kZVxuICAgICAgICB0aGlzLnJlcXVlc3RJRCA9IHJlcXVlc3RJRFxuICAgIH1cblxuICAgIHB1YmxpYyByZXRyaWV2ZUFwaUtleSgpXG4gICAge1xuICAgICAgICByZXR1cm4gdGhpcy5hcGlLZXlcbiAgICB9XG4gICAgXG4gICAgcHVibGljIGdldEVycm9yTWVzc2FnZShlcnJvck9iaj86IGFueSlcbiAgICB7XG4gICAgICAgIGxldCBlcnJvciA9IFtdXG4gICAgICAgIGlmIChlcnJvck9iailcbiAgICAgICAge1xuICAgICAgICAgICAgZXJyb3IucHVzaChlcnJvck9iailcbiAgICAgICAgfVxuICAgICAgICB0aGlzLmVycm9ycyA9IChcbiAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgdmFsaWRUb0VudGVyOiBmYWxzZSxcbiAgICAgICAgICAgICAgY29kZTogdGhpcy5lcnJvckNvZGUsXG4gICAgICAgICAgICAgIGVycm9yczogZXJyb3IsXG4gICAgICAgICAgICAgIGVudHJ5V2luZG93OiB7fSxcbiAgICAgICAgICAgICAgbWV0YWRhdGE6IHtcbiAgICAgICAgICAgICAgICAgIHJlcXVlc3RJRDogdGhpcy5yZXF1ZXN0SUQsXG4gICAgICAgICAgICAgICAgICBzZXJ2aWNlOiAnRW5kcG9pbnRTZXJ2aWNlJ1xuXG4gICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgICApXG4gICAgICAgIHJldHVybiB0aGlzLmVycm9yc1xuICAgIH1cblxuICAgIHB1YmxpYyBmaWxsT3B0aW9ucyhvcHRpb25zOiBhbnkpXG4gICAge1xuICAgICAgICB0aGlzLm9wdGlvbnMgPSBvcHRpb25zXG4gICAgfVxuXG4gICAgcHVibGljIGFzeW5jIGNhbGxBUElFbmRwb2ludCAoKSB7XG5cbiAgICAgICAgY29uc29sZS5sb2cobmV3IERhdGUoKSwgXCJDYWxsaW5nIEVuZHBvaW50XCIsIHRoaXMuYXBpRW5kcG9pbnQpXG4gICAgICAgIGxldCByZXNwb25zZTphbnlcbiAgICAgICAgdHJ5e1xuICAgICAgICAgICAgcmVzcG9uc2UgPSBhd2FpdCBmZXRjaCh0aGlzLmFwaUVuZHBvaW50LCB0aGlzLm9wdGlvbnMpXG4gICAgICAgICAgICBjb25zb2xlLmxvZyhuZXcgRGF0ZSgpLCBcIkNvbXBsZXRlZCBFbmRwb2ludFwiKVxuICAgICAgICAgICAgaWYgKHJlc3BvbnNlPy5jb2RlKVxuICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgIHJldHVybiB0aGlzLmdldEVycm9yTWVzc2FnZSh7XG4gICAgICAgICAgICAgICAgICAgIHR5cGU6ICdFcnJvciBDb2RlJywgXG4gICAgICAgICAgICAgICAgICAgIHZhbHVlIDogcmVzcG9uc2UuY29kZSwgXG4gICAgICAgICAgICAgICAgICAgIGRlc2NyaXB0aW9uIDogJ0Vycm9yIEZyb20gRW5kcG9pbnQnXG4gICAgICAgICAgICAgICAgfSlcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiByZXNwb25zZS5qc29uKClcbiAgICAgICAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICAgICAgICAgIGNvbnNvbGUubG9nKG5ldyBEYXRlKCksIFwiRmFpbCBFbmRwb2ludCB3aXRoIGVycm9yXCIsIHtlcnJvcn0pXG4gICAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IocmVzcG9uc2Uuc3RhdHVzKVxuICAgICAgICB9XG4gICAgfVxufSJdfQ==