<h1 align=center>The Common Check widget Backend Libary</h1>
<p align=center>
  <img src="https://img.shields.io/badge/built-with%20love-pink?style=for-the-badge" />
  <img src="https://img.shields.io/badge/by-affinidi-blue?style=for-the-badge" />
  <img src="https://img.shields.io/badge/for-the%20world-green?style=for-the-badge"/>
</p>

- [Getting started](#getting-started)
- [The Common Check Widget Backend Libary](#the-common-check-widget-backend-libary)
  - [Example in Javascript](#example-in-javascript)
  - [Example in Python](#example-in-python)
  - [Example in dotNET](#example-in-dotnet)
  - [Example in Java](#example-in-java)
- [The Common Check Widget Documentation](#the-common-check-widget-documentation)



# Getting started

## Private Key File & Environment Variables 

You will need to have privateKey.pem and .env with parameters below.

| Property                | Description                                       |
| ----------------------- | --------------------------------------------------|
| `API_KEY`               | License Key to Commone Check API endpoint         |
| `COMMON_CHECK_ENDPOINT` | Commone Check endpoint URL                        |
| `COMMON_CHECK_API`      | Commone Check endpoint API                        |
| `ERROR_CODE`            | Error Code Return To Widget ('5000')              |
| `SECRET_PASSPHRASE`     | SECRET_PASSPHRASE use to generate private key     |  
| `PRIVATE_KEY_FILE_NAME` | Private Key File Name (privateKey.pem)            |  
| `privateKey.pem`        | Private Key File generated by JWT Web Token       |       


# The Common Check Widget Backend Libary

This package will available on public packages hosts npmjs.org (npm), PyPI (Python), (nuget.org (NuGet), and Maven Central (Maven)) 

| Host                    | URL                                                                                     |
| ----------------------- | ----------------------------------------------------------------------------------------|
| npmjs.org (npm)         | https://www.npmjs.com/package/@affinidi/common-check-widget-backend-lib/                |
| PyPI (Python)           | https://pypi.org/project/affinidi.common-check-widget-backend-lib/                      |
| nuget.org (NuGet)       | https://www.nuget.org/packages/Affinidi.Common.Check.Widget.Backend.Lib/                |   
| Maven Central (Maven)   | https://search.maven.org/artifact/org.affinity-project/common-check-widget-backend-lib  |   


## Example in Javascript
Dependency libaries
```
    "@affinidi/common-check-widget-backend-lib": "^x.x.x",
    "cors": "^2.8.5",
    "express": "^4.17.1",
    "express-form-data": "^2.0.17"
```
Sample Code
```Javascript
const express = require('express');
const cors = require('cors');
const app = express();
const formData = require("express-form-data");
const os = require("os");
const fs = require("fs");
const {CommonCheckWidget} = require('@affinidi/common-check-widget-backend-lib'); 
/**
 * Options are the same as multiparty takes.
 * But there is a new option "autoClean" to clean all files in "uploadDir" folder after the response.
 * By default, it is "false".
 */
const options = {
  uploadDir: os.tmpdir(),
  autoClean: true
};

// parse data with connect-multiparty.
app.use(formData.parse(options));
// delete from the request all empty files (size == 0)
app.use(formData.format());
// change the file objects to fs.ReadStream
app.use(formData.stream());
// union the body and the files
app.use(formData.union());

app.use(cors());

app.get('/', (req, res) => {
  res.send('Common Check Widget API Backend is Alive')
});

app.get('/health', (req, res) => res.send(true))

app.post('/api/v1/verify', async (req, res) => {
  try {
      const encryptionFile = req.files.file
      const requestID = req.get('Request-ID')
      console.log("backend-demo-request-id", requestID)
      const ccw = new CommonCheckWidget(requestID) 
      const responseJson = await ccw.verifyAsync(encryptionFile)
      res.send(responseJson)
    } catch (e) {
      console.log("backend-demo",e)
      res.send(ccw.getErrorMessage(e))
    }

});
let port = process.env.PORT || 3000;

app.listen(port, async () => {
    console.log(`App running on port ${port}`);
});


module.exports = app

```

## Example in Python
Dependency libaries
```
flask==1.1.1
affinidi.common-check-widget-backend-lib==x.x.x
```
Sample Code
```Python
from flask import Flask, request, Response
from flask_cors import CORS
import json
import tempfile
import os
from werkzeug.utils import secure_filename
from affinidi.common_check_widget_backend_lib import *

app = Flask(__name__)
CORS(app)

@app.route("/api/v1/verify", methods=['GET', 'POST'])
def verify():
    requestID = ""
    ccw = CommonCheckWidget(requestID)
    if request.method == "POST":
        try:
            if request.files:
                encryptionFile = request.files["file"]
                if request.headers.get('Request-ID'):
                    requestID = request.headers['Request-ID']
                    print("Request-ID")
                    print(requestID)
                ccw = CommonCheckWidget(requestID)

                dir = tempfile.gettempdir()
                filename = secure_filename(encryptionFile.filename)
                encryptionFile.save(os.path.join(dir, filename))
                result = ccw.verify_by_path_async(os.path.join(dir, filename))

                
                print("RESULT")
                print(result)               
                return result
            else:
                print("NO FILE")
                return Response(json.dumps(ccw.get_error_message("NO FILE")), mimetype='application/json')
        except:
            print("ERROR")
            return Response(json.dumps(ccw.get_error_message("ERROR")), mimetype='application/json')
        

    return Response(json.dumps(ccw.get_error_message("NO REQUEST")), mimetype='application/json')


if __name__ == '__main__':
    app.run(debug=True, host='0.0.0.0', port=5005)
```

## Example in dotNET
Dependency libaries
```
    <PackageReference Include="Affinidi.Common.Check.Widget.Backend.Lib" Version="x.x.x" />
    <PackageReference Include="Microsoft.AspNet.WebApi" Version="5.2.7" />
    <PackageReference Include="Swashbuckle.AspNetCore" Version="5.6.3" />
```
Sample Code
```C#
using System;
using Microsoft.AspNetCore.Mvc;
using Affinidi.Common.Check.Widget.Backend.Lib;
namespace common_check_widget_demo_backend_dotnet.Controllers
{
    [ApiController]
    [Route("[controller]")]
    public class apiController : ControllerBase
    {
        private const string V = "5000";

        [HttpPost("v1/verify")]
        [HttpPost, DisableRequestSizeLimit]
        public  IActionResult Upload()
        {
            var requestID = "";
            CommonCheckWidget ccw = new CommonCheckWidget(requestID);
            try
            {

                var files = HttpContext.Request.Form.Files;
                if(HttpContext.Request.Headers.ContainsKey("Request-ID"))
                {
                    requestID = HttpContext.Request.Headers["Request-ID"];
                }
                
                ccw = new CommonCheckWidget(requestID);
                if (files.Count>0)
                {
                    var file = files[0];
                    var path = System.IO.Path.GetTempPath();
                    var filePath = System.IO.Path.Combine(path, file.FileName);
                
                    using (System.IO.Stream fileStream = new System.IO.FileStream(filePath, System.IO.FileMode.Create)) {
                        file.CopyToAsync(fileStream);
                    }
                    if (file.Length > 0)
                    {
                        
                        var result = ccw.VerifyByPathAsync(filePath);

                        return Ok(result);
                        
                    }

                    return Ok(ccw.GetErrorMessage(""));
                }
                return Ok(ccw.GetErrorMessage());
            }
            catch (Exception ex)
            {
                Console.Write(ex.ToString());
                return Ok(ccw.GetErrorMessage());
            }
        }
    }
}
```

## Example in Java
Dependency libaries
```
		<dependency>
			<groupId>org.springframework.boot</groupId>
			<artifactId>spring-boot-starter-web</artifactId>
		</dependency>

		<dependency>
		    <groupId>com.affinidi.stg</groupId>
			<artifactId>affinidi-ccw-backendlib</artifactId>
			<version>1.2.0</version>
		</dependency>
```
Sample Code
```Java
package affinidi.commoncheckwidget.demobackendjava.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

import affinidi.commoncheckwidget.demobackendjava.payload.UploadFileResponse;
import affinidi.commoncheckwidget.demobackendjava.service.FileStorageService;

import com.fasterxml.jackson.databind.util.JSONPObject;

import org.affinity.project.CommonCheckWidget;


@RestController
@RequestMapping(value = "/api")
public class FileController {

    @Autowired
    private FileStorageService fileStorageService;

    @RequestMapping(value = "/v1/verify", method = RequestMethod.POST, consumes = { "multipart/form-data" } )
    public JSONPObject uploadFile(@RequestParam("file") MultipartFile file, @RequestParam("Request-ID") String requestID) {
        String fileName = fileStorageService.storeFile(file);
        CommonCheckWidget ccw = new CommonCheckWidget(requestID);
    
        JSONPObject result = verifyByPathAsync("/temp/uploads/"+fileName)

        return result;
    }
    
}
```

# The Common Check Widget Documentation

Here is our common check widget link: https://doc.common-check-widget.affinity-project.org/#/

