/*
 * Decompiled with CFR 0.152.
 */
package ujson;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import ujson.Arr;
import ujson.Arr$;
import ujson.AstTransformer;
import ujson.Bool$;
import ujson.False$;
import ujson.JsVisitor;
import ujson.Null$;
import ujson.Num;
import ujson.Num$;
import ujson.Obj;
import ujson.Obj$;
import ujson.Str;
import ujson.Str$;
import ujson.Transformer;
import ujson.True$;
import ujson.Value;
import upickle.core.ObjVisitor;
import upickle.core.Util$;
import upickle.core.Visitor;

public final class Value$
implements AstTransformer<Value> {
    public static final Value$ MODULE$ = new Value$();
    private static final Str$ Str;
    private static final Obj$ Obj;
    private static final Arr$ Arr;
    private static final Num$ Num;
    private static final Bool$ Bool;
    private static final True$ True;
    private static final False$ False;
    private static final Null$ Null;

    static {
        Transformer.$init$(MODULE$);
        Visitor.$init$(MODULE$);
        JsVisitor.$init$(MODULE$);
        AstTransformer.$init$(MODULE$);
        Str = Str$.MODULE$;
        Obj = Obj$.MODULE$;
        Arr = Arr$.MODULE$;
        Num = Num$.MODULE$;
        Bool = Bool$.MODULE$;
        True = True$.MODULE$;
        False = False$.MODULE$;
        Null = Null$.MODULE$;
    }

    @Override
    public <T> T transformArray(Visitor<?, T> f, Iterable<Value> items) {
        return (T)AstTransformer.transformArray$(this, f, items);
    }

    @Override
    public <T> T transformObject(Visitor<?, T> f, Iterable<Tuple2<String, Value>> items) {
        return (T)AstTransformer.transformObject$(this, f, items);
    }

    @Override
    public Object visitFloat64String(String s, int index) {
        return JsVisitor.visitFloat64String$(this, s, index);
    }

    @Override
    public ObjVisitor<Value, Value> visitObject(int length, boolean jsonableKeys, int index) {
        return JsVisitor.visitObject$(this, length, jsonableKeys, index);
    }

    public True$ True() {
        return True;
    }

    @Override
    public <T> T transform(Value j, Visitor<?, T> f) {
        T t;
        Value value = j;
        if (Null$.MODULE$.equals(value)) {
            t = f.visitNull(-1);
        } else if (True$.MODULE$.equals(value)) {
            t = f.visitTrue(-1);
        } else if (False$.MODULE$.equals(value)) {
            t = f.visitFalse(-1);
        } else if (value instanceof Str) {
            Str str = (Str)value;
            String s = str.value();
            t = f.visitString(s, -1);
        } else if (value instanceof Num) {
            Num num = (Num)value;
            double d = num.value();
            t = f.visitFloat64(d, -1);
        } else if (value instanceof Arr) {
            Arr arr = (Arr)value;
            Object items = arr.value();
            t = this.transformArray(f, (Iterable<Value>)items);
        } else if (value instanceof Obj) {
            Obj obj = (Obj)value;
            Object items = obj.value();
            t = this.transformObject(f, (Iterable<Tuple2<String, Value>>)items);
        } else {
            throw new MatchError(value);
        }
        return t;
    }

    public AstTransformer.AstArrVisitor<ArrayBuffer> visitArray(int length, int index) {
        return new AstTransformer.AstArrVisitor<ArrayBuffer>(this, (Function1<ArrayBuffer, Arr> & Serializable)xs -> new Arr((ArrayBuffer<Value>)xs), ArrayBuffer$.MODULE$.iterableFactory());
    }

    public AstTransformer.AstObjVisitor<LinkedHashMap<String, Value>> visitJsonableObject(int length, int index) {
        return new AstTransformer.AstObjVisitor<LinkedHashMap<String, Value>>(this, (Function1<LinkedHashMap, Obj> & Serializable)xs -> new Obj((LinkedHashMap<String, Value>)xs), LinkedHashMap$.MODULE$.mapFactory());
    }

    @Override
    public Null$ visitNull(int index) {
        return Null$.MODULE$;
    }

    @Override
    public False$ visitFalse(int index) {
        return False$.MODULE$;
    }

    @Override
    public True$ visitTrue(int index) {
        return this.True();
    }

    @Override
    public Num visitFloat64StringParts(CharSequence s, int decIndex, int expIndex, int index) {
        return new Num(decIndex != -1 || expIndex != -1 ? StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(((Object)s).toString())) : (double)Util$.MODULE$.parseIntegralNum(s, decIndex, expIndex, index));
    }

    @Override
    public Num visitFloat64(double d, int index) {
        return new Num(d);
    }

    @Override
    public Str visitString(CharSequence s, int index) {
        return new Str(((Object)s).toString());
    }

    private Value$() {
    }
}

