/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.data;

import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple9;
import scala.collection.AbstractIterable;
import scala.collection.AbstractMap;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.Map$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Random;
import textworldexpress.data.RecipeIngredient;
import textworldexpress.data.TWKitchenObject;
import textworldexpress.objects.FastObject;
import ujson.Arr;
import ujson.Obj;
import ujson.Readable$;
import ujson.Str;
import ujson.Value;
import ujson.package$;

public class LoadTWKitchenDataJSON {
    private final /* synthetic */ Tuple9 x$1;
    private final TWKitchenObject[] allObjs;
    private final Map<String, TWKitchenObject> lutObj;
    private final Map<String, ArrayBuffer<TWKitchenObject>> lutLocation;
    private final Set<String> foodSplitsTrain;
    private final Set<String> foodSplitsDev;
    private final Set<String> foodSplitsTest;
    private final Map<String, Set<String>[]> foodPrepTrain;
    private final Map<String, Set<String>[]> foodPrepDev;
    private final Map<String, Set<String>[]> foodPrepTest;

    public Map<String, TWKitchenObject> lutObj() {
        return this.lutObj;
    }

    public Map<String, ArrayBuffer<TWKitchenObject>> lutLocation() {
        return this.lutLocation;
    }

    public Map<String, Set<String>[]> foodPrepTrain() {
        return this.foodPrepTrain;
    }

    public Map<String, Set<String>[]> foodPrepDev() {
        return this.foodPrepDev;
    }

    public Map<String, Set<String>[]> foodPrepTest() {
        return this.foodPrepTest;
    }

    public FastObject mkFastObjectByName(String name) {
        return ((TWKitchenObject)this.lutObj().apply(name)).toFastObject();
    }

    public Option<FastObject> mkRandomObjectByLocation(Random r, String location) {
        if (!this.lutLocation().contains(location)) {
            return None$.MODULE$;
        }
        ArrayBuffer validObjects = (ArrayBuffer)this.lutLocation().apply(location);
        if (validObjects.isEmpty()) {
            return None$.MODULE$;
        }
        int randIdx = r.nextInt(validObjects.length());
        FastObject obj = ((TWKitchenObject)validObjects.apply(randIdx)).toFastObject();
        return new Some<FastObject>(obj);
    }

    public ArrayBuffer<RecipeIngredient> mkRandomRecipe(Random r, int numIngredients, String fold) {
        Map<String, Set<String>[]> map;
        String string = fold;
        String string2 = "train";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            map = this.foodPrepTrain();
        } else {
            String string3 = fold;
            String string4 = "dev";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                map = this.foodPrepDev();
            } else {
                String string5 = fold;
                String string6 = "test";
                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                    map = this.foodPrepTest();
                } else {
                    throw new RuntimeException(new StringBuilder(60).append("ERROR: Unknown fold (").append(fold).append("). Should be 'train', 'dev, 'or 'test'.").toString());
                }
            }
        }
        Map<String, Set<String>[]> validFoodPreps = map;
        String[] ingredientKeys = (String[])validFoodPreps.keySet().toArray(ClassTag$.MODULE$.apply(String.class));
        ArrayBuffer<Integer> randIngredientIdxs = new ArrayBuffer<Integer>();
        for (int attempts = 0; randIngredientIdxs.length() < numIngredients && attempts < 100; ++attempts) {
            int randIdx = r.nextInt(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(ingredientKeys)));
            Object object = !randIngredientIdxs.contains(BoxesRunTime.boxToInteger(randIdx)) ? randIngredientIdxs.append(BoxesRunTime.boxToInteger(randIdx)) : BoxedUnit.UNIT;
        }
        ArrayBuffer<RecipeIngredient> ingredients = new ArrayBuffer<RecipeIngredient>();
        randIngredientIdxs.foreach((Function1<Object, ArrayBuffer> & Serializable)idx -> LoadTWKitchenDataJSON.$anonfun$mkRandomRecipe$1(ingredientKeys, validFoodPreps, r, ingredients, BoxesRunTime.unboxToInt(idx)));
        return ingredients;
    }

    public Tuple9<TWKitchenObject[], Map<String, TWKitchenObject>, Map<String, ArrayBuffer<TWKitchenObject>>, Set<String>, Set<String>, Set<String>, Map<String, Set<String>[]>, Map<String, Set<String>[]>, Map<String, Set<String>[]>> load(String filenameIn) {
        String jsonString = Source$.MODULE$.fromFile(filenameIn, Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString();
        LinkedHashMap dataRaw = (LinkedHashMap)package$.MODULE$.read(Readable$.MODULE$.fromString(jsonString), package$.MODULE$.read$default$2()).value();
        Object foodsCompact = ((Obj)dataRaw.apply("FOODS_COMPACT")).value();
        ArrayBuffer out = new ArrayBuffer();
        ((LinkedHashMap)foodsCompact).keySet().foreach(arg_0 -> LoadTWKitchenDataJSON.$anonfun$load$1((LinkedHashMap)foodsCompact, out, arg_0));
        scala.collection.mutable.Map lutObj = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        out.foreach((Function1<TWKitchenObject, Object> & Serializable)obj -> {
            lutObj.update(obj.name(), obj);
            return BoxedUnit.UNIT;
        });
        scala.collection.mutable.Map lutLocation = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        out.foreach((Function1<TWKitchenObject, Object> & Serializable)obj -> {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(obj.locations()), (Function1<String, ArrayBuffer> & Serializable)location -> {
                block0: {
                    if (lutLocation$1.contains(location)) break block0;
                    lutLocation$1.update(location, new ArrayBuffer());
                }
                return (ArrayBuffer)((Buffer)lutLocation$1.apply(location)).append(obj);
            });
            return BoxedUnit.UNIT;
        });
        Object foodSplits = ((Obj)dataRaw.apply("FOODS_SPLITS")).value();
        Set foodSplitsTrain = ((IterableOnceOps)((ArrayBuffer)((Arr)((AbstractMap)foodSplits).apply("train")).value()).map((Function1<Value, String> & Serializable)x$5 -> x$5.toString().replaceAll("\"", ""))).toSet();
        Set foodSplitsDev = ((IterableOnceOps)((ArrayBuffer)((Arr)((AbstractMap)foodSplits).apply("valid")).value()).map((Function1<Value, String> & Serializable)x$6 -> x$6.toString().replaceAll("\"", ""))).toSet();
        Set foodSplitsTest = ((IterableOnceOps)((ArrayBuffer)((Arr)((AbstractMap)foodSplits).apply("test")).value()).map((Function1<Value, String> & Serializable)x$7 -> x$7.toString().replaceAll("\"", ""))).toSet();
        Object foodPreparationsSplits = ((Obj)dataRaw.apply("FOOD_PREPARATIONS_SPLITS")).value();
        Object foodPrepsTrainRaw = ((Obj)((AbstractMap)foodPreparationsSplits).apply("train")).value();
        scala.collection.mutable.Map foodPrepsTrain = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        ((LinkedHashMap)foodPrepsTrainRaw).foreach((Function1<Tuple2, Object> & Serializable)elem -> {
            LoadTWKitchenDataJSON.$anonfun$load$12(foodPrepsTrain, elem);
            return BoxedUnit.UNIT;
        });
        Object foodPrepsDevRaw = ((Obj)((AbstractMap)foodPreparationsSplits).apply("valid")).value();
        scala.collection.mutable.Map foodPrepsDev = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        ((LinkedHashMap)foodPrepsDevRaw).foreach((Function1<Tuple2, Object> & Serializable)elem -> {
            LoadTWKitchenDataJSON.$anonfun$load$15(foodPrepsDev, elem);
            return BoxedUnit.UNIT;
        });
        Object foodPrepsTestRaw = ((Obj)((AbstractMap)foodPreparationsSplits).apply("test")).value();
        scala.collection.mutable.Map foodPrepsTest = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        ((LinkedHashMap)foodPrepsTestRaw).foreach((Function1<Tuple2, Object> & Serializable)elem -> {
            LoadTWKitchenDataJSON.$anonfun$load$18(foodPrepsTest, elem);
            return BoxedUnit.UNIT;
        });
        return new Tuple9(out.toArray(ClassTag$.MODULE$.apply(TWKitchenObject.class)), lutObj.toMap($less$colon$less$.MODULE$.refl()), lutLocation.toMap($less$colon$less$.MODULE$.refl()), foodSplitsTrain, foodSplitsDev, foodSplitsTest, foodPrepsTrain.toMap($less$colon$less$.MODULE$.refl()), foodPrepsDev.toMap($less$colon$less$.MODULE$.refl()), foodPrepsTest.toMap($less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$mkRandomRecipe$1(String[] ingredientKeys$1, Map validFoodPreps$1, Random r$1, ArrayBuffer ingredients$1, int idx) {
        String name = ingredientKeys$1[idx];
        Set[] possiblePreps = (Set[])validFoodPreps$1.apply(name);
        int randIdx = r$1.nextInt(possiblePreps.length);
        Set randPrep = possiblePreps[randIdx];
        RecipeIngredient recipeIngredient = new RecipeIngredient(name, randPrep);
        return (ArrayBuffer)ingredients$1.append(recipeIngredient);
    }

    public static final /* synthetic */ Object $anonfun$load$1(LinkedHashMap foodsCompact$1, ArrayBuffer out$1, String key) {
        Object object;
        Object record = ((Obj)foodsCompact$1.apply(key)).value();
        String name = key;
        ObjectRef<String> indefinite = ObjectRef.create("");
        if (((LinkedHashMap)record).contains("indefinite")) {
            indefinite.elem = ((Str)((AbstractMap)record).apply("indefinite")).toString().replaceAll("\"", "");
        }
        Set<String> properties = ((IterableOnceOps)((ArrayBuffer)((Arr)((AbstractMap)record).apply("properties")).value()).map((Function1<Value, String> & Serializable)x$2 -> x$2.toString().replaceAll("\"", ""))).toSet();
        String[] locations = (String[])((IterableOnceOps)((ArrayBuffer)((Arr)((AbstractMap)record).apply("locations")).value()).map((Function1<Value, String> & Serializable)x$3 -> (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps(x$3.toString().replaceAll("\"", "").split("\\."))))).toArray(ClassTag$.MODULE$.apply(String.class));
        String[] alternateNames = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        if (((LinkedHashMap)record).contains("names")) {
            alternateNames = (String[])((IterableOnceOps)((ArrayBuffer)((Arr)((AbstractMap)record).apply("names")).value()).map((Function1<Value, String> & Serializable)x$4 -> (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps(x$4.toString().replaceAll("\"", "").split("\\."))))).toArray(ClassTag$.MODULE$.apply(String.class));
        }
        if (alternateNames.length == 0) {
            object = out$1.append(new TWKitchenObject(name, (String)indefinite.elem, properties, locations));
        } else {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(alternateNames), (Function1<String, ArrayBuffer> & Serializable)altName -> (ArrayBuffer)out$1.append(new TWKitchenObject((String)altName, (String)indefinite$1.elem, properties, locations)));
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public static final /* synthetic */ void $anonfun$load$12(scala.collection.mutable.Map foodPrepsTrain$1, Tuple2 elem) {
        ArrayBuffer preps = new ArrayBuffer();
        String foodName = (String)elem._1();
        Object prepList = ((Arr)elem._2()).value();
        ((AbstractIterable)prepList).foreach((Function1<Value, ArrayBuffer> & Serializable)onePrep -> (ArrayBuffer)preps.append(((IterableOnceOps)((ArrayBuffer)((Arr)onePrep).value()).map((Function1<Value, String> & Serializable)x$8 -> x$8.toString().replaceAll("\"", ""))).toSet()));
        foodPrepsTrain$1.update(foodName, preps.toArray(ClassTag$.MODULE$.apply(Set.class)));
    }

    public static final /* synthetic */ void $anonfun$load$15(scala.collection.mutable.Map foodPrepsDev$1, Tuple2 elem) {
        ArrayBuffer preps = new ArrayBuffer();
        String foodName = (String)elem._1();
        Object prepList = ((Arr)elem._2()).value();
        ((AbstractIterable)prepList).foreach((Function1<Value, ArrayBuffer> & Serializable)onePrep -> (ArrayBuffer)preps.append(((IterableOnceOps)((ArrayBuffer)((Arr)onePrep).value()).map((Function1<Value, String> & Serializable)x$9 -> x$9.toString().replaceAll("\"", ""))).toSet()));
        foodPrepsDev$1.update(foodName, preps.toArray(ClassTag$.MODULE$.apply(Set.class)));
    }

    public static final /* synthetic */ void $anonfun$load$18(scala.collection.mutable.Map foodPrepsTest$1, Tuple2 elem) {
        ArrayBuffer preps = new ArrayBuffer();
        String foodName = (String)elem._1();
        Object prepList = ((Arr)elem._2()).value();
        ((AbstractIterable)prepList).foreach((Function1<Value, ArrayBuffer> & Serializable)onePrep -> (ArrayBuffer)preps.append(((IterableOnceOps)((ArrayBuffer)((Arr)onePrep).value()).map((Function1<Value, String> & Serializable)x$10 -> x$10.toString().replaceAll("\"", ""))).toSet()));
        foodPrepsTest$1.update(foodName, preps.toArray(ClassTag$.MODULE$.apply(Set.class)));
    }

    public LoadTWKitchenDataJSON(String filename) {
        Tuple9<TWKitchenObject[], Map<String, TWKitchenObject>, Map<String, ArrayBuffer<TWKitchenObject>>, Set<String>, Set<String>, Set<String>, Map<String, Set<String>[]>, Map<String, Set<String>[]>, Map<String, Set<String>[]>> tuple9 = this.load(filename);
        if (tuple9 == null) {
            throw new MatchError(tuple9);
        }
        TWKitchenObject[] allObjs = tuple9._1();
        Map<String, TWKitchenObject> lutObj = tuple9._2();
        Map<String, ArrayBuffer<TWKitchenObject>> lutLocation = tuple9._3();
        Set<String> foodSplitsTrain = tuple9._4();
        Set<String> foodSplitsDev = tuple9._5();
        Set<String> foodSplitsTest = tuple9._6();
        Map<String, Set<String>[]> foodPrepTrain = tuple9._7();
        Map<String, Set<String>[]> foodPrepDev = tuple9._8();
        Map<String, Set<String>[]> foodPrepTest = tuple9._9();
        Tuple9<TWKitchenObject[], Map<String, TWKitchenObject>, Map<String, ArrayBuffer<TWKitchenObject>>, Set<String>, Set<String>, Set<String>, Map<String, Set<String>[]>, Map<String, Set<String>[]>, Map<String, Set<String>[]>> tuple92 = new Tuple9<TWKitchenObject[], Map<String, TWKitchenObject>, Map<String, ArrayBuffer<TWKitchenObject>>, Set<String>, Set<String>, Set<String>, Map<String, Set<String>[]>, Map<String, Set<String>[]>, Map<String, Set<String>[]>>(allObjs, lutObj, lutLocation, foodSplitsTrain, foodSplitsDev, foodSplitsTest, foodPrepTrain, foodPrepDev, foodPrepTest);
        this.x$1 = tuple92;
        this.allObjs = (TWKitchenObject[])this.x$1._1();
        this.lutObj = (Map)this.x$1._2();
        this.lutLocation = (Map)this.x$1._3();
        this.foodSplitsTrain = (Set)this.x$1._4();
        this.foodSplitsDev = (Set)this.x$1._5();
        this.foodSplitsTest = (Set)this.x$1._6();
        this.foodPrepTrain = (Map)this.x$1._7();
        this.foodPrepDev = (Map)this.x$1._8();
        this.foodPrepTest = (Map)this.x$1._9();
    }
}

