/*
 * Decompiled with CFR 0.152.
 */
package scala.reflect.io;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.internal.JDK9Reflectors;
import scala.reflect.io.FileZipArchive$zipFilePool$;
import scala.reflect.io.ZipArchive;
import scala.reflect.io.ZipArchive$;

public final class FileZipArchive
extends ZipArchive {
    private volatile FileZipArchive$zipFilePool$ zipFilePool$module;
    private ZipArchive.DirEntry root;
    private final Option<String> release;
    private final HashMap<String, ZipArchive.DirEntry> dirs;
    private volatile byte bitmap$0;

    public FileZipArchive$zipFilePool$ scala$reflect$io$FileZipArchive$$zipFilePool() {
        if (this.zipFilePool$module == null) {
            this.zipFilePool$lzycompute$1();
        }
        return this.zipFilePool$module;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ZipFile scala$reflect$io$FileZipArchive$$openZipFile() {
        try {
            Option<String> option = this.release;
            if (!(option instanceof Some)) return new ZipFile(super.file());
            String r = (String)((Some)option).value();
            if (!super.file().getName().endsWith(".jar")) return new ZipFile(super.file());
            Object releaseVersion = JDK9Reflectors.runtimeVersionParse(r);
            return JDK9Reflectors.newJarFile(super.file(), true, 1, releaseVersion);
        }
        catch (IOException ioe) {
            throw new IOException(new StringBuilder(16).append("Error accessing ").append(super.file().getPath()).toString(), ioe);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ZipArchive.DirEntry root$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var1_1;
                ZipArchive.DirEntry root = new ZipArchive.DirEntry(this, "/");
                this.dirs.put("/", root);
                ZipFile zipFile = this.scala$reflect$io$FileZipArchive$$openZipFile();
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                try {
                    while (entries.hasMoreElements()) {
                        ZipEntry zipEntry = entries.nextElement();
                        if (zipEntry.getName().startsWith("META-INF/versions/") || zipEntry.isDirectory()) continue;
                        ZipArchive.DirEntry dir = this.getDir(this.dirs, zipEntry);
                        ZipEntry mrEntry = this.release.isDefined() ? zipFile.getEntry(zipEntry.getName()) : zipEntry;
                        ZipArchive.Entry f = ZipArchive$.MODULE$.closeZipFile() ? new LazyEntry(this, zipEntry.getName(), mrEntry.getTime(), (int)mrEntry.getSize()) : new LeakyEntry(this, zipEntry.getName(), mrEntry.getTime(), (int)mrEntry.getSize());
                        dir.entries().update(f.name(), f);
                    }
                }
                finally {
                    if (!ZipArchive$.MODULE$.closeZipFile()) {
                        this.scala$reflect$io$FileZipArchive$$zipFilePool().release(zipFile);
                    }
                }
                this.root = var1_1;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.root;
    }

    public ZipArchive.DirEntry root() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.root$lzycompute();
        }
        return this.root;
    }

    @Override
    public Iterator<ZipArchive.Entry> iterator() {
        return this.root().iterator();
    }

    @Override
    public String path() {
        return super.file().getPath();
    }

    public int hashCode() {
        return super.file().hashCode();
    }

    public boolean equals(Object that) {
        boolean bl;
        if (that instanceof FileZipArchive) {
            FileZipArchive fileZipArchive = (FileZipArchive)that;
            File file = super.file().getAbsoluteFile();
            File file2 = fileZipArchive.file().getAbsoluteFile();
            bl = !(file != null ? !((Object)file).equals(file2) : file2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public void close() {
        this.scala$reflect$io$FileZipArchive$$zipFilePool().close();
    }

    private final void zipFilePool$lzycompute$1() {
        synchronized (this) {
            if (this.zipFilePool$module == null) {
                this.zipFilePool$module = new FileZipArchive$zipFilePool$(this);
            }
            return;
        }
    }

    private class LazyEntry
    extends ZipArchive.Entry {
        private final long time;
        private final int size;

        public LazyEntry(FileZipArchive $outer, String name, long time, int size) {
            this.time = time;
            this.size = size;
            super($outer, name);
        }
    }

    private class LeakyEntry
    extends ZipArchive.Entry {
        private final long time;
        private final int size;

        public LeakyEntry(FileZipArchive $outer, String name, long time, int size) {
            this.time = time;
            this.size = size;
            super($outer, name);
        }
    }
}

