/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.util.NoSuchElementException;
import scala.Function1;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.LinearSeqOps;
import scala.collection.SeqFactory;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.generic.DefaultSerializable;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.MutationTracker;
import scala.collection.mutable.ReusableBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Statics;

public class ListBuffer<A>
extends AbstractBuffer<A>
implements StrictOptimizedSeqOps<A, ListBuffer, ListBuffer<A>>,
DefaultSerializable,
ReusableBuilder<A, List<A>> {
    private transient int mutationCount = 0;
    private List<A> first = Nil$.MODULE$;
    private $colon$colon<A> last0 = null;
    private boolean aliased = false;
    private int len = 0;

    @Override
    public void sizeHint(int size) {
        Builder.sizeHint$(this, size);
    }

    @Override
    public <NewTo> Builder<A, NewTo> mapResult(Function1<List<A>, NewTo> f) {
        return Builder.mapResult$(this, f);
    }

    @Override
    public Object distinctBy(Function1 f) {
        return StrictOptimizedSeqOps.distinctBy$(this, f);
    }

    @Override
    public Object appended(Object elem) {
        return StrictOptimizedSeqOps.appended$(this, elem);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    private List<A> first() {
        return this.first;
    }

    private void first_$eq(List<A> x$1) {
        this.first = x$1;
    }

    private $colon$colon<A> last0() {
        return this.last0;
    }

    private void last0_$eq($colon$colon<A> x$1) {
        this.last0 = x$1;
    }

    @Override
    public Iterator<A> iterator() {
        return new MutationTracker.CheckedIterator<A>(this.first().iterator(), () -> $this.mutationCount);
    }

    @Override
    public SeqFactory<ListBuffer> iterableFactory() {
        return ListBuffer$.MODULE$;
    }

    @Override
    public A apply(int i) throws IndexOutOfBoundsException {
        List<A> list = this.first();
        if (list == null) {
            throw null;
        }
        return (A)LinearSeqOps.apply$(list, i);
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public int knownSize() {
        return this.len;
    }

    @Override
    public boolean isEmpty() {
        return this.len == 0;
    }

    private void copyElems() {
        ListBuffer<A> buf = new ListBuffer<A>().scala$collection$mutable$ListBuffer$$freshFrom(this);
        this.first_$eq(super.first());
        this.last0_$eq(super.last0());
        this.aliased = false;
    }

    private void ensureUnaliased() {
        ++this.mutationCount;
        if (this.aliased) {
            this.copyElems();
        }
    }

    @Override
    public List<A> toList() {
        this.aliased = this.nonEmpty();
        Statics.releaseFence();
        return this.first();
    }

    @Override
    public List<A> result() {
        return this.toList();
    }

    public List<A> prependToList(List<A> xs) {
        if (this.isEmpty()) {
            return xs;
        }
        this.ensureUnaliased();
        this.last0().next_$eq(xs);
        return this.toList();
    }

    @Override
    public void clear() {
        ++this.mutationCount;
        this.first_$eq(Nil$.MODULE$);
        this.len = 0;
        this.last0_$eq(null);
        this.aliased = false;
    }

    @Override
    public final ListBuffer<A> addOne(A elem) {
        this.ensureUnaliased();
        $colon$colon<Nothing$> last1 = new $colon$colon<Nothing$>((Nothing$)elem, Nil$.MODULE$);
        if (this.len == 0) {
            this.first_$eq(last1);
        } else {
            this.last0().next_$eq(last1);
        }
        this.last0_$eq(last1);
        ++this.len;
        return this;
    }

    public ListBuffer<A> scala$collection$mutable$ListBuffer$$freshFrom(IterableOnce<A> xs) {
        Iterator<A> it = xs.iterator();
        if (it.hasNext()) {
            int len = 1;
            $colon$colon<Nothing$> last0 = new $colon$colon<Nothing$>((Nothing$)it.next(), Nil$.MODULE$);
            this.first_$eq(last0);
            while (it.hasNext()) {
                $colon$colon<Nothing$> last1 = new $colon$colon<Nothing$>((Nothing$)it.next(), Nil$.MODULE$);
                last0.next_$eq(last1);
                last0 = last1;
                ++len;
            }
            this.len = len;
            this.last0_$eq(last0);
        }
        return this;
    }

    @Override
    public final ListBuffer<A> addAll(IterableOnce<A> xs) {
        Iterator<A> it = xs.iterator();
        if (it.hasNext()) {
            ListBuffer<A> fresh = new ListBuffer<A>().scala$collection$mutable$ListBuffer$$freshFrom(it);
            this.ensureUnaliased();
            if (this.len == 0) {
                this.first_$eq(super.first());
            } else {
                this.last0().next_$eq(super.first());
            }
            this.last0_$eq(super.last0());
            this.len += fresh.length();
        }
        return this;
    }

    @Override
    public ListBuffer<A> subtractOne(A elem) {
        this.ensureUnaliased();
        if (!this.isEmpty()) {
            if (BoxesRunTime.equals(this.first().head(), elem)) {
                this.first_$eq((List)this.first().tail());
                this.reduceLengthBy(1);
            } else {
                List cursor = this.first();
                while (!((List)cursor.tail()).isEmpty() && !BoxesRunTime.equals(((IterableOps)cursor.tail()).head(), elem)) {
                    cursor = (List)cursor.tail();
                }
                if (!((List)cursor.tail()).isEmpty()) {
                    $colon$colon z = ($colon$colon)cursor;
                    List list = z.next();
                    $colon$colon<A> $colon$colon = this.last0();
                    if (!(list != null ? !((Object)list).equals($colon$colon) : $colon$colon != null)) {
                        this.last0_$eq(z);
                    }
                    z.next_$eq((List)((IterableOps)cursor.tail()).tail());
                    this.reduceLengthBy(1);
                }
            }
        }
        return this;
    }

    private void reduceLengthBy(int num) {
        this.len -= num;
        if (this.len <= 0) {
            this.last0_$eq(null);
        }
    }

    private $colon$colon<A> locate(int i) {
        if (i == 0) {
            return null;
        }
        if (i == this.len) {
            return this.last0();
        }
        List p = this.first();
        for (int j = i - 1; j > 0; --j) {
            p = (List)p.tail();
        }
        return ($colon$colon)p;
    }

    private List<A> getNext($colon$colon<A> p) {
        if (p == null) {
            return this.first();
        }
        return p.next();
    }

    @Override
    public A remove(int idx) {
        this.ensureUnaliased();
        if (idx < 0 || idx >= this.len) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(idx).append(" is out of bounds (min 0, max ").append(this.len - 1).append(")").toString());
        }
        $colon$colon<A> p = this.locate(idx);
        List<A> nx = this.getNext(p);
        if (p == null) {
            this.first_$eq((List)nx.tail());
            if (this.first().isEmpty()) {
                this.last0_$eq(null);
            }
        } else {
            if (this.last0() == nx) {
                this.last0_$eq(p);
            }
            p.next_$eq((List)nx.tail());
        }
        --this.len;
        return nx.head();
    }

    @Override
    public A last() {
        if (this.last0() == null) {
            throw new NoSuchElementException("last of empty ListBuffer");
        }
        return this.last0().head();
    }

    @Override
    public String stringPrefix() {
        return "ListBuffer";
    }
}

