/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import scala.Function0;
import scala.Function1;
import scala.collection.AbstractIndexedSeqView;
import scala.collection.IndexedSeqOps;
import scala.collection.IndexedSeqView;
import scala.collection.Iterator;
import scala.collection.mutable.MutationTracker$;

public interface CheckedIndexedSeqView<A>
extends IndexedSeqView<A> {
    public Function0<Object> mutationCount();

    @Override
    default public Iterator<A> iterator() {
        return new CheckedIterator(this, this.mutationCount());
    }

    @Override
    default public Iterator<A> reverseIterator() {
        return new CheckedReverseIterator(this, this.mutationCount());
    }

    @Override
    default public <B> IndexedSeqView<B> appended(B elem) {
        return new Appended<B>(this, elem, this.mutationCount());
    }

    @Override
    default public IndexedSeqView<A> drop(int n) {
        return new Drop(this, n, this.mutationCount());
    }

    @Override
    default public <B$> IndexedSeqView<B$> map(Function1<A, B$> f) {
        return new Map<A, B$>(this, f, this.mutationCount());
    }

    @Override
    default public IndexedSeqView<A> slice(int from, int until) {
        return new Slice(this, from, until, this.mutationCount());
    }

    public static class Appended<A>
    extends IndexedSeqView.Appended<A>
    implements CheckedIndexedSeqView<A> {
        private final Function0<Object> mutationCount;

        @Override
        public Iterator<A> iterator() {
            return ((CheckedIndexedSeqView)this).iterator();
        }

        @Override
        public Iterator<A> reverseIterator() {
            return ((CheckedIndexedSeqView)this).reverseIterator();
        }

        @Override
        public <B> IndexedSeqView<B> appended(B elem) {
            return ((CheckedIndexedSeqView)this).appended(elem);
        }

        @Override
        public IndexedSeqView<A> drop(int n) {
            return ((CheckedIndexedSeqView)this).drop(n);
        }

        @Override
        public <B$> IndexedSeqView<B$> map(Function1<A, B$> f) {
            return ((CheckedIndexedSeqView)this).map(f);
        }

        @Override
        public IndexedSeqView<A> slice(int from, int until) {
            return ((CheckedIndexedSeqView)this).slice(from, until);
        }

        @Override
        public Function0<Object> mutationCount() {
            return this.mutationCount;
        }

        public Appended(IndexedSeqOps<A, ?, Object> underlying, A elem, Function0<Object> mutationCount) {
            this.mutationCount = mutationCount;
            super(underlying, elem);
        }
    }

    public static class CheckedIterator<A>
    extends IndexedSeqView.IndexedSeqViewIterator<A> {
        private final Function0<Object> mutationCount;
        private final int expectedCount;

        @Override
        public boolean hasNext() {
            MutationTracker$.MODULE$.checkMutations(this.expectedCount, this.mutationCount.apply$mcI$sp(), "mutation occurred during iteration");
            return super.hasNext();
        }

        public CheckedIterator(IndexedSeqView<A> self, Function0<Object> mutationCount) {
            this.mutationCount = mutationCount;
            super(self);
            this.expectedCount = mutationCount.apply$mcI$sp();
        }
    }

    public static class CheckedReverseIterator<A>
    extends IndexedSeqView.IndexedSeqViewReverseIterator<A> {
        private final Function0<Object> mutationCount;
        private final int expectedCount;

        @Override
        public boolean hasNext() {
            MutationTracker$.MODULE$.checkMutations(this.expectedCount, this.mutationCount.apply$mcI$sp(), "mutation occurred during iteration");
            return super.hasNext();
        }

        public CheckedReverseIterator(IndexedSeqView<A> self, Function0<Object> mutationCount) {
            this.mutationCount = mutationCount;
            super(self);
            this.expectedCount = mutationCount.apply$mcI$sp();
        }
    }

    public static class Drop<A>
    extends IndexedSeqView.Drop<A>
    implements CheckedIndexedSeqView<A> {
        private final Function0<Object> mutationCount;

        @Override
        public Iterator<A> iterator() {
            return ((CheckedIndexedSeqView)this).iterator();
        }

        @Override
        public Iterator<A> reverseIterator() {
            return ((CheckedIndexedSeqView)this).reverseIterator();
        }

        @Override
        public <B> IndexedSeqView<B> appended(B elem) {
            return ((CheckedIndexedSeqView)this).appended(elem);
        }

        @Override
        public IndexedSeqView<A> drop(int n) {
            return ((CheckedIndexedSeqView)this).drop(n);
        }

        @Override
        public <B$> IndexedSeqView<B$> map(Function1<A, B$> f) {
            return ((CheckedIndexedSeqView)this).map(f);
        }

        @Override
        public IndexedSeqView<A> slice(int from, int until) {
            return ((CheckedIndexedSeqView)this).slice(from, until);
        }

        @Override
        public Function0<Object> mutationCount() {
            return this.mutationCount;
        }

        public Drop(IndexedSeqOps<A, ?, Object> underlying, int n, Function0<Object> mutationCount) {
            this.mutationCount = mutationCount;
            super(underlying, n);
        }
    }

    public static class Map<A, B>
    extends IndexedSeqView.Map<A, B>
    implements CheckedIndexedSeqView<B> {
        private final Function0<Object> mutationCount;

        @Override
        public Iterator<B> iterator() {
            return ((CheckedIndexedSeqView)this).iterator();
        }

        @Override
        public Iterator<B> reverseIterator() {
            return ((CheckedIndexedSeqView)this).reverseIterator();
        }

        @Override
        public <B$> IndexedSeqView<B$> appended(B$ elem) {
            return ((CheckedIndexedSeqView)this).appended(elem);
        }

        @Override
        public IndexedSeqView<B> drop(int n) {
            return ((CheckedIndexedSeqView)this).drop(n);
        }

        @Override
        public <B$> IndexedSeqView<B$> map(Function1<B, B$> f) {
            return ((CheckedIndexedSeqView)this).map(f);
        }

        @Override
        public IndexedSeqView<B> slice(int from, int until) {
            return ((CheckedIndexedSeqView)this).slice(from, until);
        }

        @Override
        public Function0<Object> mutationCount() {
            return this.mutationCount;
        }

        public Map(IndexedSeqOps<A, ?, Object> underlying, Function1<A, B> f, Function0<Object> mutationCount) {
            this.mutationCount = mutationCount;
            super(underlying, f);
        }
    }

    public static class Slice<A>
    extends AbstractIndexedSeqView<A>
    implements CheckedIndexedSeqView<A> {
        private final IndexedSeqOps<A, ?, Object> underlying;
        private final Function0<Object> mutationCount;
        private final int lo;
        private final int hi;
        private final int len;

        @Override
        public Iterator<A> iterator() {
            return ((CheckedIndexedSeqView)this).iterator();
        }

        @Override
        public Iterator<A> reverseIterator() {
            return ((CheckedIndexedSeqView)this).reverseIterator();
        }

        @Override
        public <B> IndexedSeqView<B> appended(B elem) {
            return ((CheckedIndexedSeqView)this).appended(elem);
        }

        @Override
        public IndexedSeqView<A> drop(int n) {
            return ((CheckedIndexedSeqView)this).drop(n);
        }

        @Override
        public <B$> IndexedSeqView<B$> map(Function1<A, B$> f) {
            return ((CheckedIndexedSeqView)this).map(f);
        }

        @Override
        public IndexedSeqView<A> slice(int from, int until) {
            return ((CheckedIndexedSeqView)this).slice(from, until);
        }

        @Override
        public Function0<Object> mutationCount() {
            return this.mutationCount;
        }

        public int lo() {
            return this.lo;
        }

        public int hi() {
            return this.hi;
        }

        public int len() {
            return this.len;
        }

        @Override
        public A apply(int i) throws IndexOutOfBoundsException {
            return this.underlying.apply(this.lo() + i);
        }

        @Override
        public int length() {
            return this.len();
        }

        public Slice(IndexedSeqOps<A, ?, Object> underlying, int from, int until, Function0<Object> mutationCount) {
            this.underlying = underlying;
            this.mutationCount = mutationCount;
            int max$extension_that = 0;
            this.lo = Math.max(from, max$extension_that);
            int max$extension_that2 = 0;
            int n = Math.max(until, max$extension_that2);
            int min$extension_that = underlying.length();
            this.hi = Math.min(n, min$extension_that);
            int n2 = this.hi() - this.lo();
            int max$extension_that3 = 0;
            this.len = Math.max(n2, max$extension_that3);
        }
    }
}

