/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.Serializable;
import java.util.Arrays;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.BitSetOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.SortedIterableFactory;
import scala.collection.SortedSet;
import scala.collection.SortedSetFactoryDefaults;
import scala.collection.SortedSetOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSetOps;
import scala.collection.StrictOptimizedSortedSetOps;
import scala.collection.immutable.Range;
import scala.collection.mutable.AbstractSet;
import scala.collection.mutable.BitSet$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.runtime.BoxesRunTime;

public class BitSet
extends AbstractSet<Object>
implements Serializable,
scala.collection.BitSet,
StrictOptimizedSortedSetOps<Object, scala.collection.mutable.SortedSet, BitSet>,
scala.collection.mutable.SortedSet<Object> {
    private long[] elems;

    @Override
    public String stringPrefix() {
        return scala.collection.BitSet.stringPrefix$(this);
    }

    @Override
    public /* synthetic */ int scala$collection$BitSetOps$$super$max(Ordering ord) {
        return BoxesRunTime.unboxToInt(SortedSetOps.max$(this, ord));
    }

    @Override
    public /* synthetic */ int scala$collection$BitSetOps$$super$min(Ordering ord) {
        return BoxesRunTime.unboxToInt(SortedSetOps.min$(this, ord));
    }

    @Override
    public /* synthetic */ scala.collection.BitSet scala$collection$BitSetOps$$super$concat(IterableOnce that) {
        return (scala.collection.BitSet)StrictOptimizedSetOps.concat$(this, that);
    }

    @Override
    public final Ordering<Object> ordering() {
        return BitSetOps.ordering$(this);
    }

    @Override
    public boolean contains(int elem) {
        return BitSetOps.contains$(this, elem);
    }

    @Override
    public Iterator<Object> iterator() {
        return BitSetOps.iterator$(this);
    }

    @Override
    public Iterator<Object> iteratorFrom(int start) {
        return BitSetOps.iteratorFrom$(this, start);
    }

    @Override
    public int size() {
        return BitSetOps.size$(this);
    }

    @Override
    public boolean isEmpty() {
        return BitSetOps.isEmpty$(this);
    }

    @Override
    public <B> int max(Ordering<B> ord) {
        return BitSetOps.max$(this, ord);
    }

    @Override
    public <B> int min(Ordering<B> ord) {
        return BitSetOps.min$(this, ord);
    }

    @Override
    public <U> void foreach(Function1<Object, U> f) {
        BitSetOps.foreach$(this, f);
    }

    @Override
    public scala.collection.BitSet concat(IterableOnce other) {
        return BitSetOps.concat$(this, other);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public SortedIterableFactory<scala.collection.mutable.SortedSet> sortedIterableFactory() {
        return scala.collection.mutable.SortedSet.sortedIterableFactory$(this);
    }

    @Override
    public /* synthetic */ boolean scala$collection$SortedSet$$super$equals(Object that) {
        return Set.equals$(this, that);
    }

    @Override
    public boolean equals(Object that) {
        return SortedSet.equals$(this, that);
    }

    @Override
    public SortedSetOps.WithFilter<Object, ?, ?> withFilter(Function1<Object, Object> p) {
        return SortedSetFactoryDefaults.withFilter$(this, p);
    }

    @Override
    public /* synthetic */ Object scala$collection$SortedSetOps$$super$min(Ordering ord) {
        return IterableOnceOps.min$(this, ord);
    }

    @Override
    public /* synthetic */ Object scala$collection$SortedSetOps$$super$max(Ordering ord) {
        return IterableOnceOps.max$(this, ord);
    }

    public Object firstKey() {
        return SortedSetOps.firstKey$(this);
    }

    public Object lastKey() {
        return SortedSetOps.lastKey$(this);
    }

    public final long[] elems() {
        return this.elems;
    }

    public final void elems_$eq(long[] x$1) {
        this.elems = x$1;
    }

    @Override
    public BitSet fromSpecific(IterableOnce<Object> coll) {
        return this.bitSetFactory().fromSpecific(coll);
    }

    @Override
    public Builder<Object, BitSet> newSpecificBuilder() {
        return this.bitSetFactory().newBuilder();
    }

    @Override
    public BitSet empty() {
        if (this.bitSetFactory() == null) {
            throw null;
        }
        return new BitSet();
    }

    public BitSet$ bitSetFactory() {
        return BitSet$.MODULE$;
    }

    @Override
    public final int nwords() {
        return this.elems().length;
    }

    @Override
    public final long word(int idx) {
        if (idx < this.elems().length) {
            return this.elems()[idx];
        }
        return 0L;
    }

    @Override
    public BitSet fromBitMaskNoCopy(long[] elems) {
        if (elems.length == 0) {
            return this.empty();
        }
        return new BitSet(elems);
    }

    public BitSet addOne(int elem) {
        Predef$.MODULE$.require(elem >= 0);
        if (!this.contains(elem)) {
            int idx = elem >> 6;
            this.updateWord(idx, this.word(idx) | 1L << elem);
        }
        return this;
    }

    public BitSet subtractOne(int elem) {
        Predef$.MODULE$.require(elem >= 0);
        if (this.contains(elem)) {
            int idx = elem >> 6;
            this.updateWord(idx, this.word(idx) & (1L << elem ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return this;
    }

    @Override
    public void clear() {
        this.elems_$eq(new long[this.elems().length]);
    }

    public final void updateWord(int idx, long w) {
        this.ensureCapacity(idx);
        this.elems()[idx] = w;
    }

    public final void ensureCapacity(int idx) {
        Predef$.MODULE$.require(idx < 0x2000000);
        if (idx >= this.elems().length) {
            int newlen = this.elems().length;
            while (idx >= newlen) {
                newlen = Math.min(newlen * 2, 0x2000000);
            }
            long[] elems1 = new long[newlen];
            Array$.MODULE$.copy(this.elems(), 0, elems1, 0, this.elems().length);
            this.elems_$eq(elems1);
        }
    }

    public BitSet $bar$eq(scala.collection.BitSet other) {
        this.ensureCapacity(other.nwords() - 1);
        int othernwords = other.nwords();
        for (int i = 0; i < othernwords; ++i) {
            this.elems()[i] = this.elems()[i] | other.word(i);
        }
        return this;
    }

    @Override
    public BitSet clone() {
        return new BitSet(Arrays.copyOf(this.elems(), this.elems().length));
    }

    public scala.collection.immutable.BitSet toImmutable() {
        return scala.collection.immutable.BitSet$.MODULE$.fromBitMask(this.elems());
    }

    public BitSet addAll(IterableOnce<Object> xs) {
        BitSet bitSet;
        if (xs instanceof scala.collection.BitSet) {
            scala.collection.BitSet bitSet2 = (scala.collection.BitSet)xs;
            bitSet = this.$bar$eq(bitSet2);
        } else if (xs instanceof Range) {
            Range range = (Range)xs;
            if (range.nonEmpty()) {
                int start = range.min(Ordering$Int$.MODULE$);
                if (start >= 0) {
                    int end = range.max(Ordering$Int$.MODULE$);
                    int endIdx = end >> 6;
                    this.ensureCapacity(endIdx);
                    if (range.step() == 1 || range.step() == -1) {
                        int startIdx = start >> 6;
                        int wordStart = startIdx * 64;
                        long wordMask = -1L << start - wordStart;
                        if (endIdx > startIdx) {
                            long[] lArray = this.elems();
                            lArray[startIdx] = lArray[startIdx] | wordMask;
                            Arrays.fill(this.elems(), startIdx + 1, endIdx, -1L);
                            long[] lArray2 = this.elems();
                            lArray2[endIdx] = lArray2[endIdx] | -1L >>> 64 - (end - endIdx * 64) - 1;
                        } else {
                            long[] lArray = this.elems();
                            lArray[endIdx] = lArray[endIdx] | wordMask & -1L >>> 64 - (end - wordStart) - 1;
                        }
                    } else {
                        Growable.addAll$(this, range);
                    }
                } else {
                    Growable.addAll$(this, range);
                }
            }
            bitSet = this;
        } else if (xs instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)xs;
            if (sortedSet.nonEmpty()) {
                Ordering ord = sortedSet.ordering();
                if (ord == Ordering$Int$.MODULE$) {
                    this.ensureCapacity(BoxesRunTime.unboxToInt(sortedSet.lastKey()) >> 6);
                } else if (ord == Ordering$Int$.MODULE$.scala$math$Ordering$CachedReverse$$_reverse()) {
                    this.ensureCapacity(BoxesRunTime.unboxToInt(sortedSet.firstKey()) >> 6);
                }
                Iterator iter = sortedSet.iterator();
                while (iter.hasNext()) {
                    this.addOne(BoxesRunTime.unboxToInt(iter.next()));
                }
            }
            bitSet = this;
        } else {
            bitSet = (BitSet)Growable.addAll$(this, xs);
        }
        return bitSet;
    }

    @Override
    public boolean subsetOf(Set<Object> that) {
        boolean bl;
        if (that instanceof scala.collection.BitSet) {
            scala.collection.BitSet bitSet = (scala.collection.BitSet)that;
            int n = this.elems().length;
            int bsnwords = bitSet.nwords();
            int minWords = Math.min(n, bsnwords);
            for (int i = bsnwords; i < n; ++i) {
                if (this.word(i) == 0L) continue;
                return false;
            }
            for (int j = 0; j < minWords; ++j) {
                if ((this.word(j) & (bitSet.word(j) ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
                return false;
            }
            bl = true;
        } else {
            bl = this.forall(that);
        }
        return bl;
    }

    @Override
    public BitSet filterImpl(Function1<Object, Object> pred, boolean isFlipped) {
        long[] newArray = null;
        for (int i = this.elems().length - 1; i >= 0; --i) {
            long l;
            long l2;
            long computeWordForFilter_oldWord = this.word(i);
            if (computeWordForFilter_oldWord == 0L) {
                l2 = 0L;
            } else {
                long computeWordForFilter_w = computeWordForFilter_oldWord;
                int computeWordForFilter_trailingZeroes = Long.numberOfTrailingZeros(computeWordForFilter_oldWord);
                long computeWordForFilter_jmask = 1L << computeWordForFilter_trailingZeroes;
                int computeWordForFilter_maxJ = (i + 1) * 64 - Long.numberOfLeadingZeros(computeWordForFilter_oldWord);
                for (int computeWordForFilter_j = i * 64 + computeWordForFilter_trailingZeroes; computeWordForFilter_j != computeWordForFilter_maxJ; ++computeWordForFilter_j) {
                    if ((computeWordForFilter_w & computeWordForFilter_jmask) != 0L && pred.apply$mcZI$sp(computeWordForFilter_j) == isFlipped) {
                        computeWordForFilter_w &= computeWordForFilter_jmask ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    computeWordForFilter_jmask <<= 1;
                }
                l2 = l = computeWordForFilter_w;
            }
            if (l == 0L) continue;
            if (newArray == null) {
                newArray = new long[i + 1];
            }
            newArray[i] = l;
        }
        if (newArray == null) {
            return this.empty();
        }
        return this.fromBitMaskNoCopy(newArray);
    }

    public BitSet(long[] elems) {
        this.elems = elems;
    }

    public BitSet(int initSize) {
        this(new long[Math.max(initSize + 63 >> 6, 1)]);
    }

    public BitSet() {
        this(0);
    }
}

