/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.collection.IndexedSeqOps;
import scala.collection.IndexedSeqView;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.generic.DefaultSerializable;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.ArrayDeque$;
import scala.collection.mutable.ArrayDequeOps;
import scala.collection.mutable.IndexedBuffer;
import scala.reflect.ClassTag;

public class ArrayDeque<A>
extends AbstractBuffer<A>
implements DefaultSerializable,
ArrayDequeOps<A, ArrayDeque, ArrayDeque<A>>,
IndexedBuffer<A> {
    private Object[] array;
    private int scala$collection$mutable$ArrayDeque$$start;
    private int scala$collection$mutable$ArrayDeque$$end;

    @Override
    public final Object clone() {
        return ArrayDequeOps.clone$(this);
    }

    @Override
    public Object copySliceToArray(int srcStart, Object dest, int destStart, int maxItems) {
        return ArrayDequeOps.copySliceToArray$(this, srcStart, dest, destStart, maxItems);
    }

    @Override
    public Object slice(int from, int until) {
        return ArrayDequeOps.slice$(this, from, until);
    }

    @Override
    public Object distinctBy(Function1 f) {
        return StrictOptimizedSeqOps.distinctBy$(this, f);
    }

    @Override
    public Object appended(Object elem) {
        return StrictOptimizedSeqOps.appended$(this, elem);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public Iterator<A> iterator() {
        return IndexedSeqOps.iterator$(this);
    }

    @Override
    public Iterator<A> reverseIterator() {
        return IndexedSeqOps.reverseIterator$(this);
    }

    @Override
    public IndexedSeqView<A> view() {
        return IndexedSeqOps.view$(this);
    }

    @Override
    public Iterable<A> reversed() {
        return IndexedSeqOps.reversed$(this);
    }

    @Override
    public Object drop(int n) {
        return IndexedSeqOps.drop$(this, n);
    }

    @Override
    public A head() {
        return (A)IndexedSeqOps.head$(this);
    }

    @Override
    public A last() {
        return (A)IndexedSeqOps.last$(this);
    }

    @Override
    public final int lengthCompare(int len) {
        return IndexedSeqOps.lengthCompare$(this, len);
    }

    @Override
    public Object[] array() {
        return this.array;
    }

    public void array_$eq(Object[] x$1) {
        this.array = x$1;
    }

    public int scala$collection$mutable$ArrayDeque$$start() {
        return this.scala$collection$mutable$ArrayDeque$$start;
    }

    public void scala$collection$mutable$ArrayDeque$$start_$eq(int x$1) {
        this.scala$collection$mutable$ArrayDeque$$start = x$1;
    }

    public int scala$collection$mutable$ArrayDeque$$end() {
        return this.scala$collection$mutable$ArrayDeque$$end;
    }

    public void scala$collection$mutable$ArrayDeque$$end_$eq(int x$1) {
        this.scala$collection$mutable$ArrayDeque$$end = x$1;
    }

    private void reset(Object[] array, int start, int end) {
        if (!((array.length & array.length - 1) == 0)) {
            throw new AssertionError((Object)new StringBuilder(18).append("assertion failed: ").append((Object)"Array.length must be power of 2").toString());
        }
        int requireBounds_until = array.length;
        if (start < 0 || start >= requireBounds_until) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(start).append(" is out of bounds (min 0, max ").append(requireBounds_until - 1).append(")").toString());
        }
        int requireBounds_until2 = array.length;
        if (end < 0 || end >= requireBounds_until2) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(end).append(" is out of bounds (min 0, max ").append(requireBounds_until2 - 1).append(")").toString());
        }
        this.array_$eq(array);
        this.scala$collection$mutable$ArrayDeque$$start_$eq(start);
        this.scala$collection$mutable$ArrayDeque$$end_$eq(end);
    }

    @Override
    public int knownSize() {
        return IndexedSeqOps.knownSize$(this);
    }

    @Override
    public A apply(int idx) {
        int n = this.length();
        if (idx < 0 || idx >= n) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(idx).append(" is out of bounds (min 0, max ").append(n - 1).append(")").toString());
        }
        return (A)this.array()[this.start_$plus(idx)];
    }

    @Override
    public ArrayDeque<A> addOne(A elem) {
        this.ensureSize(this.length() + 1);
        return this.scala$collection$mutable$ArrayDeque$$appendAssumingCapacity(elem);
    }

    public ArrayDeque<A> scala$collection$mutable$ArrayDeque$$appendAssumingCapacity(A elem) {
        this.array()[this.scala$collection$mutable$ArrayDeque$$end()] = elem;
        int scala$collection$mutable$ArrayDeque$$end_$plus_idx = 1;
        this.scala$collection$mutable$ArrayDeque$$end_$eq(this.scala$collection$mutable$ArrayDeque$$end() + scala$collection$mutable$ArrayDeque$$end_$plus_idx & this.array().length - 1);
        return this;
    }

    @Override
    public ArrayDeque<A> addAll(IterableOnce<A> elems) {
        int n = elems.knownSize();
        switch (n) {
            default: 
        }
        if (n > 0) {
            this.ensureSize(n + this.length());
            elems.iterator().foreach((Function1<Object, ArrayDeque> & Serializable)elem -> this.scala$collection$mutable$ArrayDeque$$appendAssumingCapacity(elem));
        } else {
            elems.iterator().foreach((Function1<Object, ArrayDeque> & Serializable)elem -> (ArrayDeque)this.$plus$eq(elem));
        }
        return this;
    }

    public void remove(int idx, int count) {
        if (count > 0) {
            int i;
            int n = this.length();
            if (idx < 0 || idx >= n) {
                throw new IndexOutOfBoundsException(new StringBuilder(31).append(idx).append(" is out of bounds (min 0, max ").append(n - 1).append(")").toString());
            }
            int n2 = this.length();
            int removals = Math.min(n2 - idx, count);
            int finalLength = n2 - removals;
            int suffixStart = idx + removals;
            if (this.array().length > 128 && this.array().length - finalLength - (finalLength >> 1) > finalLength) {
                Object[] array2 = ArrayDeque$.MODULE$.alloc(finalLength);
                this.copySliceToArray(0, array2, 0, idx);
                this.copySliceToArray(suffixStart, array2, idx, n2);
                this.reset(array2, 0, finalLength);
                return;
            }
            if (2 * idx <= finalLength) {
                int i2;
                for (i2 = suffixStart - 1; i2 >= removals; --i2) {
                    Object _set_elem;
                    Object object;
                    int _get_idx = i2 - removals;
                    Object object2 = object = this.array()[this.start_$plus(_get_idx)];
                    object = null;
                    this.array()[this.start_$plus((int)i2)] = _set_elem = object2;
                    Object var12_12 = null;
                }
                while (i2 >= 0) {
                    this.array()[this.start_$plus((int)i2)] = null;
                    --i2;
                }
                this.scala$collection$mutable$ArrayDeque$$start_$eq(this.start_$plus(removals));
                return;
            }
            for (i = idx; i < finalLength; ++i) {
                Object _set_elem;
                Object object;
                int _get_idx = i + removals;
                Object object3 = object = this.array()[this.start_$plus(_get_idx)];
                object = null;
                this.array()[this.start_$plus((int)i)] = _set_elem = object3;
                Object var15_16 = null;
            }
            while (i < n2) {
                this.array()[this.start_$plus((int)i)] = null;
                ++i;
            }
            this.scala$collection$mutable$ArrayDeque$$end_$eq(this.scala$collection$mutable$ArrayDeque$$end() - removals & this.array().length - 1);
            return;
        }
        if (!(count == 0)) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)ArrayDeque.$anonfun$remove$1(count)).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public A remove(int idx) {
        void var2_2;
        A elem = this.apply(idx);
        this.remove(idx, 1);
        return var2_2;
    }

    @Override
    public ArrayDeque<A> subtractOne(A elem) {
        int idx = this.indexOf(elem);
        if (idx >= 0) {
            this.remove(idx, 1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public A removeHead(boolean resizeInternalRepr) {
        void var2_2;
        if (this.isEmpty()) {
            throw new NoSuchElementException("empty collection");
        }
        Object removeHeadAssumingNonEmpty_elem = this.array()[this.scala$collection$mutable$ArrayDeque$$start()];
        this.array()[this.scala$collection$mutable$ArrayDeque$$start()] = null;
        this.scala$collection$mutable$ArrayDeque$$start_$eq(this.start_$plus(1));
        if (resizeInternalRepr) {
            this.scala$collection$mutable$ArrayDeque$$resize(this.length());
        }
        return var2_2;
    }

    public boolean removeHead$default$1() {
        return false;
    }

    public void ensureSize(int hint) {
        if (hint > this.length() && hint >= this.array().length) {
            this.scala$collection$mutable$ArrayDeque$$resize(hint);
        }
    }

    @Override
    public int length() {
        int scala$collection$mutable$ArrayDeque$$end_$minus_idx = this.scala$collection$mutable$ArrayDeque$$start();
        return this.scala$collection$mutable$ArrayDeque$$end() - scala$collection$mutable$ArrayDeque$$end_$minus_idx & this.array().length - 1;
    }

    @Override
    public boolean isEmpty() {
        return this.scala$collection$mutable$ArrayDeque$$start() == this.scala$collection$mutable$ArrayDeque$$end();
    }

    @Override
    public ArrayDeque<A> klone() {
        return new ArrayDeque<A>((Object[])this.array().clone(), this.scala$collection$mutable$ArrayDeque$$start(), this.scala$collection$mutable$ArrayDeque$$end());
    }

    @Override
    public SeqFactory<ArrayDeque> iterableFactory() {
        return ArrayDeque$.MODULE$;
    }

    @Override
    public void clear() {
        while (this.nonEmpty()) {
            boolean bl = false;
            Object cfr_ignored_0 = this.array()[this.scala$collection$mutable$ArrayDeque$$start()];
            this.array()[this.scala$collection$mutable$ArrayDeque$$start()] = null;
            this.scala$collection$mutable$ArrayDeque$$start_$eq(this.start_$plus(1));
            if (!bl) continue;
            this.scala$collection$mutable$ArrayDeque$$resize(this.length());
        }
    }

    @Override
    public ArrayDeque<A> ofArray(Object[] array, int end) {
        return new ArrayDeque<A>(array, 0, end);
    }

    @Override
    public <B> int copyToArray(Object dest, int destStart, int len) {
        int elemsToCopyToArray_max_y;
        int elemsToCopyToArray_min_y;
        int n = Array.getLength(dest);
        int elemsToCopyToArray_srcLen = this.length();
        int n2 = Math.min(len, elemsToCopyToArray_srcLen);
        int n3 = Math.min(n2, elemsToCopyToArray_min_y = n - destStart);
        int n4 = Math.max(n3, elemsToCopyToArray_max_y = 0);
        if (n4 > 0) {
            this.copySliceToArray(0, dest, destStart, len);
        }
        return n4;
    }

    @Override
    public <B> Object toArray(ClassTag<B> evidence$1) {
        return this.copySliceToArray(0, evidence$1.newArray(this.length()), 0, this.length());
    }

    @Override
    public int start_$plus(int idx) {
        return this.scala$collection$mutable$ArrayDeque$$start() + idx & this.array().length - 1;
    }

    public void scala$collection$mutable$ArrayDeque$$resize(int len) {
        if (len >= this.array().length || this.array().length > 16 && this.array().length - len > len) {
            int n = this.length();
            Object[] array2 = (Object[])this.copySliceToArray(0, ArrayDeque$.MODULE$.alloc(len), 0, n);
            this.reset(array2, 0, n);
        }
    }

    @Override
    public String stringPrefix() {
        return "ArrayDeque";
    }

    public static final /* synthetic */ String $anonfun$remove$1(int count$1) {
        return new StringBuilder(38).append("removing negative number of elements: ").append(count$1).toString();
    }

    public ArrayDeque(Object[] array, int start, int end) {
        this.array = array;
        this.scala$collection$mutable$ArrayDeque$$start = start;
        this.scala$collection$mutable$ArrayDeque$$end = end;
        this.reset(this.array(), this.scala$collection$mutable$ArrayDeque$$start(), this.scala$collection$mutable$ArrayDeque$$end());
    }

    public ArrayDeque(int initialSize) {
        this(ArrayDeque$.MODULE$.alloc(initialSize), 0, 0);
    }
}

