/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Function1;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.MapBuilderImpl;
import scala.collection.immutable.VectorBuilder;
import scala.collection.immutable.VectorMap;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;

public final class VectorMapBuilder<K, V>
implements Builder<Tuple2<K, V>, VectorMap<K, V>> {
    private final VectorBuilder<K> vectorBuilder = new VectorBuilder();
    private final MapBuilderImpl<K, Tuple2<Object, V>> mapBuilder = new MapBuilderImpl();
    private VectorMap<K, V> aliased;

    @Override
    public void sizeHint(int size) {
        Builder.sizeHint$(this, size);
    }

    @Override
    public <NewTo> Builder<Tuple2<K, V>, NewTo> mapResult(Function1<VectorMap<K, V>, NewTo> f) {
        return Builder.mapResult$(this, f);
    }

    @Override
    public final Growable $plus$eq(Object elem) {
        return Growable.$plus$eq$(this, elem);
    }

    @Override
    public Growable<Tuple2<K, V>> addAll(IterableOnce<Tuple2<K, V>> xs) {
        return Growable.addAll$(this, xs);
    }

    @Override
    public final Growable<Tuple2<K, V>> $plus$plus$eq(IterableOnce<Tuple2<K, V>> xs) {
        return Growable.$plus$plus$eq$(this, xs);
    }

    @Override
    public void clear() {
        this.vectorBuilder.clear();
        this.mapBuilder.clear();
        this.aliased = null;
    }

    @Override
    public VectorMap<K, V> result() {
        if (this.aliased == null) {
            this.aliased = new VectorMap(this.vectorBuilder.result(), this.mapBuilder.result());
        }
        return this.aliased;
    }

    public VectorMapBuilder<K, V> addOne(K key, V value) {
        if (this.aliased != null) {
            this.aliased = this.aliased.updated((Object)key, value);
        } else {
            Tuple2 tuple2 = this.mapBuilder.getOrElse(key, null);
            if (tuple2 != null) {
                int slot = tuple2._1$mcI$sp();
                this.mapBuilder.addOne(key, new Tuple2<Integer, V>(slot, value));
            } else {
                VectorBuilder<K> vectorBuilder = this.vectorBuilder;
                if (vectorBuilder == null) {
                    throw null;
                }
                int n = vectorBuilder.knownSize();
                this.vectorBuilder.addOne((Object)key);
                this.mapBuilder.addOne(key, new Tuple2<Integer, V>(n, value));
            }
        }
        return this;
    }

    public VectorMapBuilder<K, V> addOne(Tuple2<K, V> elem) {
        return this.addOne(elem._1(), elem._2());
    }
}

