/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.collection.immutable.Node;
import scala.collection.immutable.Node$;

public abstract class ChampBaseReverseIterator<T extends Node<T>> {
    private int currentValueCursor = -1;
    private T currentValueNode;
    private int currentStackLevel = -1;
    private final int[] nodeIndex = new int[Node$.MODULE$.MaxDepth() + 1];
    private final T[] nodeStack = new Node[Node$.MODULE$.MaxDepth() + 1];

    public int currentValueCursor() {
        return this.currentValueCursor;
    }

    public void currentValueCursor_$eq(int x$1) {
        this.currentValueCursor = x$1;
    }

    public T currentValueNode() {
        return this.currentValueNode;
    }

    public void currentValueNode_$eq(T x$1) {
        this.currentValueNode = x$1;
    }

    private final void setupPayloadNode(T node) {
        this.currentValueNode_$eq(node);
        this.currentValueCursor_$eq(((Node)node).payloadArity() - 1);
    }

    private final void pushNode(T node) {
        ++this.currentStackLevel;
        this.nodeStack[this.currentStackLevel] = node;
        this.nodeIndex[this.currentStackLevel] = ((Node)node).nodeArity() - 1;
    }

    private final void popNode() {
        --this.currentStackLevel;
    }

    private final boolean searchNextValueNode() {
        while (this.currentStackLevel >= 0) {
            int nodeCursor = this.nodeIndex[this.currentStackLevel];
            this.nodeIndex[this.currentStackLevel] = nodeCursor - 1;
            if (nodeCursor >= 0) {
                Object nextNode = ((Node)this.nodeStack[this.currentStackLevel]).getNode(nodeCursor);
                this.pushNode(nextNode);
                continue;
            }
            T currNode = this.nodeStack[this.currentStackLevel];
            this.popNode();
            if (!((Node)currNode).hasPayload()) continue;
            this.setupPayloadNode(currNode);
            return true;
        }
        return false;
    }

    public final boolean hasNext() {
        return this.currentValueCursor() >= 0 || this.searchNextValueNode();
    }

    public ChampBaseReverseIterator() {
    }

    public ChampBaseReverseIterator(T rootNode) {
        this();
        super.pushNode(rootNode);
        super.searchNextValueNode();
    }
}

