/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.collection.immutable.Node;
import scala.collection.immutable.Node$;

public abstract class ChampBaseIterator<T extends Node<T>> {
    private int currentValueCursor = 0;
    private int currentValueLength = 0;
    private T currentValueNode;
    private int currentStackLevel = -1;
    private int[] nodeCursorsAndLengths;
    private T[] nodes;

    public int currentValueCursor() {
        return this.currentValueCursor;
    }

    public void currentValueCursor_$eq(int x$1) {
        this.currentValueCursor = x$1;
    }

    public int currentValueLength() {
        return this.currentValueLength;
    }

    public void currentValueLength_$eq(int x$1) {
        this.currentValueLength = x$1;
    }

    public T currentValueNode() {
        return this.currentValueNode;
    }

    public void currentValueNode_$eq(T x$1) {
        this.currentValueNode = x$1;
    }

    private void initNodes() {
        if (this.nodeCursorsAndLengths == null) {
            this.nodeCursorsAndLengths = new int[Node$.MODULE$.MaxDepth() * 2];
            this.nodes = new Node[Node$.MODULE$.MaxDepth()];
        }
    }

    private final void setupPayloadNode(T node) {
        this.currentValueNode_$eq(node);
        this.currentValueCursor_$eq(0);
        this.currentValueLength_$eq(((Node)node).payloadArity());
    }

    private final void pushNode(T node) {
        this.initNodes();
        ++this.currentStackLevel;
        int cursorIndex = this.currentStackLevel * 2;
        int lengthIndex = this.currentStackLevel * 2 + 1;
        this.nodes[this.currentStackLevel] = node;
        this.nodeCursorsAndLengths[cursorIndex] = 0;
        this.nodeCursorsAndLengths[lengthIndex] = ((Node)node).nodeArity();
    }

    private final void popNode() {
        --this.currentStackLevel;
    }

    private final boolean searchNextValueNode() {
        while (this.currentStackLevel >= 0) {
            int cursorIndex = this.currentStackLevel * 2;
            int nodeCursor = this.nodeCursorsAndLengths[cursorIndex];
            int lengthIndex = this.currentStackLevel * 2 + 1;
            int nodeLength = this.nodeCursorsAndLengths[lengthIndex];
            if (nodeCursor < nodeLength) {
                int[] nArray = this.nodeCursorsAndLengths;
                nArray[cursorIndex] = nArray[cursorIndex] + 1;
                Object nextNode = ((Node)this.nodes[this.currentStackLevel]).getNode(nodeCursor);
                if (((Node)nextNode).hasNodes()) {
                    this.pushNode(nextNode);
                }
                if (!((Node)nextNode).hasPayload()) continue;
                this.setupPayloadNode(nextNode);
                return true;
            }
            this.popNode();
        }
        return false;
    }

    public final boolean hasNext() {
        return this.currentValueCursor() < this.currentValueLength() || this.searchNextValueNode();
    }

    public ChampBaseIterator() {
    }

    public ChampBaseIterator(T rootNode) {
        this();
        if (((Node)rootNode).hasNodes()) {
            super.pushNode(rootNode);
        }
        if (((Node)rootNode).hasPayload()) {
            super.setupPayloadNode(rootNode);
        }
    }
}

