/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.convert;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterator;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedMapOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.StrictOptimizedSetOps;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.AbstractSet;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.MapOps;
import scala.jdk.CollectionConverters$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

public final class JavaCollectionWrappers {

    public static interface IterableWrapperTrait<A> {
        public Iterable<A> underlying();

        default public int size() {
            return this.underlying().size();
        }

        default public IteratorWrapper<A> iterator() {
            return new IteratorWrapper(this.underlying().iterator());
        }

        default public boolean isEmpty() {
            return this.underlying().isEmpty();
        }
    }

    public static class IteratorWrapper<A>
    implements Serializable,
    Enumeration<A>,
    java.util.Iterator<A>,
    Product {
        private final Iterator<A> underlying;

        @Override
        public void forEachRemaining(Consumer<? super A> x$1) {
            java.util.Iterator.super.forEachRemaining(x$1);
        }

        public Iterator<A> underlying() {
            return this.underlying;
        }

        @Override
        public boolean hasNext() {
            return this.underlying().hasNext();
        }

        @Override
        public A next() {
            return this.underlying().next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.underlying().hasNext();
        }

        @Override
        public A nextElement() {
            return this.underlying().next();
        }

        public Nothing$ remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String productPrefix() {
            return "IteratorWrapper";
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.underlying();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return new AbstractIterator<T>(this){
                private int c;
                private final int cmax;
                private final Product x$2;

                public boolean hasNext() {
                    return this.c < this.cmax;
                }

                /*
                 * WARNING - void declaration
                 */
                public T next() {
                    void var1_1;
                    Object result = this.x$2.productElement(this.c);
                    ++this.c;
                    return var1_1;
                }
                {
                    this.x$2 = x$2;
                    this.c = 0;
                    this.cmax = x$2.productArity();
                }
            };
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof IteratorWrapper;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    boolean bl = x$1 instanceof IteratorWrapper;
                    if (!bl) break block3;
                    IteratorWrapper iteratorWrapper = (IteratorWrapper)x$1;
                    Iterator<A> iterator = this.underlying();
                    Iterator<A> iterator2 = iteratorWrapper.underlying();
                    if (!(!(iterator != null ? !iterator.equals(iterator2) : iterator2 != null) && iteratorWrapper.canEqual(this))) break block3;
                }
                return true;
            }
            return false;
        }

        public IteratorWrapper(Iterator<A> underlying) {
            this.underlying = underlying;
        }
    }

    public static class JIteratorWrapper<A>
    extends AbstractIterator<A>
    implements Serializable,
    Product {
        private final java.util.Iterator<A> underlying;

        public java.util.Iterator<A> underlying() {
            return this.underlying;
        }

        @Override
        public boolean hasNext() {
            return this.underlying().hasNext();
        }

        @Override
        public A next() {
            return this.underlying().next();
        }

        @Override
        public String productPrefix() {
            return "JIteratorWrapper";
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.underlying();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return new /* invalid duplicate definition of identical inner class */;
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof JIteratorWrapper;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash(this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    boolean bl = x$1 instanceof JIteratorWrapper;
                    if (!bl) break block3;
                    JIteratorWrapper jIteratorWrapper = (JIteratorWrapper)x$1;
                    java.util.Iterator<A> iterator = this.underlying();
                    java.util.Iterator<A> iterator2 = jIteratorWrapper.underlying();
                    if (!(!(iterator != null ? !iterator.equals(iterator2) : iterator2 != null) && jIteratorWrapper.canEqual(this))) break block3;
                }
                return true;
            }
            return false;
        }

        public JIteratorWrapper(java.util.Iterator<A> underlying) {
            this.underlying = underlying;
        }
    }

    public static class JListWrapper<A>
    extends AbstractBuffer<A>
    implements Serializable,
    Product,
    StrictOptimizedSeqOps<A, Buffer, Buffer<A>> {
        private final List<A> underlying;

        @Override
        public Object distinctBy(Function1 f) {
            return StrictOptimizedSeqOps.distinctBy$(this, f);
        }

        @Override
        public Object appended(Object elem) {
            return StrictOptimizedSeqOps.appended$(this, elem);
        }

        @Override
        public Object map(Function1 f) {
            return StrictOptimizedIterableOps.map$(this, f);
        }

        @Override
        public Object filter(Function1 pred) {
            return StrictOptimizedIterableOps.filter$(this, pred);
        }

        @Override
        public Object filterNot(Function1 pred) {
            return StrictOptimizedIterableOps.filterNot$(this, pred);
        }

        @Override
        public Object filterImpl(Function1 pred, boolean isFlipped) {
            return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
        }

        public List<A> underlying() {
            return this.underlying;
        }

        @Override
        public int length() {
            return this.underlying().size();
        }

        @Override
        public int knownSize() {
            if (this.underlying().isEmpty()) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.underlying().isEmpty();
        }

        @Override
        public Iterator<A> iterator() {
            java.util.Iterator<A> IteratorHasAsScala_i = this.underlying().iterator();
            CollectionConverters$ IteratorHasAsScala_this = CollectionConverters$.MODULE$;
            Object var1_2 = null;
            Object var2_1 = null;
            return new AsScalaExtensions.IteratorHasAsScala<A>(IteratorHasAsScala_this, IteratorHasAsScala_i).asScala();
        }

        @Override
        public A apply(int i) {
            return this.underlying().get(i);
        }

        @Override
        public JListWrapper<A> addOne(A elem) {
            this.underlying().add(elem);
            return this;
        }

        @Override
        public A remove(int i) {
            return this.underlying().remove(i);
        }

        @Override
        public void clear() {
            this.underlying().clear();
        }

        @Override
        public JListWrapper<A> clone() {
            return new JListWrapper<A>(new ArrayList<A>(this.underlying()));
        }

        @Override
        public ArrayBuffer$ iterableFactory() {
            return ArrayBuffer$.MODULE$;
        }

        @Override
        public JListWrapper<A> subtractOne(A elem) {
            this.underlying().remove(elem);
            return this;
        }

        @Override
        public String productPrefix() {
            return "JListWrapper";
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.underlying();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return new /* invalid duplicate definition of identical inner class */;
        }

        public JListWrapper(List<A> underlying) {
            this.underlying = underlying;
        }
    }

    public static interface JMapWrapperLike<K, V, CC extends MapOps<Object, Object, CC, ?>, C extends MapOps<K, V, CC, C>>
    extends StrictOptimizedMapOps<K, V, CC, C>,
    MapOps<K, V, CC, C> {
        public Map<K, V> underlying();

        @Override
        default public int size() {
            return this.underlying().size();
        }

        @Override
        default public Option<V> get(K k) {
            V v = this.underlying().get(k);
            if (v != null) {
                return new Some<V>(v);
            }
            if (this.underlying().containsKey(k)) {
                return new Some<Object>(null);
            }
            return None$.MODULE$;
        }

        @Override
        default public Option<V> put(K k, V v) {
            boolean present = this.underlying().containsKey(k);
            V result = this.underlying().put(k, v);
            if (present) {
                return new Some<V>(result);
            }
            return None$.MODULE$;
        }

        @Override
        default public void update(K k, V v) {
            this.underlying().put(k, v);
        }

        @Override
        default public Option<V> remove(K k) {
            if (this.underlying().containsKey(k)) {
                return new Some<V>(this.underlying().remove(k));
            }
            return None$.MODULE$;
        }

        @Override
        default public Iterator<Tuple2<K, V>> iterator() {
            return new AbstractIterator<Tuple2<K, V>>(this){
                private final java.util.Iterator<Map.Entry<K, V>> ui;

                private java.util.Iterator<Map.Entry<K, V>> ui() {
                    return this.ui;
                }

                public boolean hasNext() {
                    return this.ui().hasNext();
                }

                public Tuple2<K, V> next() {
                    Map.Entry<K, V> e = this.ui().next();
                    return new Tuple2<K, V>(e.getKey(), e.getValue());
                }
                {
                    this.ui = $outer.underlying().entrySet().iterator();
                }
            };
        }

        @Override
        default public <U> void foreachEntry(Function2<K, V, U> f) {
            for (Map.Entry<K, V> entry : this.underlying().entrySet()) {
                f.apply(entry.getKey(), entry.getValue());
            }
        }

        @Override
        default public void clear() {
            this.underlying().clear();
        }
    }

    public static class JSetWrapper<A>
    extends AbstractSet<A>
    implements Serializable,
    Product,
    StrictOptimizedSetOps<A, scala.collection.mutable.Set, scala.collection.mutable.Set<A>> {
        private final java.util.Set<A> underlying;

        @Override
        public SetOps concat(IterableOnce that) {
            return StrictOptimizedSetOps.concat$(this, that);
        }

        @Override
        public Object map(Function1 f) {
            return StrictOptimizedIterableOps.map$(this, f);
        }

        @Override
        public Object filter(Function1 pred) {
            return StrictOptimizedIterableOps.filter$(this, pred);
        }

        @Override
        public Object filterNot(Function1 pred) {
            return StrictOptimizedIterableOps.filterNot$(this, pred);
        }

        @Override
        public Object filterImpl(Function1 pred, boolean isFlipped) {
            return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
        }

        public java.util.Set<A> underlying() {
            return this.underlying;
        }

        @Override
        public int size() {
            return this.underlying().size();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying().isEmpty();
        }

        @Override
        public int knownSize() {
            if (this.underlying().isEmpty()) {
                return 0;
            }
            return -1;
        }

        @Override
        public Iterator<A> iterator() {
            java.util.Iterator<A> IteratorHasAsScala_i = this.underlying().iterator();
            CollectionConverters$ IteratorHasAsScala_this = CollectionConverters$.MODULE$;
            Object var1_2 = null;
            Object var2_1 = null;
            return new AsScalaExtensions.IteratorHasAsScala<A>(IteratorHasAsScala_this, IteratorHasAsScala_i).asScala();
        }

        @Override
        public boolean contains(A elem) {
            return this.underlying().contains(elem);
        }

        @Override
        public JSetWrapper<A> addOne(A elem) {
            this.underlying().add(elem);
            return this;
        }

        @Override
        public JSetWrapper<A> subtractOne(A elem) {
            this.underlying().remove(elem);
            return this;
        }

        @Override
        public boolean remove(A elem) {
            return this.underlying().remove(elem);
        }

        @Override
        public void clear() {
            this.underlying().clear();
        }

        @Override
        public scala.collection.mutable.Set<A> empty() {
            return new JSetWrapper(new HashSet());
        }

        @Override
        public scala.collection.mutable.Set<A> clone() {
            return new JSetWrapper<A>(new LinkedHashSet<A>(this.underlying()));
        }

        @Override
        public IterableFactory<scala.collection.mutable.Set> iterableFactory() {
            return HashSet$.MODULE$;
        }

        @Override
        public String productPrefix() {
            return "JSetWrapper";
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.underlying();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return new /* invalid duplicate definition of identical inner class */;
        }

        public JSetWrapper(java.util.Set<A> underlying) {
            this.underlying = underlying;
        }
    }

    public static class MutableSetWrapper<A>
    extends SetWrapper<A>
    implements Product {
        private final scala.collection.mutable.Set<A> underlying;

        public scala.collection.mutable.Set<A> underlying() {
            return this.underlying;
        }

        @Override
        public boolean add(A elem) {
            int sz = this.underlying().size();
            scala.collection.mutable.Set<A> set = this.underlying();
            if (set == null) {
                throw null;
            }
            set.addOne(elem);
            return sz < this.underlying().size();
        }

        @Override
        public boolean remove(Object elem) {
            try {
                return this.underlying().remove(elem);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        @Override
        public void clear() {
            this.underlying().clear();
        }

        @Override
        public String productPrefix() {
            return "MutableSetWrapper";
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.underlying();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return new /* invalid duplicate definition of identical inner class */;
        }
    }

    public static class SeqWrapper<A>
    extends AbstractList<A>
    implements Serializable,
    Product,
    IterableWrapperTrait<A> {
        private final Seq<A> underlying;

        @Override
        public int size() {
            return ((IterableWrapperTrait)this).size();
        }

        @Override
        public IteratorWrapper<A> iterator() {
            return ((IterableWrapperTrait)this).iterator();
        }

        @Override
        public boolean isEmpty() {
            return ((IterableWrapperTrait)this).isEmpty();
        }

        @Override
        public Seq<A> underlying() {
            return this.underlying;
        }

        @Override
        public A get(int i) {
            return (A)this.underlying().apply(i);
        }

        @Override
        public String productPrefix() {
            return "SeqWrapper";
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.underlying();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return new /* invalid duplicate definition of identical inner class */;
        }

        public SeqWrapper(Seq<A> underlying) {
            this.underlying = underlying;
        }
    }

    public static class SetWrapper<A>
    extends java.util.AbstractSet<A>
    implements Serializable {
        public final Set<A> scala$collection$convert$JavaCollectionWrappers$SetWrapper$$underlying;

        @Override
        public boolean contains(Object o) {
            try {
                return this.scala$collection$convert$JavaCollectionWrappers$SetWrapper$$underlying.contains(o);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        @Override
        public boolean isEmpty() {
            return this.scala$collection$convert$JavaCollectionWrappers$SetWrapper$$underlying.isEmpty();
        }

        @Override
        public int size() {
            return this.scala$collection$convert$JavaCollectionWrappers$SetWrapper$$underlying.size();
        }

        @Override
        public java.util.Iterator<A> iterator() {
            return new java.util.Iterator<A>(this){
                private final Iterator<A> ui;
                private Option<A> prev;
                private final /* synthetic */ SetWrapper $outer;

                public void forEachRemaining(Consumer<? super A> x$1) {
                    java.util.Iterator.super.forEachRemaining(x$1);
                }

                private Iterator<A> ui() {
                    return this.ui;
                }

                private Option<A> prev() {
                    return this.prev;
                }

                private void prev_$eq(Option<A> x$1) {
                    this.prev = x$1;
                }

                public boolean hasNext() {
                    return this.ui().hasNext();
                }

                /*
                 * WARNING - void declaration
                 */
                public A next() {
                    void var1_1;
                    A e = this.ui().next();
                    this.prev_$eq(new Some<A>(e));
                    return var1_1;
                }

                public void remove() {
                    Option<A> option = this.prev();
                    if (option instanceof Some) {
                        A e = ((Some)option).value();
                        Set<A> set = this.$outer.scala$collection$convert$JavaCollectionWrappers$SetWrapper$$underlying;
                        if (set instanceof scala.collection.mutable.Set) {
                            ((scala.collection.mutable.Set)set).remove(e);
                            this.prev_$eq(None$.MODULE$);
                            return;
                        }
                        throw new UnsupportedOperationException("remove");
                    }
                    throw new IllegalStateException("next must be called at least once before remove");
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.ui = $outer.scala$collection$convert$JavaCollectionWrappers$SetWrapper$$underlying.iterator();
                    this.prev = None$.MODULE$;
                }
            };
        }
    }
}

