/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import scala.Function1;
import scala.Function2;
import scala.collection.AbstractSeqView;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.View;

public interface SeqView<A>
extends SeqOps<A, View, View<A>>,
View<A> {
    @Override
    default public <B$> SeqView<B$> map(Function1<A, B$> f) {
        return new Map<A, B$>(this, f);
    }

    @Override
    default public <B> SeqView<B> appended(B elem) {
        return new Appended<B>(this, elem);
    }

    @Override
    default public SeqView<A> drop(int n) {
        return new Drop(this, n);
    }

    @Override
    default public String stringPrefix() {
        return "SeqView";
    }

    public static class Appended<A>
    extends View.Appended<A>
    implements SeqView<A> {
        private final SeqOps<A, ?, Object> underlying;
        private final A elem;

        @Override
        public <B$> SeqView<B$> map(Function1<A, B$> f) {
            return ((SeqView)this).map(f);
        }

        @Override
        public <B> SeqView<B> appended(B elem) {
            return ((SeqView)this).appended(elem);
        }

        @Override
        public SeqView<A> drop(int n) {
            return ((SeqView)this).drop(n);
        }

        @Override
        public String stringPrefix() {
            return ((SeqView)this).stringPrefix();
        }

        @Override
        public /* synthetic */ int scala$collection$SeqOps$$super$sizeCompare(int otherSize) {
            return IterableOps.sizeCompare$(this, otherSize);
        }

        @Override
        public final int size() {
            return SeqOps.size$(this);
        }

        @Override
        public Object distinct() {
            return SeqOps.distinct$(this);
        }

        @Override
        public Object distinctBy(Function1 f) {
            return SeqOps.distinctBy$(this, f);
        }

        @Override
        public Iterator<A> reverseIterator() {
            return SeqOps.reverseIterator$(this);
        }

        @Override
        public boolean isDefinedAt(int idx) {
            return SeqOps.isDefinedAt$(this, idx);
        }

        @Override
        public int indexWhere(Function1<A, Object> p, int from) {
            return SeqOps.indexWhere$(this, p, from);
        }

        @Override
        public <B> int indexOf(B elem, int from) {
            return SeqOps.indexOf$(this, elem, from);
        }

        @Override
        public <B> int indexOf(B elem) {
            return SeqOps.indexOf$(this, elem);
        }

        @Override
        public <A1> boolean contains(A1 elem) {
            return SeqOps.contains$(this, elem);
        }

        @Override
        public final int sizeCompare(int otherSize) {
            return SeqOps.sizeCompare$(this, otherSize);
        }

        @Override
        public int lengthCompare(int len) {
            return SeqOps.lengthCompare$(this, len);
        }

        @Override
        public boolean isEmpty() {
            return SeqOps.isEmpty$(this);
        }

        @Override
        public <B> boolean sameElements(IterableOnce<B> that) {
            return SeqOps.sameElements$(this, that);
        }

        @Override
        public <B$> boolean corresponds(Seq<B$> that, Function2<A, B$, Object> p) {
            return SeqOps.corresponds$(this, that, p);
        }

        @Override
        public Object updated(int index, Object elem) {
            return SeqOps.updated$(this, index, elem);
        }

        @Override
        public A apply(int idx) {
            if (idx == this.underlying.length()) {
                return this.elem;
            }
            return this.underlying.apply(idx);
        }

        @Override
        public int length() {
            return this.underlying.length() + 1;
        }

        public Appended(SeqOps<A, ?, Object> underlying, A elem) {
            this.underlying = underlying;
            this.elem = elem;
            super(underlying, elem);
        }
    }

    public static class Drop<A>
    extends View.Drop<A>
    implements SeqView<A> {
        private final SeqOps<A, ?, Object> underlying;
        private final int n;

        @Override
        public <B$> SeqView<B$> map(Function1<A, B$> f) {
            return ((SeqView)this).map(f);
        }

        @Override
        public <B> SeqView<B> appended(B elem) {
            return ((SeqView)this).appended(elem);
        }

        @Override
        public String stringPrefix() {
            return ((SeqView)this).stringPrefix();
        }

        @Override
        public /* synthetic */ int scala$collection$SeqOps$$super$sizeCompare(int otherSize) {
            return IterableOps.sizeCompare$(this, otherSize);
        }

        @Override
        public final int size() {
            return SeqOps.size$(this);
        }

        @Override
        public Object distinct() {
            return SeqOps.distinct$(this);
        }

        @Override
        public Object distinctBy(Function1 f) {
            return SeqOps.distinctBy$(this, f);
        }

        @Override
        public Iterator<A> reverseIterator() {
            return SeqOps.reverseIterator$(this);
        }

        @Override
        public boolean isDefinedAt(int idx) {
            return SeqOps.isDefinedAt$(this, idx);
        }

        @Override
        public int indexWhere(Function1<A, Object> p, int from) {
            return SeqOps.indexWhere$(this, p, from);
        }

        @Override
        public <B> int indexOf(B elem, int from) {
            return SeqOps.indexOf$(this, elem, from);
        }

        @Override
        public <B> int indexOf(B elem) {
            return SeqOps.indexOf$(this, elem);
        }

        @Override
        public <A1> boolean contains(A1 elem) {
            return SeqOps.contains$(this, elem);
        }

        @Override
        public final int sizeCompare(int otherSize) {
            return SeqOps.sizeCompare$(this, otherSize);
        }

        @Override
        public int lengthCompare(int len) {
            return SeqOps.lengthCompare$(this, len);
        }

        @Override
        public boolean isEmpty() {
            return SeqOps.isEmpty$(this);
        }

        @Override
        public <B> boolean sameElements(IterableOnce<B> that) {
            return SeqOps.sameElements$(this, that);
        }

        @Override
        public <B$> boolean corresponds(Seq<B$> that, Function2<A, B$, Object> p) {
            return SeqOps.corresponds$(this, that, p);
        }

        @Override
        public Object updated(int index, Object elem) {
            return SeqOps.updated$(this, index, elem);
        }

        @Override
        public int length() {
            SeqOps<A, ?, Object> seqOps = this.underlying;
            if (seqOps == null) {
                throw null;
            }
            int n = seqOps.length() - this.normN();
            int max$extension_that = 0;
            return Math.max(n, max$extension_that);
        }

        @Override
        public A apply(int i) throws IndexOutOfBoundsException {
            return this.underlying.apply(i + this.normN());
        }

        @Override
        public SeqView<A> drop(int n) {
            return new Drop<A>(this.underlying, this.n + n);
        }

        public Drop(SeqOps<A, ?, Object> underlying, int n) {
            this.underlying = underlying;
            this.n = n;
            super(underlying, n);
        }
    }

    public static class Id<A>
    extends AbstractSeqView<A> {
        private final SeqOps<A, ?, Object> underlying;

        @Override
        public A apply(int idx) {
            return this.underlying.apply(idx);
        }

        @Override
        public int length() {
            return this.underlying.length();
        }

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator();
        }

        @Override
        public int knownSize() {
            return this.underlying.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        public Id(SeqOps<A, ?, Object> underlying) {
            this.underlying = underlying;
        }
    }

    public static class Map<A, B>
    extends View.Map<A, B>
    implements SeqView<B> {
        private final SeqOps<A, ?, Object> underlying;
        private final Function1<A, B> f;

        @Override
        public <B$> SeqView<B$> map(Function1<B, B$> f) {
            return ((SeqView)this).map(f);
        }

        @Override
        public <B$> SeqView<B$> appended(B$ elem) {
            return ((SeqView)this).appended(elem);
        }

        @Override
        public SeqView<B> drop(int n) {
            return ((SeqView)this).drop(n);
        }

        @Override
        public String stringPrefix() {
            return ((SeqView)this).stringPrefix();
        }

        @Override
        public /* synthetic */ int scala$collection$SeqOps$$super$sizeCompare(int otherSize) {
            return IterableOps.sizeCompare$(this, otherSize);
        }

        @Override
        public final int size() {
            return SeqOps.size$(this);
        }

        @Override
        public Object distinct() {
            return SeqOps.distinct$(this);
        }

        @Override
        public Object distinctBy(Function1 f) {
            return SeqOps.distinctBy$(this, f);
        }

        @Override
        public Iterator<B> reverseIterator() {
            return SeqOps.reverseIterator$(this);
        }

        @Override
        public boolean isDefinedAt(int idx) {
            return SeqOps.isDefinedAt$(this, idx);
        }

        @Override
        public int indexWhere(Function1<B, Object> p, int from) {
            return SeqOps.indexWhere$(this, p, from);
        }

        @Override
        public <B$> int indexOf(B$ elem, int from) {
            return SeqOps.indexOf$(this, elem, from);
        }

        @Override
        public <B$> int indexOf(B$ elem) {
            return SeqOps.indexOf$(this, elem);
        }

        @Override
        public <A1> boolean contains(A1 elem) {
            return SeqOps.contains$(this, elem);
        }

        @Override
        public final int sizeCompare(int otherSize) {
            return SeqOps.sizeCompare$(this, otherSize);
        }

        @Override
        public int lengthCompare(int len) {
            return SeqOps.lengthCompare$(this, len);
        }

        @Override
        public boolean isEmpty() {
            return SeqOps.isEmpty$(this);
        }

        @Override
        public <B$> boolean sameElements(IterableOnce<B$> that) {
            return SeqOps.sameElements$(this, that);
        }

        @Override
        public <B$> boolean corresponds(Seq<B$> that, Function2<B, B$, Object> p) {
            return SeqOps.corresponds$(this, that, p);
        }

        @Override
        public Object updated(int index, Object elem) {
            return SeqOps.updated$(this, index, elem);
        }

        @Override
        public B apply(int idx) {
            return this.f.apply(this.underlying.apply(idx));
        }

        @Override
        public int length() {
            return this.underlying.length();
        }

        public Map(SeqOps<A, ?, Object> underlying, Function1<A, B> f) {
            this.underlying = underlying;
            this.f = f;
            super(underlying, f);
        }
    }

    public static class Reverse<A>
    extends AbstractSeqView<A> {
        private final SeqOps<A, ?, Object> underlying;

        @Override
        public A apply(int i) {
            return this.underlying.apply(this.length() - 1 - i);
        }

        @Override
        public int length() {
            SeqOps<A, ?, Object> seqOps = this.underlying;
            if (seqOps == null) {
                throw null;
            }
            return seqOps.length();
        }

        @Override
        public Iterator<A> iterator() {
            return this.underlying.reverseIterator();
        }

        @Override
        public int knownSize() {
            return this.underlying.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        public Reverse(SeqOps<A, ?, Object> underlying) {
            this.underlying = underlying;
        }
    }
}

