# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    The version of the OpenAPI document: 2.3.0
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class OrderBookChanges(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'message_class': 'str',
        'emitted_at': 'datetime',
        'contract_id': 'str',
        'contract_type': 'ContractType',
        'delivery_area': 'str',
        'active_since': 'datetime',
        'revision': 'int',
        'sequence_number': 'int',
        'best_price_changed': 'bool',
        'delta': 'bool',
        'orders': 'Orders'
    }

    attribute_map = {
        'message_class': 'messageClass',
        'emitted_at': 'emittedAt',
        'contract_id': 'contract_id',
        'contract_type': 'contract_type',
        'delivery_area': 'delivery_area',
        'active_since': 'active_since',
        'revision': 'revision',
        'sequence_number': 'sequence_number',
        'best_price_changed': 'best_price_changed',
        'delta': 'delta',
        'orders': 'orders'
    }

    def __init__(self, message_class=None, emitted_at=None, contract_id=None, contract_type=None, delivery_area=None, active_since=None, revision=None, sequence_number=None, best_price_changed=None, delta=None, orders=None, local_vars_configuration=None):  # noqa: E501
        """OrderBookChanges - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._message_class = None
        self._emitted_at = None
        self._contract_id = None
        self._contract_type = None
        self._delivery_area = None
        self._active_since = None
        self._revision = None
        self._sequence_number = None
        self._best_price_changed = None
        self._delta = None
        self._orders = None
        self.discriminator = None

        if message_class is not None:
            self.message_class = message_class
        if emitted_at is not None:
            self.emitted_at = emitted_at
        if contract_id is not None:
            self.contract_id = contract_id
        if contract_type is not None:
            self.contract_type = contract_type
        if delivery_area is not None:
            self.delivery_area = delivery_area
        if active_since is not None:
            self.active_since = active_since
        if revision is not None:
            self.revision = revision
        if sequence_number is not None:
            self.sequence_number = sequence_number
        if best_price_changed is not None:
            self.best_price_changed = best_price_changed
        if delta is not None:
            self.delta = delta
        if orders is not None:
            self.orders = orders

    @property
    def message_class(self):
        """Gets the message_class of this OrderBookChanges.  # noqa: E501


        :return: The message_class of this OrderBookChanges.  # noqa: E501
        :rtype: str
        """
        return self._message_class

    @message_class.setter
    def message_class(self, message_class):
        """Sets the message_class of this OrderBookChanges.


        :param message_class: The message_class of this OrderBookChanges.  # noqa: E501
        :type message_class: str
        """

        self._message_class = message_class

    @property
    def emitted_at(self):
        """Gets the emitted_at of this OrderBookChanges.  # noqa: E501


        :return: The emitted_at of this OrderBookChanges.  # noqa: E501
        :rtype: datetime
        """
        return self._emitted_at

    @emitted_at.setter
    def emitted_at(self, emitted_at):
        """Sets the emitted_at of this OrderBookChanges.


        :param emitted_at: The emitted_at of this OrderBookChanges.  # noqa: E501
        :type emitted_at: datetime
        """

        self._emitted_at = emitted_at

    @property
    def contract_id(self):
        """Gets the contract_id of this OrderBookChanges.  # noqa: E501


        :return: The contract_id of this OrderBookChanges.  # noqa: E501
        :rtype: str
        """
        return self._contract_id

    @contract_id.setter
    def contract_id(self, contract_id):
        """Sets the contract_id of this OrderBookChanges.


        :param contract_id: The contract_id of this OrderBookChanges.  # noqa: E501
        :type contract_id: str
        """

        self._contract_id = contract_id

    @property
    def contract_type(self):
        """Gets the contract_type of this OrderBookChanges.  # noqa: E501


        :return: The contract_type of this OrderBookChanges.  # noqa: E501
        :rtype: ContractType
        """
        return self._contract_type

    @contract_type.setter
    def contract_type(self, contract_type):
        """Sets the contract_type of this OrderBookChanges.


        :param contract_type: The contract_type of this OrderBookChanges.  # noqa: E501
        :type contract_type: ContractType
        """

        self._contract_type = contract_type

    @property
    def delivery_area(self):
        """Gets the delivery_area of this OrderBookChanges.  # noqa: E501


        :return: The delivery_area of this OrderBookChanges.  # noqa: E501
        :rtype: str
        """
        return self._delivery_area

    @delivery_area.setter
    def delivery_area(self, delivery_area):
        """Sets the delivery_area of this OrderBookChanges.


        :param delivery_area: The delivery_area of this OrderBookChanges.  # noqa: E501
        :type delivery_area: str
        """

        self._delivery_area = delivery_area

    @property
    def active_since(self):
        """Gets the active_since of this OrderBookChanges.  # noqa: E501

        The timestamp (UTC) since when the contract has been observed as active for trading in the corresponding delivery area. Is reset to current time after a system or market outage or after the market was hibernated. Can be used to determine potential low liquidity situations after activation of new contracts or market outages.  # noqa: E501

        :return: The active_since of this OrderBookChanges.  # noqa: E501
        :rtype: datetime
        """
        return self._active_since

    @active_since.setter
    def active_since(self, active_since):
        """Sets the active_since of this OrderBookChanges.

        The timestamp (UTC) since when the contract has been observed as active for trading in the corresponding delivery area. Is reset to current time after a system or market outage or after the market was hibernated. Can be used to determine potential low liquidity situations after activation of new contracts or market outages.  # noqa: E501

        :param active_since: The active_since of this OrderBookChanges.  # noqa: E501
        :type active_since: datetime
        """

        self._active_since = active_since

    @property
    def revision(self):
        """Gets the revision of this OrderBookChanges.  # noqa: E501


        :return: The revision of this OrderBookChanges.  # noqa: E501
        :rtype: int
        """
        return self._revision

    @revision.setter
    def revision(self, revision):
        """Sets the revision of this OrderBookChanges.


        :param revision: The revision of this OrderBookChanges.  # noqa: E501
        :type revision: int
        """

        self._revision = revision

    @property
    def sequence_number(self):
        """Gets the sequence_number of this OrderBookChanges.  # noqa: E501

        Running number within one delivery area  # noqa: E501

        :return: The sequence_number of this OrderBookChanges.  # noqa: E501
        :rtype: int
        """
        return self._sequence_number

    @sequence_number.setter
    def sequence_number(self, sequence_number):
        """Sets the sequence_number of this OrderBookChanges.

        Running number within one delivery area  # noqa: E501

        :param sequence_number: The sequence_number of this OrderBookChanges.  # noqa: E501
        :type sequence_number: int
        """

        self._sequence_number = sequence_number

    @property
    def best_price_changed(self):
        """Gets the best_price_changed of this OrderBookChanges.  # noqa: E501

        True if the best ask or best bid order changed.  # noqa: E501

        :return: The best_price_changed of this OrderBookChanges.  # noqa: E501
        :rtype: bool
        """
        return self._best_price_changed

    @best_price_changed.setter
    def best_price_changed(self, best_price_changed):
        """Sets the best_price_changed of this OrderBookChanges.

        True if the best ask or best bid order changed.  # noqa: E501

        :param best_price_changed: The best_price_changed of this OrderBookChanges.  # noqa: E501
        :type best_price_changed: bool
        """

        self._best_price_changed = best_price_changed

    @property
    def delta(self):
        """Gets the delta of this OrderBookChanges.  # noqa: E501

        if set to true, the change is delta otherwise a full snapshot of the orderbook  # noqa: E501

        :return: The delta of this OrderBookChanges.  # noqa: E501
        :rtype: bool
        """
        return self._delta

    @delta.setter
    def delta(self, delta):
        """Sets the delta of this OrderBookChanges.

        if set to true, the change is delta otherwise a full snapshot of the orderbook  # noqa: E501

        :param delta: The delta of this OrderBookChanges.  # noqa: E501
        :type delta: bool
        """

        self._delta = delta

    @property
    def orders(self):
        """Gets the orders of this OrderBookChanges.  # noqa: E501


        :return: The orders of this OrderBookChanges.  # noqa: E501
        :rtype: Orders
        """
        return self._orders

    @orders.setter
    def orders(self, orders):
        """Sets the orders of this OrderBookChanges.


        :param orders: The orders of this OrderBookChanges.  # noqa: E501
        :type orders: Orders
        """

        self._orders = orders

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrderBookChanges):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OrderBookChanges):
            return True

        return self.to_dict() != other.to_dict()
